/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.relation.rule.eval;

import com.bigdata.journal.IIndexManager;
import com.bigdata.journal.Journal;
import com.bigdata.journal.TimestampUtility;
import com.bigdata.relation.accesspath.ChunkConsumerIterator;
import com.bigdata.relation.accesspath.IAsynchronousIterator;
import com.bigdata.relation.accesspath.IBlockingBuffer;
import com.bigdata.relation.rule.IProgram;
import com.bigdata.relation.rule.IStep;
import com.bigdata.relation.rule.eval.ActionEnum;
import com.bigdata.relation.rule.eval.IJoinNexusFactory;
import com.bigdata.relation.rule.eval.IProgramTask;
import com.bigdata.relation.rule.eval.ISolution;
import com.bigdata.relation.rule.eval.MutationTask;
import com.bigdata.relation.rule.eval.ProgramUtility;
import com.bigdata.relation.rule.eval.QueryTask;
import com.bigdata.relation.rule.eval.RuleLog;
import com.bigdata.relation.rule.eval.RuleStats;
import com.bigdata.service.DataService;
import com.bigdata.service.DataServiceCallable;
import com.bigdata.service.IBigdataFederation;
import java.io.IOException;
import java.util.Iterator;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;

public class ProgramTask
extends DataServiceCallable<Object>
implements IProgramTask {
    private static final long serialVersionUID = -7047397038429305180L;
    protected static final transient Logger log = Logger.getLogger(ProgramTask.class);
    private final ActionEnum action;
    private final IStep step;
    private final IJoinNexusFactory joinNexusFactory;
    private transient IIndexManager indexManager;

    @Override
    public void setDataService(DataService dataService) {
        super.setDataService(dataService);
        this.indexManager = dataService.getFederation();
    }

    public ProgramTask(ActionEnum action, IStep step, IJoinNexusFactory joinNexusFactory) {
        if (action == null) {
            throw new IllegalArgumentException();
        }
        if (step == null) {
            throw new IllegalArgumentException();
        }
        if (joinNexusFactory == null) {
            throw new IllegalArgumentException();
        }
        this.action = action;
        this.step = step;
        this.joinNexusFactory = joinNexusFactory;
        this.indexManager = null;
    }

    public ProgramTask(ActionEnum action, IStep step, IJoinNexusFactory joinNexusFactory, IIndexManager indexManager) {
        if (action == null) {
            throw new IllegalArgumentException();
        }
        if (step == null) {
            throw new IllegalArgumentException();
        }
        if (joinNexusFactory == null) {
            throw new IllegalArgumentException();
        }
        if (indexManager == null) {
            throw new IllegalArgumentException();
        }
        this.action = action;
        this.step = step;
        this.joinNexusFactory = joinNexusFactory;
        this.indexManager = indexManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object call() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("begin: program=" + this.step.getName() + ", action=" + (Object)((Object)this.action)));
        }
        try {
            ProgramUtility util = new ProgramUtility();
            if (this.action.isMutation()) {
                RuleStats totals = !this.step.isRule() && ((IProgram)this.step).isClosure() ? this.executeClosure((IProgram)this.step) : (util.isClosureProgram(this.step) ? this.executeProgramWithEmbeddedClosure((IProgram)this.step) : this.executeMutation(this.step));
                RuleLog.log(totals);
                Long l = totals.mutationCount.get();
                return l;
            }
            if (!this.step.isRule() && ((IProgram)this.step).isClosure() || util.isClosureProgram(this.step)) {
                throw new UnsupportedOperationException("Closure only allowed for mutation.");
            }
            ChunkConsumerIterator chunkConsumerIterator = new ChunkConsumerIterator(this.executeQuery(this.step));
            return chunkConsumerIterator;
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug((Object)"bye");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IAsynchronousIterator<ISolution[]> executeQuery(IStep step) {
        if (step == null) {
            throw new IllegalArgumentException();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("program=" + step.getName()));
        }
        IBlockingBuffer<ISolution[]> buffer = this.joinNexusFactory.newInstance(this.indexManager).newQueryBuffer();
        QueryTask queryTask = new QueryTask(step, this.joinNexusFactory, buffer, this.indexManager, this.isDataService() ? this.getDataService() : null);
        Future<RuleStats> future = null;
        try {
            try {
                future = queryTask.submit();
                buffer.setFuture(future);
            }
            finally {
                if (future != null && buffer.getFuture() == null) {
                    future.cancel(true);
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Returning iterator reading on async query task");
            }
            return buffer.iterator();
        }
        catch (Throwable ex) {
            try {
                log.error((Object)ex, ex);
                throw new RuntimeException(ex);
            }
            catch (Throwable throwable) {
                buffer.close();
                if (future != null) {
                    future.cancel(true);
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RuleStats executeMutation(IStep step) throws InterruptedException, ExecutionException {
        if (step == null) {
            throw new IllegalArgumentException();
        }
        if (!this.action.isMutation()) {
            throw new IllegalArgumentException();
        }
        long tx = 0L;
        try {
            if (this.indexManager instanceof IBigdataFederation) {
                long lastCommitTime = this.indexManager.getLastCommitTime();
                try {
                    tx = ((IBigdataFederation)this.indexManager).getTransactionService().newTx(lastCommitTime);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
                this.joinNexusFactory.setReadTimestamp(TimestampUtility.asHistoricalRead(lastCommitTime));
            }
            MutationTask mutationTask = new MutationTask(this.action, this.joinNexusFactory, step, this.indexManager, this.isDataService() ? this.getDataService() : null);
            if (log.isDebugEnabled()) {
                log.debug((Object)("begin: action=" + (Object)((Object)this.action) + ", program=" + step.getName() + ", task=" + mutationTask));
            }
            RuleStats ruleStats = mutationTask.submit().get();
            return ruleStats;
        }
        finally {
            if (tx != 0L) {
                if (this.indexManager instanceof IBigdataFederation) {
                    try {
                        ((IBigdataFederation)this.indexManager).getTransactionService().abort(tx);
                    }
                    catch (IOException ex) {
                        throw new RuntimeException(ex);
                    }
                } else if (this.indexManager instanceof Journal) {
                    ((Journal)this.indexManager).abort(tx);
                }
            }
        }
    }

    protected RuleStats executeClosure(IProgram program) throws InterruptedException, ExecutionException {
        if (program == null) {
            throw new IllegalArgumentException();
        }
        if (!program.isClosure()) {
            throw new IllegalArgumentException();
        }
        long begin = System.currentTimeMillis();
        RuleStats totals = this.joinNexusFactory.newInstance(this.indexManager).getRuleStatisticsFactory().newInstance(program);
        int round = 1;
        long mutationCount = 0L;
        while (true) {
            long mutationCount0 = totals.mutationCount.get();
            if (log.isDebugEnabled()) {
                log.debug((Object)("round=" + round + ", mutationCount(before)=" + mutationCount0));
            }
            RuleStats tmp = this.executeMutation(program);
            long mutationDelta = tmp.mutationCount.get();
            long mutationCount1 = mutationCount = mutationCount0 + tmp.mutationCount.get();
            tmp.closureRound = round;
            totals.add(tmp);
            if (log.isDebugEnabled()) {
                log.debug((Object)("round# " + round + ", mutationCount(before=" + mutationCount0 + ", after=" + mutationCount1 + ", delta=" + mutationDelta + "):" + totals));
            }
            if (mutationDelta == 0L) break;
            ++round;
        }
        long elapsed = System.currentTimeMillis() - begin;
        if (!totals.mutationCount.compareAndSet(0L, mutationCount)) {
            throw new AssertionError((Object)("mutationCount=" + totals.mutationCount));
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("\nComputed fixed point: program=" + program.getName() + ", rounds=" + round + ", elapsed=" + elapsed + "ms"));
        }
        return totals;
    }

    protected RuleStats executeProgramWithEmbeddedClosure(IProgram program) throws InterruptedException, ExecutionException {
        if (program == null) {
            throw new IllegalArgumentException();
        }
        if (program.isClosure()) {
            throw new IllegalArgumentException();
        }
        if (!this.action.isMutation()) {
            throw new IllegalStateException();
        }
        if (log.isInfoEnabled()) {
            log.info((Object)"program embeds closure operations");
        }
        RuleStats totals = this.joinNexusFactory.newInstance(this.indexManager).getRuleStatisticsFactory().newInstance(program);
        Iterator<IStep> itr = program.steps();
        long mutationCount = 0L;
        while (itr.hasNext()) {
            IStep step = itr.next();
            RuleStats stats = !step.isRule() && ((IProgram)step).isClosure() ? this.executeClosure((IProgram)step) : this.executeMutation(step);
            totals.add(stats);
            mutationCount += stats.mutationCount.get();
        }
        if (!totals.mutationCount.compareAndSet(0L, mutationCount)) {
            throw new AssertionError((Object)("mutationCount=" + totals.mutationCount));
        }
        return totals;
    }
}

