/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.resources;

import com.bigdata.journal.TimestampUtility;
import com.bigdata.resources.AbstractPrepareTask;
import com.bigdata.resources.BuildResult;
import com.bigdata.resources.MoveTask;
import com.bigdata.resources.OverflowActionEnum;
import com.bigdata.resources.SplitIndexPartitionTask;
import com.bigdata.resources.SplitResult;
import com.bigdata.resources.SplitUtility;
import com.bigdata.resources.ViewMetadata;
import com.bigdata.service.DataService;
import com.bigdata.service.Event;
import com.bigdata.service.EventResource;
import com.bigdata.service.Split;
import java.util.UUID;

public class SplitTailTask
extends AbstractPrepareTask {
    private final ViewMetadata vmd;
    private final UUID moveTarget;

    public SplitTailTask(ViewMetadata vmd, UUID moveTarget) {
        super(vmd.resourceManager, TimestampUtility.asHistoricalRead(vmd.commitTime), vmd.name);
        this.vmd = vmd;
        if (vmd.pmd == null) {
            throw new IllegalStateException("Not an index partition.");
        }
        if (vmd.pmd.getSourcePartitionId() != -1) {
            throw new IllegalStateException("Split not allowed during move: sourcePartitionId=" + vmd.pmd.getSourcePartitionId());
        }
        if (this.resourceManager.getDataServiceUUID().equals(moveTarget)) {
            throw new IllegalArgumentException("Move to self");
        }
        this.moveTarget = moveTarget;
    }

    @Override
    protected void clearRefs() {
        this.vmd.clearRef();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object doTask() throws Exception {
        SplitResult splitResult;
        Event e;
        block11: {
            e = new Event(this.resourceManager.getFederation(), new EventResource(this.vmd.indexMetadata), (Object)OverflowActionEnum.TailSplit, this.vmd.getParams()).addDetail("summary", (Object)((Object)OverflowActionEnum.TailSplit) + (this.moveTarget != null ? "+" + (Object)((Object)OverflowActionEnum.Move) : "") + "(" + this.vmd.name + ")");
            if (this.moveTarget != null) {
                e.addDetail("moveTarget", "" + this.moveTarget);
            }
            e.start();
            SplitResult splitResult2 = null;
            try {
                try {
                    Split[] splits = SplitUtility.tailSplit(this.resourceManager, this.vmd.getBTree());
                    SplitUtility.validateSplits(this.vmd.getBTree(), splits);
                    splitResult2 = SplitUtility.buildSplits(this.vmd, splits, e);
                }
                finally {
                    this.clearRefs();
                }
                SplitIndexPartitionTask.doSplitAtomicUpdate(this.resourceManager, this.vmd, splitResult2, OverflowActionEnum.TailSplit, this.resourceManager.overflowCounters.indexPartitionTailSplitCounter, e);
                if (this.moveTarget != null) {
                    int newPartitionId = this.resourceManager.nextPartitionId(this.vmd.indexMetadata.getName());
                    String rightSiblingName = DataService.getIndexPartitionName(this.vmd.indexMetadata.getName(), splitResult2.splits[1].pmd.getPartitionId());
                    MoveTask.doAtomicUpdate(this.resourceManager, rightSiblingName, splitResult2.buildResults[1], this.moveTarget, newPartitionId, e);
                }
                splitResult = splitResult2;
                if (splitResult2 == null) break block11;
            }
            catch (Throwable throwable) {
                if (splitResult2 != null) {
                    for (BuildResult buildResult : splitResult2.buildResults) {
                        if (buildResult == null) continue;
                        this.resourceManager.retentionSetRemove(buildResult.segmentMetadata.getUUID());
                    }
                }
                e.end();
                throw throwable;
            }
            for (BuildResult buildResult : splitResult2.buildResults) {
                if (buildResult == null) continue;
                this.resourceManager.retentionSetRemove(buildResult.segmentMetadata.getUUID());
            }
        }
        e.end();
        return splitResult;
    }
}

