/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rwstore;

import com.bigdata.rawstore.IAllocationContext;
import com.bigdata.rawstore.IPSOutputStream;
import com.bigdata.rwstore.FixedAllocator;
import com.bigdata.rwstore.IStore;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class PSOutputStream
extends IPSOutputStream {
    private static final Logger log = Logger.getLogger(FixedAllocator.class);
    private static final transient String ERR_NO_STORE = "PSOutputStream with unitilialized store";
    private static final transient String ERR_ALREADY_SAVED = "Writing to saved PSOutputStream";
    private static PSOutputStream m_poolHead = null;
    private static PSOutputStream m_poolTail = null;
    private static int m_streamCount = 0;
    private ArrayList<Integer> m_blobHeader = null;
    private byte[] m_buf = null;
    private boolean m_isSaved = false;
    private int m_count = 0;
    private int m_bytesWritten = 0;
    private int m_blobThreshold = 0;
    private IStore m_store;
    private IAllocationContext m_context;
    private PSOutputStream m_next = null;
    private int m_blobHdrIdx;
    private boolean m_writingHdr = false;

    public static synchronized PSOutputStream getNew(IStore store, int maxAlloc, IAllocationContext context) {
        PSOutputStream ret = m_poolHead;
        if (ret != null) {
            --m_streamCount;
            m_poolHead = ret.next();
            if (m_poolHead == null) {
                m_poolTail = null;
            }
        } else {
            ret = new PSOutputStream();
        }
        ret.init(store, maxAlloc, context);
        return ret;
    }

    static synchronized void returnStream(PSOutputStream stream) {
        if (m_streamCount > 10) {
            return;
        }
        stream.m_count = 0;
        if (m_poolTail != null) {
            m_poolTail.setNext(stream);
        } else {
            m_poolHead = stream;
        }
        m_poolTail = stream;
        ++m_streamCount;
    }

    private PSOutputStream next() {
        return this.m_next;
    }

    private void setNext(PSOutputStream str) {
        this.m_next = str;
    }

    void init(IStore store, int maxAlloc, IAllocationContext context) {
        this.m_store = store;
        this.m_context = context;
        this.m_next = null;
        this.m_blobThreshold = maxAlloc - 4;
        if (this.m_buf == null || this.m_buf.length != this.m_blobThreshold) {
            this.m_buf = new byte[this.m_blobThreshold];
        }
        this.reset();
    }

    public void reset() {
        this.m_isSaved = false;
        this.m_count = 0;
        this.m_bytesWritten = 0;
        this.m_isSaved = false;
        this.m_blobHeader = null;
        this.m_blobHdrIdx = 0;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.m_store == null) {
            throw new IllegalStateException(ERR_NO_STORE);
        }
        if (this.m_isSaved) {
            throw new IllegalStateException(ERR_ALREADY_SAVED);
        }
        if (this.m_count == this.m_blobThreshold && !this.m_writingHdr) {
            if (this.m_blobHeader == null) {
                this.m_blobHeader = new ArrayList();
            }
            int curAddr = (int)this.m_store.alloc(this.m_buf, this.m_count, this.m_context);
            this.m_blobHeader.add(curAddr);
            this.m_count = 0;
        }
        this.m_buf[this.m_count++] = (byte)b;
        ++this.m_bytesWritten;
    }

    public void writeInt(int b) throws IOException {
        this.write(b >>> 24 & 0xFF);
        this.write(b >>> 16 & 0xFF);
        this.write(b >>> 8 & 0xFF);
        this.write(b & 0xFF);
    }

    public void writeLong(long b) throws IOException {
        int hi = (int)(b >> 32);
        int lo = (int)(b & 0xFFFFFFFFFFFFFFFFL);
        this.writeInt(hi);
        this.writeInt(lo);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.m_store == null) {
            throw new IllegalStateException(ERR_NO_STORE);
        }
        if (this.m_isSaved) {
            throw new IllegalStateException(ERR_ALREADY_SAVED);
        }
        if (this.m_count + len > this.m_blobThreshold) {
            for (int i = 0; i < len; ++i) {
                this.write(b[off + i]);
            }
        } else {
            System.arraycopy(b, off, this.m_buf, this.m_count, len);
            this.m_count += len;
            this.m_bytesWritten += len;
        }
    }

    public void write(InputStream instr) throws IOException {
        if (this.m_isSaved) {
            throw new IllegalStateException(ERR_ALREADY_SAVED);
        }
        byte[] b = new byte[512];
        int r = instr.read(b);
        while (r == 512) {
            this.write(b, 0, r);
            r = instr.read(b);
        }
        if (r != -1) {
            this.write(b, 0, r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long save() {
        if (this.m_isSaved) {
            throw new IllegalStateException(ERR_ALREADY_SAVED);
        }
        if (this.m_store == null) {
            return 0L;
        }
        if (this.m_count == 0) {
            this.m_isSaved = true;
            return 0L;
        }
        int addr = (int)this.m_store.alloc(this.m_buf, this.m_count, this.m_context);
        if (this.m_blobHeader != null) {
            try {
                this.m_writingHdr = true;
                this.m_blobHeader.add(addr);
                this.m_count = 0;
                try {
                    int hdrBufSize = 4 * (this.m_blobHeader.size() + 1);
                    ByteArrayOutputStream hdrbuf = new ByteArrayOutputStream(hdrBufSize);
                    DataOutputStream hdrout = new DataOutputStream(hdrbuf);
                    hdrout.writeInt(this.m_blobHeader.size());
                    for (int i = 0; i < this.m_blobHeader.size(); ++i) {
                        hdrout.writeInt(this.m_blobHeader.get(i));
                    }
                    hdrout.flush();
                    byte[] outbuf = hdrbuf.toByteArray();
                    addr = (int)this.m_store.alloc(outbuf, hdrBufSize, this.m_context);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            finally {
                this.m_writingHdr = false;
            }
        }
        this.m_isSaved = true;
        return addr;
    }

    @Override
    public void close() throws IOException {
    }

    public int getBytesWritten() {
        return this.m_bytesWritten;
    }

    public OutputStream getFilterWrapper(final boolean saveBeforeClose) {
        return new FilterOutputStream(this){

            @Override
            public void close() throws IOException {
                if (saveBeforeClose) {
                    this.flush();
                    PSOutputStream.this.save();
                    super.close();
                } else {
                    super.close();
                    PSOutputStream.this.save();
                }
            }
        };
    }

    @Override
    public long getAddr() {
        long addr = this.save();
        addr <<= 32;
        return addr += (long)this.m_bytesWritten;
    }
}

