/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service;

import com.bigdata.Banner;
import com.bigdata.service.IBigdataClient;
import com.bigdata.service.IFederationDelegate;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.Logger;

public abstract class AbstractClient<T>
implements IBigdataClient<T> {
    protected static final Logger log = Logger.getLogger(IBigdataClient.class);
    private final Properties properties;
    private final int defaultRangeQueryCapacity;
    private final boolean batchApiOnly;
    private final int threadPoolSize;
    private final int maxStaleLocatorRetries;
    private final int maxParallelTasksPerRequest;
    private final long taskTimeout;
    private final int locatorCacheCapacity;
    private final long locatorCacheTimeout;
    private final int indexCacheCapacity;
    private final long indexCacheTimeout;
    private final boolean readConsistent;
    private final AtomicReference<IFederationDelegate<T>> delegate = new AtomicReference();

    @Override
    public Properties getProperties() {
        return new Properties(this.properties);
    }

    @Override
    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    @Override
    public int getDefaultRangeQueryCapacity() {
        return this.defaultRangeQueryCapacity;
    }

    @Override
    public boolean getBatchApiOnly() {
        return this.batchApiOnly;
    }

    @Override
    public int getMaxStaleLocatorRetries() {
        return this.maxStaleLocatorRetries;
    }

    @Override
    public int getMaxParallelTasksPerRequest() {
        return this.maxParallelTasksPerRequest;
    }

    @Override
    public boolean isReadConsistent() {
        return this.readConsistent;
    }

    @Override
    public long getTaskTimeout() {
        return this.taskTimeout;
    }

    public int getLocatorCacheCapacity() {
        return this.locatorCacheCapacity;
    }

    public long getLocatorCacheTimeout() {
        return this.locatorCacheTimeout;
    }

    @Override
    public int getIndexCacheCapacity() {
        return this.indexCacheCapacity;
    }

    @Override
    public long getIndexCacheTimeout() {
        return this.indexCacheTimeout;
    }

    protected AbstractClient(Properties properties) {
        Banner.banner();
        if (properties == null) {
            throw new IllegalArgumentException();
        }
        this.properties = properties;
        this.threadPoolSize = Integer.parseInt(properties.getProperty(IBigdataClient.Options.CLIENT_THREAD_POOL_SIZE, "0"));
        if (log.isInfoEnabled()) {
            log.info((Object)(IBigdataClient.Options.CLIENT_THREAD_POOL_SIZE + "=" + this.threadPoolSize));
        }
        this.maxStaleLocatorRetries = Integer.parseInt(properties.getProperty(IBigdataClient.Options.CLIENT_MAX_STALE_LOCATOR_RETRIES, "100"));
        if (log.isInfoEnabled()) {
            log.info((Object)(IBigdataClient.Options.CLIENT_MAX_STALE_LOCATOR_RETRIES + "=" + this.maxStaleLocatorRetries));
        }
        if (this.maxStaleLocatorRetries < 0) {
            throw new RuntimeException(IBigdataClient.Options.CLIENT_MAX_STALE_LOCATOR_RETRIES + " must be non-negative");
        }
        this.readConsistent = Boolean.valueOf(properties.getProperty(IBigdataClient.Options.CLIENT_READ_CONSISTENT, "true"));
        if (log.isInfoEnabled()) {
            log.info((Object)(IBigdataClient.Options.CLIENT_READ_CONSISTENT + "=" + this.readConsistent));
        }
        this.maxParallelTasksPerRequest = Integer.parseInt(properties.getProperty(IBigdataClient.Options.CLIENT_MAX_PARALLEL_TASKS_PER_REQUEST, "100"));
        if (log.isInfoEnabled()) {
            log.info((Object)(IBigdataClient.Options.CLIENT_MAX_PARALLEL_TASKS_PER_REQUEST + "=" + this.maxParallelTasksPerRequest));
        }
        if (this.maxParallelTasksPerRequest <= 0) {
            throw new RuntimeException(IBigdataClient.Options.CLIENT_MAX_PARALLEL_TASKS_PER_REQUEST + " must be positive");
        }
        this.taskTimeout = Long.parseLong(properties.getProperty(IBigdataClient.Options.CLIENT_TASK_TIMEOUT, "9223372036854775807"));
        if (log.isInfoEnabled()) {
            log.info((Object)(IBigdataClient.Options.CLIENT_TASK_TIMEOUT + "=" + this.taskTimeout));
        }
        this.defaultRangeQueryCapacity = Integer.parseInt(properties.getProperty(IBigdataClient.Options.CLIENT_RANGE_QUERY_CAPACITY, "10000"));
        if (log.isInfoEnabled()) {
            log.info((Object)(IBigdataClient.Options.CLIENT_RANGE_QUERY_CAPACITY + "=" + this.defaultRangeQueryCapacity));
        }
        this.batchApiOnly = Boolean.valueOf(properties.getProperty(IBigdataClient.Options.CLIENT_BATCH_API_ONLY, "false"));
        if (log.isInfoEnabled()) {
            log.info((Object)(IBigdataClient.Options.CLIENT_BATCH_API_ONLY + "=" + this.batchApiOnly));
        }
        this.locatorCacheCapacity = Integer.parseInt(properties.getProperty(IBigdataClient.Options.CLIENT_LOCATOR_CACHE_CAPACITY, "20"));
        if (log.isInfoEnabled()) {
            log.info((Object)(IBigdataClient.Options.CLIENT_LOCATOR_CACHE_CAPACITY + "=" + this.locatorCacheCapacity));
        }
        this.locatorCacheTimeout = Long.parseLong(properties.getProperty(IBigdataClient.Options.CLIENT_LOCATOR_CACHE_TIMEOUT, "60000"));
        if (log.isInfoEnabled()) {
            log.info((Object)(IBigdataClient.Options.CLIENT_LOCATOR_CACHE_TIMEOUT + "=" + this.locatorCacheTimeout));
        }
        this.indexCacheCapacity = Integer.parseInt(properties.getProperty(IBigdataClient.Options.CLIENT_INDEX_CACHE_CAPACITY, "20"));
        if (log.isInfoEnabled()) {
            log.info((Object)(IBigdataClient.Options.CLIENT_INDEX_CACHE_CAPACITY + "=" + this.indexCacheCapacity));
        }
        if (this.indexCacheCapacity <= 0) {
            throw new RuntimeException(IBigdataClient.Options.CLIENT_INDEX_CACHE_CAPACITY + " must be positive");
        }
        this.indexCacheTimeout = Long.parseLong(properties.getProperty(IBigdataClient.Options.CLIENT_INDEX_CACHE_TIMEOUT, "60000"));
        if (log.isInfoEnabled()) {
            log.info((Object)(IBigdataClient.Options.CLIENT_INDEX_CACHE_TIMEOUT + "=" + this.indexCacheTimeout));
        }
        if (this.indexCacheTimeout < 0L) {
            throw new RuntimeException(IBigdataClient.Options.CLIENT_INDEX_CACHE_TIMEOUT + " must be non-negative");
        }
    }

    public final IFederationDelegate<T> getDelegate() {
        return this.delegate.get();
    }

    public final void setDelegate(IFederationDelegate<T> delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException();
        }
        if (this.isConnected()) {
            throw new IllegalStateException();
        }
        if (!this.delegate.compareAndSet(null, delegate) && !this.delegate.compareAndSet(delegate, delegate)) {
            throw new IllegalStateException();
        }
    }

    protected void finalize() throws Throwable {
        if (this.isConnected()) {
            log.warn((Object)"Disconnecting client or service");
            this.disconnect(true);
        }
        super.finalize();
    }
}

