/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service;

import com.bigdata.btree.BTree;
import com.bigdata.btree.Checkpoint;
import com.bigdata.btree.DefaultTupleSerializer;
import com.bigdata.btree.ITuple;
import com.bigdata.btree.IndexMetadata;
import com.bigdata.btree.keys.ASCIIKeyBuilderFactory;
import com.bigdata.btree.keys.IKeyBuilder;
import com.bigdata.btree.keys.IKeyBuilderFactory;
import com.bigdata.btree.keys.KeyBuilder;
import com.bigdata.rawstore.IRawStore;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.UUID;

public class CommitTimeIndex
extends BTree {
    private final IKeyBuilder keyBuilder = new KeyBuilder(8);

    public static CommitTimeIndex createTransient() {
        IndexMetadata metadata = new IndexMetadata(UUID.randomUUID());
        metadata.setBTreeClassName(CommitTimeIndex.class.getName());
        metadata.setTupleSerializer(new TupleSerializer(new ASCIIKeyBuilderFactory(8)));
        return (CommitTimeIndex)BTree.createTransient(metadata);
    }

    public CommitTimeIndex(IRawStore store, Checkpoint checkpoint, IndexMetadata metadata, boolean readOnly) {
        super(store, checkpoint, metadata, readOnly);
    }

    protected byte[] encodeKey(long commitTime) {
        return this.keyBuilder.reset().append(commitTime).getKey();
    }

    protected long decodeKey(byte[] key) {
        return KeyBuilder.decodeLong(key, 0);
    }

    public synchronized long find(long timestamp) {
        if (timestamp <= 0L) {
            throw new IllegalArgumentException();
        }
        long index = this.findIndexOf(timestamp);
        if (index == -1L) {
            return -1L;
        }
        return this.decodeKey(this.keyAt(index));
    }

    public synchronized long findNext(long timestamp) {
        if (timestamp < 0L) {
            throw new IllegalArgumentException();
        }
        long index = this.findIndexOf(Math.abs(timestamp)) + 1L;
        if (index == this.nentries) {
            return -1L;
        }
        return this.decodeKey(this.keyAt(index));
    }

    public synchronized long findIndexOf(long timestamp) {
        long pos = super.indexOf(this.encodeKey(timestamp));
        if (pos < 0L) {
            if ((pos = -(pos + 1L)) == 0L) {
                return -1L;
            }
            return --pos;
        }
        return pos;
    }

    public void add(long commitTime) {
        if (commitTime == 0L) {
            throw new IllegalArgumentException();
        }
        byte[] key = this.encodeKey(commitTime);
        if (!super.contains(key)) {
            super.insert(key, null);
        }
    }

    protected static class TupleSerializer
    extends DefaultTupleSerializer<Long, Void> {
        private static final long serialVersionUID = -2851852959439807542L;
        private static final transient byte VERSION0 = 0;
        private static final transient byte VERSION = 0;

        public TupleSerializer() {
        }

        public TupleSerializer(IKeyBuilderFactory keyBuilderFactory) {
            super(keyBuilderFactory);
        }

        @Override
        public Long deserializeKey(ITuple tuple) {
            byte[] key = tuple.getKeyBuffer().array();
            long id = KeyBuilder.decodeLong(key, 0);
            return id;
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
            byte version = in.readByte();
            switch (version) {
                case 0: {
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown version: " + version);
                }
            }
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            super.writeExternal(out);
            out.writeByte(0);
        }
    }
}

