/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service.ndx;

import com.bigdata.counters.CounterSet;
import com.bigdata.counters.Instrument;
import com.bigdata.util.concurrent.TaskCounters;
import java.util.concurrent.TimeUnit;

public class IndexSyncRPCCounters
extends TaskCounters {
    public long redirectCount = 0L;
    public long requestCount = 0L;
    public long elementsOut = 0L;
    public long pointRequestCount;
    public long keyRangeRequestCount;
    public long keyArrayRequestCount;
    public long readOnlyRequestCount;

    public double getAverageNanosPerRequest() {
        return this.requestCount == 0L ? 0.0 : (double)this.serviceNanoTime.get() / (double)this.requestCount;
    }

    public double getAverageElementsPerRequest() {
        return this.requestCount == 0L ? 0.0 : (double)this.elementsOut / (double)this.requestCount;
    }

    @Override
    public CounterSet getCounters() {
        CounterSet t = super.getCounters();
        t.addCounter("redirectCount", new Instrument<Long>(){

            @Override
            protected void sample() {
                this.setValue(IndexSyncRPCCounters.this.redirectCount);
            }
        });
        t.addCounter("requestCount", new Instrument<Long>(){

            @Override
            protected void sample() {
                this.setValue(IndexSyncRPCCounters.this.requestCount);
            }
        });
        t.addCounter("pointRequestCount", new Instrument<Long>(){

            @Override
            protected void sample() {
                this.setValue(IndexSyncRPCCounters.this.pointRequestCount);
            }
        });
        t.addCounter("keyRangeRequestCount", new Instrument<Long>(){

            @Override
            protected void sample() {
                this.setValue(IndexSyncRPCCounters.this.keyRangeRequestCount);
            }
        });
        t.addCounter("keyArrayRequestCount", new Instrument<Long>(){

            @Override
            protected void sample() {
                this.setValue(IndexSyncRPCCounters.this.keyArrayRequestCount);
            }
        });
        t.addCounter("readOnlyRequestCount", new Instrument<Long>(){

            @Override
            protected void sample() {
                this.setValue(IndexSyncRPCCounters.this.readOnlyRequestCount);
            }
        });
        t.addCounter("elementsOut", new Instrument<Long>(){

            @Override
            protected void sample() {
                this.setValue(IndexSyncRPCCounters.this.elementsOut);
            }
        });
        t.addCounter("averageMillisPerRequest", new Instrument<Long>(){

            @Override
            protected void sample() {
                this.setValue(TimeUnit.NANOSECONDS.toMillis((long)IndexSyncRPCCounters.this.getAverageNanosPerRequest()));
            }
        });
        t.addCounter("averageElementsPerRequest", new Instrument<Double>(){

            @Override
            protected void sample() {
                this.setValue(IndexSyncRPCCounters.this.getAverageElementsPerRequest());
            }
        });
        return t;
    }
}

