/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.sparse;

public enum KeyType {
    Integer(0, 4),
    Long(1, 8),
    Float(2, 4),
    Double(3, 8),
    Unicode(4, 0),
    ASCII(5, 0),
    Date(6, 8);

    private final byte b;
    private final int encodedLength;

    private KeyType(int b, int encodedLength) {
        this.b = (byte)b;
        this.encodedLength = encodedLength;
    }

    public boolean isFixedLength() {
        return this.encodedLength != 0;
    }

    public int getEncodedLength() {
        return this.encodedLength;
    }

    public byte getByteCode() {
        return this.b;
    }

    public static KeyType getKeyType(byte b) {
        switch (b) {
            case 0: {
                return Integer;
            }
            case 1: {
                return Long;
            }
            case 2: {
                return Float;
            }
            case 3: {
                return Double;
            }
            case 4: {
                return Unicode;
            }
            case 5: {
                return ASCII;
            }
            case 6: {
                return Date;
            }
        }
        throw new IllegalArgumentException("byte=" + b);
    }
}

