/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.sparse;

import com.bigdata.io.DataInputBuffer;
import com.bigdata.io.DataOutputBuffer;
import com.bigdata.io.SerializerUtil;
import com.bigdata.sparse.AutoIncIntegerCounter;
import com.bigdata.sparse.AutoIncLongCounter;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;

public enum ValueType {
    Integer(1),
    Long(2),
    Float(3),
    Double(4),
    Unicode(5),
    Date(6),
    ByteArray(7),
    AutoIncInteger(8),
    AutoIncLong(9),
    Serializable(10);

    private final int code;
    private static final String UTF8 = "UTF-8";
    private static ThreadLocal buf;

    private ValueType(int code) {
        this.code = code;
    }

    public int intValue() {
        return this.code;
    }

    public static ValueType valueOf(int code) {
        switch (code) {
            case 1: {
                return Integer;
            }
            case 2: {
                return Long;
            }
            case 3: {
                return Float;
            }
            case 4: {
                return Double;
            }
            case 5: {
                return Unicode;
            }
            case 6: {
                return Date;
            }
            case 7: {
                return ByteArray;
            }
            case 8: {
                return AutoIncInteger;
            }
            case 9: {
                return AutoIncLong;
            }
            case 10: {
                return Serializable;
            }
        }
        throw new IllegalArgumentException("Unknown code: " + code);
    }

    public static DataOutputBuffer getBuffer() {
        return (DataOutputBuffer)buf.get();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static byte[] encode(Object v) {
        try {
            if (v == null) {
                return null;
            }
            DataOutputBuffer buf = ValueType.getBuffer();
            buf.reset();
            if (v instanceof byte[]) {
                buf.writeByte(ByteArray.intValue());
                byte[] bytes = (byte[])v;
                buf.packLong(bytes.length);
                buf.write(bytes);
                return buf.toByteArray();
            } else if (v instanceof Number) {
                if (v instanceof Integer) {
                    buf.writeByte(Integer.intValue());
                    buf.writeInt(((Number)v).intValue());
                    return buf.toByteArray();
                } else if (v instanceof Long) {
                    buf.writeByte(Long.intValue());
                    buf.writeLong(((Number)v).longValue());
                    return buf.toByteArray();
                } else if (v instanceof Float) {
                    buf.writeByte(Float.intValue());
                    buf.writeFloat(((Number)v).floatValue());
                    return buf.toByteArray();
                } else {
                    if (!(v instanceof Double)) throw new UnsupportedOperationException();
                    buf.writeByte(Double.intValue());
                    buf.writeDouble(((Number)v).doubleValue());
                }
                return buf.toByteArray();
            } else if (v instanceof Date) {
                buf.writeByte(Date.intValue());
                buf.writeLong(((Date)v).getTime());
                return buf.toByteArray();
            } else if (v instanceof String) {
                buf.writeByte(Unicode.intValue());
                byte[] bytes = ((String)v).getBytes(UTF8);
                buf.packLong(bytes.length);
                buf.write(bytes);
                return buf.toByteArray();
            } else if (v instanceof AutoIncIntegerCounter) {
                buf.writeByte(AutoIncInteger.intValue());
                return buf.toByteArray();
            } else if (v instanceof AutoIncLongCounter) {
                buf.writeByte(AutoIncLong.intValue());
                return buf.toByteArray();
            } else {
                if (!(v instanceof Serializable)) throw new UnsupportedOperationException();
                buf.writeByte(Serializable.intValue());
                byte[] bytes = SerializerUtil.serialize(v);
                buf.packLong(bytes.length);
                buf.write(bytes);
            }
            return buf.toByteArray();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Object decode(byte[] v) {
        if (v == null) {
            return null;
        }
        if (v.length == 0) {
            throw new IllegalArgumentException("Zero length byte[]");
        }
        DataInputBuffer buf = new DataInputBuffer(v, 0, v.length);
        try {
            ValueType type = ValueType.valueOf(buf.readByte());
            switch (type) {
                case Integer: {
                    return buf.readInt();
                }
                case Long: {
                    return buf.readLong();
                }
                case Float: {
                    return java.lang.Float.valueOf(buf.readFloat());
                }
                case Double: {
                    return buf.readDouble();
                }
                case Unicode: {
                    int len = (int)buf.unpackLong();
                    byte[] bytes = new byte[len];
                    buf.readFully(bytes);
                    String s = new String(bytes, UTF8);
                    return s;
                }
                case Date: {
                    return new Date(buf.readLong());
                }
                case ByteArray: {
                    int len = (int)buf.unpackLong();
                    byte[] bytes = new byte[len];
                    buf.readFully(bytes);
                    return bytes;
                }
                case AutoIncInteger: {
                    return AutoIncIntegerCounter.INSTANCE;
                }
                case AutoIncLong: {
                    return AutoIncLongCounter.INSTANCE;
                }
                case Serializable: {
                    int len = (int)buf.unpackLong();
                    byte[] bytes = new byte[len];
                    buf.readFully(bytes);
                    return SerializerUtil.deserialize(bytes);
                }
            }
            throw new AssertionError((Object)("type=" + (Object)((Object)type)));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    static {
        buf = new ThreadLocal(){

            protected synchronized Object initialValue() {
                return new DataOutputBuffer();
            }
        };
    }
}

