/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.striterator;

import com.bigdata.striterator.IChunkedIterator;
import com.bigdata.striterator.IChunkedOrderedIterator;
import com.bigdata.striterator.IFilter;
import com.bigdata.striterator.IKeyOrder;
import cutthecrap.utils.striterators.ICloseableIterator;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class Resolver<I extends Iterator<E>, E, F>
implements IFilter<I, E, F> {
    private final int chunkSize;
    private final IKeyOrder<F> keyOrder;

    public Resolver() {
        this(100, null);
    }

    public Resolver(int chunkSize, IKeyOrder<F> keyOrder) {
        this.chunkSize = chunkSize;
        this.keyOrder = keyOrder;
    }

    @Override
    public IChunkedIterator<F> filter(I src) {
        return new ChunkedResolvingIterator(src, this);
    }

    protected abstract F resolve(E var1);

    private static class ChunkedResolvingIterator<I extends Iterator<E>, E, F>
    implements IChunkedOrderedIterator<F> {
        private final I src;
        private final Resolver<I, E, F> filter;

        public ChunkedResolvingIterator(I src, Resolver<I, E, F> filter) {
            if (src == null) {
                throw new IllegalArgumentException();
            }
            this.src = src;
            this.filter = filter;
        }

        @Override
        public IKeyOrder<F> getKeyOrder() {
            return ((Resolver)this.filter).keyOrder;
        }

        public boolean hasNext() {
            return this.src.hasNext();
        }

        @Override
        public F next() {
            return this.filter.resolve(this.src.next());
        }

        @Override
        public F[] nextChunk() {
            if (!this.src.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.src instanceof IChunkedIterator) {
                E[] a = ((IChunkedIterator)this.src).nextChunk();
                return this.resolveChunk(a, a.length);
            }
            Object[] a = null;
            int n = 0;
            for (int i = 0; i < ((Resolver)this.filter).chunkSize && this.src.hasNext(); ++i) {
                Object e = this.src.next();
                if (a == null) {
                    a = (Object[])Array.newInstance(e.getClass(), ((Resolver)this.filter).chunkSize);
                }
                a[i] = e;
                ++n;
            }
            return this.resolveChunk(a, n);
        }

        protected F[] resolveChunk(E[] a, int n) {
            Object[] b = null;
            for (int i = 0; i < n; ++i) {
                F e = this.filter.resolve(a[i]);
                if (b == null) {
                    b = (Object[])Array.newInstance(e.getClass(), n);
                }
                b[i] = e;
            }
            return b;
        }

        @Override
        public F[] nextChunk(IKeyOrder<F> keyOrder) {
            if (keyOrder == null) {
                throw new IllegalArgumentException();
            }
            F[] chunk = this.nextChunk();
            if (!keyOrder.equals(this.getKeyOrder())) {
                Arrays.sort(chunk, 0, chunk.length, keyOrder.getComparator());
            }
            return chunk;
        }

        @Override
        public void remove() {
            this.src.remove();
        }

        public void close() {
            if (this.src instanceof ICloseableIterator) {
                ((ICloseableIterator)this.src).close();
            }
        }
    }
}

