/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.rdf;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpUtility;
import com.bigdata.bop.Constant;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IValueExpression;
import com.bigdata.bop.Var;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.constraints.IVValueExpression;
import com.bigdata.rdf.internal.constraints.OrBOp;
import java.util.Iterator;
import java.util.Map;
import junit.framework.TestCase2;
import org.apache.log4j.Logger;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.sail.SailRepository;
import org.openrdf.sail.Sail;
import org.openrdf.sail.memory.MemoryStore;

public class TestBOpUtility
extends TestCase2 {
    private static final Logger log = Logger.getLogger(TestBOpUtility.class);

    public TestBOpUtility() {
    }

    public TestBOpUtility(String name) {
        super(name);
    }

    private void eatData(Iterator<?> itr) {
        int i = 1;
        while (itr.hasNext()) {
            Object t = itr.next();
            ++i;
        }
    }

    private BOp generateBOp(int count, IValueExpression<?> a) {
        DummyVE bop = null;
        for (int i = 0; i < count; ++i) {
            DummyVE c = new DummyVE(new BOp[]{a, new Constant((Object)i)}, BOp.NOANNS);
            bop = bop == null ? c : new OrBOp((IValueExpression)c, (IValueExpression)bop);
        }
        return bop;
    }

    public void test_getSpannedVariables() {
        Var a = Var.var((String)"a");
        if (log.isInfoEnabled()) {
            log.info((Object)"depth, millis");
        }
        int ntrials = 2000;
        for (int count = 1; count < 2000; ++count) {
            BOp bop = this.generateBOp(count, (IValueExpression<?>)a);
            long begin = System.currentTimeMillis();
            if (log.isInfoEnabled()) {
                log.info((Object)count);
            }
            this.eatData(BOpUtility.preOrderIterator((BOp)bop));
            long elapsed = System.currentTimeMillis() - begin;
            if (!log.isInfoEnabled()) continue;
            log.info((Object)(", " + elapsed));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOpenWorldEq() throws Exception {
        MemoryStore sail = new MemoryStore();
        SailRepository repo = new SailRepository((Sail)sail);
        repo.initialize();
        RepositoryConnection cxn = repo.getConnection();
        try {
            ValueFactory vf = sail.getValueFactory();
            URI mike = vf.createURI("http://www.bigdata.com/rdf#mike");
            URI age = vf.createURI("http://www.bigdata.com/rdf#age");
            Literal mikeAge = vf.createLiteral(34);
            cxn.add(vf.createStatement((Resource)mike, RDF.TYPE, (Value)RDFS.RESOURCE), new Resource[0]);
            cxn.add(vf.createStatement((Resource)mike, age, (Value)mikeAge), new Resource[0]);
            String query = "select * where {   ?s ?p ?o .   filter (?o < 40) }";
            TupleQuery tupleQuery = cxn.prepareTupleQuery(QueryLanguage.SPARQL, "select * where {   ?s ?p ?o .   filter (?o < 40) }");
            TupleQueryResult result = tupleQuery.evaluate();
            while (result.hasNext()) {
                BindingSet tmp = (BindingSet)result.next();
                if (!log.isInfoEnabled()) continue;
                log.info((Object)tmp.toString());
            }
        }
        finally {
            cxn.close();
            repo.shutDown();
        }
    }

    private static class DummyVE
    extends IVValueExpression {
        private static final long serialVersionUID = 1942393209821562541L;

        public DummyVE(BOp[] args, Map<String, Object> annotations) {
            super(args, annotations);
        }

        public DummyVE(IVValueExpression op) {
            super(op);
        }

        public IV get(IBindingSet bindingSet) {
            throw new RuntimeException();
        }

        public boolean areGlobalsRequired() {
            return false;
        }
    }
}

