/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.rdf;

import com.bigdata.bop.BOpContext;
import com.bigdata.bop.Constant;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.Var;
import com.bigdata.bop.bindingSet.ListBindingSet;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.impl.literal.XSDNumericIV;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.model.BigdataValueFactoryImpl;
import junit.framework.TestCase2;

public class TestBind
extends TestCase2 {
    public TestBind() {
    }

    public TestBind(String name) {
        super(name);
    }

    public void test_bind01() {
        ListBindingSet expected = new ListBindingSet();
        ListBindingSet left = new ListBindingSet();
        ListBindingSet right = new ListBindingSet();
        IBindingSet actual = BOpContext.bind((IBindingSet)left, (IBindingSet)right, null, null);
        TestBind.assertEquals((Object)expected, (Object)actual);
    }

    public void test_bind02() {
        Var x = Var.var((String)"x");
        Constant val = new Constant((Object)new XSDNumericIV(1));
        ListBindingSet expected = new ListBindingSet();
        expected.set((IVariable)x, (IConstant)val);
        ListBindingSet left = new ListBindingSet();
        left.set((IVariable)x, (IConstant)val);
        ListBindingSet right = new ListBindingSet();
        IBindingSet actual = BOpContext.bind((IBindingSet)left, (IBindingSet)right, null, null);
        TestBind.assertEquals((Object)expected, (Object)actual);
        IBindingSet actual2 = BOpContext.bind((IBindingSet)right, (IBindingSet)left, null, null);
        TestBind.assertEquals((Object)expected, (Object)actual2);
    }

    public void test_bind03() {
        Var x = Var.var((String)"x");
        Constant val = new Constant((Object)new XSDNumericIV(1));
        ListBindingSet expected = new ListBindingSet();
        expected.set((IVariable)x, (IConstant)val);
        ListBindingSet left = new ListBindingSet();
        left.set((IVariable)x, (IConstant)val);
        ListBindingSet right = new ListBindingSet();
        right.set((IVariable)x, (IConstant)val);
        IBindingSet actual = BOpContext.bind((IBindingSet)left, (IBindingSet)right, null, null);
        TestBind.assertEquals((Object)expected, (Object)actual);
        IBindingSet actual2 = BOpContext.bind((IBindingSet)left, (IBindingSet)right, null, null);
        TestBind.assertEquals((Object)expected, (Object)actual2);
    }

    public void test_bind04() {
        Var x = Var.var((String)"x");
        Constant val1 = new Constant((Object)new XSDNumericIV(1));
        Constant val2 = new Constant((Object)new XSDNumericIV(2));
        ListBindingSet left = new ListBindingSet();
        left.set((IVariable)x, (IConstant)val1);
        ListBindingSet right = new ListBindingSet();
        right.set((IVariable)x, (IConstant)val2);
        IBindingSet actual = BOpContext.bind((IBindingSet)left, (IBindingSet)right, null, null);
        TestBind.assertNull((Object)actual);
        IBindingSet actual2 = BOpContext.bind((IBindingSet)left, (IBindingSet)right, null, null);
        TestBind.assertNull((Object)actual2);
    }

    public void test_bind05() {
        BigdataValueFactory f = BigdataValueFactoryImpl.getInstance((String)this.getName());
        BigdataLiteral lit = f.createLiteral(1);
        Var x = Var.var((String)"x");
        XSDNumericIV iv1 = new XSDNumericIV(1);
        XSDNumericIV iv2 = new XSDNumericIV(1);
        XSDNumericIV iv3 = new XSDNumericIV(1);
        Constant val1 = new Constant((Object)iv1);
        Constant val2 = new Constant((Object)iv2);
        Constant val3 = new Constant((Object)iv3);
        iv1.setValue((BigdataValue)lit);
        iv3.setValue((BigdataValue)lit);
        ListBindingSet expected = new ListBindingSet();
        expected.set((IVariable)x, (IConstant)val3);
        ListBindingSet left = new ListBindingSet();
        left.set((IVariable)x, (IConstant)val1);
        ListBindingSet right = new ListBindingSet();
        right.set((IVariable)x, (IConstant)val2);
        IBindingSet actual = BOpContext.bind((IBindingSet)left, (IBindingSet)right, null, null);
        TestBind.assertEquals((Object)expected, (Object)actual);
        TestBind.assertEquals((Object)iv3.getValue(), (Object)((IV)actual.get((IVariable)x).get()).getValue());
    }

    public void test_bind05b() {
        BigdataValueFactory f = BigdataValueFactoryImpl.getInstance((String)this.getName());
        BigdataLiteral lit = f.createLiteral(1);
        Var x = Var.var((String)"x");
        XSDNumericIV iv1 = new XSDNumericIV(1);
        XSDNumericIV iv2 = new XSDNumericIV(1);
        XSDNumericIV iv3 = new XSDNumericIV(1);
        Constant val1 = new Constant((Object)iv1);
        Constant val2 = new Constant((Object)iv2);
        Constant val3 = new Constant((Object)iv3);
        iv2.setValue((BigdataValue)lit);
        iv3.setValue((BigdataValue)lit);
        ListBindingSet expected = new ListBindingSet();
        expected.set((IVariable)x, (IConstant)val3);
        ListBindingSet left = new ListBindingSet();
        left.set((IVariable)x, (IConstant)val1);
        ListBindingSet right = new ListBindingSet();
        right.set((IVariable)x, (IConstant)val2);
        IBindingSet actual = BOpContext.bind((IBindingSet)left, (IBindingSet)right, null, null);
        TestBind.assertEquals((Object)expected, (Object)actual);
        TestBind.assertEquals((Object)iv3.getValue(), (Object)((IV)actual.get((IVariable)x).get()).getValue());
    }

    public void test_bind06() {
        BigdataValueFactory f = BigdataValueFactoryImpl.getInstance((String)this.getName());
        BigdataLiteral lit = f.createLiteral(1);
        Var x = Var.var((String)"x");
        XSDNumericIV iv1 = new XSDNumericIV(1);
        XSDNumericIV iv2 = new XSDNumericIV(1);
        XSDNumericIV iv3 = new XSDNumericIV(1);
        Constant val1 = new Constant((Object)iv1);
        Constant val2 = new Constant((Object)iv2);
        Constant val3 = new Constant((Object)iv3);
        iv2.setValue((BigdataValue)lit);
        iv3.setValue((BigdataValue)lit);
        ListBindingSet expected = new ListBindingSet();
        expected.set((IVariable)x, (IConstant)val3);
        ListBindingSet left = new ListBindingSet();
        left.set((IVariable)x, (IConstant)val1);
        ListBindingSet right = new ListBindingSet();
        right.set((IVariable)x, (IConstant)val2);
        IBindingSet actual = BOpContext.bind((IBindingSet)left, (IBindingSet)right, null, null);
        TestBind.assertEquals((Object)expected, (Object)actual);
        TestBind.assertEquals((Object)iv3.getValue(), (Object)((IV)actual.get((IVariable)x).get()).getValue());
    }
}

