/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.rdf.aggregate;

import com.bigdata.bop.BOpContext;
import com.bigdata.bop.BOpContextBase;
import com.bigdata.bop.Constant;
import com.bigdata.bop.ContextBindingSet;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IValueExpression;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.TestMockUtility;
import com.bigdata.bop.Var;
import com.bigdata.bop.bindingSet.ListBindingSet;
import com.bigdata.bop.rdf.aggregate.SAMPLE;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.constraints.MathBOp;
import com.bigdata.rdf.internal.impl.literal.XSDNumericIV;
import com.bigdata.rdf.sparql.ast.GlobalAnnotations;
import com.bigdata.rdf.store.AbstractTripleStore;
import java.util.LinkedHashSet;
import junit.framework.TestCase2;

public class TestSAMPLE
extends TestCase2 {
    public TestSAMPLE() {
    }

    public TestSAMPLE(String name) {
        super(name);
    }

    public void test_sample() {
        Var org = Var.var((String)"org");
        Var auth = Var.var((String)"auth");
        Var book = Var.var((String)"book");
        Var lprice = Var.var((String)"lprice");
        Constant org1 = new Constant((Object)"org1");
        Constant org2 = new Constant((Object)"org2");
        Constant auth1 = new Constant((Object)"auth1");
        Constant auth2 = new Constant((Object)"auth2");
        Constant auth3 = new Constant((Object)"auth3");
        Constant book1 = new Constant((Object)"book1");
        Constant book2 = new Constant((Object)"book2");
        Constant book3 = new Constant((Object)"book3");
        Constant book4 = new Constant((Object)"book4");
        Constant price5 = new Constant((Object)new XSDNumericIV(5));
        Constant price7 = new Constant((Object)new XSDNumericIV(7));
        Constant price9 = new Constant((Object)new XSDNumericIV(9));
        IBindingSet[] data = new IBindingSet[]{new ListBindingSet(new IVariable[]{org, auth, book, lprice}, new IConstant[]{org1, auth1, book1, price9}), new ListBindingSet(new IVariable[]{org, auth, book, lprice}, new IConstant[]{org1, auth1, book2, price5}), new ListBindingSet(new IVariable[]{org, auth, book, lprice}, new IConstant[]{org1, auth2, book3, price7}), new ListBindingSet(new IVariable[]{org, auth, book, lprice}, new IConstant[]{org2, auth3, book4, price7})};
        Var expr = lprice;
        SAMPLE op = new SAMPLE(false, (IValueExpression)expr);
        TestSAMPLE.assertFalse((boolean)op.isDistinct());
        TestSAMPLE.assertFalse((boolean)op.isWildcard());
        LinkedHashSet<Object> values = new LinkedHashSet<Object>();
        for (IBindingSet bs : data) {
            values.add(expr.get(bs));
        }
        op.reset();
        for (IBindingSet bs : data) {
            op.get(bs);
        }
        TestSAMPLE.assertTrue((boolean)values.contains(op.done()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_sample_with_complex_inner_value_expression() {
        AbstractTripleStore kb = TestMockUtility.mockTripleStore((String)this.getName());
        try {
            BOpContext context = TestMockUtility.mockContext((AbstractTripleStore)kb);
            String lexiconNamespace = kb.getLexiconRelation().getNamespace();
            Var org = Var.var((String)"org");
            Var auth = Var.var((String)"auth");
            Var book = Var.var((String)"book");
            Var lprice = Var.var((String)"lprice");
            Constant org1 = new Constant((Object)"org1");
            Constant org2 = new Constant((Object)"org2");
            Constant auth1 = new Constant((Object)"auth1");
            Constant auth2 = new Constant((Object)"auth2");
            Constant auth3 = new Constant((Object)"auth3");
            Constant book1 = new Constant((Object)"book1");
            Constant book2 = new Constant((Object)"book2");
            Constant book3 = new Constant((Object)"book3");
            Constant book4 = new Constant((Object)"book4");
            Constant price5 = new Constant((Object)new XSDNumericIV(5));
            Constant price7 = new Constant((Object)new XSDNumericIV(7));
            Constant price9 = new Constant((Object)new XSDNumericIV(9));
            IBindingSet[] data = new IBindingSet[]{new ContextBindingSet((BOpContextBase)context, (IBindingSet)new ListBindingSet(new IVariable[]{org, auth, book, lprice}, new IConstant[]{org1, auth1, book1, price9})), new ContextBindingSet((BOpContextBase)context, (IBindingSet)new ListBindingSet(new IVariable[]{org, auth, book, lprice}, new IConstant[]{org1, auth1, book2, price5})), new ContextBindingSet((BOpContextBase)context, (IBindingSet)new ListBindingSet(new IVariable[]{org, auth, book, lprice}, new IConstant[]{org1, auth2, book3, price7})), new ContextBindingSet((BOpContextBase)context, (IBindingSet)new ListBindingSet(new IVariable[]{org, auth, book, lprice}, new IConstant[]{org2, auth3, book4, price7}))};
            MathBOp expr = new MathBOp((IValueExpression)lprice, (IValueExpression)new Constant((Object)new XSDNumericIV(1)), MathBOp.MathOp.PLUS, new GlobalAnnotations(lexiconNamespace, -1L));
            SAMPLE op = new SAMPLE(false, (IValueExpression)expr);
            TestSAMPLE.assertFalse((boolean)op.isDistinct());
            TestSAMPLE.assertFalse((boolean)op.isWildcard());
            LinkedHashSet<Object> values = new LinkedHashSet<Object>();
            for (IBindingSet bs : data) {
                values.add(expr.get(bs));
            }
            op.reset();
            for (IBindingSet bs : data) {
                op.get(bs);
            }
            TestSAMPLE.assertTrue((boolean)values.contains(op.done()));
        }
        finally {
            kb.getIndexManager().destroy();
        }
    }

    public void test_sample_with_null() {
        Var org = Var.var((String)"org");
        Var auth = Var.var((String)"auth");
        Var book = Var.var((String)"book");
        Var lprice = Var.var((String)"lprice");
        Constant org1 = new Constant((Object)"org1");
        Constant org2 = new Constant((Object)"org2");
        Constant auth1 = new Constant((Object)"auth1");
        Constant auth2 = new Constant((Object)"auth2");
        Constant auth3 = new Constant((Object)"auth3");
        Constant book1 = new Constant((Object)"book1");
        Constant book2 = new Constant((Object)"book2");
        Constant book3 = new Constant((Object)"book3");
        Constant book4 = new Constant((Object)"book4");
        Constant price5 = new Constant((Object)new XSDNumericIV(5));
        Constant price7 = new Constant((Object)new XSDNumericIV(7));
        Constant price9 = new Constant((Object)new XSDNumericIV(9));
        IBindingSet[] data = new IBindingSet[]{new ListBindingSet(new IVariable[]{org, auth, book, lprice}, new IConstant[]{org1, auth1, book1, price9}), new ListBindingSet(new IVariable[]{org, auth, book}, new IConstant[]{org1, auth1, book2}), new ListBindingSet(new IVariable[]{org, auth, book, lprice}, new IConstant[]{org1, auth2, book3, price7}), new ListBindingSet(new IVariable[]{org, auth, book, lprice}, new IConstant[]{org2, auth3, book4, price7})};
        Var expr = lprice;
        SAMPLE op = new SAMPLE(false, (IValueExpression)expr);
        TestSAMPLE.assertFalse((boolean)op.isDistinct());
        TestSAMPLE.assertFalse((boolean)op.isWildcard());
        LinkedHashSet<IV> values = new LinkedHashSet<IV>();
        for (IBindingSet bs : data) {
            IV iv = (IV)expr.get(bs);
            if (iv == null) continue;
            values.add(iv);
        }
        op.reset();
        for (IBindingSet bs : data) {
            op.get(bs);
        }
        TestSAMPLE.assertTrue((boolean)values.contains(op.done()));
    }
}

