/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.rdf.aggregate;

import com.bigdata.bop.BOpContext;
import com.bigdata.bop.BOpContextBase;
import com.bigdata.bop.Constant;
import com.bigdata.bop.ContextBindingSet;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IValueExpression;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.TestMockUtility;
import com.bigdata.bop.Var;
import com.bigdata.bop.bindingSet.ListBindingSet;
import com.bigdata.bop.rdf.aggregate.SUM;
import com.bigdata.rdf.error.SparqlTypeErrorException;
import com.bigdata.rdf.internal.VTE;
import com.bigdata.rdf.internal.constraints.MathBOp;
import com.bigdata.rdf.internal.impl.TermId;
import com.bigdata.rdf.internal.impl.literal.XSDIntegerIV;
import com.bigdata.rdf.internal.impl.literal.XSDNumericIV;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.model.BigdataValueFactoryImpl;
import com.bigdata.rdf.sparql.ast.GlobalAnnotations;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.util.InnerCause;
import java.math.BigInteger;
import junit.framework.TestCase2;

public class TestSUM
extends TestCase2 {
    public TestSUM() {
    }

    public TestSUM(String name) {
        super(name);
    }

    public void test_sum() {
        Var org = Var.var((String)"org");
        Var auth = Var.var((String)"auth");
        Var book = Var.var((String)"book");
        Var lprice = Var.var((String)"lprice");
        Constant org1 = new Constant((Object)"org1");
        Constant org2 = new Constant((Object)"org2");
        Constant auth1 = new Constant((Object)"auth1");
        Constant auth2 = new Constant((Object)"auth2");
        Constant auth3 = new Constant((Object)"auth3");
        Constant book1 = new Constant((Object)"book1");
        Constant book2 = new Constant((Object)"book2");
        Constant book3 = new Constant((Object)"book3");
        Constant book4 = new Constant((Object)"book4");
        Constant price5 = new Constant((Object)new XSDNumericIV(5));
        Constant price7 = new Constant((Object)new XSDNumericIV(7));
        Constant price9 = new Constant((Object)new XSDNumericIV(9));
        IBindingSet[] data = new IBindingSet[]{new ListBindingSet(new IVariable[]{org, auth, book, lprice}, new IConstant[]{org1, auth1, book1, price9}), new ListBindingSet(new IVariable[]{org, auth, book, lprice}, new IConstant[]{org1, auth1, book2, price5}), new ListBindingSet(new IVariable[]{org, auth, book, lprice}, new IConstant[]{org1, auth2, book3, price7}), new ListBindingSet(new IVariable[]{org, auth, book, lprice}, new IConstant[]{org2, auth3, book4, price7})};
        SUM op = new SUM(false, new IValueExpression[]{lprice});
        TestSUM.assertFalse((boolean)op.isDistinct());
        TestSUM.assertFalse((boolean)op.isWildcard());
        op.reset();
        for (IBindingSet bs : data) {
            op.get(bs);
        }
        TestSUM.assertEquals((Object)new XSDIntegerIV(BigInteger.valueOf(28L)), (Object)op.done());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_sum_with_complex_inner_value_expression() {
        AbstractTripleStore kb = TestMockUtility.mockTripleStore((String)this.getName());
        try {
            BOpContext context = TestMockUtility.mockContext((AbstractTripleStore)kb);
            String lexiconNamespace = kb.getLexiconRelation().getNamespace();
            Var org = Var.var((String)"org");
            Var auth = Var.var((String)"auth");
            Var book = Var.var((String)"book");
            Var lprice = Var.var((String)"lprice");
            Constant org1 = new Constant((Object)"org1");
            Constant org2 = new Constant((Object)"org2");
            Constant auth1 = new Constant((Object)"auth1");
            Constant auth2 = new Constant((Object)"auth2");
            Constant auth3 = new Constant((Object)"auth3");
            Constant book1 = new Constant((Object)"book1");
            Constant book2 = new Constant((Object)"book2");
            Constant book3 = new Constant((Object)"book3");
            Constant book4 = new Constant((Object)"book4");
            Constant price5 = new Constant((Object)new XSDNumericIV(5));
            Constant price7 = new Constant((Object)new XSDNumericIV(7));
            Constant price9 = new Constant((Object)new XSDNumericIV(9));
            IBindingSet[] data = new IBindingSet[]{new ContextBindingSet((BOpContextBase)context, (IBindingSet)new ListBindingSet(new IVariable[]{org, auth, book, lprice}, new IConstant[]{org1, auth1, book1, price9})), new ContextBindingSet((BOpContextBase)context, (IBindingSet)new ListBindingSet(new IVariable[]{org, auth, book, lprice}, new IConstant[]{org1, auth1, book2, price5})), new ContextBindingSet((BOpContextBase)context, (IBindingSet)new ListBindingSet(new IVariable[]{org, auth, book, lprice}, new IConstant[]{org1, auth2, book3, price7})), new ContextBindingSet((BOpContextBase)context, (IBindingSet)new ListBindingSet(new IVariable[]{org, auth, book, lprice}, new IConstant[]{org2, auth3, book4, price7}))};
            SUM op = new SUM(false, new IValueExpression[]{new MathBOp((IValueExpression)lprice, (IValueExpression)new Constant((Object)new XSDNumericIV(1)), MathBOp.MathOp.PLUS, new GlobalAnnotations(lexiconNamespace, -1L))});
            TestSUM.assertFalse((boolean)op.isDistinct());
            TestSUM.assertFalse((boolean)op.isWildcard());
            op.reset();
            for (IBindingSet bs : data) {
                op.get(bs);
            }
            TestSUM.assertEquals((Object)new XSDIntegerIV(BigInteger.valueOf(32L)), (Object)op.done());
        }
        finally {
            kb.getIndexManager().destroy();
        }
    }

    public void test_sum_with_null() {
        Var org = Var.var((String)"org");
        Var auth = Var.var((String)"auth");
        Var book = Var.var((String)"book");
        Var lprice = Var.var((String)"lprice");
        Constant org1 = new Constant((Object)"org1");
        Constant org2 = new Constant((Object)"org2");
        Constant auth1 = new Constant((Object)"auth1");
        Constant auth2 = new Constant((Object)"auth2");
        Constant auth3 = new Constant((Object)"auth3");
        Constant book1 = new Constant((Object)"book1");
        Constant book2 = new Constant((Object)"book2");
        Constant book3 = new Constant((Object)"book3");
        Constant book4 = new Constant((Object)"book4");
        Constant price5 = new Constant((Object)new XSDNumericIV(5));
        Constant price7 = new Constant((Object)new XSDNumericIV(7));
        Constant price9 = new Constant((Object)new XSDNumericIV(9));
        IBindingSet[] data = new IBindingSet[]{new ListBindingSet(new IVariable[]{org, auth, book, lprice}, new IConstant[]{org1, auth1, book1, price9}), new ListBindingSet(new IVariable[]{org, auth, book}, new IConstant[]{org1, auth1, book2}), new ListBindingSet(new IVariable[]{org, auth, book, lprice}, new IConstant[]{org1, auth2, book3, price7}), new ListBindingSet(new IVariable[]{org, auth, book, lprice}, new IConstant[]{org2, auth3, book4, price7})};
        SUM op = new SUM(false, new IValueExpression[]{lprice});
        TestSUM.assertFalse((boolean)op.isDistinct());
        TestSUM.assertFalse((boolean)op.isWildcard());
        op.reset();
        for (IBindingSet bs : data) {
            op.get(bs);
        }
        TestSUM.assertEquals((Object)new XSDIntegerIV(BigInteger.valueOf(23L)), (Object)op.done());
    }

    public void test_sum_with_errors() {
        BigdataValueFactory f = BigdataValueFactoryImpl.getInstance((String)this.getName());
        Var org = Var.var((String)"org");
        Var auth = Var.var((String)"auth");
        Var book = Var.var((String)"book");
        Var lprice = Var.var((String)"lprice");
        Constant org1 = new Constant((Object)"org1");
        Constant org2 = new Constant((Object)"org2");
        Constant auth1 = new Constant((Object)"auth1");
        TermId tid1 = new TermId(VTE.LITERAL, 1L);
        tid1.setValue((BigdataValue)f.createLiteral("auth2"));
        Constant auth2 = new Constant((Object)tid1);
        Constant auth3 = new Constant((Object)"auth3");
        Constant book1 = new Constant((Object)"book1");
        Constant book2 = new Constant((Object)"book2");
        Constant book3 = new Constant((Object)"book3");
        Constant book4 = new Constant((Object)"book4");
        Constant price5 = new Constant((Object)new XSDNumericIV(5));
        Constant price7 = new Constant((Object)new XSDNumericIV(7));
        Constant price9 = new Constant((Object)new XSDNumericIV(9));
        IBindingSet[] data = new IBindingSet[]{new ListBindingSet(new IVariable[]{org, auth, book, lprice}, new IConstant[]{org1, auth1, book1, price9}), new ListBindingSet(new IVariable[]{org, auth, book, lprice}, new IConstant[]{org1, auth1, book2, price5}), new ListBindingSet(new IVariable[]{org, auth, book, lprice}, new IConstant[]{org1, auth2, book3, auth2}), new ListBindingSet(new IVariable[]{org, auth, book, lprice}, new IConstant[]{org2, auth3, book4, price7})};
        SUM op = new SUM(false, new IValueExpression[]{lprice});
        TestSUM.assertFalse((boolean)op.isDistinct());
        TestSUM.assertFalse((boolean)op.isWildcard());
        try {
            op.reset();
            for (IBindingSet bs : data) {
                op.get(bs);
            }
            TestSUM.fail((String)("Expecting: " + SparqlTypeErrorException.class));
        }
        catch (RuntimeException ex) {
            if (InnerCause.isInnerCause((Throwable)ex, SparqlTypeErrorException.class)) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Ignoring expected exception: " + ex));
                }
            }
            TestSUM.fail((String)("Expecting: " + SparqlTypeErrorException.class), (Throwable)ex);
        }
        try {
            op.done();
            TestSUM.fail((String)("Expecting: " + SparqlTypeErrorException.class));
        }
        catch (RuntimeException ex) {
            if (InnerCause.isInnerCause((Throwable)ex, SparqlTypeErrorException.class)) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Ignoring expected exception: " + ex));
                }
            }
            TestSUM.fail((String)("Expecting: " + SparqlTypeErrorException.class), (Throwable)ex);
        }
        op.reset();
        op.done();
    }
}

