/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.rdf.filter;

import com.bigdata.bop.rdf.filter.NativeDistinctFilter;
import com.bigdata.journal.BufferMode;
import com.bigdata.journal.IIndexManager;
import com.bigdata.journal.Journal;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.model.StatementEnum;
import com.bigdata.rdf.spo.SPO;
import com.bigdata.rdf.spo.SPOKeyOrder;
import com.bigdata.rdf.store.LocalTripleStore;
import com.bigdata.rdf.vocab.decls.FOAFVocabularyDecl;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import junit.framework.TestCase2;

public class TestNativeDistinctFilter
extends TestCase2 {
    public TestNativeDistinctFilter() {
    }

    public TestNativeDistinctFilter(String name) {
        super(name);
    }

    public void test_filterKeyOrder_quads() {
        TestNativeDistinctFilter.assertEquals((int[])new int[]{0, 1, 2}, (int[])NativeDistinctFilter.getFilterKeyOrder((SPOKeyOrder)SPOKeyOrder.SPOC));
        TestNativeDistinctFilter.assertEquals((int[])new int[]{0, 1, 3}, (int[])NativeDistinctFilter.getFilterKeyOrder((SPOKeyOrder)SPOKeyOrder.POCS));
        TestNativeDistinctFilter.assertEquals((int[])new int[]{0, 2, 3}, (int[])NativeDistinctFilter.getFilterKeyOrder((SPOKeyOrder)SPOKeyOrder.OCSP));
        TestNativeDistinctFilter.assertEquals((int[])new int[]{1, 2, 3}, (int[])NativeDistinctFilter.getFilterKeyOrder((SPOKeyOrder)SPOKeyOrder.CSPO));
        TestNativeDistinctFilter.assertEquals((int[])new int[]{0, 2, 3}, (int[])NativeDistinctFilter.getFilterKeyOrder((SPOKeyOrder)SPOKeyOrder.PCSO));
        TestNativeDistinctFilter.assertEquals((int[])new int[]{0, 1, 2}, (int[])NativeDistinctFilter.getFilterKeyOrder((SPOKeyOrder)SPOKeyOrder.SOPC));
    }

    public void test_filterKeyOrder_triples() {
        TestNativeDistinctFilter.assertEquals((int[])new int[]{0, 1, 2}, (int[])NativeDistinctFilter.getFilterKeyOrder((SPOKeyOrder)SPOKeyOrder.SPO));
        TestNativeDistinctFilter.assertEquals((int[])new int[]{1, 2, 0}, (int[])NativeDistinctFilter.getFilterKeyOrder((SPOKeyOrder)SPOKeyOrder.POS));
        TestNativeDistinctFilter.assertEquals((int[])new int[]{2, 0, 1}, (int[])NativeDistinctFilter.getFilterKeyOrder((SPOKeyOrder)SPOKeyOrder.OSP));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_htreeDistinctSPOFilter() {
        JoinSetup setup = new JoinSetup(this.getName());
        try {
            LinkedList<SPO> expected = new LinkedList<SPO>(Arrays.asList(new SPO(setup.paul, setup.knows, setup.mary, StatementEnum.Explicit), new SPO(setup.paul, setup.knows, setup.brad, StatementEnum.Explicit), new SPO(setup.john, setup.knows, setup.mary, StatementEnum.Explicit), new SPO(setup.john, setup.knows, setup.brad, StatementEnum.Explicit), new SPO(setup.mary, setup.knows, setup.brad, StatementEnum.Explicit), new SPO(setup.brad, setup.knows, setup.fred, StatementEnum.Explicit), new SPO(setup.brad, setup.knows, setup.leon, StatementEnum.Explicit)));
            LinkedList<SPO> given = new LinkedList<SPO>(expected);
            given.addAll(Arrays.asList(new SPO(setup.john, setup.knows, setup.brad, StatementEnum.Explicit), new SPO(setup.mary, setup.knows, setup.brad, StatementEnum.Explicit), new SPO(setup.brad, setup.knows, setup.fred, StatementEnum.Explicit)));
            Iterator actual = NativeDistinctFilter.newInstance((SPOKeyOrder)SPOKeyOrder.CSPO).filter(given.iterator(), null);
            TestNativeDistinctFilter.assertSameIteratorAnyOrder((Object[])expected.toArray(new SPO[0]), (Iterator)actual);
        }
        finally {
            setup.destroy();
        }
    }

    public static class JoinSetup {
        protected final String spoNamespace;
        protected final IV<?, ?> knows;
        protected final IV<?, ?> brad;
        protected final IV<?, ?> john;
        protected final IV<?, ?> fred;
        protected final IV<?, ?> mary;
        protected final IV<?, ?> paul;
        protected final IV<?, ?> leon;
        protected final IV<?, ?> luke;
        private Journal jnl;

        public JoinSetup(String kbNamespace) {
            if (kbNamespace == null) {
                throw new IllegalArgumentException();
            }
            Properties properties = new Properties();
            properties.setProperty(Journal.Options.BUFFER_MODE, BufferMode.Transient.toString());
            this.jnl = new Journal(properties);
            LocalTripleStore kb = new LocalTripleStore((IIndexManager)this.jnl, kbNamespace, Long.valueOf(0L), properties);
            kb.create();
            this.spoNamespace = kb.getSPORelation().getNamespace();
            BigdataValueFactory vf = kb.getValueFactory();
            String uriString = "http://bigdata.com/";
            BigdataURI _knows = vf.asValue(FOAFVocabularyDecl.knows);
            BigdataURI _brad = vf.createURI("http://bigdata.com/brad");
            BigdataURI _john = vf.createURI("http://bigdata.com/john");
            BigdataURI _fred = vf.createURI("http://bigdata.com/fred");
            BigdataURI _mary = vf.createURI("http://bigdata.com/mary");
            BigdataURI _paul = vf.createURI("http://bigdata.com/paul");
            BigdataURI _leon = vf.createURI("http://bigdata.com/leon");
            BigdataURI _luke = vf.createURI("http://bigdata.com/luke");
            BigdataValue[] a = new BigdataValue[]{_knows, _brad, _john, _fred, _mary, _paul, _leon, _luke};
            kb.getLexiconRelation().addTerms(a, a.length, false);
            this.knows = _knows.getIV();
            this.brad = _brad.getIV();
            this.john = _john.getIV();
            this.fred = _fred.getIV();
            this.mary = _mary.getIV();
            this.paul = _paul.getIV();
            this.leon = _leon.getIV();
            this.luke = _luke.getIV();
        }

        protected void destroy() {
            if (this.jnl != null) {
                this.jnl.destroy();
                this.jnl = null;
            }
        }
    }
}

