/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.rdf.joinGraph;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Random;
import java.util.UUID;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFWriter;
import org.openrdf.rio.Rio;
import org.openrdf.sail.memory.model.MemValueFactory;

public class GenerateBarData {
    private static final Random random = new Random(1L);

    public static int getUniformInteger(double prob, int low, int high) {
        if (random.nextDouble() <= prob) {
            return low + random.nextInt(high - low);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException, RDFHandlerException {
        if (args.length != 3) {
            System.err.println("usage: #orders #servers #maxItemsPerOrder");
            System.exit(1);
        }
        int totalOrders = Integer.parseInt(args[0]);
        int totalServers = Integer.parseInt(args[1]);
        int maxItemsPerOrder = Integer.parseInt(args[2]);
        File output = new File("./barData.trig");
        try (FileWriter fw = new FileWriter(output);){
            RDFWriter writer = Rio.createWriter((RDFFormat)RDFFormat.TRIG, (Writer)fw);
            writer.startRDF();
            writer.handleNamespace("bar", "http://test/bar#");
            writer.handleNamespace("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns");
            MemValueFactory factory = new MemValueFactory();
            URI empType = factory.createURI("http://test/bar#Employee");
            URI employeeNum = factory.createURI("http://test/bar#employeeNum");
            URI employee = factory.createURI("http://test/bar#employee");
            URI orderType = factory.createURI("http://test/bar#Order");
            URI orderItemType = factory.createURI("http://test/bar#OrderItem");
            URI orderItems = factory.createURI("http://test/bar#orderItems");
            URI beverage = factory.createURI("http://test/bar#beverageType");
            Literal[] drinks = new Literal[]{factory.createLiteral("Beer"), factory.createLiteral("Wine"), factory.createLiteral("Water"), factory.createLiteral("Soda"), factory.createLiteral("DietSoda"), factory.createLiteral("Juice")};
            URI[] employees = new URI[totalServers];
            for (int s = 0; s < totalServers; ++s) {
                employees[s] = factory.createURI("http://test/bar#employee_" + s);
                writer.handleStatement(factory.createStatement((Resource)employees[s], RDF.TYPE, (Value)empType, (Resource)employees[s]));
                writer.handleStatement(factory.createStatement((Resource)employees[s], employeeNum, (Value)factory.createLiteral(s), (Resource)employees[s]));
            }
            int totalItems = 0;
            for (int i = 0; i < totalOrders; ++i) {
                URI orderGraph = factory.createURI("http://test/bar#order_" + UUID.randomUUID().toString());
                writer.handleStatement(factory.createStatement((Resource)orderGraph, RDF.TYPE, (Value)orderType, (Resource)orderGraph));
                writer.handleStatement(factory.createStatement((Resource)orderGraph, employee, (Value)employees[GenerateBarData.getUniformInteger(1.0, 0, totalServers)], (Resource)orderGraph));
                ArrayList<URI> items = new ArrayList<URI>();
                for (int k = 0; k < GenerateBarData.getUniformInteger(0.9, 1, maxItemsPerOrder); ++k) {
                    ++totalItems;
                    URI orderItem = factory.createURI("http://test/bar#orderItem_" + UUID.randomUUID().toString());
                    items.add(orderItem);
                    writer.handleStatement(factory.createStatement((Resource)orderGraph, orderItems, (Value)orderItem, (Resource)orderGraph));
                }
                for (URI orderItem : items) {
                    writer.handleStatement(factory.createStatement((Resource)orderItem, RDF.TYPE, (Value)orderItemType, (Resource)orderGraph));
                    Literal drink = drinks[GenerateBarData.getUniformInteger(1.0, 0, drinks.length)];
                    writer.handleStatement(factory.createStatement((Resource)orderItem, beverage, (Value)drink, (Resource)orderGraph));
                }
            }
            System.err.println("totalItems=" + totalItems);
            writer.endRDF();
        }
    }
}

