/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.axioms;

import com.bigdata.io.SerializerUtil;
import com.bigdata.rdf.axioms.Axioms;
import com.bigdata.rdf.axioms.NoAxioms;
import com.bigdata.rdf.axioms.OwlAxioms;
import com.bigdata.rdf.axioms.RdfsAxioms;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.spo.SPO;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.store.AbstractTripleStoreTestCase;
import java.util.Iterator;
import java.util.Properties;
import org.openrdf.model.vocabulary.OWL;
import org.openrdf.model.vocabulary.RDF;

public class TestAxioms
extends AbstractTripleStoreTestCase {
    public TestAxioms() {
    }

    public TestAxioms(String name) {
        super(name);
    }

    public void test_ctor_NoAxioms() {
        new NoAxioms(this.getName());
    }

    public void test_ctor_RDFSAxioms() {
        new RdfsAxioms(this.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_NoAxioms() {
        Properties properties = this.getProperties();
        properties.setProperty(AbstractTripleStore.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        AbstractTripleStore store = this.getStore(properties);
        try {
            BigdataValueFactory f = store.getValueFactory();
            TestAxioms.assertEquals((String)store.getAxioms().getNamespace(), (String)f.getNamespace());
            BigdataURI rdfType = f.asValue(RDF.TYPE);
            BigdataURI rdfProperty = f.asValue(RDF.PROPERTY);
            BigdataURI unknownURI = f.createURI("http://www.bigdata.com/unknown");
            store.addTerms(new BigdataValue[]{rdfType, rdfProperty, unknownURI});
            NoAxioms axioms = (NoAxioms)store.getAxioms();
            int naxioms = axioms.size();
            TestAxioms.assertEquals((int)0, (int)naxioms);
            TestAxioms.assertEquals((long)naxioms, (long)store.getStatementCount());
            TestAxioms.assertFalse((boolean)axioms.isAxiom(rdfType.getIV(), rdfType.getIV(), rdfProperty.getIV()));
            TestAxioms.assertFalse((boolean)axioms.isAxiom(rdfType.getIV(), rdfType.getIV(), unknownURI.getIV()));
            Axioms axioms2 = this.doRoundTripTest((Axioms)axioms);
            TestAxioms.assertFalse((boolean)axioms2.isAxiom(rdfType.getIV(), rdfType.getIV(), rdfProperty.getIV()));
            TestAxioms.assertFalse((boolean)axioms2.isAxiom(rdfType.getIV(), rdfType.getIV(), unknownURI.getIV()));
            if (store.isStable()) {
                store = this.reopenStore(store);
                axioms2 = (NoAxioms)store.getAxioms();
                this.assertSameAxioms((Axioms)axioms, axioms2);
                TestAxioms.assertFalse((boolean)axioms2.isAxiom(rdfType.getIV(), rdfType.getIV(), rdfProperty.getIV()));
                TestAxioms.assertFalse((boolean)axioms2.isAxiom(rdfType.getIV(), rdfType.getIV(), unknownURI.getIV()));
            }
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_RdfsAxioms() {
        Properties properties = this.getProperties();
        properties.setProperty(AbstractTripleStore.Options.AXIOMS_CLASS, RdfsAxioms.class.getName());
        AbstractTripleStore store = this.getStore(properties);
        try {
            BigdataValueFactory f = store.getValueFactory();
            BigdataURI rdfType = f.asValue(RDF.TYPE);
            BigdataURI rdfProperty = f.asValue(RDF.PROPERTY);
            BigdataURI unknownURI = f.createURI("http://www.bigdata.com/unknown");
            store.addTerms(new BigdataValue[]{rdfType, rdfProperty, unknownURI});
            RdfsAxioms axioms = (RdfsAxioms)store.getAxioms();
            int naxioms = axioms.size();
            TestAxioms.assertEquals((long)naxioms, (long)store.getStatementCount());
            TestAxioms.assertTrue((boolean)axioms.isAxiom(rdfType.getIV(), rdfType.getIV(), rdfProperty.getIV()));
            TestAxioms.assertFalse((boolean)axioms.isAxiom(rdfType.getIV(), rdfType.getIV(), unknownURI.getIV()));
            Axioms axioms2 = this.doRoundTripTest((Axioms)axioms);
            TestAxioms.assertTrue((boolean)axioms2.isAxiom(rdfType.getIV(), rdfType.getIV(), rdfProperty.getIV()));
            TestAxioms.assertFalse((boolean)axioms2.isAxiom(rdfType.getIV(), rdfType.getIV(), unknownURI.getIV()));
            if (store.isStable()) {
                store = this.reopenStore(store);
                axioms2 = (RdfsAxioms)store.getAxioms();
                this.assertSameAxioms((Axioms)axioms, axioms2);
                TestAxioms.assertTrue((boolean)axioms2.isAxiom(rdfType.getIV(), rdfType.getIV(), rdfProperty.getIV()));
                TestAxioms.assertFalse((boolean)axioms2.isAxiom(rdfType.getIV(), rdfType.getIV(), unknownURI.getIV()));
            }
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_OwlAxioms() {
        Properties properties = this.getProperties();
        properties.setProperty(AbstractTripleStore.Options.AXIOMS_CLASS, OwlAxioms.class.getName());
        AbstractTripleStore store = this.getStore(properties);
        try {
            BigdataValueFactory f = store.getValueFactory();
            BigdataURI rdfType = f.asValue(RDF.TYPE);
            BigdataURI rdfProperty = f.asValue(RDF.PROPERTY);
            BigdataURI owlEquivalentClass = f.asValue(OWL.EQUIVALENTCLASS);
            BigdataURI unknownURI = f.createURI("http://www.bigdata.com/unknown");
            store.addTerms(new BigdataValue[]{rdfType, rdfProperty, owlEquivalentClass, unknownURI});
            OwlAxioms axioms = (OwlAxioms)store.getAxioms();
            int naxioms = axioms.size();
            TestAxioms.assertEquals((long)naxioms, (long)store.getStatementCount());
            TestAxioms.assertTrue((boolean)axioms.isAxiom(rdfType.getIV(), rdfType.getIV(), rdfProperty.getIV()));
            TestAxioms.assertTrue((boolean)axioms.isAxiom(owlEquivalentClass.getIV(), rdfType.getIV(), rdfProperty.getIV()));
            TestAxioms.assertFalse((boolean)axioms.isAxiom(rdfType.getIV(), rdfType.getIV(), unknownURI.getIV()));
            Axioms axioms2 = this.doRoundTripTest((Axioms)axioms);
            TestAxioms.assertTrue((boolean)axioms2.isAxiom(rdfType.getIV(), rdfType.getIV(), rdfProperty.getIV()));
            TestAxioms.assertTrue((boolean)axioms2.isAxiom(owlEquivalentClass.getIV(), rdfType.getIV(), rdfProperty.getIV()));
            TestAxioms.assertFalse((boolean)axioms2.isAxiom(rdfType.getIV(), rdfType.getIV(), unknownURI.getIV()));
            if (store.isStable()) {
                store = this.reopenStore(store);
                axioms2 = (OwlAxioms)store.getAxioms();
                this.assertSameAxioms((Axioms)axioms, axioms2);
                TestAxioms.assertTrue((boolean)axioms2.isAxiom(rdfType.getIV(), rdfType.getIV(), rdfProperty.getIV()));
                TestAxioms.assertTrue((boolean)axioms2.isAxiom(owlEquivalentClass.getIV(), rdfType.getIV(), rdfProperty.getIV()));
                TestAxioms.assertFalse((boolean)axioms2.isAxiom(rdfType.getIV(), rdfType.getIV(), unknownURI.getIV()));
            }
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    protected Axioms doRoundTripTest(Axioms expected) {
        byte[] data = SerializerUtil.serialize((Object)expected);
        Axioms actual = (Axioms)SerializerUtil.deserialize((byte[])data);
        this.assertSameAxioms(expected, actual);
        return actual;
    }

    protected void assertSameAxioms(Axioms expected, Axioms actual) {
        TestAxioms.assertEquals((String)"size", (int)expected.size(), (int)actual.size());
        Iterator itre = expected.axioms();
        Iterator itra = actual.axioms();
        while (itre.hasNext()) {
            TestAxioms.assertTrue((boolean)itra.hasNext());
            SPO spoe = (SPO)itre.next();
            SPO spoa = (SPO)itra.next();
            if (log.isInfoEnabled()) {
                log.info((Object)spoe.toString());
            }
            this.assertEquals(spoe, spoa);
        }
        TestAxioms.assertFalse((boolean)itra.hasNext());
    }
}

