/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.graph.impl.bd;

import com.bigdata.journal.BufferMode;
import com.bigdata.journal.Journal;
import com.bigdata.rdf.graph.AbstractGraphTestCase;
import com.bigdata.rdf.graph.impl.bd.BigdataGraphFixture;
import com.bigdata.rdf.graph.util.IGraphFixture;
import com.bigdata.rdf.graph.util.IGraphFixtureFactory;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.sail.BigdataSail;
import java.util.Properties;
import junit.framework.TestCase;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.vocabulary.RDF;

public class AbstractBigdataGraphTestCase
extends AbstractGraphTestCase {
    public AbstractBigdataGraphTestCase() {
    }

    public AbstractBigdataGraphTestCase(String name) {
        super(name);
    }

    protected IGraphFixtureFactory getGraphFixtureFactory() {
        return new IGraphFixtureFactory(){

            public IGraphFixture newGraphFixture() throws Exception {
                return new BigdataGraphFixture(AbstractBigdataGraphTestCase.this.getProperties());
            }
        };
    }

    protected Properties getProperties() {
        Properties p = new Properties();
        p.setProperty(Journal.Options.BUFFER_MODE, BufferMode.MemStore.toString());
        p.setProperty(BigdataSail.Options.TRIPLES_MODE, "true");
        p.setProperty(BigdataSail.Options.TRUTH_MAINTENANCE, "false");
        return p;
    }

    protected BigdataGraphFixture getGraphFixture() {
        return (BigdataGraphFixture)super.getGraphFixture();
    }

    protected SmallGraphProblem setupSmallGraphProblem() throws Exception {
        return new SmallGraphProblem();
    }

    protected SmallWeightedGraphProblem setupSmallWeightedGraphProblem() throws Exception {
        return new SmallWeightedGraphProblem();
    }

    protected class SmallWeightedGraphProblem {
        private static final String smallWeightedGraph = "src/test/resources/graph/data/smallWeightedGraph.ttlx";
        private final BigdataURI foafKnows;
        private final BigdataURI linkWeight;
        private final BigdataURI v1;
        private final BigdataURI v2;
        private final BigdataURI v3;
        private final BigdataURI v4;
        private final BigdataURI v5;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SmallWeightedGraphProblem() throws Exception {
            AbstractBigdataGraphTestCase.this.getGraphFixture().loadGraph(new String[]{smallWeightedGraph});
            try (BigdataSail.BigdataSailConnection conn = AbstractBigdataGraphTestCase.this.getGraphFixture().getSail().getReadOnlyConnection();){
                ValueFactory vf = conn.getBigdataSail().getValueFactory();
                this.foafKnows = (BigdataURI)vf.createURI("http://xmlns.com/foaf/0.1/knows");
                this.linkWeight = (BigdataURI)vf.createURI("http://www.bigdata.com/weight");
                this.v1 = (BigdataURI)vf.createURI("http://www.bigdata.com/1");
                this.v2 = (BigdataURI)vf.createURI("http://www.bigdata.com/2");
                this.v3 = (BigdataURI)vf.createURI("http://www.bigdata.com/3");
                this.v4 = (BigdataURI)vf.createURI("http://www.bigdata.com/4");
                this.v5 = (BigdataURI)vf.createURI("http://www.bigdata.com/5");
                BigdataValue[] terms = new BigdataValue[]{this.foafKnows, this.linkWeight, this.v1, this.v2, this.v3, this.v4, this.v5};
                conn.getTripleStore().getLexiconRelation().addTerms(terms, terms.length, true);
                for (BigdataValue v : terms) {
                    if (v.getIV() != null) continue;
                    TestCase.fail((String)("Did not resolve: " + v));
                }
            }
        }

        public IV getFoafKnows() {
            return this.foafKnows.getIV();
        }

        public IV getLinkWeight() {
            return this.linkWeight.getIV();
        }

        public IV getV1() {
            return this.v1.getIV();
        }

        public IV getV2() {
            return this.v2.getIV();
        }

        public IV getV3() {
            return this.v3.getIV();
        }

        public IV getV4() {
            return this.v4.getIV();
        }

        public IV getV5() {
            return this.v5.getIV();
        }
    }

    protected class SmallGraphProblem {
        private static final String smallGraph = "src/test/resources/graph/data/smallGraph.ttl";
        private final BigdataURI rdfType;
        private final BigdataURI foafKnows;
        private final BigdataURI foafPerson;
        private final BigdataURI mike;
        private final BigdataURI bryan;
        private final BigdataURI martyn;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SmallGraphProblem() throws Exception {
            AbstractBigdataGraphTestCase.this.getGraphFixture().loadGraph(new String[]{smallGraph});
            try (BigdataSail.BigdataSailConnection conn = AbstractBigdataGraphTestCase.this.getGraphFixture().getSail().getReadOnlyConnection();){
                ValueFactory vf = conn.getBigdataSail().getValueFactory();
                this.rdfType = (BigdataURI)vf.createURI(RDF.TYPE.stringValue());
                this.foafKnows = (BigdataURI)vf.createURI("http://xmlns.com/foaf/0.1/knows");
                this.foafPerson = (BigdataURI)vf.createURI("http://xmlns.com/foaf/0.1/Person");
                this.mike = (BigdataURI)vf.createURI("http://www.bigdata.com/Mike");
                this.bryan = (BigdataURI)vf.createURI("http://www.bigdata.com/Bryan");
                this.martyn = (BigdataURI)vf.createURI("http://www.bigdata.com/Martyn");
                BigdataValue[] terms = new BigdataValue[]{this.rdfType, this.foafKnows, this.foafPerson, this.mike, this.bryan, this.martyn};
                conn.getTripleStore().getLexiconRelation().addTerms(terms, terms.length, true);
                for (BigdataValue v : terms) {
                    if (v.getIV() != null) continue;
                    TestCase.fail((String)("Did not resolve: " + v));
                }
            }
        }

        public IV getRdfType() {
            return this.rdfType.getIV();
        }

        public IV getFoafKnows() {
            return this.foafKnows.getIV();
        }

        public IV getFoafPerson() {
            return this.foafPerson.getIV();
        }

        public IV getMike() {
            return this.mike.getIV();
        }

        public IV getBryan() {
            return this.bryan.getIV();
        }

        public IV getMartyn() {
            return this.martyn.getIV();
        }
    }
}

