/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.graph.impl.bd;

import com.bigdata.rdf.graph.IGASContext;
import com.bigdata.rdf.graph.IGASProgram;
import com.bigdata.rdf.graph.IGASState;
import com.bigdata.rdf.graph.IGraphAccessor;
import com.bigdata.rdf.graph.TraversalDirectionEnum;
import com.bigdata.rdf.graph.analytics.BFS;
import com.bigdata.rdf.graph.impl.bd.AbstractBigdataGraphTestCase;
import com.bigdata.rdf.graph.impl.bd.BigdataGASEngine;
import com.bigdata.rdf.sail.BigdataSail;
import org.openrdf.model.Value;
import org.openrdf.sail.SailConnection;

public class TestBFS
extends AbstractBigdataGraphTestCase {
    public TestBFS() {
    }

    public TestBFS(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBFS() throws Exception {
        AbstractBigdataGraphTestCase.SmallGraphProblem p = this.setupSmallGraphProblem();
        BigdataGASEngine gasEngine = this.getGraphFixture().newGASEngine(1);
        try {
            IGraphAccessor graphAccessor = this.getGraphFixture().newGraphAccessor(null);
            IGASContext gasContext = gasEngine.newGASContext(graphAccessor, (IGASProgram)new BFS());
            IGASState gasState = gasContext.getGASState();
            gasState.setFrontier(gasContext, new Value[]{p.getMike()});
            gasContext.call();
            TestBFS.assertEquals((int)0, (int)((BFS.VS)gasState.getState((Value)p.getMike())).depth());
            TestBFS.assertEquals(null, (Object)((BFS.VS)gasState.getState((Value)p.getMike())).predecessor());
            TestBFS.assertEquals((int)1, (int)((BFS.VS)gasState.getState((Value)p.getFoafPerson())).depth());
            TestBFS.assertEquals((Object)p.getMike(), (Object)((BFS.VS)gasState.getState((Value)p.getFoafPerson())).predecessor());
            TestBFS.assertEquals((int)1, (int)((BFS.VS)gasState.getState((Value)p.getBryan())).depth());
            TestBFS.assertEquals((Object)p.getMike(), (Object)((BFS.VS)gasState.getState((Value)p.getBryan())).predecessor());
            TestBFS.assertEquals((int)2, (int)((BFS.VS)gasState.getState((Value)p.getMartyn())).depth());
            TestBFS.assertEquals((Object)p.getBryan(), (Object)((BFS.VS)gasState.getState((Value)p.getMartyn())).predecessor());
        }
        finally {
            gasEngine.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBFS_directed_forward() throws Exception {
        AbstractBigdataGraphTestCase.SmallGraphProblem p = this.setupSmallGraphProblem();
        BigdataGASEngine gasEngine = this.getGraphFixture().newGASEngine(1);
        try {
            BigdataSail.BigdataSailConnection cxn = this.getGraphFixture().getSail().getConnection();
            try {
                IGraphAccessor graphAccessor = this.getGraphFixture().newGraphAccessor((SailConnection)cxn);
                IGASContext gasContext = gasEngine.newGASContext(graphAccessor, (IGASProgram)new BFS());
                IGASState gasState = gasContext.getGASState();
                gasState.setFrontier(gasContext, new Value[]{p.getFoafPerson()});
                gasContext.setTraversalDirection(TraversalDirectionEnum.Forward);
                gasContext.call();
                TestBFS.assertEquals((int)0, (int)((BFS.VS)gasState.getState((Value)p.getFoafPerson())).depth());
                TestBFS.assertEquals(null, (Object)((BFS.VS)gasState.getState((Value)p.getFoafPerson())).predecessor());
                TestBFS.assertEquals((int)-1, (int)((BFS.VS)gasState.getState((Value)p.getMike())).depth());
                TestBFS.assertEquals(null, (Object)((BFS.VS)gasState.getState((Value)p.getMike())).predecessor());
                TestBFS.assertEquals((int)-1, (int)((BFS.VS)gasState.getState((Value)p.getBryan())).depth());
                TestBFS.assertEquals(null, (Object)((BFS.VS)gasState.getState((Value)p.getBryan())).predecessor());
                TestBFS.assertEquals((int)-1, (int)((BFS.VS)gasState.getState((Value)p.getMartyn())).depth());
                TestBFS.assertEquals(null, (Object)((BFS.VS)gasState.getState((Value)p.getMartyn())).predecessor());
            }
            finally {
                try {
                    cxn.rollback();
                }
                finally {
                    cxn.close();
                }
            }
        }
        finally {
            gasEngine.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBFS_directed_reverse() throws Exception {
        AbstractBigdataGraphTestCase.SmallGraphProblem p = this.setupSmallGraphProblem();
        BigdataGASEngine gasEngine = this.getGraphFixture().newGASEngine(1);
        try {
            BigdataSail.BigdataSailConnection cxn = this.getGraphFixture().getSail().getConnection();
            try {
                IGraphAccessor graphAccessor = this.getGraphFixture().newGraphAccessor((SailConnection)cxn);
                IGASContext gasContext = gasEngine.newGASContext(graphAccessor, (IGASProgram)new BFS());
                IGASState gasState = gasContext.getGASState();
                gasState.setFrontier(gasContext, new Value[]{p.getFoafPerson()});
                gasContext.setTraversalDirection(TraversalDirectionEnum.Reverse);
                gasContext.call();
                TestBFS.assertEquals((int)0, (int)((BFS.VS)gasState.getState((Value)p.getFoafPerson())).depth());
                TestBFS.assertEquals(null, (Object)((BFS.VS)gasState.getState((Value)p.getFoafPerson())).predecessor());
                TestBFS.assertEquals((int)1, (int)((BFS.VS)gasState.getState((Value)p.getMike())).depth());
                TestBFS.assertEquals((Object)p.getFoafPerson(), (Object)((BFS.VS)gasState.getState((Value)p.getMike())).predecessor());
                TestBFS.assertEquals((int)1, (int)((BFS.VS)gasState.getState((Value)p.getBryan())).depth());
                TestBFS.assertEquals((Object)p.getFoafPerson(), (Object)((BFS.VS)gasState.getState((Value)p.getBryan())).predecessor());
                TestBFS.assertEquals((int)1, (int)((BFS.VS)gasState.getState((Value)p.getMartyn())).depth());
                TestBFS.assertEquals((Object)p.getFoafPerson(), (Object)((BFS.VS)gasState.getState((Value)p.getMartyn())).predecessor());
            }
            finally {
                try {
                    cxn.rollback();
                }
                finally {
                    cxn.close();
                }
            }
        }
        finally {
            gasEngine.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBFS_undirected() throws Exception {
        AbstractBigdataGraphTestCase.SmallGraphProblem p = this.setupSmallGraphProblem();
        BigdataGASEngine gasEngine = this.getGraphFixture().newGASEngine(1);
        try {
            BigdataSail.BigdataSailConnection cxn = this.getGraphFixture().getSail().getConnection();
            try {
                IGraphAccessor graphAccessor = this.getGraphFixture().newGraphAccessor((SailConnection)cxn);
                IGASContext gasContext = gasEngine.newGASContext(graphAccessor, (IGASProgram)new BFS());
                IGASState gasState = gasContext.getGASState();
                gasState.setFrontier(gasContext, new Value[]{p.getFoafPerson()});
                gasContext.setTraversalDirection(TraversalDirectionEnum.Undirected);
                gasContext.call();
                TestBFS.assertEquals((int)0, (int)((BFS.VS)gasState.getState((Value)p.getFoafPerson())).depth());
                TestBFS.assertEquals(null, (Object)((BFS.VS)gasState.getState((Value)p.getFoafPerson())).predecessor());
                TestBFS.assertEquals((int)1, (int)((BFS.VS)gasState.getState((Value)p.getMike())).depth());
                TestBFS.assertEquals((Object)p.getFoafPerson(), (Object)((BFS.VS)gasState.getState((Value)p.getMike())).predecessor());
                TestBFS.assertEquals((int)1, (int)((BFS.VS)gasState.getState((Value)p.getBryan())).depth());
                TestBFS.assertEquals((Object)p.getFoafPerson(), (Object)((BFS.VS)gasState.getState((Value)p.getBryan())).predecessor());
                TestBFS.assertEquals((int)1, (int)((BFS.VS)gasState.getState((Value)p.getMartyn())).depth());
                TestBFS.assertEquals((Object)p.getFoafPerson(), (Object)((BFS.VS)gasState.getState((Value)p.getMartyn())).predecessor());
            }
            finally {
                try {
                    cxn.rollback();
                }
                finally {
                    cxn.close();
                }
            }
        }
        finally {
            gasEngine.shutdownNow();
        }
    }
}

