/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.graph.impl.bd;

import com.bigdata.rdf.graph.EdgesEnum;
import com.bigdata.rdf.graph.Factory;
import com.bigdata.rdf.graph.FrontierEnum;
import com.bigdata.rdf.graph.IGASContext;
import com.bigdata.rdf.graph.IGASProgram;
import com.bigdata.rdf.graph.IGASScheduler;
import com.bigdata.rdf.graph.IGASState;
import com.bigdata.rdf.graph.IGASStats;
import com.bigdata.rdf.graph.IGraphAccessor;
import com.bigdata.rdf.graph.impl.BaseGASProgram;
import com.bigdata.rdf.graph.impl.GASStats;
import com.bigdata.rdf.graph.impl.bd.AbstractBigdataGraphTestCase;
import com.bigdata.rdf.graph.impl.bd.BigdataGASEngine;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.model.StatementEnum;
import com.bigdata.rdf.spo.SPO;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.openrdf.model.Statement;
import org.openrdf.model.Value;

public class TestGather
extends AbstractBigdataGraphTestCase {
    public TestGather() {
    }

    public TestGather(String name) {
        super(name);
    }

    public void testGather_inEdges() throws Exception {
        AbstractBigdataGraphTestCase.SmallGraphProblem p = this.setupSmallGraphProblem();
        Set expected = TestGather.set((Object[])new Object[0]);
        this.doGatherTest(EdgesEnum.NoEdges, expected, (Value)p.getMike());
        BigdataValueFactory vf = (BigdataValueFactory)this.getGraphFixture().getSail().getValueFactory();
        Set expected2 = TestGather.set((Object[])new Statement[]{new SPO(p.getBryan(), p.getFoafKnows(), p.getMike(), StatementEnum.Explicit)});
        this.doGatherTest(EdgesEnum.InEdges, expected2, (Value)p.getMike());
        expected2 = TestGather.set((Object[])new Statement[]{new SPO(p.getMike(), p.getRdfType(), p.getFoafPerson(), StatementEnum.Explicit), new SPO(p.getMike(), p.getFoafKnows(), p.getBryan(), StatementEnum.Explicit)});
        this.doGatherTest(EdgesEnum.OutEdges, expected2, (Value)p.getMike());
        expected2 = TestGather.set((Object[])new Statement[]{new SPO(p.getBryan(), p.getFoafKnows(), p.getMike(), StatementEnum.Explicit), new SPO(p.getMike(), p.getRdfType(), p.getFoafPerson(), StatementEnum.Explicit), new SPO(p.getMike(), p.getFoafKnows(), p.getBryan(), StatementEnum.Explicit)});
        this.doGatherTest(EdgesEnum.AllEdges, expected2, (Value)p.getMike());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGatherTest(EdgesEnum gatherEdges, Set<? extends Statement> expected, Value startingVertex) throws Exception {
        BigdataGASEngine gasEngine = this.getGraphFixture().newGASEngine(1);
        try {
            IGraphAccessor graphAccessor = this.getGraphFixture().newGraphAccessor(null);
            IGASContext gasContext = gasEngine.newGASContext(graphAccessor, (IGASProgram)new MockGASProgram(gatherEdges));
            IGASState gasState = gasContext.getGASState();
            gasState.setFrontier(gasContext, new Value[]{startingVertex});
            gasContext.doRound((IGASStats)new GASStats());
            Set actual = (Set)gasState.getState(startingVertex);
            TestGather.assertSameEdges(expected, (Set)actual);
        }
        finally {
            gasEngine.shutdownNow();
        }
    }

    private static class MockGASProgram
    extends BaseGASProgram<Set<Statement>, Set<Statement>, Set<Statement>> {
        private final EdgesEnum gatherEdges;

        MockGASProgram(EdgesEnum gatherEdges) {
            this.gatherEdges = gatherEdges;
        }

        public FrontierEnum getInitialFrontierEnum() {
            return FrontierEnum.SingleVertex;
        }

        public EdgesEnum getGatherEdges() {
            return this.gatherEdges;
        }

        public EdgesEnum getScatterEdges() {
            return EdgesEnum.NoEdges;
        }

        public Factory<Value, Set<Statement>> getVertexStateFactory() {
            return new Factory<Value, Set<Statement>>(){

                public Set<Statement> initialValue(Value value) {
                    return new LinkedHashSet<Statement>();
                }
            };
        }

        public Factory<Statement, Set<Statement>> getEdgeStateFactory() {
            return null;
        }

        public void initVertex(IGASContext<Set<Statement>, Set<Statement>, Set<Statement>> ctx, IGASState<Set<Statement>, Set<Statement>, Set<Statement>> state, Value u) {
        }

        public Set<Statement> gather(IGASState<Set<Statement>, Set<Statement>, Set<Statement>> state, Value u, Statement e) {
            return Collections.singleton(e);
        }

        public Set<Statement> sum(IGASState<Set<Statement>, Set<Statement>, Set<Statement>> state, Set<Statement> left, Set<Statement> right) {
            LinkedHashSet<Statement> tmp = new LinkedHashSet<Statement>(left);
            tmp.addAll(right);
            return tmp;
        }

        public Set<Statement> apply(IGASState<Set<Statement>, Set<Statement>, Set<Statement>> state, Value u, Set<Statement> sum) {
            if (sum != null) {
                Set us = (Set)state.getState(u);
                us.addAll(sum);
                return us;
            }
            return null;
        }

        public boolean isChanged(IGASState<Set<Statement>, Set<Statement>, Set<Statement>> state, Value u) {
            return true;
        }

        public void scatter(IGASState<Set<Statement>, Set<Statement>, Set<Statement>> state, IGASScheduler sch, Value u, Statement e) {
            throw new UnsupportedOperationException();
        }

        public boolean nextRound(IGASContext ctx) {
            return true;
        }
    }
}

