/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.graph.impl.bd;

import com.bigdata.rdf.graph.IGASContext;
import com.bigdata.rdf.graph.IGASProgram;
import com.bigdata.rdf.graph.IGASState;
import com.bigdata.rdf.graph.IGraphAccessor;
import com.bigdata.rdf.graph.analytics.SSSP;
import com.bigdata.rdf.graph.impl.bd.AbstractBigdataGraphTestCase;
import com.bigdata.rdf.graph.impl.bd.BigdataGASEngine;
import org.openrdf.model.URI;
import org.openrdf.model.Value;

public class TestSSSP
extends AbstractBigdataGraphTestCase {
    public TestSSSP() {
    }

    public TestSSSP(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSSSP() throws Exception {
        AbstractBigdataGraphTestCase.SmallGraphProblem p = this.setupSmallGraphProblem();
        BigdataGASEngine gasEngine = this.getGraphFixture().newGASEngine(1);
        try {
            IGraphAccessor graphAccessor = this.getGraphFixture().newGraphAccessor(null);
            IGASContext gasContext = gasEngine.newGASContext(graphAccessor, (IGASProgram)new SSSP());
            IGASState gasState = gasContext.getGASState();
            gasState.setFrontier(gasContext, new Value[]{p.getMike()});
            gasContext.call();
            TestSSSP.assertEquals((Object)0.0, (Object)((SSSP.VS)gasState.getState((Value)p.getMike())).dist());
            TestSSSP.assertEquals((Object)1.0, (Object)((SSSP.VS)gasState.getState((Value)p.getFoafPerson())).dist());
            TestSSSP.assertEquals((Object)1.0, (Object)((SSSP.VS)gasState.getState((Value)p.getBryan())).dist());
            TestSSSP.assertEquals((Object)2.0, (Object)((SSSP.VS)gasState.getState((Value)p.getMartyn())).dist());
        }
        finally {
            gasEngine.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_sssp_linkType_constraint() throws Exception {
        AbstractBigdataGraphTestCase.SmallWeightedGraphProblem p = this.setupSmallWeightedGraphProblem();
        BigdataGASEngine gasEngine = this.getGraphFixture().newGASEngine(1);
        try {
            IGraphAccessor graphAccessor = this.getGraphFixture().newGraphAccessor(null);
            IGASContext gasContext = gasEngine.newGASContext(graphAccessor, (IGASProgram)new SSSP());
            gasContext.setLinkType((URI)p.getFoafKnows());
            IGASState gasState = gasContext.getGASState();
            gasState.setFrontier(gasContext, new Value[]{p.getV1()});
            gasContext.call();
            TestSSSP.assertEquals((Object)0.0, (Object)((SSSP.VS)gasState.getState((Value)p.getV1())).dist());
            TestSSSP.assertEquals((Object)1.0, (Object)((SSSP.VS)gasState.getState((Value)p.getV2())).dist());
            TestSSSP.assertEquals((Object)1.0, (Object)((SSSP.VS)gasState.getState((Value)p.getV3())).dist());
            TestSSSP.assertEquals((Object)2.0, (Object)((SSSP.VS)gasState.getState((Value)p.getV4())).dist());
            TestSSSP.assertEquals((Object)2.0, (Object)((SSSP.VS)gasState.getState((Value)p.getV5())).dist());
        }
        finally {
            gasEngine.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_sssp_weightedGraph() throws Exception {
        AbstractBigdataGraphTestCase.SmallWeightedGraphProblem p = this.setupSmallWeightedGraphProblem();
        BigdataGASEngine gasEngine = this.getGraphFixture().newGASEngine(1);
        try {
            IGraphAccessor graphAccessor = this.getGraphFixture().newGraphAccessor(null);
            IGASContext gasContext = gasEngine.newGASContext(graphAccessor, (IGASProgram)new SSSP());
            gasContext.setLinkType((URI)p.getFoafKnows());
            gasContext.setLinkAttributeType((URI)p.getLinkWeight());
            IGASState gasState = gasContext.getGASState();
            gasState.setFrontier(gasContext, new Value[]{p.getV1()});
            gasContext.call();
            TestSSSP.assertEquals((Object)0.0, (Object)((SSSP.VS)gasState.getState((Value)p.getV1())).dist());
            TestSSSP.assertEquals((Object)100.0, (Object)((SSSP.VS)gasState.getState((Value)p.getV2())).dist());
            TestSSSP.assertEquals((Object)100.0, (Object)((SSSP.VS)gasState.getState((Value)p.getV3())).dist());
            TestSSSP.assertEquals((Object)150.0, (Object)((SSSP.VS)gasState.getState((Value)p.getV4())).dist());
            TestSSSP.assertEquals((Object)175.0, (Object)((SSSP.VS)gasState.getState((Value)p.getV5())).dist());
        }
        finally {
            gasEngine.shutdownNow();
        }
    }
}

