/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal;

import com.bigdata.btree.keys.IKeyBuilder;
import com.bigdata.btree.keys.KeyBuilder;
import com.bigdata.io.SerializerUtil;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.IVUtility;
import com.bigdata.rdf.internal.VTE;
import com.bigdata.rdf.lexicon.BlobsIndexHelper;
import com.bigdata.test.MockTermIdFactory;
import com.bigdata.util.BytesUtil;
import java.util.Arrays;
import junit.framework.TestCase2;

public abstract class AbstractEncodeDecodeKeysTestCase
extends TestCase2 {
    private MockTermIdFactory termIdFactory;

    public AbstractEncodeDecodeKeysTestCase() {
    }

    public AbstractEncodeDecodeKeysTestCase(String name) {
        super(name);
    }

    public static IV[] decodeStatementKey(byte[] key, int arity) {
        return IVUtility.decode((byte[])key, (int)arity);
    }

    protected static IV<?, ?>[] doEncodeDecodeTest(IV<?, ?>[] e) {
        IV actual;
        IV<?, ?> expected;
        int i;
        KeyBuilder keyBuilder = new KeyBuilder();
        keyBuilder.reset();
        for (int i2 = 0; i2 < e.length; ++i2) {
            e[i2].encode((IKeyBuilder)keyBuilder);
        }
        byte[] key = keyBuilder.getKey();
        IV[] a = AbstractEncodeDecodeKeysTestCase.decodeStatementKey(key, e.length);
        for (i = 0; i < e.length; ++i) {
            expected = e[i];
            actual = a[i];
            if (!expected.equals((Object)actual)) {
                AbstractEncodeDecodeKeysTestCase.fail((String)("values differ @ index=" + Integer.toString(i) + " : expected=" + expected + ", actual=" + actual));
            }
            if (expected.hashCode() == actual.hashCode()) continue;
            AbstractEncodeDecodeKeysTestCase.fail((String)("hashCodes differ @ index=" + Integer.toString(i) + " : expected=" + expected + "(hash=" + expected.hashCode() + ")" + ", actual=" + actual + "(hash=" + actual.hashCode() + ")"));
        }
        for (i = 0; i < e.length; ++i) {
            expected = e[i];
            byte[] data = SerializerUtil.serialize(expected);
            IV actual2 = (IV)SerializerUtil.deserialize((byte[])data);
            if (!expected.equals((Object)actual2)) {
                AbstractEncodeDecodeKeysTestCase.fail((String)("Round trip serialization problem: expected=" + expected + ", actual=" + actual2));
            }
            if (expected.hashCode() == actual2.hashCode()) continue;
            AbstractEncodeDecodeKeysTestCase.fail((String)("hashCodes differ @ index=" + Integer.toString(i) + " : expected=" + expected + "(hash=" + expected.hashCode() + ")" + ", actual=" + actual2 + "(hash=" + actual2.hashCode() + ")"));
        }
        for (i = 0; i < e.length; ++i) {
            expected = e[i];
            actual = expected.clone(true);
            if (!expected.equals((Object)actual)) {
                AbstractEncodeDecodeKeysTestCase.fail((String)("Clone problem: expected=" + expected + ", actual=" + actual));
            }
            if (expected.hashCode() == actual.hashCode()) continue;
            AbstractEncodeDecodeKeysTestCase.fail((String)("hashCodes differ @ index=" + Integer.toString(i) + " : expected=" + expected + "(hash=" + expected.hashCode() + ")" + ", actual=" + actual + "(hash=" + actual.hashCode() + ")"));
        }
        for (i = 0; i < e.length; ++i) {
            expected = e[i];
            actual = expected.clone(false);
            if (!expected.equals((Object)actual)) {
                AbstractEncodeDecodeKeysTestCase.fail((String)("Clone problem: expected=" + expected + ", actual=" + actual));
            }
            if (expected.hashCode() == actual.hashCode()) continue;
            AbstractEncodeDecodeKeysTestCase.fail((String)("hashCodes differ @ index=" + Integer.toString(i) + " : expected=" + expected + "(hash=" + expected.hashCode() + ")" + ", actual=" + actual + "(hash=" + actual.hashCode() + ")"));
        }
        return a;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.termIdFactory = new MockTermIdFactory();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.termIdFactory = null;
    }

    protected IV<?, ?> newTermId(VTE vte) {
        return this.termIdFactory.newTermId(vte);
    }

    protected static void doComparatorTest(IV<?, ?>[] e) {
        Object actualIV;
        BlobsIndexHelper h = new BlobsIndexHelper();
        IKeyBuilder keyBuilder = h.newKeyBuilder();
        byte[][] keys = new byte[e.length][];
        for (int i = 0; i < e.length; ++i) {
            IV<?, ?> iv = e[i];
            byte[] key = IVUtility.encode((IKeyBuilder)keyBuilder.reset(), iv).getKey();
            actualIV = IVUtility.decode((byte[])key);
            AbstractEncodeDecodeKeysTestCase.assertEquals(iv, (Object)actualIV);
            keys[i] = key;
        }
        Object[] a = (IV[])e.clone();
        Arrays.sort(a);
        Arrays.sort(keys, BytesUtil.UnsignedByteArrayComparator.INSTANCE);
        for (int i = 0; i < e.length; ++i) {
            IV expectedIV = IVUtility.decode((byte[])keys[i]);
            if (expectedIV.equals(actualIV = a[i])) continue;
            AbstractEncodeDecodeKeysTestCase.fail((String)("Order differs at index=" + i + ": expectedIV=" + expectedIV + ", actualIV=" + actualIV));
        }
    }
}

