/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal;

import com.bigdata.rdf.internal.AbstractEncodeDecodeKeysTestCase;
import com.bigdata.rdf.internal.ColorsEnumExtension;
import com.bigdata.rdf.internal.IDatatypeURIResolver;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.VTE;
import com.bigdata.rdf.internal.XSD;
import com.bigdata.rdf.internal.impl.BlobIV;
import com.bigdata.rdf.internal.impl.bnode.FullyInlineUnicodeBNodeIV;
import com.bigdata.rdf.internal.impl.bnode.NumericBNodeIV;
import com.bigdata.rdf.internal.impl.bnode.SidIV;
import com.bigdata.rdf.internal.impl.bnode.UUIDBNodeIV;
import com.bigdata.rdf.internal.impl.extensions.DateTimeExtension;
import com.bigdata.rdf.internal.impl.extensions.DerivedNumericsExtension;
import com.bigdata.rdf.internal.impl.extensions.XSDStringExtension;
import com.bigdata.rdf.internal.impl.literal.AbstractLiteralIV;
import com.bigdata.rdf.internal.impl.literal.FullyInlineTypedLiteralIV;
import com.bigdata.rdf.internal.impl.literal.PartlyInlineTypedLiteralIV;
import com.bigdata.rdf.internal.impl.literal.UUIDLiteralIV;
import com.bigdata.rdf.internal.impl.literal.XSDBooleanIV;
import com.bigdata.rdf.internal.impl.literal.XSDDecimalIV;
import com.bigdata.rdf.internal.impl.literal.XSDIntegerIV;
import com.bigdata.rdf.internal.impl.literal.XSDNumericIV;
import com.bigdata.rdf.internal.impl.literal.XSDUnsignedByteIV;
import com.bigdata.rdf.internal.impl.literal.XSDUnsignedIntIV;
import com.bigdata.rdf.internal.impl.literal.XSDUnsignedLongIV;
import com.bigdata.rdf.internal.impl.literal.XSDUnsignedShortIV;
import com.bigdata.rdf.internal.impl.uri.FullyInlineURIIV;
import com.bigdata.rdf.internal.impl.uri.PartlyInlineURIIV;
import com.bigdata.rdf.internal.impl.uri.URIExtensionIV;
import com.bigdata.rdf.internal.impl.uri.VocabURIByteIV;
import com.bigdata.rdf.internal.impl.uri.VocabURIShortIV;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.model.BigdataValueFactoryImpl;
import com.bigdata.rdf.model.StatementEnum;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.spo.SPO;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.TimeZone;
import java.util.UUID;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.RDF;

public abstract class AbstractEncodeDecodeMixedIVsTest
extends AbstractEncodeDecodeKeysTestCase {
    private static boolean fullyInlineUnicode = true;

    public AbstractEncodeDecodeMixedIVsTest() {
    }

    public AbstractEncodeDecodeMixedIVsTest(String name) {
        super(name);
    }

    protected List<IV<?, ?>> prepareIVs() throws DatatypeConfigurationException {
        int i;
        Random r = new Random();
        final BigdataValueFactory vf = BigdataValueFactoryImpl.getInstance((String)this.getName());
        URIImpl datatype = new URIImpl("http://www.bigdata.com");
        URIImpl dt1 = new URIImpl("http://www.bigdata.com/mock-datatype-1");
        URIImpl dt2 = new URIImpl("http://www.bigdata.com/mock-datatype-2");
        IV<?, ?> namespaceIV = this.newTermId(VTE.URI);
        IV<?, ?> datatypeIV = this.newTermId(VTE.URI);
        IV<?, ?> datatypeIV2 = this.newTermId(VTE.URI);
        final IV<?, ?> colorIV = this.newTermId(VTE.URI);
        final IV<?, ?> xsdStringIV = this.newTermId(VTE.URI);
        final IV<?, ?> xsdDateTimeIV = this.newTermId(VTE.URI);
        IDatatypeURIResolver resolver = new IDatatypeURIResolver(){

            public BigdataURI resolve(URI uri) {
                BigdataURI buri = vf.createURI(uri.stringValue());
                if (ColorsEnumExtension.COLOR.equals((Object)uri)) {
                    buri.setIV(colorIV);
                } else if (XSD.STRING.equals((Object)uri)) {
                    buri.setIV(xsdStringIV);
                } else if (XSD.DATETIME.equals((Object)uri)) {
                    buri.setIV(xsdDateTimeIV);
                } else if (XSD.DATE.equals((Object)uri)) {
                    buri.setIV(AbstractEncodeDecodeMixedIVsTest.this.newTermId(VTE.URI));
                } else if (XSD.TIME.equals((Object)uri)) {
                    buri.setIV(AbstractEncodeDecodeMixedIVsTest.this.newTermId(VTE.URI));
                } else if (XSD.GDAY.equals((Object)uri)) {
                    buri.setIV(AbstractEncodeDecodeMixedIVsTest.this.newTermId(VTE.URI));
                } else if (XSD.GMONTH.equals((Object)uri)) {
                    buri.setIV(AbstractEncodeDecodeMixedIVsTest.this.newTermId(VTE.URI));
                } else if (XSD.GMONTHDAY.equals((Object)uri)) {
                    buri.setIV(AbstractEncodeDecodeMixedIVsTest.this.newTermId(VTE.URI));
                } else if (XSD.GYEAR.equals((Object)uri)) {
                    buri.setIV(AbstractEncodeDecodeMixedIVsTest.this.newTermId(VTE.URI));
                } else if (XSD.GYEARMONTH.equals((Object)uri)) {
                    buri.setIV(AbstractEncodeDecodeMixedIVsTest.this.newTermId(VTE.URI));
                } else if (XSD.POSITIVE_INTEGER.equals((Object)uri)) {
                    buri.setIV(AbstractEncodeDecodeMixedIVsTest.this.newTermId(VTE.URI));
                } else if (XSD.NEGATIVE_INTEGER.equals((Object)uri)) {
                    buri.setIV(AbstractEncodeDecodeMixedIVsTest.this.newTermId(VTE.URI));
                } else if (XSD.NON_POSITIVE_INTEGER.equals((Object)uri)) {
                    buri.setIV(AbstractEncodeDecodeMixedIVsTest.this.newTermId(VTE.URI));
                } else if (XSD.NON_NEGATIVE_INTEGER.equals((Object)uri)) {
                    buri.setIV(AbstractEncodeDecodeMixedIVsTest.this.newTermId(VTE.URI));
                } else {
                    throw new UnsupportedOperationException();
                }
                return buri;
            }
        };
        LinkedList ivs = new LinkedList();
        if (fullyInlineUnicode) {
            ivs.add((IV<?, ?>)new FullyInlineUnicodeBNodeIV("FOO"));
            ivs.add((IV<?, ?>)new FullyInlineUnicodeBNodeIV("_bar"));
            ivs.add((IV<?, ?>)new FullyInlineUnicodeBNodeIV("bar"));
            ivs.add((IV<?, ?>)new FullyInlineUnicodeBNodeIV("baz"));
            ivs.add((IV<?, ?>)new FullyInlineUnicodeBNodeIV("12"));
            ivs.add((IV<?, ?>)new FullyInlineUnicodeBNodeIV("1298"));
            ivs.add((IV<?, ?>)new FullyInlineUnicodeBNodeIV("asassdao"));
            ivs.add((IV<?, ?>)new FullyInlineUnicodeBNodeIV("1"));
        }
        ivs.add((IV<?, ?>)new NumericBNodeIV(-1));
        ivs.add((IV<?, ?>)new NumericBNodeIV(0));
        ivs.add((IV<?, ?>)new NumericBNodeIV(1));
        ivs.add((IV<?, ?>)new NumericBNodeIV(-52));
        ivs.add((IV<?, ?>)new NumericBNodeIV(52));
        ivs.add((IV<?, ?>)new NumericBNodeIV(Integer.MAX_VALUE));
        ivs.add((IV<?, ?>)new NumericBNodeIV(Integer.MIN_VALUE));
        for (int i3 = 0; i3 < 100; ++i3) {
            ivs.add((IV<?, ?>)new UUIDBNodeIV(UUID.randomUUID()));
        }
        ivs.add((IV<?, ?>)new FullyInlineURIIV((URI)new URIImpl("http://www.bigdata.com")));
        ivs.add((IV<?, ?>)new FullyInlineURIIV((URI)new URIImpl("http://www.bigdata.com/")));
        ivs.add((IV<?, ?>)new FullyInlineURIIV((URI)new URIImpl("http://www.bigdata.com/foo")));
        ivs.add((IV<?, ?>)new FullyInlineURIIV((URI)new URIImpl("http://www.bigdata.com:80/foo")));
        ivs.add((IV<?, ?>)new FullyInlineURIIV((URI)new URIImpl("http://www.bigdata.com")));
        if (fullyInlineUnicode) {
            ivs.add((IV<?, ?>)new FullyInlineURIIV(RDF.TYPE));
            ivs.add((IV<?, ?>)new FullyInlineURIIV(RDF.SUBJECT));
            ivs.add((IV<?, ?>)new FullyInlineURIIV(RDF.BAG));
            ivs.add((IV<?, ?>)new FullyInlineURIIV(RDF.OBJECT));
            ivs.add((IV<?, ?>)new URIExtensionIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV("http://www.example.com/"), (IV)new VocabURIByteIV(1)));
            ivs.add((IV<?, ?>)new URIExtensionIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV("http://www.example.com/foo"), (IV)new VocabURIByteIV(1)));
            ivs.add((IV<?, ?>)new URIExtensionIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV("http://www.example.com/foobar"), (IV)new VocabURIByteIV(1)));
        }
        if (fullyInlineUnicode) {
            ivs.add((IV<?, ?>)new FullyInlineTypedLiteralIV("foo", null, null));
            ivs.add((IV<?, ?>)new FullyInlineTypedLiteralIV("bar", null, null));
            ivs.add((IV<?, ?>)new FullyInlineTypedLiteralIV("baz", null, null));
            ivs.add((IV<?, ?>)new FullyInlineTypedLiteralIV("123", null, null));
            ivs.add((IV<?, ?>)new FullyInlineTypedLiteralIV("23", null, null));
            ivs.add((IV<?, ?>)new FullyInlineTypedLiteralIV("3", null, null));
            ivs.add((IV<?, ?>)new FullyInlineTypedLiteralIV("", null, null));
        }
        if (fullyInlineUnicode) {
            ivs.add((IV<?, ?>)new FullyInlineTypedLiteralIV("foo", "en", null));
            ivs.add((IV<?, ?>)new FullyInlineTypedLiteralIV("bar", "en", null));
            ivs.add((IV<?, ?>)new FullyInlineTypedLiteralIV("goo", "en", null));
            ivs.add((IV<?, ?>)new FullyInlineTypedLiteralIV("baz", "en", null));
            ivs.add((IV<?, ?>)new FullyInlineTypedLiteralIV("foo", "de", null));
            ivs.add((IV<?, ?>)new FullyInlineTypedLiteralIV("bar", "de", null));
            ivs.add((IV<?, ?>)new FullyInlineTypedLiteralIV("goo", "de", null));
            ivs.add((IV<?, ?>)new FullyInlineTypedLiteralIV("baz", "de", null));
            ivs.add((IV<?, ?>)new FullyInlineTypedLiteralIV("", "en", null));
            ivs.add((IV<?, ?>)new FullyInlineTypedLiteralIV("", "de", null));
            ivs.add((IV<?, ?>)new FullyInlineTypedLiteralIV("1", "en", null));
            ivs.add((IV<?, ?>)new FullyInlineTypedLiteralIV("1", "de", null));
            ivs.add((IV<?, ?>)new FullyInlineTypedLiteralIV("12", "en", null));
            ivs.add((IV<?, ?>)new FullyInlineTypedLiteralIV("12", "de", null));
            ivs.add((IV<?, ?>)new FullyInlineTypedLiteralIV("2", "en", null));
            ivs.add((IV<?, ?>)new FullyInlineTypedLiteralIV("2", "de", null));
            ivs.add((IV<?, ?>)new FullyInlineTypedLiteralIV("23", "en", null));
            ivs.add((IV<?, ?>)new FullyInlineTypedLiteralIV("23", "de", null));
            ivs.add((IV<?, ?>)new FullyInlineTypedLiteralIV("123", "en", null));
            ivs.add((IV<?, ?>)new FullyInlineTypedLiteralIV("123", "de", null));
            ivs.add((IV<?, ?>)new FullyInlineTypedLiteralIV("3", "en", null));
            ivs.add((IV<?, ?>)new FullyInlineTypedLiteralIV("3", "de", null));
        }
        if (fullyInlineUnicode) {
            ivs.add((IV<?, ?>)new FullyInlineTypedLiteralIV("foo", null, (URI)dt1));
            ivs.add((IV<?, ?>)new FullyInlineTypedLiteralIV("bar", null, (URI)dt1));
            ivs.add((IV<?, ?>)new FullyInlineTypedLiteralIV("baz", null, (URI)dt1));
            ivs.add((IV<?, ?>)new FullyInlineTypedLiteralIV("goo", null, (URI)dt1));
            ivs.add((IV<?, ?>)new FullyInlineTypedLiteralIV("foo", null, (URI)dt2));
            ivs.add((IV<?, ?>)new FullyInlineTypedLiteralIV("bar", null, (URI)dt2));
            ivs.add((IV<?, ?>)new FullyInlineTypedLiteralIV("baz", null, (URI)dt2));
            ivs.add((IV<?, ?>)new FullyInlineTypedLiteralIV("goo", null, (URI)dt2));
            ivs.add((IV<?, ?>)new FullyInlineTypedLiteralIV("", null, (URI)dt2));
            ivs.add((IV<?, ?>)new FullyInlineTypedLiteralIV("", null, (URI)dt2));
            ivs.add((IV<?, ?>)new FullyInlineTypedLiteralIV("1", null, (URI)dt2));
            ivs.add((IV<?, ?>)new FullyInlineTypedLiteralIV("1", null, (URI)dt2));
            ivs.add((IV<?, ?>)new FullyInlineTypedLiteralIV("12", null, (URI)dt2));
            ivs.add((IV<?, ?>)new FullyInlineTypedLiteralIV("12", null, (URI)dt2));
            ivs.add((IV<?, ?>)new FullyInlineTypedLiteralIV("123", null, (URI)dt2));
            ivs.add((IV<?, ?>)new FullyInlineTypedLiteralIV("123", null, (URI)dt2));
            ivs.add((IV<?, ?>)new FullyInlineTypedLiteralIV("23", null, (URI)dt2));
            ivs.add((IV<?, ?>)new FullyInlineTypedLiteralIV("23", null, (URI)dt2));
            ivs.add((IV<?, ?>)new FullyInlineTypedLiteralIV("3", null, (URI)dt2));
            ivs.add((IV<?, ?>)new FullyInlineTypedLiteralIV("3", null, (URI)dt2));
        }
        ivs.add((IV<?, ?>)new FullyInlineTypedLiteralIV("foo", null, XSD.STRING));
        ivs.add((IV<?, ?>)new FullyInlineTypedLiteralIV("bar", null, XSD.STRING));
        ivs.add((IV<?, ?>)new FullyInlineTypedLiteralIV("baz", null, XSD.STRING));
        ivs.add((IV<?, ?>)new FullyInlineTypedLiteralIV(""));
        ivs.add((IV<?, ?>)new FullyInlineTypedLiteralIV(" "));
        ivs.add((IV<?, ?>)new FullyInlineTypedLiteralIV("1"));
        ivs.add((IV<?, ?>)new FullyInlineTypedLiteralIV("12"));
        ivs.add((IV<?, ?>)new FullyInlineTypedLiteralIV("123"));
        ivs.add((IV<?, ?>)new FullyInlineTypedLiteralIV("", "en", null));
        ivs.add((IV<?, ?>)new FullyInlineTypedLiteralIV(" ", "en", null));
        ivs.add((IV<?, ?>)new FullyInlineTypedLiteralIV("1", "en", null));
        ivs.add((IV<?, ?>)new FullyInlineTypedLiteralIV("12", "fr", null));
        ivs.add((IV<?, ?>)new FullyInlineTypedLiteralIV("123", "de", null));
        ivs.add((IV<?, ?>)new FullyInlineTypedLiteralIV("", null, (URI)datatype));
        ivs.add((IV<?, ?>)new FullyInlineTypedLiteralIV(" ", null, (URI)datatype));
        ivs.add((IV<?, ?>)new FullyInlineTypedLiteralIV("1", null, (URI)datatype));
        ivs.add((IV<?, ?>)new FullyInlineTypedLiteralIV("12", null, (URI)datatype));
        ivs.add((IV<?, ?>)new FullyInlineTypedLiteralIV("123", null, (URI)datatype));
        ivs.add((IV<?, ?>)new XSDBooleanIV(true));
        ivs.add((IV<?, ?>)new XSDBooleanIV(false));
        ivs.add((IV<?, ?>)new XSDNumericIV(-128));
        ivs.add((IV<?, ?>)new XSDNumericIV(-1));
        ivs.add((IV<?, ?>)new XSDNumericIV(0));
        ivs.add((IV<?, ?>)new XSDNumericIV(1));
        ivs.add((IV<?, ?>)new XSDNumericIV(127));
        ivs.add((IV<?, ?>)new XSDNumericIV(-1));
        ivs.add((IV<?, ?>)new XSDNumericIV(0));
        ivs.add((IV<?, ?>)new XSDNumericIV(1));
        ivs.add((IV<?, ?>)new XSDNumericIV(Short.MIN_VALUE));
        ivs.add((IV<?, ?>)new XSDNumericIV(Short.MAX_VALUE));
        ivs.add((IV<?, ?>)new XSDNumericIV(1));
        ivs.add((IV<?, ?>)new XSDNumericIV(0));
        ivs.add((IV<?, ?>)new XSDNumericIV(-1));
        ivs.add((IV<?, ?>)new XSDNumericIV(Integer.MAX_VALUE));
        ivs.add((IV<?, ?>)new XSDNumericIV(Integer.MIN_VALUE));
        ivs.add((IV<?, ?>)new XSDNumericIV(1L));
        ivs.add((IV<?, ?>)new XSDNumericIV(0L));
        ivs.add((IV<?, ?>)new XSDNumericIV(-1L));
        ivs.add((IV<?, ?>)new XSDNumericIV(Long.MIN_VALUE));
        ivs.add((IV<?, ?>)new XSDNumericIV(Long.MAX_VALUE));
        ivs.add((IV<?, ?>)new XSDNumericIV(1.0f));
        ivs.add((IV<?, ?>)new XSDNumericIV(-1.0f));
        ivs.add((IV<?, ?>)new XSDNumericIV(0.0f));
        ivs.add((IV<?, ?>)new XSDNumericIV(Float.MAX_VALUE));
        ivs.add((IV<?, ?>)new XSDNumericIV(Float.MIN_VALUE));
        ivs.add((IV<?, ?>)new XSDNumericIV(Float.MIN_NORMAL));
        ivs.add((IV<?, ?>)new XSDNumericIV(Float.POSITIVE_INFINITY));
        ivs.add((IV<?, ?>)new XSDNumericIV(Float.NEGATIVE_INFINITY));
        ivs.add((IV<?, ?>)new XSDNumericIV(Float.NaN));
        ivs.add((IV<?, ?>)new XSDNumericIV(1.0));
        ivs.add((IV<?, ?>)new XSDNumericIV(-1.0));
        ivs.add((IV<?, ?>)new XSDNumericIV(0.0));
        ivs.add((IV<?, ?>)new XSDNumericIV(Double.MAX_VALUE));
        ivs.add((IV<?, ?>)new XSDNumericIV(Double.MIN_VALUE));
        ivs.add((IV<?, ?>)new XSDNumericIV(Double.MIN_NORMAL));
        ivs.add((IV<?, ?>)new XSDNumericIV(Double.POSITIVE_INFINITY));
        ivs.add((IV<?, ?>)new XSDNumericIV(Double.NEGATIVE_INFINITY));
        ivs.add((IV<?, ?>)new XSDNumericIV(Double.NaN));
        for (int i2 = 0; i2 < 100; ++i2) {
            ivs.add((IV<?, ?>)new UUIDLiteralIV(UUID.randomUUID()));
        }
        ivs.add((IV<?, ?>)new XSDUnsignedByteIV(-128));
        ivs.add((IV<?, ?>)new XSDUnsignedByteIV(-1));
        ivs.add((IV<?, ?>)new XSDUnsignedByteIV(0));
        ivs.add((IV<?, ?>)new XSDUnsignedByteIV(1));
        ivs.add((IV<?, ?>)new XSDUnsignedByteIV(127));
        ivs.add((IV<?, ?>)new XSDUnsignedShortIV(Short.MIN_VALUE));
        ivs.add((IV<?, ?>)new XSDUnsignedShortIV(-1));
        ivs.add((IV<?, ?>)new XSDUnsignedShortIV(0));
        ivs.add((IV<?, ?>)new XSDUnsignedShortIV(1));
        ivs.add((IV<?, ?>)new XSDUnsignedShortIV(Short.MAX_VALUE));
        ivs.add((IV<?, ?>)new XSDUnsignedIntIV(Integer.MIN_VALUE));
        ivs.add((IV<?, ?>)new XSDUnsignedIntIV(-1));
        ivs.add((IV<?, ?>)new XSDUnsignedIntIV(0));
        ivs.add((IV<?, ?>)new XSDUnsignedIntIV(1));
        ivs.add((IV<?, ?>)new XSDUnsignedIntIV(Integer.MAX_VALUE));
        ivs.add((IV<?, ?>)new XSDUnsignedLongIV(Long.MIN_VALUE));
        ivs.add((IV<?, ?>)new XSDUnsignedLongIV(-1L));
        ivs.add((IV<?, ?>)new XSDUnsignedLongIV(0L));
        ivs.add((IV<?, ?>)new XSDUnsignedLongIV(1L));
        ivs.add((IV<?, ?>)new XSDUnsignedLongIV(Long.MAX_VALUE));
        ivs.add((IV<?, ?>)new XSDIntegerIV(BigInteger.valueOf(-1L)));
        ivs.add((IV<?, ?>)new XSDIntegerIV(BigInteger.valueOf(0L)));
        ivs.add((IV<?, ?>)new XSDIntegerIV(BigInteger.valueOf(1L)));
        ivs.add((IV<?, ?>)new XSDIntegerIV(BigInteger.valueOf(Long.MAX_VALUE)));
        ivs.add((IV<?, ?>)new XSDIntegerIV(BigInteger.valueOf(Long.MIN_VALUE)));
        ivs.add((IV<?, ?>)new XSDDecimalIV(BigDecimal.valueOf(1.01)));
        ivs.add((IV<?, ?>)new XSDDecimalIV(BigDecimal.valueOf(2.01)));
        ivs.add((IV<?, ?>)new XSDDecimalIV(BigDecimal.valueOf(0.01)));
        ivs.add((IV<?, ?>)new XSDDecimalIV(BigDecimal.valueOf(1.01)));
        ivs.add((IV<?, ?>)new XSDDecimalIV(BigDecimal.valueOf(-1.01)));
        ivs.add((IV<?, ?>)new XSDDecimalIV(BigDecimal.valueOf(0.01)));
        ivs.add((IV<?, ?>)new XSDDecimalIV(BigDecimal.valueOf(-2.01)));
        ivs.add((IV<?, ?>)new XSDDecimalIV(BigDecimal.valueOf(-1.01)));
        ivs.add((IV<?, ?>)new XSDDecimalIV(BigDecimal.valueOf(10.01)));
        ivs.add((IV<?, ?>)new XSDDecimalIV(BigDecimal.valueOf(11.01)));
        ivs.add((IV<?, ?>)new XSDDecimalIV(BigDecimal.valueOf(258.01)));
        ivs.add((IV<?, ?>)new XSDDecimalIV(BigDecimal.valueOf(259.01)));
        ivs.add((IV<?, ?>)new XSDDecimalIV(BigDecimal.valueOf(3.01)));
        ivs.add((IV<?, ?>)new XSDDecimalIV(BigDecimal.valueOf(259.01)));
        ivs.add((IV<?, ?>)new XSDDecimalIV(BigDecimal.valueOf(383.01)));
        ivs.add((IV<?, ?>)new XSDDecimalIV(BigDecimal.valueOf(383.02)));
        ivs.add((IV<?, ?>)new XSDDecimalIV(new BigDecimal("1.5")));
        ivs.add((IV<?, ?>)new XSDDecimalIV(new BigDecimal("1.51")));
        ivs.add((IV<?, ?>)new XSDDecimalIV(new BigDecimal("-1.5")));
        ivs.add((IV<?, ?>)new XSDDecimalIV(new BigDecimal("-1.51")));
        ivs.add((IV<?, ?>)new XSDIntegerIV(BigInteger.valueOf(-1L)));
        ivs.add((IV<?, ?>)new XSDIntegerIV(BigInteger.valueOf(0L)));
        ivs.add((IV<?, ?>)new XSDIntegerIV(BigInteger.valueOf(1L)));
        ivs.add((IV<?, ?>)new XSDIntegerIV(BigInteger.valueOf(Long.MAX_VALUE)));
        ivs.add((IV<?, ?>)new XSDIntegerIV(BigInteger.valueOf(Long.MIN_VALUE)));
        ivs.add((IV<?, ?>)new XSDIntegerIV(new BigInteger("15")));
        ivs.add((IV<?, ?>)new XSDIntegerIV(new BigInteger("151")));
        ivs.add((IV<?, ?>)new XSDIntegerIV(new BigInteger("-15")));
        ivs.add((IV<?, ?>)new XSDIntegerIV(new BigInteger("-151")));
        ivs.add((IV<?, ?>)new VocabURIByteIV(-128));
        ivs.add((IV<?, ?>)new VocabURIByteIV(-1));
        ivs.add((IV<?, ?>)new VocabURIByteIV(0));
        ivs.add((IV<?, ?>)new VocabURIByteIV(1));
        ivs.add((IV<?, ?>)new VocabURIByteIV(127));
        ivs.add((IV<?, ?>)new VocabURIShortIV(Short.MIN_VALUE));
        ivs.add((IV<?, ?>)new VocabURIShortIV(-1));
        ivs.add((IV<?, ?>)new VocabURIShortIV(0));
        ivs.add((IV<?, ?>)new VocabURIShortIV(1));
        ivs.add((IV<?, ?>)new VocabURIShortIV(Short.MAX_VALUE));
        IV<?, ?> s1 = this.newTermId(VTE.URI);
        IV<?, ?> iV = this.newTermId(VTE.URI);
        IV<?, ?> p1 = this.newTermId(VTE.URI);
        IV<?, ?> p2 = this.newTermId(VTE.URI);
        IV<?, ?> iV2 = this.newTermId(VTE.URI);
        IV<?, ?> o2 = this.newTermId(VTE.BNODE);
        IV<?, ?> o3 = this.newTermId(VTE.LITERAL);
        SPO spo1 = new SPO(s1, p1, iV2, StatementEnum.Explicit);
        SPO spo2 = new SPO(s1, p1, o2, StatementEnum.Explicit);
        SPO spo3 = new SPO(s1, p1, o3, StatementEnum.Explicit);
        SPO spo4 = new SPO(s1, p2, iV2, StatementEnum.Explicit);
        SPO spo5 = new SPO(s1, p2, o2, StatementEnum.Explicit);
        SPO spo6 = new SPO(s1, p2, o3, StatementEnum.Explicit);
        SPO spo7 = new SPO(iV, p1, iV2, StatementEnum.Explicit);
        SPO spo8 = new SPO(iV, p1, o2, StatementEnum.Explicit);
        SPO spo9 = new SPO(iV, p1, o3, StatementEnum.Explicit);
        SPO spo10 = new SPO(iV, p2, iV2, StatementEnum.Explicit);
        SPO spo11 = new SPO(iV, p2, o2, StatementEnum.Explicit);
        SPO spo12 = new SPO(iV, p2, o3, StatementEnum.Explicit);
        SPO spo13 = new SPO(spo1.getStatementIdentifier(), p1, iV2, StatementEnum.Explicit);
        SPO spo14 = new SPO(spo2.getStatementIdentifier(), p2, o2, StatementEnum.Explicit);
        SPO spo15 = new SPO(s1, p1, spo3.getStatementIdentifier(), StatementEnum.Explicit);
        SPO spo16 = new SPO(s1, p1, spo6.getStatementIdentifier(), StatementEnum.Explicit);
        SPO spo17 = new SPO(spo1.getStatementIdentifier(), p1, spo15.getStatementIdentifier(), StatementEnum.Explicit);
        IV[] e = new IV[]{new SidIV((ISPO)spo1), new SidIV((ISPO)spo2), new SidIV((ISPO)spo3), new SidIV((ISPO)spo4), new SidIV((ISPO)spo5), new SidIV((ISPO)spo6), new SidIV((ISPO)spo7), new SidIV((ISPO)spo8), new SidIV((ISPO)spo9), new SidIV((ISPO)spo10), new SidIV((ISPO)spo11), new SidIV((ISPO)spo12), new SidIV((ISPO)spo13), new SidIV((ISPO)spo14), new SidIV((ISPO)spo15), new SidIV((ISPO)spo16), new SidIV((ISPO)spo17)};
        ivs.addAll(Arrays.asList(e));
        for (int i2 = 0; i2 < 100; ++i2) {
            for (VTE vTE : VTE.values()) {
                ivs.add(this.newTermId(vTE));
            }
        }
        for (int i3 = 0; i3 < 100; ++i3) {
            for (VTE vTE : VTE.values()) {
                int hashCode = r.nextInt();
                int counter = Short.MAX_VALUE - r.nextInt(18);
                BlobIV v = new BlobIV(vTE, hashCode, (short)counter);
                ivs.add((IV<?, ?>)v);
            }
        }
        if (fullyInlineUnicode) {
            ivs.add((IV<?, ?>)new PartlyInlineURIIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV("bar"), namespaceIV));
            ivs.add((IV<?, ?>)new PartlyInlineURIIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV("baz"), namespaceIV));
            ivs.add((IV<?, ?>)new PartlyInlineURIIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV("123"), namespaceIV));
            ivs.add((IV<?, ?>)new PartlyInlineURIIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV("23"), namespaceIV));
            ivs.add((IV<?, ?>)new PartlyInlineURIIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV("3"), namespaceIV));
        }
        ivs.add((IV<?, ?>)new PartlyInlineTypedLiteralIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV(""), datatypeIV));
        ivs.add((IV<?, ?>)new PartlyInlineTypedLiteralIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV("abc"), datatypeIV));
        ivs.add((IV<?, ?>)new PartlyInlineTypedLiteralIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV(" "), datatypeIV));
        ivs.add((IV<?, ?>)new PartlyInlineTypedLiteralIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV("1"), datatypeIV));
        ivs.add((IV<?, ?>)new PartlyInlineTypedLiteralIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV("12"), datatypeIV));
        if (fullyInlineUnicode) {
            ivs.add((IV<?, ?>)new PartlyInlineTypedLiteralIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV(""), datatypeIV));
            ivs.add((IV<?, ?>)new PartlyInlineTypedLiteralIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV(" "), datatypeIV2));
            ivs.add((IV<?, ?>)new PartlyInlineTypedLiteralIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV("1"), datatypeIV));
            ivs.add((IV<?, ?>)new PartlyInlineTypedLiteralIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV("1"), datatypeIV2));
            ivs.add((IV<?, ?>)new PartlyInlineTypedLiteralIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV("12"), datatypeIV));
            ivs.add((IV<?, ?>)new PartlyInlineTypedLiteralIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV("12"), datatypeIV2));
            ivs.add((IV<?, ?>)new PartlyInlineTypedLiteralIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV("123"), datatypeIV));
            ivs.add((IV<?, ?>)new PartlyInlineTypedLiteralIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV("123"), datatypeIV2));
            ivs.add((IV<?, ?>)new PartlyInlineTypedLiteralIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV("23"), datatypeIV));
            ivs.add((IV<?, ?>)new PartlyInlineTypedLiteralIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV("23"), datatypeIV2));
            ivs.add((IV<?, ?>)new PartlyInlineTypedLiteralIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV("3"), datatypeIV));
            ivs.add((IV<?, ?>)new PartlyInlineTypedLiteralIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV("3"), datatypeIV2));
            ivs.add((IV<?, ?>)new PartlyInlineTypedLiteralIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV("bar"), datatypeIV));
            ivs.add((IV<?, ?>)new PartlyInlineTypedLiteralIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV("baz"), datatypeIV));
            ivs.add((IV<?, ?>)new PartlyInlineTypedLiteralIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV("bar"), datatypeIV2));
            ivs.add((IV<?, ?>)new PartlyInlineTypedLiteralIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV("baz"), datatypeIV2));
        }
        if (fullyInlineUnicode) {
            ivs.add((IV<?, ?>)new PartlyInlineURIIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV("bar"), (IV)new VocabURIShortIV(1)));
            ivs.add((IV<?, ?>)new PartlyInlineURIIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV("baz"), (IV)new VocabURIShortIV(1)));
            ivs.add((IV<?, ?>)new PartlyInlineURIIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV("bar"), (IV)new VocabURIShortIV(2)));
            ivs.add((IV<?, ?>)new PartlyInlineURIIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV("baz"), (IV)new VocabURIShortIV(2)));
            ivs.add((IV<?, ?>)new PartlyInlineURIIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV("123"), (IV)new VocabURIShortIV(2)));
            ivs.add((IV<?, ?>)new PartlyInlineURIIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV("123"), (IV)new VocabURIShortIV(2)));
            ivs.add((IV<?, ?>)new PartlyInlineURIIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV("23"), (IV)new VocabURIShortIV(2)));
            ivs.add((IV<?, ?>)new PartlyInlineURIIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV("23"), (IV)new VocabURIShortIV(2)));
            ivs.add((IV<?, ?>)new PartlyInlineURIIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV("3"), (IV)new VocabURIShortIV(2)));
            ivs.add((IV<?, ?>)new PartlyInlineURIIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV("3"), (IV)new VocabURIShortIV(2)));
        }
        if (fullyInlineUnicode) {
            VocabURIShortIV datatypeIVa = new VocabURIShortIV(1);
            VocabURIShortIV vocabURIShortIV = new VocabURIShortIV(2);
            ivs.add((IV<?, ?>)new PartlyInlineTypedLiteralIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV("bar"), (IV)datatypeIVa));
            ivs.add((IV<?, ?>)new PartlyInlineTypedLiteralIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV("bar"), (IV)vocabURIShortIV));
            ivs.add((IV<?, ?>)new PartlyInlineTypedLiteralIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV("baz"), (IV)datatypeIVa));
            ivs.add((IV<?, ?>)new PartlyInlineTypedLiteralIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV("baz"), (IV)vocabURIShortIV));
            ivs.add((IV<?, ?>)new PartlyInlineTypedLiteralIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV("123"), (IV)datatypeIVa));
            ivs.add((IV<?, ?>)new PartlyInlineTypedLiteralIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV("123"), (IV)vocabURIShortIV));
            ivs.add((IV<?, ?>)new PartlyInlineTypedLiteralIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV("23"), (IV)datatypeIVa));
            ivs.add((IV<?, ?>)new PartlyInlineTypedLiteralIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV("23"), (IV)vocabURIShortIV));
            ivs.add((IV<?, ?>)new PartlyInlineTypedLiteralIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV("3"), (IV)datatypeIVa));
            ivs.add((IV<?, ?>)new PartlyInlineTypedLiteralIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV("3"), (IV)vocabURIShortIV));
        }
        DatatypeFactory df = DatatypeFactory.newInstance();
        DateTimeExtension dateTimeExtension = new DateTimeExtension(resolver, TimeZone.getDefault());
        BigdataLiteral[] dt = new BigdataLiteral[]{vf.createLiteral(df.newXMLGregorianCalendar("2001-10-26T21:32:52")), vf.createLiteral(df.newXMLGregorianCalendar("2001-10-26T21:32:52+02:00")), vf.createLiteral(df.newXMLGregorianCalendar("2001-10-26T19:32:52Z")), vf.createLiteral(df.newXMLGregorianCalendar("2001-10-26T19:32:52+00:00")), vf.createLiteral(df.newXMLGregorianCalendar("-2001-10-26T21:32:52")), vf.createLiteral(df.newXMLGregorianCalendar("2001-10-26T21:32:52.12679")), vf.createLiteral(df.newXMLGregorianCalendar("1901-10-26T21:32:52"))};
        for (i = 0; i < dt.length; ++i) {
            ivs.add((IV<?, ?>)dateTimeExtension.createIV((Value)dt[i]));
        }
        df = DatatypeFactory.newInstance();
        DerivedNumericsExtension derivedNumericsExtension = new DerivedNumericsExtension(resolver);
        dt = new BigdataLiteral[]{vf.createLiteral("1", XSD.POSITIVE_INTEGER), vf.createLiteral("-1", XSD.NEGATIVE_INTEGER), vf.createLiteral("-1", XSD.NON_POSITIVE_INTEGER), vf.createLiteral("1", XSD.NON_NEGATIVE_INTEGER), vf.createLiteral("0", XSD.NON_POSITIVE_INTEGER), vf.createLiteral("0", XSD.NON_NEGATIVE_INTEGER)};
        for (i = 0; i < dt.length; ++i) {
            ivs.add((IV<?, ?>)derivedNumericsExtension.createIV((Value)dt[i]));
        }
        if (fullyInlineUnicode) {
            int maxInlineStringLength = 128;
            XSDStringExtension xSDStringExtension = new XSDStringExtension(resolver, 128);
            IV[] e2 = new IV[]{xSDStringExtension.createIV((Value)new LiteralImpl("", XSD.STRING)), xSDStringExtension.createIV((Value)new LiteralImpl(" ", XSD.STRING)), xSDStringExtension.createIV((Value)new LiteralImpl("  ", XSD.STRING)), xSDStringExtension.createIV((Value)new LiteralImpl("1", XSD.STRING)), xSDStringExtension.createIV((Value)new LiteralImpl("12", XSD.STRING)), xSDStringExtension.createIV((Value)new LiteralImpl("123", XSD.STRING)), xSDStringExtension.createIV((Value)new LiteralImpl("234", XSD.STRING)), xSDStringExtension.createIV((Value)new LiteralImpl("34", XSD.STRING)), xSDStringExtension.createIV((Value)new LiteralImpl("4", XSD.STRING)), xSDStringExtension.createIV((Value)new LiteralImpl("a", XSD.STRING)), xSDStringExtension.createIV((Value)new LiteralImpl("ab", XSD.STRING)), xSDStringExtension.createIV((Value)new LiteralImpl("abc", XSD.STRING))};
            ivs.addAll(Arrays.asList(e2));
        }
        ColorsEnumExtension ext2 = new ColorsEnumExtension(resolver);
        for (ColorsEnumExtension.Color color : ColorsEnumExtension.Color.values()) {
            ivs.add((IV<?, ?>)ext2.createIV((Value)new LiteralImpl(color.name(), ColorsEnumExtension.COLOR)));
        }
        return ivs;
    }
}

