/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal;

import com.bigdata.rdf.internal.IDatatypeURIResolver;
import com.bigdata.rdf.internal.IExtension;
import com.bigdata.rdf.internal.impl.literal.AbstractLiteralIV;
import com.bigdata.rdf.internal.impl.literal.LiteralExtensionIV;
import com.bigdata.rdf.internal.impl.literal.XSDNumericIV;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import java.util.LinkedHashSet;
import java.util.Set;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.URIImpl;

public class ColorsEnumExtension<V extends BigdataValue>
implements IExtension<V> {
    public static final transient URI COLOR = new URIImpl("http://www.bigdata.com/rdf#Color");
    private final BigdataURI color;

    public ColorsEnumExtension(IDatatypeURIResolver resolver) {
        this.color = resolver.resolve(COLOR);
    }

    public Set<BigdataURI> getDatatypes() {
        LinkedHashSet<BigdataURI> datatypes = new LinkedHashSet<BigdataURI>();
        datatypes.add(this.color);
        return datatypes;
    }

    public LiteralExtensionIV createIV(Value value) {
        Color c;
        if (!(value instanceof Literal)) {
            throw new IllegalArgumentException();
        }
        Literal l = (Literal)value;
        if (l.getDatatype() == null || !this.color.equals(l.getDatatype())) {
            throw new IllegalArgumentException();
        }
        String s = value.stringValue();
        try {
            c = Enum.valueOf(Color.class, s);
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
        XSDNumericIV delegate = new XSDNumericIV(c.getByte());
        return new LiteralExtensionIV((AbstractLiteralIV)delegate, this.color.getIV());
    }

    public V asValue(LiteralExtensionIV iv, BigdataValueFactory vf) {
        byte b = iv.getDelegate().byteValue();
        Color c = Color.valueOf(b);
        if (c == null) {
            throw new RuntimeException("bad color got encoded somehow");
        }
        return (V)vf.createLiteral(c.toString(), (URI)this.color);
    }

    public static enum Color {
        Red(0),
        Blue(1),
        Green(2),
        Yellow(3),
        Orange(4),
        Purple(5),
        Black(6),
        White(7),
        Brown(8);

        private final byte b;

        private Color(byte b) {
            this.b = b;
        }

        public static final Color valueOf(byte b) {
            switch (b) {
                case 0: {
                    return Red;
                }
                case 1: {
                    return Blue;
                }
                case 2: {
                    return Green;
                }
                case 3: {
                    return Yellow;
                }
                case 4: {
                    return Orange;
                }
                case 5: {
                    return Purple;
                }
                case 6: {
                    return Black;
                }
                case 7: {
                    return White;
                }
                case 8: {
                    return Brown;
                }
            }
            throw new IllegalArgumentException(Byte.toString(b));
        }

        public byte getByte() {
            return this.b;
        }
    }
}

