/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal;

import com.bigdata.rdf.internal.IDatatypeURIResolver;
import com.bigdata.rdf.internal.IExtension;
import com.bigdata.rdf.internal.impl.literal.AbstractLiteralIV;
import com.bigdata.rdf.internal.impl.literal.LiteralExtensionIV;
import com.bigdata.rdf.internal.impl.literal.XSDNumericIV;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import java.util.LinkedHashSet;
import java.util.Set;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.datatypes.XMLDatatypeUtil;
import org.openrdf.model.impl.URIImpl;

public class EpochExtension<V extends BigdataValue>
implements IExtension<V> {
    public static final transient URI EPOCH = new URIImpl("http://www.bigdata.com/rdf#Epoch");
    private final BigdataURI epoch;

    public EpochExtension(IDatatypeURIResolver resolver) {
        this.epoch = resolver.resolve(EPOCH);
    }

    public Set<BigdataURI> getDatatypes() {
        LinkedHashSet<BigdataURI> datatypes = new LinkedHashSet<BigdataURI>();
        datatypes.add(this.epoch);
        return datatypes;
    }

    public LiteralExtensionIV createIV(Value value) {
        if (!(value instanceof Literal)) {
            throw new IllegalArgumentException();
        }
        Literal lit = (Literal)value;
        URI dt = lit.getDatatype();
        if (dt == null || !EPOCH.stringValue().equals(dt.stringValue())) {
            throw new IllegalArgumentException();
        }
        String s = value.stringValue();
        long l = XMLDatatypeUtil.parseLong((String)s);
        XSDNumericIV delegate = new XSDNumericIV(l);
        return new LiteralExtensionIV((AbstractLiteralIV)delegate, this.epoch.getIV());
    }

    public V asValue(LiteralExtensionIV iv, BigdataValueFactory vf) {
        return (V)vf.createLiteral(iv.getDelegate().stringValue(), (URI)this.epoch);
    }
}

