/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal;

import com.bigdata.Banner;
import com.bigdata.btree.BTree;
import com.bigdata.btree.DefaultTupleSerializer;
import com.bigdata.btree.ITuple;
import com.bigdata.btree.ITupleIterator;
import com.bigdata.btree.ITupleSerializer;
import com.bigdata.btree.IndexMetadata;
import com.bigdata.btree.keys.DefaultKeyBuilderFactory;
import com.bigdata.btree.keys.IKeyBuilder;
import com.bigdata.btree.keys.IKeyBuilderFactory;
import com.bigdata.btree.keys.KV;
import com.bigdata.btree.keys.KeyBuilder;
import com.bigdata.btree.keys.SuccessorUtil;
import com.bigdata.btree.raba.codec.CanonicalHuffmanRabaCoder;
import com.bigdata.btree.raba.codec.FrontCodedRabaCoder;
import com.bigdata.btree.raba.codec.IRabaCoder;
import com.bigdata.io.ByteArrayBuffer;
import com.bigdata.io.DataOutputBuffer;
import com.bigdata.io.DirectBufferPool;
import com.bigdata.io.compression.RecordCompressor;
import com.bigdata.journal.BufferMode;
import com.bigdata.journal.Journal;
import com.bigdata.rdf.internal.IDatatypeURIResolver;
import com.bigdata.rdf.internal.IExtension;
import com.bigdata.rdf.internal.IExtensionFactory;
import com.bigdata.rdf.internal.IInlineURIFactory;
import com.bigdata.rdf.internal.ILexiconConfiguration;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.InlineURIFactory;
import com.bigdata.rdf.internal.LexiconConfiguration;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.model.BigdataValueFactoryImpl;
import com.bigdata.rdf.model.BigdataValueSerializer;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.vocab.BaseVocabulary;
import com.bigdata.rdf.vocab.Vocabulary;
import com.bigdata.rwstore.sector.IMemoryManager;
import com.bigdata.rwstore.sector.MemoryManager;
import com.bigdata.util.BytesUtil;
import com.bigdata.util.concurrent.Latch;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import java.util.zip.GZIPInputStream;
import org.apache.log4j.Logger;
import org.openrdf.model.Statement;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.RDFParser;
import org.openrdf.rio.RDFParserFactory;
import org.openrdf.rio.RDFParserRegistry;
import org.openrdf.rio.helpers.RDFHandlerBase;

public class HashCollisionUtility {
    private static final Logger log = Logger.getLogger(HashCollisionUtility.class);
    private final BTree termsIndex;
    private final LexiconConfiguration<BigdataValue> conf;
    private final BigdataValueFactory vf;
    private final ReentrantLock lock = new ReentrantLock();
    private final Latch parserQueueLatch = new Latch(this.lock);
    private final Latch parserRunLatch = new Latch(this.lock);
    private final ExecutorService parserService;
    private final ExecutorService indexerService;
    private BlockingQueue<ValueBuffer> valueQueue;
    private final Counters c = new Counters();
    final int valBufSize = 0xA00000;
    final int valQueueCapacity = 10;
    final int maxDrain = 5;
    final int fileBufSize = 8192;
    final int nparserThreads = 1;
    final int parserWorkQueueCapacity = 100;
    final MemoryManager mmgr;
    private final int nbuffers = 1000;
    private FutureTask<Void> indexerTask;
    private final AtomicBoolean parsing = new AtomicBoolean(false);
    private final ValueBuffer poisonPill = new ValueBuffer(new LinkedList<IMemoryManager>(), 0, new LinkedHashMap<byte[], Bucket>());

    private HashCollisionUtility(Journal jnl) {
        BaseVocabulary vocab;
        this.termsIndex = this.getTermsIndex(jnl);
        this.parserService = null;
        this.indexerService = Executors.newSingleThreadExecutor();
        this.valueQueue = new LinkedBlockingQueue<ValueBuffer>(10);
        this.vf = BigdataValueFactoryImpl.getInstance((String)"test");
        try {
            vocab = (BaseVocabulary)Class.forName(AbstractTripleStore.Options.DEFAULT_VOCABULARY_CLASS).getDeclaredConstructor(String.class).newInstance(this.vf.getNamespace());
            vocab.init();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        IExtensionFactory xFactory = new IExtensionFactory(){

            public void init(IDatatypeURIResolver resolver, ILexiconConfiguration<BigdataValue> config) {
            }

            public Iterator<IExtension<? extends BigdataValue>> getExtensions() {
                return Collections.emptyIterator();
            }
        };
        InlineURIFactory uriFactory = new InlineURIFactory();
        uriFactory.init((Vocabulary)vocab);
        this.conf = new LexiconConfiguration(256, true, true, 64, true, false, TimeZone.getDefault(), false, xFactory, (Vocabulary)vocab, this.vf, (IInlineURIFactory)uriFactory, false, null);
        this.mmgr = new MemoryManager(DirectBufferPool.INSTANCE, 1000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        this.lock.lock();
        try {
            if (this.indexerTask != null) {
                throw new IllegalStateException();
            }
            this.indexerTask = new FutureTask<Void>(new IndexerMainTask());
            this.indexerService.submit(this.indexerTask);
            this.parsing.set(true);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws Exception {
        log.debug((Object)"shutting down...");
        this.lock.lock();
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Waiting on parserQueueLatch: " + this.parserQueueLatch));
            }
            this.parserQueueLatch.await();
            if (this.parserService != null) {
                this.parserService.shutdown();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Waiting on parserRunLatch: " + this.parserRunLatch));
            }
            this.parserRunLatch.await();
            this.parsing.set(false);
            log.debug((Object)"Inserting poison pill.");
            this.valueQueue.put(this.poisonPill);
            if (this.indexerTask != null) {
                this.indexerTask.get();
            }
            if (this.indexerService != null) {
                this.indexerService.shutdown();
            }
            if (this.mmgr != null) {
                if (log.isInfoEnabled()) {
                    log.info((Object)this.mmgr.getCounters().toString());
                }
                this.mmgr.clear();
            }
        }
        finally {
            this.lock.unlock();
        }
        log.debug((Object)"all done.");
    }

    public void shutdownNow() throws Exception {
        log.debug((Object)"shutdownNow");
        this.parsing.set(false);
        if (this.parserService != null) {
            this.parserService.shutdownNow();
        }
        if (this.indexerService != null) {
            this.indexerService.shutdownNow();
        }
        if (this.indexerTask != null) {
            this.indexerTask.cancel(true);
        }
        if (this.mmgr != null) {
            this.mmgr.clear();
        }
    }

    private BTree getTermsIndex(Journal jnl) {
        String name = "TERMS";
        BTree ndx = jnl.getIndex("TERMS");
        int m = 1024;
        int q = 8000;
        int ratio = 32;
        boolean maxRecLen = false;
        if (ndx == null) {
            IndexMetadata md = new IndexMetadata("TERMS", UUID.randomUUID());
            md.setNodeKeySerializer((IRabaCoder)new FrontCodedRabaCoder(32));
            DefaultTupleSerializer tupleSer = new DefaultTupleSerializer((IKeyBuilderFactory)new DefaultKeyBuilderFactory(new Properties()), (IRabaCoder)new FrontCodedRabaCoder(32), (IRabaCoder)CanonicalHuffmanRabaCoder.INSTANCE);
            md.setTupleSerializer((ITupleSerializer)tupleSer);
            md.setRawRecords(true);
            md.setMaxRecLen(0);
            md.setBranchingFactor(1024);
            md.setWriteRetentionQueueCapacity(8000);
            ndx = jnl.registerIndex("TERMS", md);
        }
        return ndx;
    }

    private void parseFileOrDirectory(File fileOrDir, RDFFormat fallback) throws Exception {
        if (fileOrDir.isDirectory()) {
            File[] files = fileOrDir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                File f = files[i];
                this.parseFileOrDirectory(f, fallback);
            }
            return;
        }
        File f = fileOrDir;
        String n = f.getName();
        RDFFormat fmt = RDFFormat.forFileName((String)n, (RDFFormat)fallback);
        if (fmt == null && n.endsWith(".zip")) {
            fmt = RDFFormat.forFileName((String)n.substring(0, n.length() - 4), (RDFFormat)fallback);
        }
        if (fmt == null && n.endsWith(".gz")) {
            fmt = RDFFormat.forFileName((String)n.substring(0, n.length() - 3), (RDFFormat)fallback);
        }
        if (fmt == null) {
            log.warn((Object)("Ignoring: " + f));
            return;
        }
        StatementHandler stmtHandler = new StatementHandler(0xA00000, this.c, this.conf, this.vf, (IMemoryManager)this.mmgr, this.valueQueue, this.parsing);
        ReportingFutureTask<Void> ft = new ReportingFutureTask<Void>(f, new ParseFileTask(f, fallback, 8192, this.vf, stmtHandler));
        if (this.parserService != null) {
            this.parserService.submit(ft);
        } else {
            ((FutureTask)ft).run();
            ft.get();
        }
    }

    public static void main(String[] args) throws Exception {
        Banner.banner();
        for (String filename : args) {
            File file = new File(filename);
            if (file.exists()) continue;
            throw new RuntimeException("Not found: " + file);
        }
        long begin = System.currentTimeMillis();
        Properties properties = new Properties();
        properties.setProperty(Journal.Options.BUFFER_MODE, BufferMode.DiskRW.toString());
        properties.setProperty(Journal.Options.INITIAL_EXTENT, "209715200");
        properties.setProperty(Journal.Options.HTTPD_PORT, "8081");
        String journalFile = System.getProperty(Journal.Options.FILE);
        if (journalFile == null) {
            System.err.println("Journal file must be specified: -D" + Journal.Options.FILE);
            System.exit(1);
        }
        properties.setProperty(Journal.Options.FILE, journalFile);
        if (new File(journalFile).exists()) {
            System.err.println("Removing old journal: " + journalFile);
            new File(journalFile).delete();
        }
        Journal jnl = new Journal(properties);
        RDFFormat fallback = RDFFormat.N3;
        HashCollisionUtility u = null;
        try {
            u = new HashCollisionUtility(jnl);
            u.start();
            for (String filename : args) {
                u.parseFileOrDirectory(new File(filename), fallback);
            }
            u.shutdown();
            jnl.commit();
        }
        catch (Throwable t) {
            u.shutdownNow();
            throw new RuntimeException(t);
        }
        finally {
            jnl.close();
            long elapsed = System.currentTimeMillis() - begin;
            System.out.println("Elapsed: " + elapsed + "ms");
            if (u != null) {
                System.out.println("NumStatements: " + u.c.nstmts);
                System.out.println("NumDistinctVals: " + u.c.ninserted);
                System.out.println("NumShortLiterals: " + u.c.nshortLiterals);
                System.out.println("NumShortBNodes: " + u.c.nshortBNodes);
                System.out.println("NumShortURIs: " + u.c.nshortURIs);
                System.out.println("TotalKeyBytes: " + u.c.totalKeyBytes);
                System.out.println("TotalValBytes: " + u.c.totalValBytes);
                System.out.println("MaxCollisions: " + u.c.maxCollisions);
                System.out.println("TotalCollisions: " + u.c.totalCollisions);
            }
            if (new File(journalFile).exists()) {
                System.out.println("Journal size: " + new File(journalFile).length() + " bytes");
            }
        }
    }

    private static class IndexValueBufferTask
    implements Callable<Void> {
        private final MemoryManager mmgr;
        private final ValueBuffer vbuf;
        private final BTree termsIndex;
        private final Counters c;
        private final IKeyBuilder keyBuilder = KeyBuilder.newInstance();
        private final BigdataValueSerializer<BigdataValue> valSer;
        private final RecordCompressor compressor;

        public IndexValueBufferTask(MemoryManager mmgr, ValueBuffer vbuf, BTree termsIndex, BigdataValueFactory vf, Counters c) {
            if (mmgr == null) {
                throw new IllegalArgumentException();
            }
            if (vbuf == null) {
                throw new IllegalArgumentException();
            }
            if (termsIndex == null) {
                throw new IllegalArgumentException();
            }
            if (vf == null) {
                throw new IllegalArgumentException();
            }
            if (c == null) {
                throw new IllegalArgumentException();
            }
            this.mmgr = mmgr;
            this.vbuf = vbuf;
            this.termsIndex = termsIndex;
            this.c = c;
            this.valSer = vf.getValueSerializer();
            this.compressor = new RecordCompressor(1);
        }

        @Override
        public Void call() throws Exception {
            long begin = System.currentTimeMillis();
            if (log.isInfoEnabled()) {
                log.info((Object)("Indexing " + this.vbuf.nvalues + " values occupying " + this.vbuf.getUserBytes() + " bytes"));
            }
            Object[] a = this.vbuf.addrMap.values().toArray(new Bucket[0]);
            Arrays.sort(a);
            for (int i = 0; i < a.length; ++i) {
                Object b = a[i];
                byte[] baseKey = this.keyBuilder.reset().append(((Bucket)b).key).getKey();
                for (long addr : ((Bucket)b).addrs) {
                    byte[] val = this.mmgr.read(addr);
                    this.addValue(baseKey, val);
                }
            }
            if (log.isInfoEnabled()) {
                long elapsed = System.currentTimeMillis() - begin;
                log.info((Object)("Indexed " + this.vbuf.nvalues + " values occupying " + this.vbuf.getUserBytes() + " bytes in " + elapsed + "ms"));
            }
            this.vbuf.clear();
            return null;
        }

        private void addValue(byte[] baseKey, byte[] val) {
            byte[] key;
            byte[] fromKey = baseKey;
            byte[] toKey = SuccessorUtil.successor((byte[])((byte[])fromKey.clone()));
            long rangeCount = this.termsIndex.rangeCount(fromKey, toKey);
            if (rangeCount >= 127L) {
                throw new RuntimeException("Too many hash collisions: ncoll=" + rangeCount);
            }
            byte counter = (byte)rangeCount;
            if (rangeCount == 0L) {
                byte[] key2 = this.keyBuilder.reset().append(fromKey).appendSigned(counter).getKey();
                if (this.termsIndex.insert(key2, val) != null) {
                    throw new AssertionError();
                }
                this.c.ninserted.incrementAndGet();
                this.c.totalKeyBytes.addAndGet(key2.length);
                this.c.totalValBytes.addAndGet(val.length);
                return;
            }
            ITupleIterator itr = this.termsIndex.rangeIterator(fromKey, toKey, 0, 2, null);
            boolean found = false;
            while (itr.hasNext()) {
                ITuple tuple = itr.next();
                byte[] tmp = tuple.getValue();
                if (!BytesUtil.bytesEqual((byte[])val, (byte[])tmp)) continue;
                found = true;
                break;
            }
            if (found) {
                return;
            }
            if (rangeCount > this.c.maxCollisions.get()) {
                this.c.maxCollisions.set(rangeCount);
                log.warn((Object)("MAX COLLISIONS NOW: " + this.c.maxCollisions.get()));
            }
            if (this.termsIndex.insert(key = this.keyBuilder.reset().append(fromKey).appendSigned(counter).getKey(), val) != null) {
                throw new AssertionError();
            }
            this.c.ninserted.incrementAndGet();
            this.c.totalKeyBytes.addAndGet(key.length);
            this.c.totalValBytes.addAndGet(val.length);
            this.c.totalCollisions.incrementAndGet();
            if (rangeCount > 128L) {
                log.warn((Object)("Collision: hashCode=" + BytesUtil.toString((byte[])key) + ", nstmts=" + this.c.nstmts + ", nshortLiterals=" + this.c.nshortLiterals + ", nshortURIs=" + this.c.nshortURIs + ", ninserted=" + this.c.ninserted + ", totalCollisions=" + this.c.totalCollisions + ", maxCollisions=" + this.c.maxCollisions + ", ncollThisTerm=" + rangeCount + ", resource=" + this.getValue(val)));
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Collision: hashCode=" + BytesUtil.toString((byte[])key) + ", nstmts=" + this.c.nstmts + ", nshortLiterals=" + this.c.nshortLiterals + ", nshortURIs=" + this.c.nshortURIs + ", ninserted=" + this.c.ninserted + ", totalCollisions=" + this.c.totalCollisions + ", maxCollisions=" + this.c.maxCollisions + ", ncollThisTerm=" + rangeCount + ", resource=" + this.getValue(val)));
            }
        }

        private Value getValue(byte[] tmp) {
            ByteBuffer b = this.compressor.decompress(tmp);
            byte[] c = new byte[b.limit()];
            b.get(c);
            return this.valSer.deserialize(c);
        }
    }

    private static class StatementHandler
    extends RDFHandlerBase {
        private final Counters c;
        private final LexiconConfiguration<BigdataValue> conf;
        final BlockingQueue<ValueBuffer> valueQueue;
        final AtomicBoolean parsing;
        private final IKeyBuilder keyBuilder = KeyBuilder.newInstance();
        private final DataOutputBuffer out = new DataOutputBuffer();
        private final ByteArrayBuffer tbuf = new ByteArrayBuffer();
        private final BigdataValueSerializer<BigdataValue> valSer;
        private final RecordCompressor compressor = new RecordCompressor(1);
        private int nvalues = 0;
        private final IMemoryManager memoryManager;
        private IMemoryManager context = null;
        private Map<byte[], Bucket> addrMap;
        private final int valueBufSize;

        public StatementHandler(int valueBufSize, Counters c, LexiconConfiguration<BigdataValue> conf, BigdataValueFactory vf, IMemoryManager memoryManager, BlockingQueue<ValueBuffer> valueQueue, AtomicBoolean parsing) {
            this.valueBufSize = valueBufSize;
            this.c = c;
            this.conf = conf;
            this.memoryManager = memoryManager;
            this.valueQueue = valueQueue;
            this.parsing = parsing;
            this.valSer = vf.getValueSerializer();
        }

        public void endRDF() {
            if (log.isTraceEnabled()) {
                log.trace((Object)"End of source.");
            }
            try {
                this.flush();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }

        public void handleStatement(Statement stmt) throws RDFHandlerException {
            if (!this.parsing.get()) {
                throw new IllegalStateException();
            }
            try {
                this.bufferValue((BigdataValue)stmt.getSubject());
                this.bufferValue((BigdataValue)stmt.getPredicate());
                this.bufferValue((BigdataValue)stmt.getObject());
                if (stmt.getContext() != null) {
                    this.bufferValue((BigdataValue)stmt.getContext());
                }
            }
            catch (InterruptedException ex) {
                throw new RDFHandlerException((Throwable)ex);
            }
            this.c.nstmts.incrementAndGet();
        }

        private void bufferValue(BigdataValue value) throws InterruptedException {
            assert (value.getIV() == null);
            IV iv = this.conf.createInlineIV((Value)value);
            if (iv != null) {
                switch (iv.getVTE()) {
                    case URI: {
                        this.c.nshortURIs.incrementAndGet();
                        break;
                    }
                    case BNODE: {
                        this.c.nshortBNodes.incrementAndGet();
                        break;
                    }
                    case LITERAL: {
                        this.c.nshortLiterals.incrementAndGet();
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                assert (value.getIV() == iv);
                return;
            }
            if (this.context != null && this.context.getSlotBytes() >= (long)this.valueBufSize) {
                this.flush();
            }
            if (this.context == null) {
                this.context = this.memoryManager.createAllocationContext();
                this.addrMap = new LinkedHashMap<byte[], Bucket>();
            }
            KV t = this.makeKV(value);
            Bucket bucket = this.addrMap.get(t.key);
            if (bucket == null) {
                long addr = this.context.allocate(ByteBuffer.wrap(t.val));
                bucket = new Bucket(t.key, addr);
                this.addrMap.put(t.key, bucket);
                ++this.nvalues;
            } else {
                for (Long addr : bucket.addrs) {
                    byte[] tmp;
                    if (this.context.allocationSize(addr.longValue()) != t.val.length || !BytesUtil.bytesEqual((byte[])t.val, (byte[])(tmp = this.context.read(addr.longValue())))) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Duplicate value in chunk: " + Arrays.toString(t.val)));
                    }
                    return;
                }
                bucket.add(this.context.allocate(ByteBuffer.wrap(t.val)));
                ++this.nvalues;
            }
        }

        void flush() throws InterruptedException {
            if (this.nvalues == 0) {
                return;
            }
            if (!this.parsing.get()) {
                throw new IllegalStateException();
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("Adding chunk with " + this.nvalues + " values and " + this.context.getUserBytes() + " bytes to queue."));
            }
            LinkedList<IMemoryManager> contexts = new LinkedList<IMemoryManager>();
            contexts.add(this.context);
            this.valueQueue.put(new ValueBuffer(contexts, this.nvalues, this.addrMap));
            this.context = null;
            this.addrMap = null;
            this.nvalues = 0;
        }

        private KV makeKV(BigdataValue r) {
            byte[] val = this.valSer.serialize((Value)r, this.out.reset(), this.tbuf);
            if (this.compressor != null) {
                this.out.reset();
                this.compressor.compress(val, (OutputStream)this.out);
            }
            val = this.out.toByteArray();
            byte[] key = this.buildKey((Value)r, val).getKey();
            return new KV(key, val);
        }

        private IKeyBuilder buildKey(Value r, byte[] val) {
            int hashCode = r.hashCode();
            return this.keyBuilder.reset().append(hashCode);
        }
    }

    private static class ParseFileTask
    implements Callable<Void> {
        private final File file;
        private final RDFFormat fallback;
        private final int fileBufSize;
        private final BigdataValueFactory vf;
        private final StatementHandler stmtHandler;

        public ParseFileTask(File file, RDFFormat fallback, int fileBufSize, BigdataValueFactory vf, StatementHandler stmtHandler) {
            if (file == null) {
                throw new IllegalArgumentException();
            }
            if (stmtHandler == null) {
                throw new IllegalArgumentException();
            }
            this.file = file;
            this.fallback = fallback;
            this.fileBufSize = fileBufSize;
            this.vf = vf;
            this.stmtHandler = stmtHandler;
        }

        @Override
        public Void call() throws Exception {
            this.parseFile(this.file);
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void parseFile(File file) throws IOException, RDFParseException, RDFHandlerException, NoSuchAlgorithmException, InterruptedException {
            RDFParserFactory rdfParserFactory;
            if (!file.exists()) {
                throw new RuntimeException("Not found: " + file);
            }
            RDFFormat format = RDFFormat.forFileName((String)file.getName(), (RDFFormat)this.fallback);
            if (format == null) {
                throw new RuntimeException("Unknown format: " + file);
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("RDFFormat=" + format));
            }
            if ((rdfParserFactory = (RDFParserFactory)RDFParserRegistry.getInstance().get((Object)format)) == null) {
                throw new RuntimeException("No parser for format: " + format);
            }
            RDFParser rdfParser = rdfParserFactory.getParser();
            rdfParser.setValueFactory((ValueFactory)this.vf);
            rdfParser.setVerifyData(false);
            rdfParser.setStopAtFirstError(false);
            rdfParser.setDatatypeHandling(RDFParser.DatatypeHandling.IGNORE);
            rdfParser.setRDFHandler((RDFHandler)this.stmtHandler);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Parsing: " + file));
            }
            try (InputStream is = new FileInputStream(file);){
                is = new BufferedInputStream(is, this.fileBufSize);
                boolean gzip = file.getName().endsWith(".gz");
                if (gzip) {
                    is = new GZIPInputStream(is);
                }
                String baseURI = file.toURI().toString();
                rdfParser.parse(is, baseURI);
            }
        }
    }

    private class IndexerMainTask
    implements Callable<Void> {
        private IndexerMainTask() {
        }

        @Override
        public Void call() throws Exception {
            boolean done = false;
            while (!done) {
                try {
                    ValueBuffer first = (ValueBuffer)HashCollisionUtility.this.valueQueue.take();
                    LinkedList<ValueBuffer> coll = new LinkedList<ValueBuffer>();
                    coll.add(first);
                    int ndrained = HashCollisionUtility.this.valueQueue.drainTo(coll, 5) + 1;
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Drained " + ndrained + " chunks with " + HashCollisionUtility.this.valueQueue.size() + " remaining in the queue."));
                    }
                    if (coll.remove(HashCollisionUtility.this.poisonPill)) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Found poison pill.");
                        }
                        done = true;
                    }
                    if (coll.isEmpty()) continue;
                    ValueBuffer b = this.combineChunks(coll);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Will index " + coll.size() + " chunks having " + b.nvalues + " values in " + b.getUserBytes() + " bytes"));
                    }
                    new IndexValueBufferTask(HashCollisionUtility.this.mmgr, b, HashCollisionUtility.this.termsIndex, HashCollisionUtility.this.vf, HashCollisionUtility.this.c).call();
                }
                catch (Throwable t) {
                    log.error((Object)t, t);
                    HashCollisionUtility.this.shutdownNow();
                    throw new RuntimeException(t);
                }
            }
            log.debug((Object)"done.");
            return null;
        }

        private ValueBuffer combineChunks(LinkedList<ValueBuffer> coll) {
            ValueBuffer b;
            if (coll.size() == 1) {
                b = coll.getFirst();
            } else {
                int nvalues = 0;
                for (ValueBuffer t : coll) {
                    nvalues += t.nvalues;
                }
                LinkedList<IMemoryManager> contexts = new LinkedList<IMemoryManager>();
                LinkedHashMap<byte[], Bucket> addrMap = new LinkedHashMap<byte[], Bucket>();
                for (ValueBuffer t : coll) {
                    contexts.addAll(t.contexts);
                    nvalues += t.nvalues;
                    for (Bucket bucket : t.addrMap.values()) {
                        Bucket tmp = addrMap.get(bucket.key);
                        if (tmp == null) {
                            addrMap.put(bucket.key, bucket);
                            continue;
                        }
                        tmp.addrs.addAll(bucket.addrs);
                    }
                }
                b = new ValueBuffer(contexts, nvalues, addrMap);
            }
            return b;
        }
    }

    private static class ValueBuffer {
        private final Set<IMemoryManager> contexts = new LinkedHashSet<IMemoryManager>();
        private final int nvalues;
        private final Map<byte[], Bucket> addrMap;

        public ValueBuffer(List<IMemoryManager> contexts, int nvalues, Map<byte[], Bucket> addrMap) {
            if (contexts == null) {
                throw new IllegalArgumentException();
            }
            if (addrMap == null) {
                throw new IllegalArgumentException();
            }
            this.contexts.addAll(contexts);
            this.nvalues = nvalues;
            this.addrMap = addrMap;
        }

        public void clear() {
            this.addrMap.clear();
            for (IMemoryManager context : this.contexts) {
                context.clear();
            }
        }

        public long getUserBytes() {
            long nbytes = 0L;
            for (IMemoryManager context : this.contexts) {
                nbytes += context.getUserBytes();
            }
            return nbytes;
        }
    }

    private static class Bucket
    implements Comparable<Bucket> {
        public final byte[] key;
        public final List<Long> addrs = new LinkedList<Long>();

        public Bucket(byte[] key) {
            if (key == null) {
                throw new IllegalArgumentException();
            }
            this.key = key;
        }

        public Bucket(byte[] key, long addr) {
            this(key);
            this.addrs.add(addr);
        }

        public void add(long addr) {
            this.addrs.add(addr);
        }

        @Override
        public int compareTo(Bucket o) {
            return BytesUtil.compareBytes((byte[])this.key, (byte[])o.key);
        }
    }

    private class ReportingFutureTask<V>
    extends FutureTask<V> {
        public final File file;

        public ReportingFutureTask(File file, Callable<V> callable) {
            super(callable);
            this.file = file;
            HashCollisionUtility.this.parserQueueLatch.inc();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                HashCollisionUtility.this.parserRunLatch.inc();
                HashCollisionUtility.this.parserQueueLatch.dec();
                super.run();
                HashCollisionUtility.this.parserRunLatch.dec();
            }
            finally {
                this.report(this);
            }
        }

        protected void report(ReportingFutureTask<?> task) {
            try {
                task.get();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Finished parsing: " + task.file + ", queueLatch=" + HashCollisionUtility.this.parserQueueLatch + ", runLatch=" + HashCollisionUtility.this.parserRunLatch));
                }
            }
            catch (ExecutionException ex) {
                log.error((Object)ex, (Throwable)ex);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private static class Counters {
        private final AtomicLong nstmts = new AtomicLong();
        private final AtomicLong nshortURIs = new AtomicLong();
        private final AtomicLong nshortBNodes = new AtomicLong();
        private final AtomicLong nshortLiterals = new AtomicLong();
        private final AtomicLong maxCollisions = new AtomicLong();
        private final AtomicLong totalCollisions = new AtomicLong();
        private final AtomicLong ninserted = new AtomicLong();
        private final AtomicLong totalKeyBytes = new AtomicLong();
        private final AtomicLong totalValBytes = new AtomicLong();

        private Counters() {
        }
    }
}

