/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal;

import com.bigdata.Banner;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.GZIPInputStream;
import org.apache.log4j.Logger;
import org.openrdf.model.Statement;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.RDFParser;
import org.openrdf.rio.RDFParserFactory;
import org.openrdf.rio.RDFParserRegistry;
import org.openrdf.rio.helpers.RDFHandlerBase;

public class ParserSpeedTest {
    private static final Logger log = Logger.getLogger(ParserSpeedTest.class);
    private final ExecutorService parserService;
    private final int fileBufSize = 8192;
    private final ValueFactory vf;
    final long begin = System.currentTimeMillis();
    private final AtomicLong nstmts = new AtomicLong();

    public ParserSpeedTest() {
        this.parserService = Executors.newCachedThreadPool();
        this.vf = new ValueFactoryImpl();
    }

    public void shutdown() {
        this.parserService.shutdown();
    }

    private void parseFileOrDirectory(File fileOrDir) throws Exception {
        if (fileOrDir.isDirectory()) {
            File[] files = fileOrDir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                File f = files[i];
                this.parseFileOrDirectory(f);
            }
            return;
        }
        File f = fileOrDir;
        String n = f.getName();
        RDFFormat fmt = RDFFormat.forFileName((String)n);
        if (fmt == null && n.endsWith(".zip")) {
            fmt = RDFFormat.forFileName((String)n.substring(0, n.length() - 4));
        }
        if (fmt == null && n.endsWith(".gz")) {
            fmt = RDFFormat.forFileName((String)n.substring(0, n.length() - 3));
        }
        if (fmt == null) {
            log.warn((Object)("Ignoring: " + f));
            return;
        }
        StatementHandler stmtHandler = new StatementHandler();
        FutureTask<Void> ft = new FutureTask<Void>(new ParseFileTask(f, 8192, this.vf, stmtHandler));
        this.parserService.submit(ft);
        ft.get();
        if (log.isInfoEnabled()) {
            log.info((Object)("Finished parsing: " + f));
        }
    }

    private long triplesPerSecond() {
        long elapsed = System.currentTimeMillis() - this.begin;
        return (long)((double)this.nstmts.get() / (double)elapsed * 1000.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Banner.banner();
        for (String filename : args) {
            File file = new File(filename);
            if (file.exists()) continue;
            throw new RuntimeException("Not found: " + file);
        }
        ParserSpeedTest u = new ParserSpeedTest();
        try {
            for (String filename : args) {
                u.parseFileOrDirectory(new File(filename));
            }
        }
        finally {
            u.shutdown();
            long elapsed = System.currentTimeMillis() - u.begin;
            System.out.println("nstmts=" + u.nstmts + ", tps=" + u.triplesPerSecond() + ", elapsed=" + elapsed);
        }
    }

    private class StatementHandler
    extends RDFHandlerBase {
        public void endRDF() {
            if (log.isInfoEnabled()) {
                log.info((Object)"End of source.");
            }
        }

        public void handleStatement(Statement stmt) throws RDFHandlerException {
            long n = ParserSpeedTest.this.nstmts.incrementAndGet();
            if (n % 10000L == 0L) {
                System.out.println("nstmts=" + n + ", tps=" + ParserSpeedTest.this.triplesPerSecond());
            }
        }
    }

    private static class ParseFileTask
    implements Callable<Void> {
        private final File file;
        private final int fileBufSize;
        private final ValueFactory vf;
        private final StatementHandler stmtHandler;

        public ParseFileTask(File file, int fileBufSize, ValueFactory vf, StatementHandler stmtHandler) {
            if (file == null) {
                throw new IllegalArgumentException();
            }
            if (stmtHandler == null) {
                throw new IllegalArgumentException();
            }
            this.file = file;
            this.fileBufSize = fileBufSize;
            this.vf = vf;
            this.stmtHandler = stmtHandler;
        }

        @Override
        public Void call() throws Exception {
            this.parseFile(this.file);
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void parseFile(File file) throws IOException, RDFParseException, RDFHandlerException, NoSuchAlgorithmException, InterruptedException {
            RDFParserFactory rdfParserFactory;
            if (!file.exists()) {
                throw new RuntimeException("Not found: " + file);
            }
            RDFFormat format = RDFFormat.forFileName((String)file.getName());
            if (format == null) {
                throw new RuntimeException("Unknown format: " + file);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("RDFFormat=" + format));
            }
            if ((rdfParserFactory = (RDFParserFactory)RDFParserRegistry.getInstance().get((Object)format)) == null) {
                throw new RuntimeException("No parser for format: " + format);
            }
            RDFParser rdfParser = rdfParserFactory.getParser();
            rdfParser.setValueFactory(this.vf);
            rdfParser.setVerifyData(false);
            rdfParser.setStopAtFirstError(false);
            rdfParser.setDatatypeHandling(RDFParser.DatatypeHandling.IGNORE);
            rdfParser.setRDFHandler((RDFHandler)this.stmtHandler);
            if (log.isInfoEnabled()) {
                log.info((Object)("Parsing: " + file));
            }
            try (InputStream is = new FileInputStream(file);){
                is = new BufferedInputStream(is, this.fileBufSize);
                boolean gzip = file.getName().endsWith(".gz");
                if (gzip) {
                    is = new GZIPInputStream(is);
                }
                String baseURI = file.toURI().toString();
                rdfParser.parse(is, baseURI);
            }
        }
    }
}

