/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal;

import com.bigdata.btree.keys.IKeyBuilder;
import com.bigdata.rdf.internal.AbstractEncodeDecodeKeysTestCase;
import com.bigdata.rdf.internal.DTE;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.IVUtility;
import com.bigdata.rdf.internal.VTE;
import com.bigdata.rdf.internal.impl.BlobIV;
import com.bigdata.rdf.lexicon.BlobsIndexHelper;
import com.bigdata.util.BytesUtil;
import java.util.Random;
import junit.framework.TestCase2;

public class TestBlobIV
extends TestCase2 {
    private BlobsIndexHelper helper;

    public TestBlobIV() {
    }

    public TestBlobIV(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.helper = new BlobsIndexHelper();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.helper = null;
    }

    public void test_BlobIV_isExtensionIV() {
        BlobIV iv = new BlobIV(VTE.URI, 12, 50);
        TestBlobIV.assertEquals((Object)VTE.URI, (Object)iv.getVTE());
        TestBlobIV.assertFalse((boolean)iv.isInline());
        TestBlobIV.assertTrue((boolean)iv.isExtension());
        TestBlobIV.assertEquals((Object)DTE.XSDBoolean, (Object)iv.getDTE());
        TestBlobIV.assertEquals((int)12, (int)iv.hashCode());
        TestBlobIV.assertEquals((int)50, (int)iv.counter());
    }

    private void doBlobIVTest(VTE vte, int hashCode, int counter) {
        IKeyBuilder keyBuilder = this.helper.newKeyBuilder();
        BlobIV iv = new BlobIV(vte, hashCode, (short)counter);
        TestBlobIV.assertEquals((byte)BlobIV.toFlags((VTE)vte), (byte)iv.flags());
        TestBlobIV.assertEquals((Object)vte, (Object)iv.getVTE());
        TestBlobIV.assertEquals((int)hashCode, (int)iv.hashCode());
        TestBlobIV.assertEquals((int)counter, (int)iv.counter());
        TestBlobIV.assertEquals((Object)iv, (Object)BlobIV.fromString((String)iv.toString()));
        byte[] a = iv.encode(keyBuilder.reset()).getKey();
        byte[] key = this.helper.makeKey(keyBuilder.reset(), vte, hashCode, counter);
        if (!BytesUtil.bytesEqual((byte[])a, (byte[])key)) {
            TestBlobIV.fail((String)("Encoding differs: iv=" + iv + ", expected=" + BytesUtil.toString((byte[])a) + ", actual=" + BytesUtil.toString((byte[])key)));
        }
        BlobIV iv2 = (BlobIV)IVUtility.decode((byte[])key);
        TestBlobIV.assertEquals((Object)vte, (Object)iv2.getVTE());
        TestBlobIV.assertEquals((int)hashCode, (int)iv2.hashCode());
        TestBlobIV.assertEquals((int)counter, (int)iv2.counter());
        TestBlobIV.assertEquals((Object)iv, (Object)BlobIV.fromString((String)iv2.toString()));
        TestBlobIV.assertEquals((Object)iv, (Object)iv2);
    }

    public void test_BlobIV_URI() {
        VTE vte = VTE.URI;
        int hashCode = 12;
        boolean counter = true;
        this.doBlobIVTest(vte, 12, 1);
    }

    public void test_BlobIV_Literal() {
        VTE vte = VTE.LITERAL;
        int hashCode = 12;
        boolean counter = true;
        this.doBlobIVTest(vte, 12, 1);
    }

    public void test_BlobIV_BNode() {
        VTE vte = VTE.BNODE;
        int hashCode = 12;
        boolean counter = true;
        this.doBlobIVTest(vte, 12, 1);
    }

    public void test_BlobIV_URI_Counter_ZERO() {
        VTE vte = VTE.URI;
        int hashCode = 12;
        boolean counter = false;
        this.doBlobIVTest(vte, 12, 0);
    }

    public void test_BlobIV_URI_Counter_ONE() {
        VTE vte = VTE.URI;
        int hashCode = 12;
        boolean counter = true;
        this.doBlobIVTest(vte, 12, 1);
    }

    public void test_BlobIV_URI_Counter_MIN_VALUE() {
        VTE vte = VTE.URI;
        int hashCode = 12;
        int counter = Short.MIN_VALUE;
        this.doBlobIVTest(vte, 12, Short.MIN_VALUE);
    }

    public void test_BlobIV_URI_Counter_MAX_VALUE() {
        VTE vte = VTE.URI;
        int hashCode = 12;
        int counter = Short.MAX_VALUE;
        this.doBlobIVTest(vte, 12, Short.MAX_VALUE);
    }

    public void test_BlobIV_problemValue_01() {
        VTE vte = VTE.LITERAL;
        int hashCode = 1974963648;
        boolean counter = false;
        this.doBlobIVTest(vte, 1974963648, 0);
    }

    public void test_BlobIV() {
        Random r = new Random();
        IKeyBuilder keyBuilder = this.helper.newKeyBuilder();
        for (VTE vte : VTE.values()) {
            int hashCode = r.nextInt();
            int counter = Short.MAX_VALUE - r.nextInt(18);
            BlobIV v = new BlobIV(vte, hashCode, (short)counter);
            TestBlobIV.assertFalse((boolean)v.isInline());
            if (!vte.equals((Object)v.getVTE())) {
                TestBlobIV.fail((String)("Expected=" + vte + ", actual=" + v.getVTE() + " : iv=" + v));
            }
            TestBlobIV.assertEquals((int)hashCode, (int)v.hashCode());
            TestBlobIV.assertEquals((int)counter, (int)v.counter());
            byte[] key = this.helper.makeKey(keyBuilder.reset(), vte, hashCode, counter);
            BlobIV iv2 = (BlobIV)IVUtility.decode((byte[])key);
            TestBlobIV.assertEquals((Object)v, (Object)iv2);
            TestBlobIV.assertEquals((int)0, (int)v.compareTo((IV)iv2));
            TestBlobIV.assertEquals((int)0, (int)iv2.compareTo((IV)v));
            TestBlobIV.assertEquals((boolean)v.isURI(), (boolean)iv2.isURI());
            TestBlobIV.assertEquals((boolean)v.isLiteral(), (boolean)iv2.isLiteral());
            TestBlobIV.assertEquals((boolean)v.isBNode(), (boolean)iv2.isBNode());
            TestBlobIV.assertEquals((boolean)v.isStatement(), (boolean)iv2.isStatement());
            try {
                v.getInlineValue();
                TestBlobIV.fail((String)("Expecting " + UnsupportedOperationException.class));
            }
            catch (UnsupportedOperationException ex) {
                // empty catch block
            }
            switch (vte) {
                case URI: {
                    TestBlobIV.assertTrue((boolean)v.isURI());
                    TestBlobIV.assertFalse((boolean)v.isBNode());
                    TestBlobIV.assertFalse((boolean)v.isLiteral());
                    TestBlobIV.assertFalse((boolean)v.isStatement());
                    break;
                }
                case BNODE: {
                    TestBlobIV.assertFalse((boolean)v.isURI());
                    TestBlobIV.assertTrue((boolean)v.isBNode());
                    TestBlobIV.assertFalse((boolean)v.isLiteral());
                    TestBlobIV.assertFalse((boolean)v.isStatement());
                    break;
                }
                case LITERAL: {
                    TestBlobIV.assertFalse((boolean)v.isURI());
                    TestBlobIV.assertFalse((boolean)v.isBNode());
                    TestBlobIV.assertTrue((boolean)v.isLiteral());
                    TestBlobIV.assertFalse((boolean)v.isStatement());
                    break;
                }
                case STATEMENT: {
                    TestBlobIV.assertFalse((boolean)v.isURI());
                    TestBlobIV.assertFalse((boolean)v.isBNode());
                    TestBlobIV.assertFalse((boolean)v.isLiteral());
                    TestBlobIV.assertTrue((boolean)v.isStatement());
                    break;
                }
                default: {
                    TestBlobIV.fail((String)("vte=" + vte));
                }
            }
            String s = v.toString();
            BlobIV tmp = BlobIV.fromString((String)s);
            TestBlobIV.assertEquals((Object)v, (Object)tmp);
        }
    }

    public void test_blobIV_encodeDecode_compareTo() {
        Random r = new Random();
        IV[] e = new IV[100 * VTE.values().length];
        int n = 0;
        for (int i = 0; i < 100; ++i) {
            for (VTE vte : VTE.values()) {
                int hashCode = r.nextInt();
                int counter = Short.MAX_VALUE - r.nextInt(18);
                BlobIV v = new BlobIV(vte, hashCode, (short)counter);
                e[n++] = v;
            }
        }
        AbstractEncodeDecodeKeysTestCase.doEncodeDecodeTest(e);
        AbstractEncodeDecodeKeysTestCase.doComparatorTest(e);
    }
}

