/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal;

import com.bigdata.rdf.internal.DTE;
import com.bigdata.rdf.internal.XSD;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.UUID;
import junit.framework.TestCase;
import org.openrdf.model.URI;

public class TestDTE
extends TestCase {
    public TestDTE() {
    }

    public TestDTE(String name) {
        super(name);
    }

    public void test_DTE_selfConsistent() {
        for (DTE e : DTE.values()) {
            if (e == DTE.Extension) continue;
            DTE a = DTE.valueOf((byte)e.v);
            if (e != a) {
                TestDTE.fail((String)("expected: " + e + " (v=" + e.v + "), actual=" + a));
            }
            if (e != (a = DTE.valueOf((URI)e.getDatatypeURI()))) {
                TestDTE.fail((String)("expected: " + e + " (v=" + e.v + "), actual=" + a));
            }
            TestDTE.assertEquals((byte)e.v, (byte)e.v());
        }
    }

    public void test_XSDBoolean() {
        TestDTE.assertFalse((boolean)DTE.XSDBoolean.isNumeric());
        TestDTE.assertFalse((boolean)DTE.XSDBoolean.isFixedNumeric());
        TestDTE.assertFalse((boolean)DTE.XSDBoolean.isFloatingPointNumeric());
        TestDTE.assertFalse((boolean)DTE.XSDBoolean.isUnsignedNumeric());
        TestDTE.assertFalse((boolean)DTE.XSDBoolean.isSignedNumeric());
        TestDTE.assertFalse((boolean)DTE.XSDBoolean.isBigNumeric());
        TestDTE.assertEquals((int)1, (int)DTE.XSDBoolean.len());
        TestDTE.assertEquals(Boolean.class, (Object)DTE.XSDBoolean.getCls());
        TestDTE.assertEquals((Object)XSD.BOOLEAN, (Object)DTE.XSDBoolean.getDatatypeURI());
    }

    public void test_XSDByte() {
        TestDTE.assertTrue((boolean)DTE.XSDByte.isNumeric());
        TestDTE.assertTrue((boolean)DTE.XSDByte.isFixedNumeric());
        TestDTE.assertFalse((boolean)DTE.XSDByte.isFloatingPointNumeric());
        TestDTE.assertFalse((boolean)DTE.XSDByte.isUnsignedNumeric());
        TestDTE.assertTrue((boolean)DTE.XSDByte.isSignedNumeric());
        TestDTE.assertFalse((boolean)DTE.XSDByte.isBigNumeric());
        TestDTE.assertEquals((int)1, (int)DTE.XSDByte.len());
        TestDTE.assertEquals(Byte.class, (Object)DTE.XSDByte.getCls());
        TestDTE.assertEquals((Object)XSD.BYTE, (Object)DTE.XSDByte.getDatatypeURI());
    }

    public void test_XSDShort() {
        TestDTE.assertTrue((boolean)DTE.XSDShort.isNumeric());
        TestDTE.assertTrue((boolean)DTE.XSDShort.isFixedNumeric());
        TestDTE.assertFalse((boolean)DTE.XSDShort.isFloatingPointNumeric());
        TestDTE.assertFalse((boolean)DTE.XSDShort.isUnsignedNumeric());
        TestDTE.assertTrue((boolean)DTE.XSDShort.isSignedNumeric());
        TestDTE.assertFalse((boolean)DTE.XSDShort.isBigNumeric());
        TestDTE.assertEquals((int)2, (int)DTE.XSDShort.len());
        TestDTE.assertEquals(Short.class, (Object)DTE.XSDShort.getCls());
        TestDTE.assertEquals((Object)XSD.SHORT, (Object)DTE.XSDShort.getDatatypeURI());
    }

    public void test_XSDInt() {
        TestDTE.assertTrue((boolean)DTE.XSDInt.isNumeric());
        TestDTE.assertTrue((boolean)DTE.XSDInt.isFixedNumeric());
        TestDTE.assertFalse((boolean)DTE.XSDInt.isFloatingPointNumeric());
        TestDTE.assertFalse((boolean)DTE.XSDInt.isUnsignedNumeric());
        TestDTE.assertTrue((boolean)DTE.XSDInt.isSignedNumeric());
        TestDTE.assertFalse((boolean)DTE.XSDInt.isBigNumeric());
        TestDTE.assertEquals((int)4, (int)DTE.XSDInt.len());
        TestDTE.assertEquals(Integer.class, (Object)DTE.XSDInt.getCls());
        TestDTE.assertEquals((Object)XSD.INT, (Object)DTE.XSDInt.getDatatypeURI());
    }

    public void test_XSDLong() {
        TestDTE.assertTrue((boolean)DTE.XSDLong.isNumeric());
        TestDTE.assertTrue((boolean)DTE.XSDLong.isFixedNumeric());
        TestDTE.assertFalse((boolean)DTE.XSDLong.isFloatingPointNumeric());
        TestDTE.assertFalse((boolean)DTE.XSDLong.isUnsignedNumeric());
        TestDTE.assertTrue((boolean)DTE.XSDLong.isSignedNumeric());
        TestDTE.assertFalse((boolean)DTE.XSDLong.isBigNumeric());
        TestDTE.assertEquals((int)8, (int)DTE.XSDLong.len());
        TestDTE.assertEquals(Long.class, (Object)DTE.XSDLong.getCls());
        TestDTE.assertEquals((Object)XSD.LONG, (Object)DTE.XSDLong.getDatatypeURI());
    }

    public void test_XSDUnsignedByte() {
        TestDTE.assertTrue((boolean)DTE.XSDUnsignedByte.isNumeric());
        TestDTE.assertTrue((boolean)DTE.XSDUnsignedByte.isFixedNumeric());
        TestDTE.assertFalse((boolean)DTE.XSDUnsignedByte.isFloatingPointNumeric());
        TestDTE.assertTrue((boolean)DTE.XSDUnsignedByte.isUnsignedNumeric());
        TestDTE.assertFalse((boolean)DTE.XSDUnsignedByte.isSignedNumeric());
        TestDTE.assertFalse((boolean)DTE.XSDUnsignedByte.isBigNumeric());
        TestDTE.assertEquals((int)1, (int)DTE.XSDUnsignedByte.len());
        TestDTE.assertEquals(Byte.class, (Object)DTE.XSDUnsignedByte.getCls());
        TestDTE.assertEquals((Object)XSD.UNSIGNED_BYTE, (Object)DTE.XSDUnsignedByte.getDatatypeURI());
    }

    public void test_XSDUnsignedShort() {
        TestDTE.assertTrue((boolean)DTE.XSDUnsignedShort.isNumeric());
        TestDTE.assertTrue((boolean)DTE.XSDUnsignedShort.isFixedNumeric());
        TestDTE.assertFalse((boolean)DTE.XSDUnsignedShort.isFloatingPointNumeric());
        TestDTE.assertTrue((boolean)DTE.XSDUnsignedShort.isUnsignedNumeric());
        TestDTE.assertFalse((boolean)DTE.XSDUnsignedShort.isSignedNumeric());
        TestDTE.assertFalse((boolean)DTE.XSDUnsignedShort.isBigNumeric());
        TestDTE.assertEquals((int)2, (int)DTE.XSDUnsignedShort.len());
        TestDTE.assertEquals(Short.class, (Object)DTE.XSDUnsignedShort.getCls());
        TestDTE.assertEquals((Object)XSD.UNSIGNED_SHORT, (Object)DTE.XSDUnsignedShort.getDatatypeURI());
    }

    public void test_XSDUnsignedInt() {
        TestDTE.assertTrue((boolean)DTE.XSDUnsignedInt.isNumeric());
        TestDTE.assertTrue((boolean)DTE.XSDUnsignedInt.isFixedNumeric());
        TestDTE.assertFalse((boolean)DTE.XSDUnsignedInt.isFloatingPointNumeric());
        TestDTE.assertTrue((boolean)DTE.XSDUnsignedInt.isUnsignedNumeric());
        TestDTE.assertFalse((boolean)DTE.XSDUnsignedInt.isSignedNumeric());
        TestDTE.assertFalse((boolean)DTE.XSDUnsignedInt.isBigNumeric());
        TestDTE.assertEquals((int)4, (int)DTE.XSDUnsignedInt.len());
        TestDTE.assertEquals(Integer.class, (Object)DTE.XSDUnsignedInt.getCls());
        TestDTE.assertEquals((Object)XSD.UNSIGNED_INT, (Object)DTE.XSDUnsignedInt.getDatatypeURI());
    }

    public void test_XSDUnsignedLong() {
        TestDTE.assertTrue((boolean)DTE.XSDUnsignedLong.isNumeric());
        TestDTE.assertTrue((boolean)DTE.XSDUnsignedLong.isFixedNumeric());
        TestDTE.assertFalse((boolean)DTE.XSDUnsignedLong.isFloatingPointNumeric());
        TestDTE.assertTrue((boolean)DTE.XSDUnsignedLong.isUnsignedNumeric());
        TestDTE.assertFalse((boolean)DTE.XSDUnsignedLong.isSignedNumeric());
        TestDTE.assertFalse((boolean)DTE.XSDUnsignedLong.isBigNumeric());
        TestDTE.assertEquals((int)8, (int)DTE.XSDUnsignedLong.len());
        TestDTE.assertEquals(Long.class, (Object)DTE.XSDUnsignedLong.getCls());
        TestDTE.assertEquals((Object)XSD.UNSIGNED_LONG, (Object)DTE.XSDUnsignedLong.getDatatypeURI());
    }

    public void test_XSDFloat() {
        TestDTE.assertTrue((boolean)DTE.XSDFloat.isNumeric());
        TestDTE.assertTrue((boolean)DTE.XSDFloat.isFixedNumeric());
        TestDTE.assertTrue((boolean)DTE.XSDFloat.isFloatingPointNumeric());
        TestDTE.assertFalse((boolean)DTE.XSDFloat.isUnsignedNumeric());
        TestDTE.assertTrue((boolean)DTE.XSDFloat.isSignedNumeric());
        TestDTE.assertFalse((boolean)DTE.XSDFloat.isBigNumeric());
        TestDTE.assertEquals((int)4, (int)DTE.XSDFloat.len());
        TestDTE.assertEquals(Float.class, (Object)DTE.XSDFloat.getCls());
        TestDTE.assertEquals((Object)XSD.FLOAT, (Object)DTE.XSDFloat.getDatatypeURI());
    }

    public void test_XSDDouble() {
        TestDTE.assertTrue((boolean)DTE.XSDDouble.isNumeric());
        TestDTE.assertTrue((boolean)DTE.XSDDouble.isFixedNumeric());
        TestDTE.assertTrue((boolean)DTE.XSDDouble.isFloatingPointNumeric());
        TestDTE.assertFalse((boolean)DTE.XSDDouble.isUnsignedNumeric());
        TestDTE.assertTrue((boolean)DTE.XSDDouble.isSignedNumeric());
        TestDTE.assertFalse((boolean)DTE.XSDDouble.isBigNumeric());
        TestDTE.assertEquals((int)8, (int)DTE.XSDDouble.len());
        TestDTE.assertEquals(Double.class, (Object)DTE.XSDDouble.getCls());
        TestDTE.assertEquals((Object)XSD.DOUBLE, (Object)DTE.XSDDouble.getDatatypeURI());
    }

    public void test_XSDInteger() {
        TestDTE.assertTrue((boolean)DTE.XSDInteger.isNumeric());
        TestDTE.assertFalse((boolean)DTE.XSDInteger.isFixedNumeric());
        TestDTE.assertFalse((boolean)DTE.XSDInteger.isFloatingPointNumeric());
        TestDTE.assertFalse((boolean)DTE.XSDInteger.isUnsignedNumeric());
        TestDTE.assertTrue((boolean)DTE.XSDInteger.isSignedNumeric());
        TestDTE.assertTrue((boolean)DTE.XSDInteger.isBigNumeric());
        TestDTE.assertEquals((int)0, (int)DTE.XSDInteger.len());
        TestDTE.assertEquals(BigInteger.class, (Object)DTE.XSDInteger.getCls());
        TestDTE.assertEquals((Object)XSD.INTEGER, (Object)DTE.XSDInteger.getDatatypeURI());
    }

    public void test_XSDDecimal() {
        TestDTE.assertTrue((boolean)DTE.XSDDecimal.isNumeric());
        TestDTE.assertFalse((boolean)DTE.XSDDecimal.isFixedNumeric());
        TestDTE.assertTrue((boolean)DTE.XSDDecimal.isFloatingPointNumeric());
        TestDTE.assertFalse((boolean)DTE.XSDDecimal.isUnsignedNumeric());
        TestDTE.assertTrue((boolean)DTE.XSDDecimal.isSignedNumeric());
        TestDTE.assertTrue((boolean)DTE.XSDDecimal.isBigNumeric());
        TestDTE.assertEquals((int)0, (int)DTE.XSDDecimal.len());
        TestDTE.assertEquals(BigDecimal.class, (Object)DTE.XSDDecimal.getCls());
        TestDTE.assertEquals((Object)XSD.DECIMAL, (Object)DTE.XSDDecimal.getDatatypeURI());
    }

    public void test_UUID() {
        TestDTE.assertFalse((boolean)DTE.UUID.isNumeric());
        TestDTE.assertFalse((boolean)DTE.UUID.isFixedNumeric());
        TestDTE.assertFalse((boolean)DTE.UUID.isFloatingPointNumeric());
        TestDTE.assertFalse((boolean)DTE.UUID.isUnsignedNumeric());
        TestDTE.assertFalse((boolean)DTE.UUID.isSignedNumeric());
        TestDTE.assertFalse((boolean)DTE.UUID.isBigNumeric());
        TestDTE.assertEquals((int)16, (int)DTE.UUID.len());
        TestDTE.assertEquals(UUID.class, (Object)DTE.UUID.getCls());
        TestDTE.assertEquals((Object)XSD.UUID, (Object)DTE.UUID.getDatatypeURI());
    }

    public void test_XSDString() {
        TestDTE.assertFalse((boolean)DTE.XSDString.isNumeric());
        TestDTE.assertFalse((boolean)DTE.XSDString.isFixedNumeric());
        TestDTE.assertFalse((boolean)DTE.XSDString.isFloatingPointNumeric());
        TestDTE.assertFalse((boolean)DTE.XSDString.isUnsignedNumeric());
        TestDTE.assertFalse((boolean)DTE.XSDString.isSignedNumeric());
        TestDTE.assertFalse((boolean)DTE.XSDString.isBigNumeric());
        TestDTE.assertEquals((int)0, (int)DTE.XSDString.len());
        TestDTE.assertEquals(String.class, (Object)DTE.XSDString.getCls());
        TestDTE.assertEquals((Object)XSD.STRING, (Object)DTE.XSDString.getDatatypeURI());
    }
}

