/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal;

import com.bigdata.rdf.internal.AbstractEncodeDecodeKeysTestCase;
import com.bigdata.rdf.internal.IDatatypeURIResolver;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.VTE;
import com.bigdata.rdf.internal.impl.extensions.GeoSpatialLiteralExtension;
import com.bigdata.rdf.internal.impl.extensions.InvalidGeoSpatialLiteralError;
import com.bigdata.rdf.internal.impl.literal.LiteralExtensionIV;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.model.BigdataValueFactoryImpl;
import com.bigdata.service.geospatial.GeoSpatial;
import com.bigdata.service.geospatial.GeoSpatialDatatypeConfiguration;
import com.bigdata.service.geospatial.GeoSpatialDatatypeFieldConfiguration;
import com.bigdata.service.geospatial.GeoSpatialDefaultLiteralSerializer;
import com.bigdata.service.geospatial.IGeoSpatialLiteralSerializer;
import java.math.BigDecimal;
import java.util.ArrayList;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.URIImpl;

public class TestEncodeDecodeGeoSpatialLiteralIVs
extends AbstractEncodeDecodeKeysTestCase {
    private final String STR_DATATYPE_LAT_LON_LONG_MIN = "http://my.test.datatype/lat_lon_long_min";
    private final URI URI_DATATYPE_LAT_LON_LONG_MIN = new URIImpl("http://my.test.datatype/lat_lon_long_min");
    private final String STR_DATATYPE_LAT_LON_LONG = "http://my.test.datatype/lat_lon_as-long";
    private final URI URI_DATATYPE_LAT_LON_LONG = new URIImpl("http://my.test.datatype/lat_lon_as-long");
    private final String STR_DATATYPE_LAT_LON_DOUBLE = "http://my.test.datatype/lat_lon_as-double";
    private final URI URI_DATATYPE_LAT_LON_DOUBLE = new URIImpl("http://my.test.datatype/lat_lon_as-double");
    private final String STR_DATATYPE_LAT_LON_TIME = "http://my.test.datatype/lat_lon_time";
    private final URI URI_DATATYPE_LAT_LON_TIME = new URIImpl("http://my.test.datatype/lat_lon_time");

    public TestEncodeDecodeGeoSpatialLiteralIVs() {
    }

    public TestEncodeDecodeGeoSpatialLiteralIVs(String name) {
        super(name);
    }

    public void test_encodeDecodeLatLonTimeGeoSpatialLiterals() throws Exception {
        BigdataValueFactory vf = BigdataValueFactoryImpl.getInstance((String)"test");
        GeoSpatialLiteralExtension<BigdataValue> ext = this.getLatLonTimeGSLiteralExtension(vf);
        this.encodeDecodeGeoSpatialLiterals(vf, this.getDummyGeospatialLiteralsLatLonTime(vf, this.URI_DATATYPE_LAT_LON_TIME), ext);
    }

    public void test_encodeDecodeLatLonGeoSpatialLiterals() throws Exception {
        BigdataValueFactory vf = BigdataValueFactoryImpl.getInstance((String)"test");
        GeoSpatialLiteralExtension<BigdataValue> ext = this.getLatLonGSLiteralExtension(vf);
        this.encodeDecodeGeoSpatialLiterals(vf, this.getDummyGeospatialLiteralsLatLon(vf, this.URI_DATATYPE_LAT_LON_DOUBLE), ext);
    }

    public void test_encodeDecodeGeoSpatialLiteralsWrongFormat() throws Exception {
        BigdataValueFactory vf = BigdataValueFactoryImpl.getInstance((String)"test");
        boolean case1Passed = false;
        try {
            GeoSpatialLiteralExtension<BigdataValue> extLatLonTime = this.getLatLonTimeGSLiteralExtension(vf);
            this.encodeDecodeGeoSpatialLiterals(vf, this.getDummyGeospatialLiteralsLatLon(vf, this.URI_DATATYPE_LAT_LON_TIME), extLatLonTime);
        }
        catch (InvalidGeoSpatialLiteralError e) {
            case1Passed = true;
        }
        if (!case1Passed) {
            throw new RuntimeException("Expected IllegalArgumentException");
        }
        boolean case2Passed = false;
        try {
            GeoSpatialLiteralExtension<BigdataValue> extLatLon = this.getLatLonGSLiteralExtension(vf);
            this.encodeDecodeGeoSpatialLiterals(vf, this.getDummyGeospatialLiteralsLatLonTime(vf, GeoSpatial.DEFAULT_DATATYPE), extLatLon);
        }
        catch (InvalidGeoSpatialLiteralError e) {
            case2Passed = true;
        }
        if (!case2Passed) {
            throw new RuntimeException("Expected IllegalArgumentException");
        }
    }

    public void testZIndexOrderingPositive() {
        BigdataValueFactory vf = BigdataValueFactoryImpl.getInstance((String)"test");
        GeoSpatialLiteralExtension<BigdataValue> litExt = this.getSimpleLatLonGSLiteralExtension(vf);
        this.zIndexOrderingPositiveBase(vf, litExt, this.URI_DATATYPE_LAT_LON_LONG);
    }

    public void testZIndexOrderingPositiveWithRangeAdjustment() {
        BigdataValueFactory vf = BigdataValueFactoryImpl.getInstance((String)"test");
        GeoSpatialLiteralExtension<BigdataValue> litExt = this.getSimpleLatLonGSLiteralExtensionWithRange(vf, 0L);
        this.zIndexOrderingPositiveBase(vf, litExt, this.URI_DATATYPE_LAT_LON_LONG_MIN);
    }

    public void testZIndexOrderingMixed() {
        BigdataValueFactory vf = BigdataValueFactoryImpl.getInstance((String)"test");
        GeoSpatialLiteralExtension<BigdataValue> litExt = this.getSimpleLatLonGSLiteralExtension(vf);
        this.zIndexOrderingMixedBase(vf, litExt, this.URI_DATATYPE_LAT_LON_LONG);
    }

    public void testZIndexOrderingMixedWithRangeAdjustment() {
        BigdataValueFactory vf = BigdataValueFactoryImpl.getInstance((String)"test");
        GeoSpatialLiteralExtension<BigdataValue> litExt = this.getSimpleLatLonGSLiteralExtensionWithRange(vf, -2L);
        this.zIndexOrderingMixedBase(vf, litExt, this.URI_DATATYPE_LAT_LON_LONG_MIN);
    }

    protected void encodeDecodeGeoSpatialLiterals(BigdataValueFactory vf, BigdataLiteral[] dt, GeoSpatialLiteralExtension<BigdataValue> ext) throws Exception {
        int i;
        IV[] e = new IV[dt.length];
        for (i = 0; i < dt.length; ++i) {
            e[i] = ext.createIV((Value)dt[i]);
        }
        for (i = 0; i < e.length; ++i) {
            BigdataValue val = ext.asValue((LiteralExtensionIV)e[i], vf);
            this.assertSemanticallyIdentical(val, dt[i]);
        }
        IV<?, ?>[] a = TestEncodeDecodeGeoSpatialLiteralIVs.doEncodeDecodeTest(e);
        if (log.isInfoEnabled()) {
            for (int i2 = 0; i2 < e.length; ++i2) {
                log.info((Object)("original: " + dt[i2]));
                log.info((Object)("asValue : " + ext.asValue((LiteralExtensionIV)e[i2], vf)));
                log.info((Object)("decoded : " + ext.asValue((LiteralExtensionIV)a[i2], vf)));
                log.info((Object)"");
            }
        }
        TestEncodeDecodeGeoSpatialLiteralIVs.doComparatorTest(e);
    }

    protected void zIndexOrderingPositiveBase(BigdataValueFactory vf, GeoSpatialLiteralExtension<BigdataValue> litExt, URI datatype) {
        int i;
        BigdataLiteral[] asWritten = this.getGeospatialLiteralsLatLonInRange(vf, 0, 7, datatype);
        LiteralExtensionIV[] asWrittenConverted = new LiteralExtensionIV[asWritten.length];
        for (i = 0; i < asWritten.length; ++i) {
            asWrittenConverted[i] = litExt.createIV((Value)asWritten[i]);
        }
        for (i = 0; i < asWrittenConverted.length; ++i) {
            System.out.println(asWritten[i] + " -> " + asWrittenConverted[i]);
        }
        LiteralExtensionIV[] ordered = new LiteralExtensionIV[asWrittenConverted.length];
        ordered[0] = asWrittenConverted[0];
        ordered[1] = asWrittenConverted[1];
        ordered[2] = asWrittenConverted[8];
        ordered[3] = asWrittenConverted[9];
        ordered[4] = asWrittenConverted[2];
        ordered[5] = asWrittenConverted[3];
        ordered[6] = asWrittenConverted[10];
        ordered[7] = asWrittenConverted[11];
        ordered[8] = asWrittenConverted[16];
        ordered[9] = asWrittenConverted[17];
        ordered[10] = asWrittenConverted[24];
        ordered[11] = asWrittenConverted[25];
        ordered[12] = asWrittenConverted[18];
        ordered[13] = asWrittenConverted[19];
        ordered[14] = asWrittenConverted[26];
        ordered[15] = asWrittenConverted[27];
        ordered[16] = asWrittenConverted[4];
        ordered[17] = asWrittenConverted[5];
        ordered[18] = asWrittenConverted[12];
        ordered[19] = asWrittenConverted[13];
        ordered[20] = asWrittenConverted[6];
        ordered[21] = asWrittenConverted[7];
        ordered[22] = asWrittenConverted[14];
        ordered[23] = asWrittenConverted[15];
        ordered[24] = asWrittenConverted[20];
        ordered[25] = asWrittenConverted[21];
        ordered[26] = asWrittenConverted[28];
        ordered[27] = asWrittenConverted[29];
        ordered[28] = asWrittenConverted[22];
        ordered[29] = asWrittenConverted[23];
        ordered[30] = asWrittenConverted[30];
        ordered[31] = asWrittenConverted[31];
        ordered[32] = asWrittenConverted[32];
        ordered[33] = asWrittenConverted[33];
        ordered[34] = asWrittenConverted[40];
        ordered[35] = asWrittenConverted[41];
        ordered[36] = asWrittenConverted[34];
        ordered[37] = asWrittenConverted[35];
        ordered[38] = asWrittenConverted[42];
        ordered[39] = asWrittenConverted[43];
        ordered[40] = asWrittenConverted[48];
        ordered[41] = asWrittenConverted[49];
        ordered[42] = asWrittenConverted[56];
        ordered[43] = asWrittenConverted[57];
        ordered[44] = asWrittenConverted[50];
        ordered[45] = asWrittenConverted[51];
        ordered[46] = asWrittenConverted[58];
        ordered[47] = asWrittenConverted[59];
        ordered[48] = asWrittenConverted[36];
        ordered[49] = asWrittenConverted[37];
        ordered[50] = asWrittenConverted[44];
        ordered[51] = asWrittenConverted[45];
        ordered[52] = asWrittenConverted[38];
        ordered[53] = asWrittenConverted[39];
        ordered[54] = asWrittenConverted[46];
        ordered[55] = asWrittenConverted[47];
        ordered[56] = asWrittenConverted[52];
        ordered[57] = asWrittenConverted[53];
        ordered[58] = asWrittenConverted[60];
        ordered[59] = asWrittenConverted[61];
        ordered[60] = asWrittenConverted[54];
        ordered[61] = asWrittenConverted[55];
        ordered[62] = asWrittenConverted[62];
        ordered[63] = asWrittenConverted[63];
        int ctr = 0;
        for (int i2 = 0; i2 < ordered.length - 1; ++i2) {
            try {
                TestEncodeDecodeGeoSpatialLiteralIVs.assertTrue((ordered[i2].compareTo((IV)ordered[i2 + 1]) < 0 ? 1 : 0) != 0);
                ++ctr;
                continue;
            }
            catch (Throwable e) {
                throw new RuntimeException("Problem with index " + i2);
            }
        }
        System.out.println("Executed " + ctr + " comparisons. All good, in z-order");
    }

    protected void zIndexOrderingMixedBase(BigdataValueFactory vf, GeoSpatialLiteralExtension<BigdataValue> litExt, URI datatype) {
        int i;
        BigdataLiteral[] asWritten = this.getGeospatialLiteralsLatLonInRange(vf, -2, 1, datatype);
        LiteralExtensionIV[] asWrittenConverted = new LiteralExtensionIV[asWritten.length];
        for (i = 0; i < asWritten.length; ++i) {
            asWrittenConverted[i] = litExt.createIV((Value)asWritten[i]);
        }
        for (i = 0; i < asWrittenConverted.length; ++i) {
            System.out.println(asWritten[i] + " -> " + asWrittenConverted[i]);
        }
        LiteralExtensionIV[] ordered = new LiteralExtensionIV[asWrittenConverted.length];
        ordered[0] = asWrittenConverted[0];
        ordered[1] = asWrittenConverted[1];
        ordered[2] = asWrittenConverted[4];
        ordered[3] = asWrittenConverted[5];
        ordered[4] = asWrittenConverted[2];
        ordered[5] = asWrittenConverted[3];
        ordered[6] = asWrittenConverted[6];
        ordered[7] = asWrittenConverted[7];
        ordered[8] = asWrittenConverted[8];
        ordered[9] = asWrittenConverted[9];
        ordered[10] = asWrittenConverted[12];
        ordered[11] = asWrittenConverted[13];
        ordered[12] = asWrittenConverted[10];
        ordered[13] = asWrittenConverted[11];
        ordered[14] = asWrittenConverted[14];
        ordered[15] = asWrittenConverted[15];
        int ctr = 0;
        for (int i2 = 0; i2 < ordered.length - 1; ++i2) {
            try {
                TestEncodeDecodeGeoSpatialLiteralIVs.assertTrue((ordered[i2].compareTo((IV)ordered[i2 + 1]) < 0 ? 1 : 0) != 0);
                ++ctr;
                continue;
            }
            catch (Throwable e) {
                throw new RuntimeException("Problem with index " + i2);
            }
        }
        System.out.println("Executed " + ctr + " comparisons. All good, in z-order");
    }

    protected final BigdataLiteral[] getDummyGeospatialLiteralsLatLon(BigdataValueFactory vf, URI datatype) {
        Double[] baseLatLong = new Double[]{-9.9999999912345E8, -8.888888834423E7, -7777777.345, -666666.0001, -55555.21329, -4444.2345, -333.232, -22.5993, -1.3533, -0.65532, -0.5332, -0.453, -0.33, -0.2, 0.0, 0.5, 0.85, 0.901, 0.9399, 0.95002, 1.13, 22.45, 333.43453, 4444.23423, 55555.32443, 666666.22323, 7777777.0, 8.8888888023E7, 9.999999992343E8};
        BigdataLiteral[] dt = new BigdataLiteral[baseLatLong.length * baseLatLong.length];
        int ctr = 0;
        for (int lat = 0; lat < baseLatLong.length; ++lat) {
            for (int lon = 0; lon < baseLatLong.length; ++lon) {
                dt[ctr++] = vf.createLiteral(baseLatLong[lat] + "#" + baseLatLong[lon], datatype);
            }
        }
        return dt;
    }

    protected final BigdataLiteral[] getDummyGeospatialLiteralsLatLonTime(BigdataValueFactory vf, URI datatype) {
        Double[] baseLatLong = new Double[]{-9.9999999912345E8, -8.888888834423E7, -7777777.345, -666666.0001, -55555.21329, -4444.2345, -333.232, -22.5993, -1.3533, -0.65532, -0.5332, -0.453, -0.33, -0.2, 0.0, 0.5, 0.85, 0.901, 0.9399, 0.95002, 1.13, 22.45, 333.43453, 4444.23423, 55555.32443, 666666.22323, 7777777.0, 8.8888888023E7, 9.999999992343E8};
        Long[] baseTime = new Long[]{-747626633L, -93939483L, -3884843L, -293939L, -54775L, -4848L, -832L, -22L, -2L, -1L, 0L, 3L, 7L, 25L, 363L, 5482L, 88482L, 959593L, 9399937L, 93994959L, 372772737L};
        BigdataLiteral[] dt = new BigdataLiteral[baseLatLong.length * baseLatLong.length * baseTime.length];
        int ctr = 0;
        for (int lat = 0; lat < baseLatLong.length; ++lat) {
            for (int lon = 0; lon < baseLatLong.length; ++lon) {
                for (int time = 0; time < baseTime.length; ++time) {
                    dt[ctr++] = vf.createLiteral(baseLatLong[lat] + "#" + baseLatLong[lon] + "#" + baseTime[time], datatype);
                }
            }
        }
        return dt;
    }

    protected final BigdataLiteral[] getGeospatialLiteralsLatLonInRange(BigdataValueFactory vf, int from, int to, URI datatype) {
        int numComponents = to - from + 1;
        BigdataLiteral[] dt = new BigdataLiteral[numComponents * numComponents];
        int ctr = 0;
        for (int y = from; y <= to; ++y) {
            for (int x = from; x <= to; ++x) {
                dt[ctr++] = vf.createLiteral(x + "#" + y, datatype);
            }
        }
        return dt;
    }

    protected GeoSpatialLiteralExtension<BigdataValue> getLatLonTimeGSLiteralExtension(BigdataValueFactory vf) {
        GeoSpatialDatatypeFieldConfiguration field1Config = new GeoSpatialDatatypeFieldConfiguration(GeoSpatialDatatypeFieldConfiguration.ValueType.DOUBLE, null, 100000L, GeoSpatialDatatypeFieldConfiguration.ServiceMapping.LATITUDE, null);
        GeoSpatialDatatypeFieldConfiguration field2Config = new GeoSpatialDatatypeFieldConfiguration(GeoSpatialDatatypeFieldConfiguration.ValueType.DOUBLE, null, 100000L, GeoSpatialDatatypeFieldConfiguration.ServiceMapping.LONGITUDE, null);
        GeoSpatialDatatypeFieldConfiguration field3Config = new GeoSpatialDatatypeFieldConfiguration(GeoSpatialDatatypeFieldConfiguration.ValueType.LONG, null, 10L, GeoSpatialDatatypeFieldConfiguration.ServiceMapping.TIME, null);
        ArrayList<GeoSpatialDatatypeFieldConfiguration> fieldConfig = new ArrayList<GeoSpatialDatatypeFieldConfiguration>();
        fieldConfig.add(field1Config);
        fieldConfig.add(field2Config);
        fieldConfig.add(field3Config);
        GeoSpatialDatatypeConfiguration config = new GeoSpatialDatatypeConfiguration("http://my.test.datatype/lat_lon_time", (IGeoSpatialLiteralSerializer)new GeoSpatialDefaultLiteralSerializer(), fieldConfig);
        return this.getGSLiteralExtension(vf, config);
    }

    protected GeoSpatialLiteralExtension<BigdataValue> getLatLonGSLiteralExtension(BigdataValueFactory vf) {
        GeoSpatialDatatypeFieldConfiguration field1Config = new GeoSpatialDatatypeFieldConfiguration(GeoSpatialDatatypeFieldConfiguration.ValueType.DOUBLE, null, 100000L, GeoSpatialDatatypeFieldConfiguration.ServiceMapping.LATITUDE, null);
        GeoSpatialDatatypeFieldConfiguration field2Config = new GeoSpatialDatatypeFieldConfiguration(GeoSpatialDatatypeFieldConfiguration.ValueType.DOUBLE, null, 100000L, GeoSpatialDatatypeFieldConfiguration.ServiceMapping.LONGITUDE, null);
        ArrayList<GeoSpatialDatatypeFieldConfiguration> fieldConfig = new ArrayList<GeoSpatialDatatypeFieldConfiguration>();
        fieldConfig.add(field1Config);
        fieldConfig.add(field2Config);
        GeoSpatialDatatypeConfiguration config = new GeoSpatialDatatypeConfiguration("http://my.test.datatype/lat_lon_as-double", (IGeoSpatialLiteralSerializer)new GeoSpatialDefaultLiteralSerializer(), fieldConfig);
        return this.getGSLiteralExtension(vf, config);
    }

    protected GeoSpatialLiteralExtension<BigdataValue> getSimpleLatLonGSLiteralExtension(BigdataValueFactory vf) {
        GeoSpatialDatatypeFieldConfiguration field1Config = new GeoSpatialDatatypeFieldConfiguration(GeoSpatialDatatypeFieldConfiguration.ValueType.LONG, null, 1L, GeoSpatialDatatypeFieldConfiguration.ServiceMapping.LATITUDE, null);
        GeoSpatialDatatypeFieldConfiguration field2Config = new GeoSpatialDatatypeFieldConfiguration(GeoSpatialDatatypeFieldConfiguration.ValueType.LONG, null, 1L, GeoSpatialDatatypeFieldConfiguration.ServiceMapping.LONGITUDE, null);
        ArrayList<GeoSpatialDatatypeFieldConfiguration> fieldConfig = new ArrayList<GeoSpatialDatatypeFieldConfiguration>();
        fieldConfig.add(field1Config);
        fieldConfig.add(field2Config);
        GeoSpatialDatatypeConfiguration config = new GeoSpatialDatatypeConfiguration("http://my.test.datatype/lat_lon_as-long", (IGeoSpatialLiteralSerializer)new GeoSpatialDefaultLiteralSerializer(), fieldConfig);
        return this.getGSLiteralExtension(vf, config);
    }

    protected GeoSpatialLiteralExtension<BigdataValue> getSimpleLatLonGSLiteralExtensionWithRange(BigdataValueFactory vf, Long min) {
        GeoSpatialDatatypeFieldConfiguration field1Config = new GeoSpatialDatatypeFieldConfiguration(GeoSpatialDatatypeFieldConfiguration.ValueType.LONG, min, 1L, GeoSpatialDatatypeFieldConfiguration.ServiceMapping.LATITUDE, null);
        GeoSpatialDatatypeFieldConfiguration field2Config = new GeoSpatialDatatypeFieldConfiguration(GeoSpatialDatatypeFieldConfiguration.ValueType.LONG, min, 1L, GeoSpatialDatatypeFieldConfiguration.ServiceMapping.LONGITUDE, null);
        ArrayList<GeoSpatialDatatypeFieldConfiguration> fieldConfig = new ArrayList<GeoSpatialDatatypeFieldConfiguration>();
        fieldConfig.add(field1Config);
        fieldConfig.add(field2Config);
        GeoSpatialDatatypeConfiguration config = new GeoSpatialDatatypeConfiguration("http://my.test.datatype/lat_lon_long_min", (IGeoSpatialLiteralSerializer)new GeoSpatialDefaultLiteralSerializer(), fieldConfig);
        return this.getGSLiteralExtension(vf, config);
    }

    protected GeoSpatialLiteralExtension<BigdataValue> getGSLiteralExtension(final BigdataValueFactory vf, GeoSpatialDatatypeConfiguration datatypeConfig) {
        return new GeoSpatialLiteralExtension(new IDatatypeURIResolver(){

            public BigdataURI resolve(URI uri) {
                BigdataURI buri = vf.createURI(uri.stringValue());
                buri.setIV(TestEncodeDecodeGeoSpatialLiteralIVs.this.newTermId(VTE.URI));
                return buri;
            }
        }, datatypeConfig);
    }

    protected void assertSemanticallyIdentical(BigdataValue x1, BigdataLiteral x2) {
        TestEncodeDecodeGeoSpatialLiteralIVs.assertTrue((boolean)(x1 instanceof BigdataLiteral));
        BigdataLiteral x1AsLiteral = (BigdataLiteral)x1;
        TestEncodeDecodeGeoSpatialLiteralIVs.assertEquals((Object)x1AsLiteral.getDatatype(), (Object)x2.getDatatype());
        String[] x1Components = x1.stringValue().split("#");
        String[] x2Components = x2.stringValue().split("#");
        TestEncodeDecodeGeoSpatialLiteralIVs.assertEquals((int)x1Components.length, (int)x2Components.length);
        for (int i = 0; i < x1Components.length; ++i) {
            BigDecimal d1i = new BigDecimal(x1Components[i]);
            BigDecimal d2i = new BigDecimal(x2Components[i]);
            TestEncodeDecodeGeoSpatialLiteralIVs.assertEquals((Object)d1i, (Object)d2i);
        }
    }
}

