/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal;

import com.bigdata.rdf.internal.AbstractEncodeDecodeKeysTestCase;
import com.bigdata.rdf.internal.ColorsEnumExtension;
import com.bigdata.rdf.internal.DTE;
import com.bigdata.rdf.internal.EpochExtension;
import com.bigdata.rdf.internal.IDatatypeURIResolver;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.VTE;
import com.bigdata.rdf.internal.XSD;
import com.bigdata.rdf.internal.impl.AbstractIV;
import com.bigdata.rdf.internal.impl.bnode.NumericBNodeIV;
import com.bigdata.rdf.internal.impl.bnode.SidIV;
import com.bigdata.rdf.internal.impl.bnode.UUIDBNodeIV;
import com.bigdata.rdf.internal.impl.extensions.DateTimeExtension;
import com.bigdata.rdf.internal.impl.extensions.DerivedNumericsExtension;
import com.bigdata.rdf.internal.impl.extensions.GeoSpatialLiteralExtension;
import com.bigdata.rdf.internal.impl.literal.LiteralExtensionIV;
import com.bigdata.rdf.internal.impl.literal.UUIDLiteralIV;
import com.bigdata.rdf.internal.impl.literal.XSDBooleanIV;
import com.bigdata.rdf.internal.impl.literal.XSDNumericIV;
import com.bigdata.rdf.internal.impl.uri.VocabURIByteIV;
import com.bigdata.rdf.internal.impl.uri.VocabURIShortIV;
import com.bigdata.rdf.lexicon.LexiconRelation;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.model.BigdataValueFactoryImpl;
import com.bigdata.rdf.model.StatementEnum;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.spo.SPO;
import com.bigdata.service.geospatial.GeoSpatialConfig;
import com.bigdata.service.geospatial.GeoSpatialDatatypeConfiguration;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Random;
import java.util.TimeZone;
import java.util.UUID;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.impl.URIImpl;

public class TestEncodeDecodeKeys
extends AbstractEncodeDecodeKeysTestCase {
    final String GEO_SPATIAL_DATATYPE = "http://www.bigdata.com/rdf/geospatial#geoSpatialLiteral";
    final URI GEO_SPATIAL_DATATYPE_URI = new URIImpl("http://www.bigdata.com/rdf/geospatial#geoSpatialLiteral");
    final String GEO_SPATIAL_DATATYPE_CONFIG = "{\"config\": { \"uri\": \"http://www.bigdata.com/rdf/geospatial#geoSpatialLiteral\", \"fields\": [ { \"valueType\": \"DOUBLE\", \"multiplier\": \"100000\", \"serviceMapping\": \"LATITUDE\" }, { \"valueType\": \"DOUBLE\", \"multiplier\": \"100000\", \"serviceMapping\": \"LONGITUDE\" }, { \"valueType\": \"LONG\", \"serviceMapping\" : \"TIME\"  } ]}}";

    public TestEncodeDecodeKeys() {
    }

    public TestEncodeDecodeKeys(String name) {
        super(name);
    }

    public void test_InlineValue() {
        for (VTE vte : VTE.values()) {
            block7: for (DTE dte : DTE.values()) {
                AbstractIV v = new AbstractIV(vte, true, false, dte){
                    private static final long serialVersionUID = 1L;

                    public boolean equals(Object o) {
                        return this == o;
                    }

                    public int byteLength() {
                        throw new UnsupportedOperationException();
                    }

                    public int hashCode() {
                        return 0;
                    }

                    public IV<?, ?> clone(boolean clearCache) {
                        throw new UnsupportedOperationException();
                    }

                    public int _compareTo(IV o) {
                        throw new UnsupportedOperationException();
                    }

                    public BigdataValue asValue(LexiconRelation lex) throws UnsupportedOperationException {
                        return null;
                    }

                    public Object getInlineValue() throws UnsupportedOperationException {
                        return null;
                    }

                    public boolean isInline() {
                        return true;
                    }

                    public boolean needsMaterialization() {
                        return false;
                    }

                    public String stringValue() {
                        throw new UnsupportedOperationException();
                    }
                };
                TestEncodeDecodeKeys.assertTrue((boolean)v.isInline());
                v.getInlineValue();
                TestEncodeDecodeKeys.assertEquals((String)("flags=" + v.flags()), (Object)vte, (Object)v.getVTE());
                TestEncodeDecodeKeys.assertEquals((Object)dte, (Object)v.getDTE());
                switch (vte) {
                    case URI: {
                        TestEncodeDecodeKeys.assertTrue((boolean)v.isURI());
                        TestEncodeDecodeKeys.assertFalse((boolean)v.isBNode());
                        TestEncodeDecodeKeys.assertFalse((boolean)v.isLiteral());
                        TestEncodeDecodeKeys.assertFalse((boolean)v.isStatement());
                        continue block7;
                    }
                    case BNODE: {
                        TestEncodeDecodeKeys.assertFalse((boolean)v.isURI());
                        TestEncodeDecodeKeys.assertTrue((boolean)v.isBNode());
                        TestEncodeDecodeKeys.assertFalse((boolean)v.isLiteral());
                        TestEncodeDecodeKeys.assertFalse((boolean)v.isStatement());
                        continue block7;
                    }
                    case LITERAL: {
                        TestEncodeDecodeKeys.assertFalse((boolean)v.isURI());
                        TestEncodeDecodeKeys.assertFalse((boolean)v.isBNode());
                        TestEncodeDecodeKeys.assertTrue((boolean)v.isLiteral());
                        TestEncodeDecodeKeys.assertFalse((boolean)v.isStatement());
                        continue block7;
                    }
                    case STATEMENT: {
                        TestEncodeDecodeKeys.assertFalse((boolean)v.isURI());
                        TestEncodeDecodeKeys.assertFalse((boolean)v.isBNode());
                        TestEncodeDecodeKeys.assertFalse((boolean)v.isLiteral());
                        TestEncodeDecodeKeys.assertTrue((boolean)v.isStatement());
                        continue block7;
                    }
                    default: {
                        TestEncodeDecodeKeys.fail((String)("vte=" + vte));
                    }
                }
            }
        }
    }

    public void test_encodeDecode_allTermIds() {
        IV[] e = new IV[]{this.newTermId(VTE.URI), this.newTermId(VTE.URI), this.newTermId(VTE.URI), this.newTermId(VTE.URI)};
        TestEncodeDecodeKeys.doEncodeDecodeTest(e);
        TestEncodeDecodeKeys.doComparatorTest(e);
    }

    public void test_encodeDecode_XSDBoolean() {
        IV[] e = new IV[]{new XSDBooleanIV(true), new XSDBooleanIV(false)};
        TestEncodeDecodeKeys.doEncodeDecodeTest(e);
        TestEncodeDecodeKeys.doComparatorTest(e);
    }

    public void test_encodeDecode_XSDByte() {
        IV[] e = new IV[]{new XSDNumericIV(-128), new XSDNumericIV(-1), new XSDNumericIV(0), new XSDNumericIV(1), new XSDNumericIV(127)};
        TestEncodeDecodeKeys.doEncodeDecodeTest(e);
        TestEncodeDecodeKeys.doComparatorTest(e);
    }

    public void test_encodeDecode_XSDShort() {
        IV[] e = new IV[]{new XSDNumericIV(-1), new XSDNumericIV(0), new XSDNumericIV(1), new XSDNumericIV(Short.MIN_VALUE), new XSDNumericIV(Short.MAX_VALUE)};
        TestEncodeDecodeKeys.doEncodeDecodeTest(e);
        TestEncodeDecodeKeys.doComparatorTest(e);
    }

    public void test_encodeDecode_XSDInt() {
        IV[] e = new IV[]{new XSDNumericIV(1), new XSDNumericIV(0), new XSDNumericIV(-1), new XSDNumericIV(Integer.MAX_VALUE), new XSDNumericIV(Integer.MIN_VALUE)};
        TestEncodeDecodeKeys.doEncodeDecodeTest(e);
        TestEncodeDecodeKeys.doComparatorTest(e);
    }

    public void test_encodeDecode_XSDLong() {
        IV[] e = new IV[]{new XSDNumericIV(1L), new XSDNumericIV(0L), new XSDNumericIV(-1L), new XSDNumericIV(Long.MIN_VALUE), new XSDNumericIV(Long.MAX_VALUE)};
        TestEncodeDecodeKeys.doEncodeDecodeTest(e);
        TestEncodeDecodeKeys.doComparatorTest(e);
    }

    public void test_encodeDecode_XSDFloat() {
        IV[] e = new IV[]{new XSDNumericIV(1.0f), new XSDNumericIV(-1.0f), new XSDNumericIV(0.0f), new XSDNumericIV(Float.MAX_VALUE), new XSDNumericIV(Float.MIN_VALUE), new XSDNumericIV(Float.MIN_NORMAL), new XSDNumericIV(Float.POSITIVE_INFINITY), new XSDNumericIV(Float.NEGATIVE_INFINITY), new XSDNumericIV(Float.NaN)};
        TestEncodeDecodeKeys.doEncodeDecodeTest(e);
        TestEncodeDecodeKeys.doComparatorTest(e);
    }

    public void test_encodeDecode_XSDDouble() {
        IV[] e = new IV[]{new XSDNumericIV(1.0), new XSDNumericIV(-1.0), new XSDNumericIV(0.0), new XSDNumericIV(Double.MAX_VALUE), new XSDNumericIV(Double.MIN_VALUE), new XSDNumericIV(Double.MIN_NORMAL), new XSDNumericIV(Double.POSITIVE_INFINITY), new XSDNumericIV(Double.NEGATIVE_INFINITY), new XSDNumericIV(Double.NaN)};
        TestEncodeDecodeKeys.doEncodeDecodeTest(e);
        TestEncodeDecodeKeys.doComparatorTest(e);
    }

    public void test_encodeDecode_UUID() {
        IV[] e = new IV[100];
        for (int i = 0; i < e.length; ++i) {
            e[i] = new UUIDLiteralIV(UUID.randomUUID());
        }
        TestEncodeDecodeKeys.doEncodeDecodeTest(e);
        TestEncodeDecodeKeys.doComparatorTest(e);
    }

    public void test_encodeDecode_BNode_UUID_ID() {
        IV[] e = new IV[100];
        for (int i = 0; i < e.length; ++i) {
            e[i] = new UUIDBNodeIV(UUID.randomUUID());
        }
        TestEncodeDecodeKeys.doEncodeDecodeTest(e);
        TestEncodeDecodeKeys.doComparatorTest(e);
    }

    public void test_encodeDecode_BNode_INT_ID() {
        IV[] e = new IV[]{new NumericBNodeIV(-1), new NumericBNodeIV(0), new NumericBNodeIV(1), new NumericBNodeIV(-52), new NumericBNodeIV(52), new NumericBNodeIV(Integer.MAX_VALUE), new NumericBNodeIV(Integer.MIN_VALUE)};
        TestEncodeDecodeKeys.doEncodeDecodeTest(e);
        TestEncodeDecodeKeys.doComparatorTest(e);
    }

    public void test_encodeDecodeEpoch() {
        final BigdataValueFactory vf = BigdataValueFactoryImpl.getInstance((String)"test");
        EpochExtension ext = new EpochExtension(new IDatatypeURIResolver(){

            public BigdataURI resolve(URI uri) {
                BigdataURI buri = vf.createURI(uri.stringValue());
                buri.setIV(TestEncodeDecodeKeys.this.newTermId(VTE.URI));
                return buri;
            }
        });
        Random r = new Random();
        IV[] e = new IV[100];
        for (int i = 0; i < e.length; ++i) {
            long v = r.nextLong();
            String s = Long.toString(v);
            LiteralImpl lit = new LiteralImpl(s, EpochExtension.EPOCH);
            LiteralExtensionIV iv = ext.createIV((Value)lit);
            if (iv == null) {
                TestEncodeDecodeKeys.fail((String)("Did not create IV: lit=" + lit));
            }
            e[i] = iv;
        }
        TestEncodeDecodeKeys.doEncodeDecodeTest(e);
        TestEncodeDecodeKeys.doComparatorTest(e);
    }

    public void test_encodeDecodeColor() {
        final BigdataValueFactory vf = BigdataValueFactoryImpl.getInstance((String)"test");
        ColorsEnumExtension ext = new ColorsEnumExtension(new IDatatypeURIResolver(){

            public BigdataURI resolve(URI uri) {
                BigdataURI buri = vf.createURI(uri.stringValue());
                buri.setIV(TestEncodeDecodeKeys.this.newTermId(VTE.URI));
                return buri;
            }
        });
        LinkedList<LiteralExtensionIV> a = new LinkedList<LiteralExtensionIV>();
        for (ColorsEnumExtension.Color c : ColorsEnumExtension.Color.values()) {
            a.add(ext.createIV((Value)new LiteralImpl(c.name(), ColorsEnumExtension.COLOR)));
        }
        IV[] e = a.toArray(new IV[0]);
        TestEncodeDecodeKeys.doEncodeDecodeTest(e);
        TestEncodeDecodeKeys.doComparatorTest(e);
    }

    public void test_encodeDecodeDateTime() throws Exception {
        final BigdataValueFactory vf = BigdataValueFactoryImpl.getInstance((String)"test");
        DatatypeFactory df = DatatypeFactory.newInstance();
        DateTimeExtension ext = new DateTimeExtension(new IDatatypeURIResolver(){

            public BigdataURI resolve(URI uri) {
                BigdataURI buri = vf.createURI(uri.stringValue());
                buri.setIV(TestEncodeDecodeKeys.this.newTermId(VTE.URI));
                return buri;
            }
        }, TimeZone.getDefault());
        BigdataLiteral[] dt = new BigdataLiteral[]{vf.createLiteral(df.newXMLGregorianCalendar("2001-10-26T21:32:52")), vf.createLiteral(df.newXMLGregorianCalendar("2001-10-26T21:32:52+02:00")), vf.createLiteral(df.newXMLGregorianCalendar("2001-10-26T19:32:52Z")), vf.createLiteral(df.newXMLGregorianCalendar("2001-10-26T19:32:52+00:00")), vf.createLiteral(df.newXMLGregorianCalendar("-2001-10-26T21:32:52")), vf.createLiteral(df.newXMLGregorianCalendar("2001-10-26T21:32:52.12679")), vf.createLiteral(df.newXMLGregorianCalendar("1901-10-26T21:32:52"))};
        IV[] e = new IV[dt.length];
        for (int i = 0; i < dt.length; ++i) {
            e[i] = ext.createIV((Value)dt[i]);
        }
        IV<?, ?>[] a = TestEncodeDecodeKeys.doEncodeDecodeTest(e);
        if (log.isInfoEnabled()) {
            for (int i = 0; i < e.length; ++i) {
                log.info((Object)("original: " + dt[i]));
                log.info((Object)("asValue : " + ext.asValue((LiteralExtensionIV)e[i], vf)));
                log.info((Object)("decoded : " + ext.asValue((LiteralExtensionIV)a[i], vf)));
                log.info((Object)"");
            }
        }
        TestEncodeDecodeKeys.doComparatorTest(e);
    }

    public void test_dateTime_preservesMillis() throws DatatypeConfigurationException {
        final BigdataValueFactory vf = BigdataValueFactoryImpl.getInstance((String)"test");
        DatatypeFactory df = DatatypeFactory.newInstance();
        DateTimeExtension ext = new DateTimeExtension(new IDatatypeURIResolver(){

            public BigdataURI resolve(URI uri) {
                BigdataURI buri = vf.createURI(uri.stringValue());
                buri.setIV(TestEncodeDecodeKeys.this.newTermId(VTE.URI));
                return buri;
            }
        }, TimeZone.getTimeZone("GMT"));
        String givenStr = "2001-10-26T21:32:52.12679";
        String expectedStr = "2001-10-26T21:32:52.126Z";
        BigdataLiteral lit = vf.createLiteral(df.newXMLGregorianCalendar("2001-10-26T21:32:52.12679"));
        TestEncodeDecodeKeys.assertEquals((String)"2001-10-26T21:32:52.12679", (String)lit.stringValue());
        LiteralExtensionIV iv = ext.createIV((Value)lit);
        BigdataLiteral lit2 = (BigdataLiteral)ext.asValue(iv, vf);
        TestEncodeDecodeKeys.assertEquals((String)"2001-10-26T21:32:52.126Z", (String)lit2.stringValue());
    }

    public void test_encodeDecodeDerivedNumerics() throws Exception {
        final BigdataValueFactory vf = BigdataValueFactoryImpl.getInstance((String)"test");
        DerivedNumericsExtension ext = new DerivedNumericsExtension(new IDatatypeURIResolver(){

            public BigdataURI resolve(URI uri) {
                BigdataURI buri = vf.createURI(uri.stringValue());
                buri.setIV(TestEncodeDecodeKeys.this.newTermId(VTE.URI));
                return buri;
            }
        });
        BigdataLiteral[] dt = new BigdataLiteral[]{vf.createLiteral("1", XSD.POSITIVE_INTEGER), vf.createLiteral("-1", XSD.NEGATIVE_INTEGER), vf.createLiteral("-1", XSD.NON_POSITIVE_INTEGER), vf.createLiteral("1", XSD.NON_NEGATIVE_INTEGER), vf.createLiteral("0", XSD.NON_POSITIVE_INTEGER), vf.createLiteral("0", XSD.NON_NEGATIVE_INTEGER)};
        IV[] e = new IV[dt.length];
        for (int i = 0; i < dt.length; ++i) {
            e[i] = ext.createIV((Value)dt[i]);
        }
        IV<?, ?>[] a = TestEncodeDecodeKeys.doEncodeDecodeTest(e);
        if (log.isInfoEnabled()) {
            for (int i = 0; i < e.length; ++i) {
                log.info((Object)("original: " + dt[i]));
                log.info((Object)("asValue : " + ext.asValue((LiteralExtensionIV)e[i], vf)));
                log.info((Object)("decoded : " + ext.asValue((LiteralExtensionIV)a[i], vf)));
                log.info((Object)"");
            }
        }
        TestEncodeDecodeKeys.doComparatorTest(e);
    }

    public void test_encodeDecodeGeoSpatialLiterals01() throws Exception {
        final BigdataValueFactory vf = BigdataValueFactoryImpl.getInstance((String)"test");
        ArrayList<String> datatypeConfigs = new ArrayList<String>();
        datatypeConfigs.add("{\"config\": { \"uri\": \"http://www.bigdata.com/rdf/geospatial#geoSpatialLiteral\", \"fields\": [ { \"valueType\": \"DOUBLE\", \"multiplier\": \"100000\", \"serviceMapping\": \"LATITUDE\" }, { \"valueType\": \"DOUBLE\", \"multiplier\": \"100000\", \"serviceMapping\": \"LONGITUDE\" }, { \"valueType\": \"LONG\", \"serviceMapping\" : \"TIME\"  } ]}}");
        GeoSpatialConfig conf = new GeoSpatialConfig(datatypeConfigs, "http://www.bigdata.com/rdf/geospatial#geoSpatialLiteral");
        GeoSpatialDatatypeConfiguration datatypeConfig = (GeoSpatialDatatypeConfiguration)conf.getDatatypeConfigs().get(0);
        GeoSpatialLiteralExtension ext = new GeoSpatialLiteralExtension(new IDatatypeURIResolver(){

            public BigdataURI resolve(URI uri) {
                BigdataURI buri = vf.createURI(uri.stringValue());
                buri.setIV(TestEncodeDecodeKeys.this.newTermId(VTE.URI));
                return buri;
            }
        }, datatypeConfig);
        BigdataLiteral[] dt = new BigdataLiteral[]{vf.createLiteral("2#2#1", this.GEO_SPATIAL_DATATYPE_URI), vf.createLiteral("3#3#1", this.GEO_SPATIAL_DATATYPE_URI), vf.createLiteral("4#4#1", this.GEO_SPATIAL_DATATYPE_URI), vf.createLiteral("5#5#1", this.GEO_SPATIAL_DATATYPE_URI), vf.createLiteral("6#6#1", this.GEO_SPATIAL_DATATYPE_URI), vf.createLiteral("7#7#1", this.GEO_SPATIAL_DATATYPE_URI)};
        IV[] e = new IV[dt.length];
        for (int i = 0; i < dt.length; ++i) {
            e[i] = ext.createIV((Value)dt[i]);
        }
        IV<?, ?>[] a = TestEncodeDecodeKeys.doEncodeDecodeTest(e);
        if (log.isInfoEnabled()) {
            for (int i = 0; i < e.length; ++i) {
                log.info((Object)("original: " + dt[i]));
                log.info((Object)("asValue : " + ext.asValue((LiteralExtensionIV)e[i], vf)));
                log.info((Object)("decoded : " + ext.asValue((LiteralExtensionIV)a[i], vf)));
                log.info((Object)"");
            }
        }
        TestEncodeDecodeKeys.doComparatorTest(e);
    }

    public void test_encodeDecodeGeoSpatialLiterals02() throws Exception {
        final BigdataValueFactory vf = BigdataValueFactoryImpl.getInstance((String)"test");
        ArrayList<String> datatypeConfigs = new ArrayList<String>();
        datatypeConfigs.add("{\"config\": { \"uri\": \"http://www.bigdata.com/rdf/geospatial#geoSpatialLiteral\", \"fields\": [ { \"valueType\": \"DOUBLE\", \"multiplier\": \"100000\", \"serviceMapping\": \"LATITUDE\" }, { \"valueType\": \"DOUBLE\", \"multiplier\": \"100000\", \"serviceMapping\": \"LONGITUDE\" }, { \"valueType\": \"LONG\", \"serviceMapping\" : \"TIME\"  } ]}}");
        GeoSpatialConfig conf = new GeoSpatialConfig(datatypeConfigs, "http://www.bigdata.com/rdf/geospatial#geoSpatialLiteral");
        GeoSpatialDatatypeConfiguration datatypeConfig = (GeoSpatialDatatypeConfiguration)conf.getDatatypeConfigs().get(0);
        GeoSpatialLiteralExtension ext = new GeoSpatialLiteralExtension(new IDatatypeURIResolver(){

            public BigdataURI resolve(URI uri) {
                BigdataURI buri = vf.createURI(uri.stringValue());
                buri.setIV(TestEncodeDecodeKeys.this.newTermId(VTE.URI));
                return buri;
            }
        }, datatypeConfig);
        BigdataLiteral[] dt = new BigdataLiteral[]{vf.createLiteral("8#8#1", this.GEO_SPATIAL_DATATYPE_URI)};
        IV[] e = new IV[dt.length];
        for (int i = 0; i < dt.length; ++i) {
            e[i] = ext.createIV((Value)dt[i]);
        }
        IV<?, ?>[] a = TestEncodeDecodeKeys.doEncodeDecodeTest(e);
        if (log.isInfoEnabled()) {
            for (int i = 0; i < e.length; ++i) {
                log.info((Object)("original: " + dt[i]));
                log.info((Object)("asValue : " + ext.asValue((LiteralExtensionIV)e[i], vf)));
                log.info((Object)("decoded : " + ext.asValue((LiteralExtensionIV)a[i], vf)));
                log.info((Object)"");
            }
        }
        TestEncodeDecodeKeys.doComparatorTest(e);
    }

    public void test_encodeDecode_sids() {
        IV<?, ?> s1 = this.newTermId(VTE.URI);
        IV<?, ?> s2 = this.newTermId(VTE.URI);
        IV<?, ?> p1 = this.newTermId(VTE.URI);
        IV<?, ?> p2 = this.newTermId(VTE.URI);
        IV<?, ?> o1 = this.newTermId(VTE.URI);
        IV<?, ?> o2 = this.newTermId(VTE.BNODE);
        IV<?, ?> o3 = this.newTermId(VTE.LITERAL);
        SPO spo1 = new SPO(s1, p1, o1, StatementEnum.Explicit);
        SPO spo2 = new SPO(s1, p1, o2, StatementEnum.Explicit);
        SPO spo3 = new SPO(s1, p1, o3, StatementEnum.Explicit);
        SPO spo4 = new SPO(s1, p2, o1, StatementEnum.Explicit);
        SPO spo5 = new SPO(s1, p2, o2, StatementEnum.Explicit);
        SPO spo6 = new SPO(s1, p2, o3, StatementEnum.Explicit);
        SPO spo7 = new SPO(s2, p1, o1, StatementEnum.Explicit);
        SPO spo8 = new SPO(s2, p1, o2, StatementEnum.Explicit);
        SPO spo9 = new SPO(s2, p1, o3, StatementEnum.Explicit);
        SPO spo10 = new SPO(s2, p2, o1, StatementEnum.Explicit);
        SPO spo11 = new SPO(s2, p2, o2, StatementEnum.Explicit);
        SPO spo12 = new SPO(s2, p2, o3, StatementEnum.Explicit);
        SPO spo13 = new SPO(spo1.getStatementIdentifier(), p1, o1, StatementEnum.Explicit);
        SPO spo14 = new SPO(spo2.getStatementIdentifier(), p2, o2, StatementEnum.Explicit);
        SPO spo15 = new SPO(s1, p1, spo3.getStatementIdentifier(), StatementEnum.Explicit);
        SPO spo16 = new SPO(s1, p1, spo6.getStatementIdentifier(), StatementEnum.Explicit);
        SPO spo17 = new SPO(spo1.getStatementIdentifier(), p1, spo15.getStatementIdentifier(), StatementEnum.Explicit);
        IV[] e = new IV[]{new SidIV((ISPO)spo1), new SidIV((ISPO)spo2), new SidIV((ISPO)spo3), new SidIV((ISPO)spo4), new SidIV((ISPO)spo5), new SidIV((ISPO)spo6), new SidIV((ISPO)spo7), new SidIV((ISPO)spo8), new SidIV((ISPO)spo9), new SidIV((ISPO)spo10), new SidIV((ISPO)spo11), new SidIV((ISPO)spo12), new SidIV((ISPO)spo13), new SidIV((ISPO)spo14), new SidIV((ISPO)spo15), new SidIV((ISPO)spo16), new SidIV((ISPO)spo17)};
        TestEncodeDecodeKeys.doEncodeDecodeTest(e);
        TestEncodeDecodeKeys.doComparatorTest(e);
    }

    public void test_encodeDecode_URIByteIV() {
        IV[] e = new IV[]{new VocabURIByteIV(-128), new VocabURIByteIV(-1), new VocabURIByteIV(0), new VocabURIByteIV(1), new VocabURIByteIV(127)};
        TestEncodeDecodeKeys.doEncodeDecodeTest(e);
        TestEncodeDecodeKeys.doComparatorTest(e);
    }

    public void test_encodeDecode_URIShortIV() {
        IV[] e = new IV[]{new VocabURIShortIV(Short.MIN_VALUE), new VocabURIShortIV(-1), new VocabURIShortIV(0), new VocabURIShortIV(1), new VocabURIShortIV(Short.MAX_VALUE)};
        TestEncodeDecodeKeys.doEncodeDecodeTest(e);
        TestEncodeDecodeKeys.doComparatorTest(e);
    }
}

