/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal;

import com.bigdata.btree.keys.IKeyBuilder;
import com.bigdata.btree.keys.KeyBuilder;
import com.bigdata.rdf.internal.AbstractEncodeDecodeMixedIVsTest;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.InlineLiteralIV;
import com.bigdata.rdf.internal.impl.literal.AbstractLiteralIV;
import com.bigdata.rdf.internal.impl.literal.LiteralArrayIV;
import com.bigdata.rdf.internal.impl.literal.LiteralExtensionIV;
import com.bigdata.rdf.internal.impl.uri.URIExtensionIV;
import com.bigdata.rdf.internal.impl.uri.VocabURIByteIV;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.junit.Test;

public class TestEncodeDecodeLiteralArrayIVs
extends AbstractEncodeDecodeMixedIVsTest {
    private static final transient Logger log = Logger.getLogger(TestEncodeDecodeLiteralArrayIVs.class);

    public TestEncodeDecodeLiteralArrayIVs() {
    }

    public TestEncodeDecodeLiteralArrayIVs(String name) {
        super(name);
    }

    @Test
    public void testRoundTripLiteralArrayIV() throws Exception {
        List<IV<?, ?>> mixed = super.prepareIVs();
        LinkedList<LiteralArrayIV> arrays = new LinkedList<LiteralArrayIV>();
        int n = 10;
        InlineLiteralIV[] inlines = new InlineLiteralIV[10];
        int i = 0;
        for (IV<?, ?> iv : mixed) {
            if (!(iv instanceof InlineLiteralIV)) continue;
            inlines[i++] = (InlineLiteralIV)iv;
            if (i != 10) continue;
            arrays.add(new LiteralArrayIV(inlines));
            inlines = new InlineLiteralIV[10];
            i = 0;
        }
        if (i > 0) {
            InlineLiteralIV[] tmp = new InlineLiteralIV[i];
            System.arraycopy(inlines, 0, tmp, 0, i);
            arrays.add(new LiteralArrayIV(tmp));
        }
        AbstractLiteralIV[] ivs = arrays.toArray(new AbstractLiteralIV[arrays.size()]);
        byte vocab = 1;
        LiteralExtensionIV[] lits = new LiteralExtensionIV[ivs.length];
        for (int i2 = 0; i2 < ivs.length; ++i2) {
            byte by = vocab;
            vocab = (byte)(vocab + 1);
            lits[i2] = new LiteralExtensionIV(ivs[i2], (IV)new VocabURIByteIV(by));
        }
        URIExtensionIV[] uris = new URIExtensionIV[ivs.length];
        for (int i3 = 0; i3 < ivs.length; ++i3) {
            byte by = vocab;
            vocab = (byte)(vocab + 1);
            uris[i3] = new URIExtensionIV(ivs[i3], (IV)new VocabURIByteIV(by));
        }
        TestEncodeDecodeLiteralArrayIVs.doEncodeDecodeTest(ivs);
        TestEncodeDecodeLiteralArrayIVs.doEncodeDecodeTest(lits);
        TestEncodeDecodeLiteralArrayIVs.doEncodeDecodeTest(uris);
        LiteralArrayIV arrayOfArrays = new LiteralArrayIV((InlineLiteralIV[])ivs);
        TestEncodeDecodeLiteralArrayIVs.doEncodeDecodeTest(new IV[]{arrayOfArrays});
    }

    public void testRoundTripAsByte() {
        this.testRoundTripAsByte(1);
        this.testRoundTripAsByte(10);
        this.testRoundTripAsByte(200);
        this.testRoundTripAsByte(256);
        this.testRoundTripAsByte(-1);
        this.testRoundTripAsByte(0);
        this.testRoundTripAsByte(257);
    }

    private void testRoundTripAsByte(int i) {
        IKeyBuilder keyBuilder = KeyBuilder.newInstance();
        byte len = (byte)(i - 1);
        keyBuilder.append(len);
        byte[] key = keyBuilder.getKey();
        TestEncodeDecodeLiteralArrayIVs.assertEquals((int)1, (int)key.length);
        int n = (key[0] & 0xFF) + 1;
        if (i >= 1 && i <= 256) {
            TestEncodeDecodeLiteralArrayIVs.assertEquals((int)i, (int)n);
        } else {
            TestEncodeDecodeLiteralArrayIVs.assertFalse((i == n ? 1 : 0) != 0);
        }
    }
}

