/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal;

import com.bigdata.rdf.internal.AbstractEncodeDecodeKeysTestCase;
import com.bigdata.rdf.internal.IDatatypeURIResolver;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.VTE;
import com.bigdata.rdf.internal.impl.extensions.CompressedTimestampExtension;
import com.bigdata.rdf.internal.impl.literal.AbstractLiteralIV;
import com.bigdata.rdf.internal.impl.literal.LiteralExtensionIV;
import com.bigdata.rdf.internal.impl.literal.PackedLongIV;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.model.BigdataValueFactoryImpl;
import java.util.UUID;
import org.openrdf.model.URI;
import org.openrdf.model.Value;

public class TestEncodeDecodePackedLongIVs
extends AbstractEncodeDecodeKeysTestCase {
    public TestEncodeDecodePackedLongIVs() {
    }

    public TestEncodeDecodePackedLongIVs(String name) {
        super(name);
    }

    public void testRoundTripAndComparePackedLongIV() throws Exception {
        AbstractLiteralIV[] ivs = new AbstractLiteralIV[]{new PackedLongIV("0"), new PackedLongIV("100"), new PackedLongIV("101"), new PackedLongIV("103"), new PackedLongIV("1000"), new PackedLongIV("1010"), new PackedLongIV("1011"), new PackedLongIV("1012"), new PackedLongIV("1013"), new PackedLongIV("1014"), new PackedLongIV("1015"), new PackedLongIV("1016"), new PackedLongIV("1017"), new PackedLongIV("1018"), new PackedLongIV("1019"), new PackedLongIV("1020"), new PackedLongIV("1021"), new PackedLongIV("1022"), new PackedLongIV("1023"), new PackedLongIV("1024"), new PackedLongIV("1025"), new PackedLongIV("1026"), new PackedLongIV("10000"), new PackedLongIV("10010"), new PackedLongIV("10100"), new PackedLongIV("11000"), new PackedLongIV("10000"), new PackedLongIV("100001"), new PackedLongIV("1000000"), new PackedLongIV("10000000"), new PackedLongIV("1446203550"), new PackedLongIV("1446203560"), new PackedLongIV("1446203570"), new PackedLongIV("1446203580"), new PackedLongIV("1446203590"), new PackedLongIV("1446203600"), new PackedLongIV("1448881949"), new PackedLongIV("1480504349"), new PackedLongIV("2553419549"), new PackedLongIV("2869038749"), new PackedLongIV("3500190749"), new PackedLongIV("4131256349"), new PackedLongIV("7286929949"), new PackedLongIV("16754037149"), new PackedLongIV("32532491549"), new PackedLongIV("127203390749"), new PackedLongIV("253399576349")};
        TestEncodeDecodePackedLongIVs.doEncodeDecodeTest(ivs);
        TestEncodeDecodePackedLongIVs.doComparatorTest(ivs);
    }

    public void testRoundTripAndCompareCompressedTimestamp() throws Exception {
        int i;
        final BigdataValueFactory vf = BigdataValueFactoryImpl.getInstance((String)(this.getName() + UUID.randomUUID()));
        CompressedTimestampExtension ext = new CompressedTimestampExtension(new IDatatypeURIResolver(){

            public BigdataURI resolve(URI uri) {
                BigdataURI buri = vf.createURI(uri.stringValue());
                buri.setIV(TestEncodeDecodePackedLongIVs.this.newTermId(VTE.URI));
                return buri;
            }
        });
        BigdataLiteral[] dt = new BigdataLiteral[]{vf.createLiteral("0", CompressedTimestampExtension.COMPRESSED_TIMESTAMP), vf.createLiteral("100", CompressedTimestampExtension.COMPRESSED_TIMESTAMP), vf.createLiteral("101", CompressedTimestampExtension.COMPRESSED_TIMESTAMP), vf.createLiteral("103", CompressedTimestampExtension.COMPRESSED_TIMESTAMP), vf.createLiteral("1000", CompressedTimestampExtension.COMPRESSED_TIMESTAMP), vf.createLiteral("1010", CompressedTimestampExtension.COMPRESSED_TIMESTAMP), vf.createLiteral("1011", CompressedTimestampExtension.COMPRESSED_TIMESTAMP), vf.createLiteral("1012", CompressedTimestampExtension.COMPRESSED_TIMESTAMP), vf.createLiteral("1013", CompressedTimestampExtension.COMPRESSED_TIMESTAMP), vf.createLiteral("1014", CompressedTimestampExtension.COMPRESSED_TIMESTAMP), vf.createLiteral("1015", CompressedTimestampExtension.COMPRESSED_TIMESTAMP), vf.createLiteral("1016", CompressedTimestampExtension.COMPRESSED_TIMESTAMP), vf.createLiteral("1017", CompressedTimestampExtension.COMPRESSED_TIMESTAMP), vf.createLiteral("1018", CompressedTimestampExtension.COMPRESSED_TIMESTAMP), vf.createLiteral("1019", CompressedTimestampExtension.COMPRESSED_TIMESTAMP), vf.createLiteral("1020", CompressedTimestampExtension.COMPRESSED_TIMESTAMP), vf.createLiteral("1021", CompressedTimestampExtension.COMPRESSED_TIMESTAMP), vf.createLiteral("1022", CompressedTimestampExtension.COMPRESSED_TIMESTAMP), vf.createLiteral("1023", CompressedTimestampExtension.COMPRESSED_TIMESTAMP), vf.createLiteral("1024", CompressedTimestampExtension.COMPRESSED_TIMESTAMP), vf.createLiteral("1025", CompressedTimestampExtension.COMPRESSED_TIMESTAMP), vf.createLiteral("1026", CompressedTimestampExtension.COMPRESSED_TIMESTAMP), vf.createLiteral("10000", CompressedTimestampExtension.COMPRESSED_TIMESTAMP), vf.createLiteral("10010", CompressedTimestampExtension.COMPRESSED_TIMESTAMP), vf.createLiteral("10100", CompressedTimestampExtension.COMPRESSED_TIMESTAMP), vf.createLiteral("11000", CompressedTimestampExtension.COMPRESSED_TIMESTAMP), vf.createLiteral("100000", CompressedTimestampExtension.COMPRESSED_TIMESTAMP), vf.createLiteral("100001", CompressedTimestampExtension.COMPRESSED_TIMESTAMP), vf.createLiteral("1000000", CompressedTimestampExtension.COMPRESSED_TIMESTAMP), vf.createLiteral("10000000", CompressedTimestampExtension.COMPRESSED_TIMESTAMP), vf.createLiteral("1446203550", CompressedTimestampExtension.COMPRESSED_TIMESTAMP), vf.createLiteral("1446203560", CompressedTimestampExtension.COMPRESSED_TIMESTAMP), vf.createLiteral("1446203570", CompressedTimestampExtension.COMPRESSED_TIMESTAMP), vf.createLiteral("1446203580", CompressedTimestampExtension.COMPRESSED_TIMESTAMP), vf.createLiteral("1446203590", CompressedTimestampExtension.COMPRESSED_TIMESTAMP), vf.createLiteral("1446203600", CompressedTimestampExtension.COMPRESSED_TIMESTAMP), vf.createLiteral("1448881949", CompressedTimestampExtension.COMPRESSED_TIMESTAMP), vf.createLiteral("1480504349", CompressedTimestampExtension.COMPRESSED_TIMESTAMP), vf.createLiteral("2553419549", CompressedTimestampExtension.COMPRESSED_TIMESTAMP), vf.createLiteral("2869038749", CompressedTimestampExtension.COMPRESSED_TIMESTAMP), vf.createLiteral("3500190749", CompressedTimestampExtension.COMPRESSED_TIMESTAMP), vf.createLiteral("4131256349", CompressedTimestampExtension.COMPRESSED_TIMESTAMP), vf.createLiteral("7286929949", CompressedTimestampExtension.COMPRESSED_TIMESTAMP), vf.createLiteral("16754037149", CompressedTimestampExtension.COMPRESSED_TIMESTAMP), vf.createLiteral("32532491549", CompressedTimestampExtension.COMPRESSED_TIMESTAMP), vf.createLiteral("127203390749", CompressedTimestampExtension.COMPRESSED_TIMESTAMP), vf.createLiteral("253399576349", CompressedTimestampExtension.COMPRESSED_TIMESTAMP)};
        IV[] e = new IV[dt.length];
        for (i = 0; i < dt.length; ++i) {
            e[i] = ext.createIV((Value)dt[i]);
        }
        for (i = 0; i < e.length; ++i) {
            BigdataValue val = ext.asValue((LiteralExtensionIV)e[i], vf);
            if (!log.isInfoEnabled()) continue;
            log.info((Object)val);
        }
        TestEncodeDecodePackedLongIVs.doEncodeDecodeTest(e);
        TestEncodeDecodePackedLongIVs.doComparatorTest(e);
    }

    public void testPackedLongIVOutOfRange() {
        boolean failsLower = false;
        try {
            new PackedLongIV("-1");
        }
        catch (Exception e) {
            failsLower = true;
        }
        TestEncodeDecodePackedLongIVs.assertTrue((boolean)failsLower);
        new PackedLongIV("0");
        new PackedLongIV("72057594037927935");
        boolean failsUpper = false;
        try {
            new PackedLongIV("72057594037927936");
        }
        catch (Exception e) {
            failsUpper = true;
        }
        TestEncodeDecodePackedLongIVs.assertTrue((boolean)failsUpper);
    }
}

