/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal;

import com.bigdata.rdf.internal.AbstractEncodeDecodeKeysTestCase;
import com.bigdata.rdf.internal.IDatatypeURIResolver;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.VTE;
import com.bigdata.rdf.internal.XSD;
import com.bigdata.rdf.internal.impl.bnode.FullyInlineUnicodeBNodeIV;
import com.bigdata.rdf.internal.impl.extensions.XSDStringExtension;
import com.bigdata.rdf.internal.impl.literal.AbstractLiteralIV;
import com.bigdata.rdf.internal.impl.literal.FullyInlineTypedLiteralIV;
import com.bigdata.rdf.internal.impl.literal.PartlyInlineTypedLiteralIV;
import com.bigdata.rdf.internal.impl.uri.FullyInlineURIIV;
import com.bigdata.rdf.internal.impl.uri.PartlyInlineURIIV;
import com.bigdata.rdf.internal.impl.uri.URIExtensionIV;
import com.bigdata.rdf.internal.impl.uri.VocabURIByteIV;
import com.bigdata.rdf.internal.impl.uri.VocabURIShortIV;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.model.BigdataValueFactoryImpl;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.RDF;

public class TestEncodeDecodeUnicodeIVs
extends AbstractEncodeDecodeKeysTestCase {
    public TestEncodeDecodeUnicodeIVs() {
    }

    public TestEncodeDecodeUnicodeIVs(String name) {
        super(name);
    }

    public void test_encodeDecode_extension_xsdString() {
        final BigdataValueFactory vf = BigdataValueFactoryImpl.getInstance((String)"test");
        int maxInlineStringLength = 128;
        XSDStringExtension ext = new XSDStringExtension(new IDatatypeURIResolver(){

            public BigdataURI resolve(URI uri) {
                BigdataURI buri = vf.createURI(uri.stringValue());
                buri.setIV(TestEncodeDecodeUnicodeIVs.this.newTermId(VTE.URI));
                return buri;
            }
        }, 128);
        IV[] e = new IV[]{ext.createIV((Value)new LiteralImpl("", XSD.STRING)), ext.createIV((Value)new LiteralImpl(" ", XSD.STRING)), ext.createIV((Value)new LiteralImpl("  ", XSD.STRING)), ext.createIV((Value)new LiteralImpl("1", XSD.STRING)), ext.createIV((Value)new LiteralImpl("12", XSD.STRING)), ext.createIV((Value)new LiteralImpl("123", XSD.STRING)), ext.createIV((Value)new LiteralImpl("234", XSD.STRING)), ext.createIV((Value)new LiteralImpl("34", XSD.STRING)), ext.createIV((Value)new LiteralImpl("4", XSD.STRING)), ext.createIV((Value)new LiteralImpl("a", XSD.STRING)), ext.createIV((Value)new LiteralImpl("ab", XSD.STRING)), ext.createIV((Value)new LiteralImpl("abc", XSD.STRING))};
        TestEncodeDecodeUnicodeIVs.doEncodeDecodeTest(e);
        TestEncodeDecodeUnicodeIVs.doComparatorTest(e);
    }

    public void test_encodeDecode_Inline_URI() {
        IV[] e = new IV[]{new FullyInlineURIIV((URI)new URIImpl("http://www.bigdata.com")), new FullyInlineURIIV(RDF.TYPE), new FullyInlineURIIV(RDF.SUBJECT), new FullyInlineURIIV(RDF.BAG), new FullyInlineURIIV(RDF.OBJECT)};
        TestEncodeDecodeUnicodeIVs.doEncodeDecodeTest(e);
        TestEncodeDecodeUnicodeIVs.doComparatorTest(e);
    }

    public void test_encodeDecode_Inline_Extension_URI() {
        IV[] e = new IV[]{new URIExtensionIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV("http://www.example.com/"), (IV)new VocabURIByteIV(1)), new URIExtensionIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV("http://www.example.com/foo"), (IV)new VocabURIByteIV(1)), new URIExtensionIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV("http://www.example.com/foobar"), (IV)new VocabURIByteIV(1))};
        TestEncodeDecodeUnicodeIVs.doEncodeDecodeTest(e);
        TestEncodeDecodeUnicodeIVs.doComparatorTest(e);
    }

    public void test_encodeDecode_Inline_BNode_UnicodeID() {
        IV[] e = new IV[]{new FullyInlineUnicodeBNodeIV("FOO"), new FullyInlineUnicodeBNodeIV("_bar"), new FullyInlineUnicodeBNodeIV("bar"), new FullyInlineUnicodeBNodeIV("baz"), new FullyInlineUnicodeBNodeIV("12"), new FullyInlineUnicodeBNodeIV("1298"), new FullyInlineUnicodeBNodeIV("asassdao"), new FullyInlineUnicodeBNodeIV("1")};
        TestEncodeDecodeUnicodeIVs.doEncodeDecodeTest(e);
        TestEncodeDecodeUnicodeIVs.doComparatorTest(e);
    }

    public void test_encodeDecode_Inline_Literal_plainLiteral() {
        IV[] e = new IV[]{new FullyInlineTypedLiteralIV("foo", null, null), new FullyInlineTypedLiteralIV("bar", null, null), new FullyInlineTypedLiteralIV("baz", null, null), new FullyInlineTypedLiteralIV("123", null, null), new FullyInlineTypedLiteralIV("23", null, null), new FullyInlineTypedLiteralIV("3", null, null), new FullyInlineTypedLiteralIV("", null, null)};
        TestEncodeDecodeUnicodeIVs.doEncodeDecodeTest(e);
        TestEncodeDecodeUnicodeIVs.doComparatorTest(e);
    }

    public void test_encodeDecode_Inline_Literal_languageCodeLiteral() {
        IV[] e = new IV[]{new FullyInlineTypedLiteralIV("foo", "en", null), new FullyInlineTypedLiteralIV("bar", "en", null), new FullyInlineTypedLiteralIV("goo", "en", null), new FullyInlineTypedLiteralIV("baz", "en", null), new FullyInlineTypedLiteralIV("foo", "de", null), new FullyInlineTypedLiteralIV("bar", "de", null), new FullyInlineTypedLiteralIV("goo", "de", null), new FullyInlineTypedLiteralIV("baz", "de", null), new FullyInlineTypedLiteralIV("", "en", null), new FullyInlineTypedLiteralIV("", "de", null), new FullyInlineTypedLiteralIV("1", "en", null), new FullyInlineTypedLiteralIV("1", "de", null), new FullyInlineTypedLiteralIV("12", "en", null), new FullyInlineTypedLiteralIV("12", "de", null), new FullyInlineTypedLiteralIV("2", "en", null), new FullyInlineTypedLiteralIV("2", "de", null), new FullyInlineTypedLiteralIV("23", "en", null), new FullyInlineTypedLiteralIV("23", "de", null), new FullyInlineTypedLiteralIV("123", "en", null), new FullyInlineTypedLiteralIV("123", "de", null), new FullyInlineTypedLiteralIV("3", "en", null), new FullyInlineTypedLiteralIV("3", "de", null)};
        TestEncodeDecodeUnicodeIVs.doEncodeDecodeTest(e);
        TestEncodeDecodeUnicodeIVs.doComparatorTest(e);
    }

    public void test_encodeDecode_Inline_Literal_datatypeLiteral() {
        URIImpl dt1 = new URIImpl("http://www.bigdata.com/mock-datatype-1");
        URIImpl dt2 = new URIImpl("http://www.bigdata.com/mock-datatype-2");
        IV[] e = new IV[]{new FullyInlineTypedLiteralIV("foo", null, (URI)dt1), new FullyInlineTypedLiteralIV("bar", null, (URI)dt1), new FullyInlineTypedLiteralIV("baz", null, (URI)dt1), new FullyInlineTypedLiteralIV("goo", null, (URI)dt1), new FullyInlineTypedLiteralIV("foo", null, (URI)dt2), new FullyInlineTypedLiteralIV("bar", null, (URI)dt2), new FullyInlineTypedLiteralIV("baz", null, (URI)dt2), new FullyInlineTypedLiteralIV("goo", null, (URI)dt2), new FullyInlineTypedLiteralIV("", null, (URI)dt2), new FullyInlineTypedLiteralIV("", null, (URI)dt2), new FullyInlineTypedLiteralIV("1", null, (URI)dt2), new FullyInlineTypedLiteralIV("1", null, (URI)dt2), new FullyInlineTypedLiteralIV("12", null, (URI)dt2), new FullyInlineTypedLiteralIV("12", null, (URI)dt2), new FullyInlineTypedLiteralIV("123", null, (URI)dt2), new FullyInlineTypedLiteralIV("123", null, (URI)dt2), new FullyInlineTypedLiteralIV("23", null, (URI)dt2), new FullyInlineTypedLiteralIV("23", null, (URI)dt2), new FullyInlineTypedLiteralIV("3", null, (URI)dt2), new FullyInlineTypedLiteralIV("3", null, (URI)dt2)};
        TestEncodeDecodeUnicodeIVs.doEncodeDecodeTest(e);
        TestEncodeDecodeUnicodeIVs.doComparatorTest(e);
    }

    public void test_encodeDecode_Inline_Literals_All_Types() {
        URIImpl dt1 = new URIImpl("http://www.bigdata.com/mock-datatype-1");
        URIImpl dt2 = new URIImpl("http://www.bigdata.com/mock-datatype-2");
        IV[] e = new IV[]{new FullyInlineTypedLiteralIV("foo", null, null), new FullyInlineTypedLiteralIV("bar", null, null), new FullyInlineTypedLiteralIV("baz", null, null), new FullyInlineTypedLiteralIV("123", null, null), new FullyInlineTypedLiteralIV("23", null, null), new FullyInlineTypedLiteralIV("3", null, null), new FullyInlineTypedLiteralIV("foo", "en", null), new FullyInlineTypedLiteralIV("bar", "en", null), new FullyInlineTypedLiteralIV("goo", "en", null), new FullyInlineTypedLiteralIV("baz", "en", null), new FullyInlineTypedLiteralIV("foo", "de", null), new FullyInlineTypedLiteralIV("bar", "de", null), new FullyInlineTypedLiteralIV("goo", "de", null), new FullyInlineTypedLiteralIV("baz", "de", null), new FullyInlineTypedLiteralIV("foo", null, (URI)dt1), new FullyInlineTypedLiteralIV("bar", null, (URI)dt1), new FullyInlineTypedLiteralIV("baz", null, (URI)dt1), new FullyInlineTypedLiteralIV("goo", null, (URI)dt1), new FullyInlineTypedLiteralIV("foo", null, (URI)dt2), new FullyInlineTypedLiteralIV("bar", null, (URI)dt2), new FullyInlineTypedLiteralIV("baz", null, (URI)dt2), new FullyInlineTypedLiteralIV("goo", null, (URI)dt2)};
        TestEncodeDecodeUnicodeIVs.doEncodeDecodeTest(e);
        TestEncodeDecodeUnicodeIVs.doComparatorTest(e);
    }

    public void test_encodeDecode_Inline_Literal_XSDString_DeconflictionTest() {
        IV[] e = new IV[]{new FullyInlineTypedLiteralIV("foo", null, XSD.STRING), new FullyInlineTypedLiteralIV("bar", null, XSD.STRING), new FullyInlineTypedLiteralIV("baz", null, XSD.STRING)};
        TestEncodeDecodeUnicodeIVs.doEncodeDecodeTest(e);
        TestEncodeDecodeUnicodeIVs.doComparatorTest(e);
    }

    public void test_encodeDecode_NonInline_URI_with_NamespaceIV() {
        IV<?, ?> namespaceIV = this.newTermId(VTE.URI);
        IV[] e = new IV[]{new PartlyInlineURIIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV("bar"), namespaceIV), new PartlyInlineURIIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV("baz"), namespaceIV), new PartlyInlineURIIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV("123"), namespaceIV), new PartlyInlineURIIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV("23"), namespaceIV), new PartlyInlineURIIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV("3"), namespaceIV)};
        TestEncodeDecodeUnicodeIVs.doEncodeDecodeTest(e);
        TestEncodeDecodeUnicodeIVs.doComparatorTest(e);
    }

    public void test_encodeDecode_NonInline_Literal_with_DatatypeIV() {
        IV<?, ?> datatypeIV = this.newTermId(VTE.URI);
        IV<?, ?> datatypeIV2 = this.newTermId(VTE.URI);
        IV[] e = new IV[]{new PartlyInlineTypedLiteralIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV(""), datatypeIV), new PartlyInlineTypedLiteralIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV(" "), datatypeIV2), new PartlyInlineTypedLiteralIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV("1"), datatypeIV), new PartlyInlineTypedLiteralIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV("1"), datatypeIV2), new PartlyInlineTypedLiteralIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV("12"), datatypeIV), new PartlyInlineTypedLiteralIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV("12"), datatypeIV2), new PartlyInlineTypedLiteralIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV("123"), datatypeIV), new PartlyInlineTypedLiteralIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV("123"), datatypeIV2), new PartlyInlineTypedLiteralIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV("23"), datatypeIV), new PartlyInlineTypedLiteralIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV("23"), datatypeIV2), new PartlyInlineTypedLiteralIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV("3"), datatypeIV), new PartlyInlineTypedLiteralIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV("3"), datatypeIV2), new PartlyInlineTypedLiteralIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV("bar"), datatypeIV), new PartlyInlineTypedLiteralIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV("baz"), datatypeIV), new PartlyInlineTypedLiteralIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV("bar"), datatypeIV2), new PartlyInlineTypedLiteralIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV("baz"), datatypeIV2)};
        TestEncodeDecodeUnicodeIVs.doEncodeDecodeTest(e);
        TestEncodeDecodeUnicodeIVs.doComparatorTest(e);
    }

    public void test_encodeDecode_URINamespaceIV() {
        IV[] e = new IV[]{new PartlyInlineURIIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV("bar"), (IV)new VocabURIShortIV(1)), new PartlyInlineURIIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV("baz"), (IV)new VocabURIShortIV(1)), new PartlyInlineURIIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV("bar"), (IV)new VocabURIShortIV(2)), new PartlyInlineURIIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV("baz"), (IV)new VocabURIShortIV(2)), new PartlyInlineURIIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV("123"), (IV)new VocabURIShortIV(2)), new PartlyInlineURIIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV("123"), (IV)new VocabURIShortIV(2)), new PartlyInlineURIIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV("23"), (IV)new VocabURIShortIV(2)), new PartlyInlineURIIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV("23"), (IV)new VocabURIShortIV(2)), new PartlyInlineURIIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV("3"), (IV)new VocabURIShortIV(2)), new PartlyInlineURIIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV("3"), (IV)new VocabURIShortIV(2))};
        TestEncodeDecodeUnicodeIVs.doEncodeDecodeTest(e);
        TestEncodeDecodeUnicodeIVs.doComparatorTest(e);
    }

    public void test_encodeDecode_LiteralNamespaceIV() {
        VocabURIShortIV datatypeIV = new VocabURIShortIV(1);
        VocabURIShortIV datatypeIV2 = new VocabURIShortIV(2);
        IV[] e = new IV[]{new PartlyInlineTypedLiteralIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV("bar"), (IV)datatypeIV), new PartlyInlineTypedLiteralIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV("bar"), (IV)datatypeIV2), new PartlyInlineTypedLiteralIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV("baz"), (IV)datatypeIV), new PartlyInlineTypedLiteralIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV("baz"), (IV)datatypeIV2), new PartlyInlineTypedLiteralIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV("123"), (IV)datatypeIV), new PartlyInlineTypedLiteralIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV("123"), (IV)datatypeIV2), new PartlyInlineTypedLiteralIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV("23"), (IV)datatypeIV), new PartlyInlineTypedLiteralIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV("23"), (IV)datatypeIV2), new PartlyInlineTypedLiteralIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV("3"), (IV)datatypeIV), new PartlyInlineTypedLiteralIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV("3"), (IV)datatypeIV2)};
        TestEncodeDecodeUnicodeIVs.doEncodeDecodeTest(e);
        TestEncodeDecodeUnicodeIVs.doComparatorTest(e);
    }
}

