/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal;

import com.bigdata.rdf.internal.AbstractEncodeDecodeKeysTestCase;
import com.bigdata.rdf.internal.IDatatypeURIResolver;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.VTE;
import com.bigdata.rdf.internal.XSD;
import com.bigdata.rdf.internal.impl.extensions.DateTimeExtension;
import com.bigdata.rdf.internal.impl.literal.LiteralExtensionIV;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.model.BigdataValueFactoryImpl;
import java.util.TimeZone;
import org.openrdf.model.URI;
import org.openrdf.model.Value;

public class TestEncodeDecodeXSDDateIVs
extends AbstractEncodeDecodeKeysTestCase {
    public TestEncodeDecodeXSDDateIVs() {
    }

    public TestEncodeDecodeXSDDateIVs(String name) {
        super(name);
    }

    public void test_encodeDecodeDateLiterals() throws Exception {
        int i;
        BigdataValueFactory vf = BigdataValueFactoryImpl.getInstance((String)"test");
        DateTimeExtension<BigdataValue> ext = this.getDateTimeExtensionGMT(vf);
        BigdataLiteral[] dt = new BigdataLiteral[]{vf.createLiteral("-2015-01-01", XSD.DATE), vf.createLiteral("-2015-12-31", XSD.DATE), vf.createLiteral("9999-01-01", XSD.DATE), vf.createLiteral("9999-12-31", XSD.DATE)};
        IV[] e = new IV[dt.length];
        for (i = 0; i < dt.length; ++i) {
            e[i] = ext.createIV((Value)dt[i]);
        }
        for (i = 0; i < e.length; ++i) {
            BigdataValue valRoundTrip = ext.asValue((LiteralExtensionIV)e[i], vf);
            TestEncodeDecodeXSDDateIVs.assertEquals((Object)valRoundTrip, (Object)dt[i]);
        }
        IV<?, ?>[] a = TestEncodeDecodeXSDDateIVs.doEncodeDecodeTest(e);
        TestEncodeDecodeXSDDateIVs.doComparatorTest(e);
    }

    public void test_encodeDecodeGDay() throws Exception {
        int i;
        BigdataValueFactory vf = BigdataValueFactoryImpl.getInstance((String)"test");
        DateTimeExtension<BigdataValue> ext = this.getDateTimeExtensionGMT(vf);
        BigdataLiteral[] dt = new BigdataLiteral[]{vf.createLiteral("-2015-01-01", XSD.GDAY), vf.createLiteral("-2015-12-31", XSD.GDAY), vf.createLiteral("9999-01-01", XSD.GDAY), vf.createLiteral("9999-12-31", XSD.GDAY)};
        String[] expected = new String[]{"---01", "---31", "---01", "---31"};
        IV[] e = new IV[dt.length];
        for (i = 0; i < dt.length; ++i) {
            e[i] = ext.createIV((Value)dt[i]);
        }
        for (i = 0; i < e.length; ++i) {
            BigdataValue valRoundTrip = ext.asValue((LiteralExtensionIV)e[i], vf);
            TestEncodeDecodeXSDDateIVs.assertEquals((String)valRoundTrip.toString(), (String)("\"" + expected[i] + "\"^^<http://www.w3.org/2001/XMLSchema#gDay>"));
        }
        IV<?, ?>[] a = TestEncodeDecodeXSDDateIVs.doEncodeDecodeTest(e);
        TestEncodeDecodeXSDDateIVs.doComparatorTest(e);
    }

    public void test_encodeDecodeGMonth() throws Exception {
        int i;
        BigdataValueFactory vf = BigdataValueFactoryImpl.getInstance((String)"test");
        DateTimeExtension<BigdataValue> ext = this.getDateTimeExtensionGMT(vf);
        BigdataLiteral[] dt = new BigdataLiteral[]{vf.createLiteral("-2015-01-01", XSD.GMONTH), vf.createLiteral("-2015-12-31", XSD.GMONTH), vf.createLiteral("9999-01-01", XSD.GMONTH), vf.createLiteral("9999-12-31", XSD.GMONTH)};
        String[] expected = new String[]{"--01", "--12", "--01", "--12"};
        IV[] e = new IV[dt.length];
        for (i = 0; i < dt.length; ++i) {
            e[i] = ext.createIV((Value)dt[i]);
        }
        for (i = 0; i < e.length; ++i) {
            BigdataValue valRoundTrip = ext.asValue((LiteralExtensionIV)e[i], vf);
            TestEncodeDecodeXSDDateIVs.assertEquals((String)valRoundTrip.toString(), (String)("\"" + expected[i] + "\"^^<http://www.w3.org/2001/XMLSchema#gMonth>"));
        }
        IV<?, ?>[] a = TestEncodeDecodeXSDDateIVs.doEncodeDecodeTest(e);
        TestEncodeDecodeXSDDateIVs.doComparatorTest(e);
    }

    public void test_encodeDecodeGMonthDay() throws Exception {
        int i;
        BigdataValueFactory vf = BigdataValueFactoryImpl.getInstance((String)"test");
        DateTimeExtension<BigdataValue> ext = this.getDateTimeExtensionGMT(vf);
        BigdataLiteral[] dt = new BigdataLiteral[]{vf.createLiteral("-2015-01-01", XSD.GMONTHDAY), vf.createLiteral("-2015-12-31", XSD.GMONTHDAY), vf.createLiteral("9999-01-01", XSD.GMONTHDAY), vf.createLiteral("9999-12-31", XSD.GMONTHDAY)};
        String[] expected = new String[]{"--01-01", "--12-31", "--01-01", "--12-31"};
        IV[] e = new IV[dt.length];
        for (i = 0; i < dt.length; ++i) {
            e[i] = ext.createIV((Value)dt[i]);
        }
        for (i = 0; i < e.length; ++i) {
            BigdataValue valRoundTrip = ext.asValue((LiteralExtensionIV)e[i], vf);
            TestEncodeDecodeXSDDateIVs.assertEquals((String)valRoundTrip.toString(), (String)("\"" + expected[i] + "\"^^<http://www.w3.org/2001/XMLSchema#gMonthDay>"));
        }
        IV<?, ?>[] a = TestEncodeDecodeXSDDateIVs.doEncodeDecodeTest(e);
        TestEncodeDecodeXSDDateIVs.doComparatorTest(e);
    }

    public void test_encodeDecodeGYear() throws Exception {
        int i;
        BigdataValueFactory vf = BigdataValueFactoryImpl.getInstance((String)"test");
        DateTimeExtension<BigdataValue> ext = this.getDateTimeExtensionGMT(vf);
        BigdataLiteral[] dt = new BigdataLiteral[]{vf.createLiteral("-2015-01-01", XSD.GYEAR), vf.createLiteral("-1000-12-31", XSD.GYEAR), vf.createLiteral("0001-01-01", XSD.GYEAR), vf.createLiteral("9999-12-31", XSD.GYEAR)};
        String[] expected = new String[]{"-2015", "-1000", "0001", "9999"};
        IV[] e = new IV[dt.length];
        for (i = 0; i < dt.length; ++i) {
            e[i] = ext.createIV((Value)dt[i]);
        }
        for (i = 0; i < e.length; ++i) {
            BigdataValue valRoundTrip = ext.asValue((LiteralExtensionIV)e[i], vf);
            TestEncodeDecodeXSDDateIVs.assertEquals((String)valRoundTrip.toString(), (String)("\"" + expected[i] + "\"^^<http://www.w3.org/2001/XMLSchema#gYear>"));
        }
        IV<?, ?>[] a = TestEncodeDecodeXSDDateIVs.doEncodeDecodeTest(e);
        TestEncodeDecodeXSDDateIVs.doComparatorTest(e);
    }

    public void test_encodeDecodeGYearMonth() throws Exception {
        int i;
        BigdataValueFactory vf = BigdataValueFactoryImpl.getInstance((String)"test");
        DateTimeExtension<BigdataValue> ext = this.getDateTimeExtensionGMT(vf);
        BigdataLiteral[] dt = new BigdataLiteral[]{vf.createLiteral("-2015-01-01", XSD.GYEARMONTH), vf.createLiteral("-1000-12-31", XSD.GYEARMONTH), vf.createLiteral("0001-01-01", XSD.GYEARMONTH), vf.createLiteral("9999-12-31", XSD.GYEARMONTH)};
        String[] expected = new String[]{"-2015-01", "-1000-12", "0001-01", "9999-12"};
        IV[] e = new IV[dt.length];
        for (i = 0; i < dt.length; ++i) {
            e[i] = ext.createIV((Value)dt[i]);
        }
        for (i = 0; i < e.length; ++i) {
            BigdataValue valRoundTrip = ext.asValue((LiteralExtensionIV)e[i], vf);
            TestEncodeDecodeXSDDateIVs.assertEquals((String)valRoundTrip.toString(), (String)("\"" + expected[i] + "\"^^<http://www.w3.org/2001/XMLSchema#gYearMonth>"));
        }
        IV<?, ?>[] a = TestEncodeDecodeXSDDateIVs.doEncodeDecodeTest(e);
        TestEncodeDecodeXSDDateIVs.doComparatorTest(e);
    }

    public void test_encodeDecodeDateTime() throws Exception {
        int i;
        BigdataValueFactory vf = BigdataValueFactoryImpl.getInstance((String)"test");
        DateTimeExtension<BigdataValue> ext = this.getDateTimeExtensionGMT(vf);
        BigdataLiteral[] dt = new BigdataLiteral[]{vf.createLiteral("-2015-01-01T10:10:10", XSD.DATETIME), vf.createLiteral("-1000-12-31T00:00:00", XSD.DATETIME), vf.createLiteral("0001-01-01T23:59:59", XSD.DATETIME), vf.createLiteral("9999-12-31T12:12:12", XSD.DATETIME)};
        String[] expected = new String[]{"-2015-01-01T10:10:10", "-1000-12-31T00:00:00", "0001-01-01T23:59:59", "9999-12-31T12:12:12"};
        IV[] e = new IV[dt.length];
        for (i = 0; i < dt.length; ++i) {
            e[i] = ext.createIV((Value)dt[i]);
        }
        for (i = 0; i < e.length; ++i) {
            BigdataValue valRoundTrip = ext.asValue((LiteralExtensionIV)e[i], vf);
            TestEncodeDecodeXSDDateIVs.assertEquals((String)valRoundTrip.toString(), (String)("\"" + expected[i] + ".000Z\"^^<http://www.w3.org/2001/XMLSchema#dateTime>"));
        }
        IV<?, ?>[] a = TestEncodeDecodeXSDDateIVs.doEncodeDecodeTest(e);
        TestEncodeDecodeXSDDateIVs.doComparatorTest(e);
    }

    public void test_encodeDecodeTime() throws Exception {
        BigdataValueFactory vf = BigdataValueFactoryImpl.getInstance((String)"test");
        DateTimeExtension<BigdataValue> ext = this.getDateTimeExtensionGMT(vf);
        BigdataLiteral[] dt = new BigdataLiteral[]{vf.createLiteral("00:00:00", XSD.TIME), vf.createLiteral("01:02:03", XSD.TIME), vf.createLiteral("10:20:30", XSD.TIME), vf.createLiteral("23:59:59", XSD.TIME)};
        IV[] e = new IV[dt.length];
        for (int i = 0; i < dt.length; ++i) {
            e[i] = ext.createIV((Value)dt[i]);
        }
        String[] expected = new String[]{"00:00:00", "01:02:03", "10:20:30", "23:59:59"};
        for (int i = 0; i < e.length; ++i) {
            BigdataValue valRoundTrip = ext.asValue((LiteralExtensionIV)e[i], vf);
            TestEncodeDecodeXSDDateIVs.assertEquals((String)valRoundTrip.toString(), (String)("\"" + expected[i] + ".000Z\"^^<http://www.w3.org/2001/XMLSchema#time>"));
        }
        IV<?, ?>[] a = TestEncodeDecodeXSDDateIVs.doEncodeDecodeTest(e);
        TestEncodeDecodeXSDDateIVs.doComparatorTest(e);
    }

    protected DateTimeExtension<BigdataValue> getDateTimeExtensionGMT(final BigdataValueFactory vf) {
        return new DateTimeExtension(new IDatatypeURIResolver(){

            public BigdataURI resolve(URI uri) {
                BigdataURI buri = vf.createURI(uri.stringValue());
                buri.setIV(TestEncodeDecodeXSDDateIVs.this.newTermId(VTE.URI));
                return buri;
            }
        }, TimeZone.getTimeZone("GMT"));
    }
}

