/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal;

import com.bigdata.btree.keys.IKeyBuilder;
import com.bigdata.btree.keys.KeyBuilder;
import com.bigdata.rdf.internal.AbstractEncodeDecodeKeysTestCase;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.IVUtility;
import com.bigdata.rdf.internal.impl.literal.XSDDecimalIV;
import java.math.BigDecimal;
import java.util.LinkedList;
import java.util.Random;

public class TestEncodeDecodeXSDDecimalIVs
extends AbstractEncodeDecodeKeysTestCase {
    public TestEncodeDecodeXSDDecimalIVs() {
    }

    public TestEncodeDecodeXSDDecimalIVs(String name) {
        super(name);
    }

    public void test_encodeDecode_XSDDecimal_pos_and_neg_varying_digits() {
        BigDecimal p1 = new BigDecimal("1.5");
        BigDecimal p2 = new BigDecimal("1.51");
        BigDecimal m1 = new BigDecimal("-1.5");
        BigDecimal m2 = new BigDecimal("-1.51");
        IV[] e = new IV[]{new XSDDecimalIV(p1), new XSDDecimalIV(p2), new XSDDecimalIV(m1), new XSDDecimalIV(m2)};
        TestEncodeDecodeXSDDecimalIVs.doEncodeDecodeTest(e);
        TestEncodeDecodeXSDDecimalIVs.doComparatorTest(e);
    }

    public void test_encodeDecode_XSDDecimal_trailingZeros() {
        BigDecimal p1 = new BigDecimal("1.50");
        BigDecimal p2 = new BigDecimal("1.500");
        IV[] e = new IV[]{new XSDDecimalIV(p1), new XSDDecimalIV(p2)};
        IV<?, ?>[] a = TestEncodeDecodeXSDDecimalIVs.doEncodeDecodeTest(e);
        TestEncodeDecodeXSDDecimalIVs.doComparatorTest(e);
        TestEncodeDecodeXSDDecimalIVs.doComparatorTest(a);
        IV[] b = new IV[]{e[0], e[1], a[0], a[1]};
        TestEncodeDecodeXSDDecimalIVs.doComparatorTest(b);
    }

    public void test_BigDecimal_zeroPrecisionNotPreserved() {
        KeyBuilder keyBuilder = new KeyBuilder();
        BigDecimal z0 = new BigDecimal("0");
        BigDecimal z1 = new BigDecimal("0.0");
        BigDecimal z2 = new BigDecimal("0.00");
        XSDDecimalIV v0 = new XSDDecimalIV(z0);
        XSDDecimalIV v1 = new XSDDecimalIV(z1);
        XSDDecimalIV v2 = new XSDDecimalIV(z2);
        byte[] b0 = IVUtility.encode((IKeyBuilder)keyBuilder.reset(), (IV)v0).getKey();
        byte[] b1 = IVUtility.encode((IKeyBuilder)keyBuilder.reset(), (IV)v1).getKey();
        byte[] b2 = IVUtility.encode((IKeyBuilder)keyBuilder.reset(), (IV)v2).getKey();
        TestEncodeDecodeXSDDecimalIVs.assertEquals((byte[])b0, (byte[])b1);
        TestEncodeDecodeXSDDecimalIVs.assertEquals((byte[])b0, (byte[])b2);
    }

    public void test_BigDecimal_500() {
        KeyBuilder keyBuilder = new KeyBuilder();
        BigDecimal v = new BigDecimal("5E+2");
        XSDDecimalIV iv = new XSDDecimalIV(v);
        byte[] b0 = IVUtility.encode((IKeyBuilder)keyBuilder.reset(), (IV)iv).getKey();
        IV iv2 = IVUtility.decode((byte[])b0);
        byte[] b2 = IVUtility.encode((IKeyBuilder)keyBuilder.reset(), (IV)iv2).getKey();
        TestEncodeDecodeXSDDecimalIVs.assertEquals((Object)iv, (Object)iv2);
        TestEncodeDecodeXSDDecimalIVs.assertEquals((byte[])b0, (byte[])b2);
    }

    public void test_encodeDecode_XSDDecimal() {
        BigDecimal z1 = new BigDecimal("0");
        BigDecimal p1 = new BigDecimal("0.01");
        BigDecimal negp1 = new BigDecimal("-0.01");
        BigDecimal m1 = new BigDecimal("1.5");
        BigDecimal m2 = new BigDecimal("-1.51");
        BigDecimal m5 = new BigDecimal("5");
        BigDecimal m500 = new BigDecimal("5E+2");
        BigDecimal v1 = new BigDecimal("383.00000000000001");
        BigDecimal v2 = new BigDecimal("383.00000000000002");
        IV[] e = new IV[]{new XSDDecimalIV(z1), new XSDDecimalIV(p1), new XSDDecimalIV(negp1), new XSDDecimalIV(m1), new XSDDecimalIV(m2), new XSDDecimalIV(m5), new XSDDecimalIV(m500), new XSDDecimalIV(v1), new XSDDecimalIV(v2)};
        TestEncodeDecodeXSDDecimalIVs.doEncodeDecodeTest(e);
        TestEncodeDecodeXSDDecimalIVs.doComparatorTest(e);
    }

    public void test_encodeDecode_XSDDecimal_3() {
        IV[] e = new IV[]{new XSDDecimalIV(BigDecimal.valueOf(1.01)), new XSDDecimalIV(BigDecimal.valueOf(2.01)), new XSDDecimalIV(BigDecimal.valueOf(0.01)), new XSDDecimalIV(BigDecimal.valueOf(1.01)), new XSDDecimalIV(BigDecimal.valueOf(-1.01)), new XSDDecimalIV(BigDecimal.valueOf(0.01)), new XSDDecimalIV(BigDecimal.valueOf(-2.01)), new XSDDecimalIV(BigDecimal.valueOf(-1.01)), new XSDDecimalIV(BigDecimal.valueOf(10.01)), new XSDDecimalIV(BigDecimal.valueOf(11.01)), new XSDDecimalIV(BigDecimal.valueOf(258.01)), new XSDDecimalIV(BigDecimal.valueOf(259.01)), new XSDDecimalIV(BigDecimal.valueOf(3.01)), new XSDDecimalIV(BigDecimal.valueOf(259.01)), new XSDDecimalIV(BigDecimal.valueOf(383.01)), new XSDDecimalIV(BigDecimal.valueOf(383.02))};
        TestEncodeDecodeXSDDecimalIVs.doEncodeDecodeTest(e);
        TestEncodeDecodeXSDDecimalIVs.doComparatorTest(e);
    }

    public void test_encodeDecode_XSDDecimal_stressTest() {
        Random r = new Random();
        LinkedList<XSDDecimalIV> a = new LinkedList<XSDDecimalIV>();
        for (int i = 0; i < 100; ++i) {
            BigDecimal t1 = BigDecimal.valueOf(r.nextDouble());
            BigDecimal v2 = BigDecimal.valueOf(Math.abs(r.nextDouble()));
            BigDecimal v4 = BigDecimal.valueOf(r.nextDouble());
            BigDecimal t2 = t1.subtract(v2);
            BigDecimal t4 = t1.subtract(BigDecimal.valueOf(5L));
            BigDecimal t5 = t1.subtract(BigDecimal.valueOf(9L));
            BigDecimal t3 = t1.add(v2);
            BigDecimal t6 = t1.add(BigDecimal.valueOf(5L));
            BigDecimal t7 = t1.add(BigDecimal.valueOf(9L));
            a.add(new XSDDecimalIV(t1));
            a.add(new XSDDecimalIV(v2));
            a.add(new XSDDecimalIV(v4));
            a.add(new XSDDecimalIV(t2));
            a.add(new XSDDecimalIV(t4));
            a.add(new XSDDecimalIV(t5));
            a.add(new XSDDecimalIV(t3));
            a.add(new XSDDecimalIV(t6));
            a.add(new XSDDecimalIV(t7));
        }
        IV[] e = a.toArray(new IV[0]);
        TestEncodeDecodeXSDDecimalIVs.doEncodeDecodeTest(e);
        TestEncodeDecodeXSDDecimalIVs.doComparatorTest(e);
    }
}

