/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal;

import com.bigdata.rdf.internal.AbstractEncodeDecodeKeysTestCase;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.impl.literal.XSDIntegerIV;
import java.math.BigInteger;
import java.util.LinkedList;
import java.util.Random;

public class TestEncodeDecodeXSDIntegerIVs
extends AbstractEncodeDecodeKeysTestCase {
    public TestEncodeDecodeXSDIntegerIVs() {
    }

    public TestEncodeDecodeXSDIntegerIVs(String name) {
        super(name);
    }

    public void test_encodeDecode_XSDInteger() {
        IV[] e = new IV[]{new XSDIntegerIV(BigInteger.valueOf(-1L)), new XSDIntegerIV(BigInteger.valueOf(0L)), new XSDIntegerIV(BigInteger.valueOf(1L)), new XSDIntegerIV(BigInteger.valueOf(Long.MAX_VALUE)), new XSDIntegerIV(BigInteger.valueOf(Long.MIN_VALUE))};
        TestEncodeDecodeXSDIntegerIVs.doEncodeDecodeTest(e);
        TestEncodeDecodeXSDIntegerIVs.doComparatorTest(e);
    }

    public void test_encodeDecode_XSDInteger_pos_and_neg_varying_digits() {
        BigInteger p1 = new BigInteger("15");
        BigInteger p2 = new BigInteger("151");
        BigInteger m1 = new BigInteger("-15");
        BigInteger m2 = new BigInteger("-151");
        IV[] e = new IV[]{new XSDIntegerIV(p1), new XSDIntegerIV(p2), new XSDIntegerIV(m1), new XSDIntegerIV(m2)};
        TestEncodeDecodeXSDIntegerIVs.doEncodeDecodeTest(e);
        TestEncodeDecodeXSDIntegerIVs.doComparatorTest(e);
    }

    public void test_encodeDecode_XSDInteger_stressTest() {
        Random r = new Random();
        LinkedList<XSDIntegerIV> a = new LinkedList<XSDIntegerIV>();
        for (int i = 0; i < 100; ++i) {
            BigInteger t1 = BigInteger.valueOf(r.nextLong());
            BigInteger v2 = BigInteger.valueOf(Math.abs(r.nextLong()));
            BigInteger v4 = BigInteger.valueOf(r.nextLong());
            BigInteger t2 = t1.subtract(v2);
            BigInteger t4 = t1.subtract(BigInteger.valueOf(5L));
            BigInteger t5 = t1.subtract(BigInteger.valueOf(9L));
            BigInteger t3 = t1.add(v2);
            BigInteger t6 = t1.add(BigInteger.valueOf(5L));
            BigInteger t7 = t1.add(BigInteger.valueOf(9L));
            a.add(new XSDIntegerIV(t1));
            a.add(new XSDIntegerIV(v2));
            a.add(new XSDIntegerIV(v4));
            a.add(new XSDIntegerIV(t2));
            a.add(new XSDIntegerIV(t4));
            a.add(new XSDIntegerIV(t5));
            a.add(new XSDIntegerIV(t3));
            a.add(new XSDIntegerIV(t6));
            a.add(new XSDIntegerIV(t7));
        }
        IV[] e = a.toArray(new IV[0]);
        TestEncodeDecodeXSDIntegerIVs.doEncodeDecodeTest(e);
        TestEncodeDecodeXSDIntegerIVs.doComparatorTest(e);
    }
}

