/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal;

import com.bigdata.btree.keys.IKeyBuilder;
import com.bigdata.rdf.internal.AbstractEncodeDecodeKeysTestCase;
import com.bigdata.rdf.internal.DTE;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.IVUtility;
import com.bigdata.rdf.internal.VTE;
import com.bigdata.rdf.internal.impl.literal.FullyInlineTypedLiteralIV;
import com.bigdata.rdf.lexicon.BlobsIndexHelper;
import com.bigdata.rdf.model.BigdataLiteral;
import java.util.LinkedList;
import junit.framework.TestCase2;
import org.openrdf.model.URI;
import org.openrdf.model.impl.URIImpl;

public class TestFullyInlineTypedLiteralIV
extends TestCase2 {
    public TestFullyInlineTypedLiteralIV() {
    }

    public TestFullyInlineTypedLiteralIV(String name) {
        super(name);
    }

    public void test_InlineLiteralIV_plain() {
        this.doTest((FullyInlineTypedLiteralIV<BigdataLiteral>)new FullyInlineTypedLiteralIV(""));
        this.doTest((FullyInlineTypedLiteralIV<BigdataLiteral>)new FullyInlineTypedLiteralIV(" "));
        this.doTest((FullyInlineTypedLiteralIV<BigdataLiteral>)new FullyInlineTypedLiteralIV("1"));
        this.doTest((FullyInlineTypedLiteralIV<BigdataLiteral>)new FullyInlineTypedLiteralIV("12"));
        this.doTest((FullyInlineTypedLiteralIV<BigdataLiteral>)new FullyInlineTypedLiteralIV("123"));
    }

    public void test_InlineLiteralIV_datatypeURI() {
        URIImpl datatype = new URIImpl("http://www.bigdata.com");
        this.doTest((FullyInlineTypedLiteralIV<BigdataLiteral>)new FullyInlineTypedLiteralIV("", null, (URI)datatype));
        this.doTest((FullyInlineTypedLiteralIV<BigdataLiteral>)new FullyInlineTypedLiteralIV(" ", null, (URI)datatype));
        this.doTest((FullyInlineTypedLiteralIV<BigdataLiteral>)new FullyInlineTypedLiteralIV("1", null, (URI)datatype));
        this.doTest((FullyInlineTypedLiteralIV<BigdataLiteral>)new FullyInlineTypedLiteralIV("12", null, (URI)datatype));
        this.doTest((FullyInlineTypedLiteralIV<BigdataLiteral>)new FullyInlineTypedLiteralIV("123", null, (URI)datatype));
    }

    private void doTest(FullyInlineTypedLiteralIV<BigdataLiteral> iv) {
        TestFullyInlineTypedLiteralIV.assertEquals((Object)VTE.LITERAL, (Object)iv.getVTE());
        TestFullyInlineTypedLiteralIV.assertTrue((boolean)iv.isInline());
        TestFullyInlineTypedLiteralIV.assertFalse((boolean)iv.isExtension());
        TestFullyInlineTypedLiteralIV.assertEquals((Object)DTE.XSDString, (Object)iv.getDTE());
        BlobsIndexHelper h = new BlobsIndexHelper();
        IKeyBuilder keyBuilder = h.newKeyBuilder();
        byte[] key = IVUtility.encode((IKeyBuilder)keyBuilder, iv).getKey();
        IV actual = IVUtility.decode((byte[])key);
        TestFullyInlineTypedLiteralIV.assertEquals(iv, (Object)actual);
        TestFullyInlineTypedLiteralIV.assertEquals((int)key.length, (int)iv.byteLength());
        TestFullyInlineTypedLiteralIV.assertEquals((int)key.length, (int)actual.byteLength());
    }

    public void test_encodeDecode_comparator() {
        LinkedList<FullyInlineTypedLiteralIV> ivs = new LinkedList<FullyInlineTypedLiteralIV>();
        URIImpl datatype = new URIImpl("http://www.bigdata.com");
        ivs.add(new FullyInlineTypedLiteralIV(""));
        ivs.add(new FullyInlineTypedLiteralIV(" "));
        ivs.add(new FullyInlineTypedLiteralIV("1"));
        ivs.add(new FullyInlineTypedLiteralIV("12"));
        ivs.add(new FullyInlineTypedLiteralIV("123"));
        ivs.add(new FullyInlineTypedLiteralIV("", "en", null));
        ivs.add(new FullyInlineTypedLiteralIV(" ", "en", null));
        ivs.add(new FullyInlineTypedLiteralIV("1", "en", null));
        ivs.add(new FullyInlineTypedLiteralIV("12", "fr", null));
        ivs.add(new FullyInlineTypedLiteralIV("123", "de", null));
        ivs.add(new FullyInlineTypedLiteralIV("", null, (URI)datatype));
        ivs.add(new FullyInlineTypedLiteralIV(" ", null, (URI)datatype));
        ivs.add(new FullyInlineTypedLiteralIV("1", null, (URI)datatype));
        ivs.add(new FullyInlineTypedLiteralIV("12", null, (URI)datatype));
        ivs.add(new FullyInlineTypedLiteralIV("123", null, (URI)datatype));
        IV[] e = ivs.toArray(new IV[0]);
        AbstractEncodeDecodeKeysTestCase.doEncodeDecodeTest(e);
        AbstractEncodeDecodeKeysTestCase.doComparatorTest(e);
    }
}

