/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal;

import com.bigdata.btree.keys.IKeyBuilder;
import com.bigdata.rdf.internal.AbstractEncodeDecodeKeysTestCase;
import com.bigdata.rdf.internal.DTE;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.IVUtility;
import com.bigdata.rdf.internal.VTE;
import com.bigdata.rdf.internal.impl.uri.FullyInlineURIIV;
import com.bigdata.rdf.lexicon.BlobsIndexHelper;
import com.bigdata.rdf.model.BigdataURI;
import java.util.LinkedList;
import junit.framework.TestCase2;
import org.openrdf.model.URI;
import org.openrdf.model.impl.URIImpl;

public class TestFullyInlineURIIV
extends TestCase2 {
    public TestFullyInlineURIIV() {
    }

    public TestFullyInlineURIIV(String name) {
        super(name);
    }

    public void test_InlineURIIV() {
        this.doTest((FullyInlineURIIV<BigdataURI>)new FullyInlineURIIV((URI)new URIImpl("http://www.bigdata.com")));
        this.doTest((FullyInlineURIIV<BigdataURI>)new FullyInlineURIIV((URI)new URIImpl("http://www.bigdata.com/")));
        this.doTest((FullyInlineURIIV<BigdataURI>)new FullyInlineURIIV((URI)new URIImpl("http://www.bigdata.com/foo")));
        this.doTest((FullyInlineURIIV<BigdataURI>)new FullyInlineURIIV((URI)new URIImpl("http://www.bigdata.com:80/foo")));
    }

    private void doTest(FullyInlineURIIV<BigdataURI> iv) {
        TestFullyInlineURIIV.assertEquals((Object)VTE.URI, (Object)iv.getVTE());
        TestFullyInlineURIIV.assertTrue((boolean)iv.isInline());
        TestFullyInlineURIIV.assertFalse((boolean)iv.isExtension());
        TestFullyInlineURIIV.assertEquals((Object)DTE.XSDString, (Object)iv.getDTE());
        BlobsIndexHelper h = new BlobsIndexHelper();
        IKeyBuilder keyBuilder = h.newKeyBuilder();
        byte[] key = IVUtility.encode((IKeyBuilder)keyBuilder, iv).getKey();
        IV actual = IVUtility.decode((byte[])key);
        TestFullyInlineURIIV.assertEquals(iv, (Object)actual);
        TestFullyInlineURIIV.assertEquals((int)key.length, (int)iv.byteLength());
        TestFullyInlineURIIV.assertEquals((int)key.length, (int)actual.byteLength());
    }

    public void test_encodeDecode_comparator() {
        LinkedList<FullyInlineURIIV> ivs = new LinkedList<FullyInlineURIIV>();
        ivs.add(new FullyInlineURIIV((URI)new URIImpl("http://www.bigdata.com")));
        ivs.add(new FullyInlineURIIV((URI)new URIImpl("http://www.bigdata.com/")));
        ivs.add(new FullyInlineURIIV((URI)new URIImpl("http://www.bigdata.com/foo")));
        ivs.add(new FullyInlineURIIV((URI)new URIImpl("http://www.bigdata.com:80/foo")));
        IV[] e = ivs.toArray(new IV[0]);
        AbstractEncodeDecodeKeysTestCase.doEncodeDecodeTest(e);
        AbstractEncodeDecodeKeysTestCase.doComparatorTest(e);
    }
}

