/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal;

import com.bigdata.io.DataInputBuffer;
import com.bigdata.io.DataOutputBuffer;
import com.bigdata.rdf.internal.IVUnicode;
import com.bigdata.util.BytesUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Random;
import junit.framework.TestCase2;

public class TestIVUnicode
extends TestCase2 {
    private static String[] words = new String[]{"a", "a's", "able", "about", "above", "according", "accordingly", "across", "actually", "after", "afterwards", "again", "against", "ain't", "all", "allow", "allows", "almost", "alone", "along", "already", "also", "although", "always", "am", "among", "amongst", "an", "and", "another", "any", "anybody", "anyhow", "anyone", "anything", "anyway", "anyways", "anywhere", "apart", "appear", "appreciate", "appropriate", "are", "aren't", "around", "as", "aside", "ask", "asking", "associated", "at", "available", "away", "awfully", "b", "be", "became", "because", "become", "becomes", "becoming", "been", "before", "beforehand", "behind", "being", "believe", "below", "beside", "besides", "best", "better", "between", "beyond", "both", "brief", "but", "by", "c", "c'mon", "c's", "came", "can", "can't", "cannot", "cant", "cause", "causes", "certain", "certainly", "changes", "clearly", "co", "com", "come", "comes", "concerning", "consequently", "consider", "considering", "contain", "containing", "contains", "corresponding", "could", "couldn't", "course", "currently", "d", "definitely", "described", "despite", "did", "didn't", "different", "do", "does", "doesn't", "doing", "don't", "done", "down", "downwards", "during", "e", "each", "edu", "eg", "eight", "either", "else", "elsewhere", "enough", "entirely", "especially", "et", "etc", "even", "ever", "every", "everybody", "everyone", "everything", "everywhere", "ex", "exactly", "example", "except", "f", "far", "few", "fifth", "first", "five", "followed", "following", "follows", "for", "former", "formerly", "forth", "four", "from", "further", "furthermore", "g", "get", "gets", "getting", "given", "gives", "go", "goes", "going", "gone", "got", "gotten", "greetings", "h", "had", "hadn't", "happens", "hardly", "has", "hasn't", "have", "haven't", "having", "he", "he's", "hello", "help", "hence", "her", "here", "here's", "hereafter", "hereby", "herein", "hereupon", "hers", "herself", "hi", "him", "himself", "his", "hither", "hopefully", "how", "howbeit", "however", "i", "i'd", "i'll", "i'm", "i've", "ie", "if", "ignored", "immediate", "in", "inasmuch", "inc", "indeed", "indicate", "indicated", "indicates", "inner", "insofar", "instead", "into", "inward", "is", "isn't", "it", "it'd", "it'll", "it's", "its", "itself", "j", "just", "k", "keep", "keeps", "kept", "know", "knows", "known", "l", "last", "lately", "later", "latter", "latterly", "least", "less", "lest", "let", "let's", "like", "liked", "likely", "little", "look", "looking", "looks", "ltd", "m", "mainly", "many", "may", "maybe", "me", "mean", "meanwhile", "merely", "might", "more", "moreover", "most", "mostly", "much", "must", "my", "myself", "n", "name", "namely", "nd", "near", "nearly", "necessary", "need", "needs", "neither", "never", "nevertheless", "new", "next", "nine", "no", "nobody", "non", "none", "noone", "nor", "normally", "not", "nothing", "novel", "now", "nowhere", "o", "obviously", "of", "off", "often", "oh", "ok", "okay", "old", "on", "once", "one", "ones", "only", "onto", "or", "other", "others", "otherwise", "ought", "our", "ours", "ourselves", "out", "outside", "over", "overall", "own", "p", "particular", "particularly", "per", "perhaps", "placed", "please", "plus", "possible", "presumably", "probably", "provides", "q", "que", "quite", "qv", "r", "rather", "rd", "re", "really", "reasonably", "regarding", "regardless", "regards", "relatively", "respectively", "right", "s", "said", "same", "saw", "say", "saying", "says", "second", "secondly", "see", "seeing", "seem", "seemed", "seeming", "seems", "seen", "self", "selves", "sensible", "sent", "serious", "seriously", "seven", "several", "shall", "she", "should", "shouldn't", "since", "six", "so", "some", "somebody", "somehow", "someone", "something", "sometime", "sometimes", "somewhat", "somewhere", "soon", "sorry", "specified", "specify", "specifying", "still", "sub", "such", "sup", "sure", "t", "t's", "take", "taken", "tell", "tends", "th", "than", "thank", "thanks", "thanx", "that", "that's", "thats", "the", "their", "theirs", "them", "themselves", "then", "thence", "there", "there's", "thereafter", "thereby", "therefore", "therein", "theres", "thereupon", "these", "they", "they'd", "they'll", "they're", "they've", "think", "third", "this", "thorough", "thoroughly", "those", "though", "three", "through", "throughout", "thru", "thus", "to", "together", "too", "took", "toward", "towards", "tried", "tries", "truly", "try", "trying", "twice", "two", "u", "un", "under", "unfortunately", "unless", "unlikely", "until", "unto", "up", "upon", "us", "use", "used", "useful", "uses", "using", "usually", "uucp", "v", "value", "various", "very", "via", "viz", "vs", "w", "want", "wants", "was", "wasn't", "way", "we", "we'd", "we'll", "we're", "we've", "welcome", "well", "went", "were", "weren't", "what", "what's", "whatever", "when", "whence", "whenever", "where", "where's", "whereafter", "whereas", "whereby", "wherein", "whereupon", "wherever", "whether", "which", "while", "whither", "who", "who's", "whoever", "whole", "whom", "whose", "why", "will", "willing", "wish", "with", "within", "without", "won't", "wonder", "would", "would", "wouldn't", "x", "y", "yes", "yet", "you", "you'd", "you'll", "you're", "you've", "your", "yours", "yourself", "yourselves", "z", "zero"};

    public TestIVUnicode() {
    }

    public TestIVUnicode(String name) {
        super(name);
    }

    public void test_encodeDecode1() throws IOException {
        this.doEncodeDecodeTest("bigdata");
    }

    public void test_encodeDecode1_emptyString() throws IOException {
        this.doEncodeDecodeTest("");
    }

    public void test_encodeDecode1_largeString() throws IOException {
        int len = Short.MAX_VALUE;
        StringBuilder sb = new StringBuilder(Short.MAX_VALUE);
        for (int i = 0; i < Short.MAX_VALUE; ++i) {
            sb.append(Character.toChars(65 + i % 26));
        }
        String s = sb.toString();
        if (log.isInfoEnabled()) {
            log.info((Object)("length(s)=" + s.length()));
        }
        this.doEncodeDecodeTest(s);
    }

    private void doEncodeDecodeTest(String expected) throws IOException {
        byte[] data = IVUnicode.encode1((String)expected);
        StringBuilder sb = new StringBuilder();
        int ndecoded = IVUnicode.decode((InputStream)new DataInputBuffer(data), (StringBuilder)sb);
        TestIVUnicode.assertEquals((String)expected, (String)sb.toString());
        TestIVUnicode.assertEquals((int)data.length, (int)ndecoded);
    }

    public void test_encodeDecode2() throws IOException {
        this.doEncodeDecodeTest(new String[]{"en", "bigdata"});
    }

    private void doEncodeDecodeTest(String[] expected) throws IOException {
        DataOutputBuffer out = new DataOutputBuffer();
        StringBuilder exp = new StringBuilder();
        int nencoded = 0;
        for (String s : expected) {
            byte[] a = IVUnicode.encode1((String)s);
            nencoded += a.length;
            out.append(a);
            exp.append(s);
        }
        byte[] data = out.toByteArray();
        StringBuilder sb = new StringBuilder();
        DataInputBuffer in = new DataInputBuffer(data);
        int ndecoded = 0;
        for (int i = 0; i < expected.length; ++i) {
            ndecoded += IVUnicode.decode((InputStream)in, (StringBuilder)sb);
        }
        TestIVUnicode.assertEquals((String)exp.toString(), (String)sb.toString());
        TestIVUnicode.assertEquals((int)nencoded, (int)ndecoded);
    }

    public void test_stress() throws IOException {
        int ntrials = 100000;
        this.doTest(100000);
    }

    private void doTest(int ntrials) throws IOException {
        long begin = System.currentTimeMillis();
        Random r = new Random();
        StringBuilder sb = new StringBuilder();
        StringBuilder outDecoded = new StringBuilder();
        long nwords = 0L;
        long nchars = 0L;
        long nbytes = 0L;
        for (int trial = 0; trial < ntrials; ++trial) {
            int wordLength = r.nextInt(20) + 1;
            sb.setLength(0);
            for (int i = 0; i < wordLength; ++i) {
                if (i > 0) {
                    sb.append(" ");
                }
                sb.append(words[r.nextInt(words.length)]);
            }
            String expected = sb.toString();
            byte[] a = IVUnicode.encode1((String)expected);
            int nencoded = a.length;
            nwords += (long)wordLength;
            nchars += (long)expected.length();
            nbytes += (long)a.length;
            outDecoded.setLength(0);
            int ndecoded = IVUnicode.decode((InputStream)new ByteArrayInputStream(a, 0, a.length), (StringBuilder)outDecoded);
            String actual = outDecoded.toString();
            TestIVUnicode.assertEquals((String)expected, (String)actual);
            TestIVUnicode.assertEquals((int)nencoded, (int)ndecoded);
        }
        long elapsed = System.currentTimeMillis() - begin;
        double ratio = (double)nbytes / (double)nchars;
        if (log.isInfoEnabled()) {
            log.info((Object)("nwords=" + nwords + ", nchars=" + nchars + ", nbytes=" + nbytes + ", bytes/char=" + ratio + ", elapsed=" + elapsed));
        }
    }

    public void test_ordering() throws IOException {
        long begin = System.currentTimeMillis();
        Random r = new Random();
        int ntrials = 10;
        StringBuilder sb = new StringBuilder();
        StringBuilder outDecoded = new StringBuilder();
        long nwords = 0L;
        long nchars = 0L;
        long nbytes = 0L;
        String[] values = new String[10];
        byte[][] keys = new byte[10][];
        for (int trial = 0; trial < 10; ++trial) {
            int wordLength = r.nextInt(5) + 1;
            sb.setLength(0);
            for (int i = 0; i < wordLength; ++i) {
                if (i > 0) {
                    sb.append(" ");
                }
                sb.append(words[r.nextInt(words.length)]);
            }
            String expected = sb.toString();
            byte[] a = IVUnicode.encode1((String)expected);
            int nencoded = a.length;
            nwords += (long)wordLength;
            nchars += (long)expected.length();
            nbytes += (long)a.length;
            values[trial] = expected;
            keys[trial] = a;
            outDecoded.setLength(0);
            int ndecoded = IVUnicode.decode((InputStream)new ByteArrayInputStream(a, 0, a.length), (StringBuilder)outDecoded);
            String actual = outDecoded.toString();
            TestIVUnicode.assertEquals((String)expected, (String)actual);
            TestIVUnicode.assertEquals((int)nencoded, (int)ndecoded);
        }
        long elapsed = System.currentTimeMillis() - begin;
        double ratio = (double)nbytes / (double)nchars;
        if (log.isInfoEnabled()) {
            log.info((Object)("nwords=" + nwords + ", nchars=" + nchars + ", nbytes=" + nbytes + ", bytes/char=" + ratio + ", elapsed=" + elapsed));
        }
        Arrays.sort(values, IVUnicode.IVUnicodeComparator.INSTANCE);
        Arrays.sort(keys, BytesUtil.UnsignedByteArrayComparator.INSTANCE);
        for (int i = 0; i < values.length; ++i) {
            String expected = values[i];
            byte[] a = keys[i];
            outDecoded.setLength(0);
            int ndecoded = IVUnicode.decode((InputStream)new ByteArrayInputStream(a, 0, a.length), (StringBuilder)outDecoded);
            String actual = outDecoded.toString();
            if (expected.equals(actual)) continue;
            TestIVUnicode.assertEquals((String)("index=" + i + " of " + 10), (String)expected, (String)actual);
        }
    }
}

