/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal;

import com.bigdata.rdf.internal.InlineLocalNameIntegerURIHandler;
import junit.framework.TestCase2;

public class TestInlineLocalNameIntegerURIHandler
extends TestCase2 {
    private MyInlineLocalNameIntegerURIHandler handler = new MyInlineLocalNameIntegerURIHandler("http://www.blazegraph.com/", this.packedId);
    private int packedId = 1;

    public TestInlineLocalNameIntegerURIHandler(String name) {
        super(name);
    }

    public void test_packValues() {
        long testVal = 123456789L;
        this.check(this.handler, 123456789L, this.packedId);
    }

    public void test_idrange() {
        long value = 5555555555L;
        for (int i = 0; i < 32; ++i) {
            MyInlineLocalNameIntegerURIHandler h = new MyInlineLocalNameIntegerURIHandler("www.blazegraph.com", i);
            this.check(h, 5555555555L, i);
        }
    }

    public void test_maxInteger() {
        long tooBig = 576460752303423000L;
        try {
            this.handler.packValue(576460752303423000L);
        }
        catch (RuntimeException e) {
            TestInlineLocalNameIntegerURIHandler.assertTrue((boolean)true);
            return;
        }
        TestInlineLocalNameIntegerURIHandler.fail((String)"576460752303423000 exceeds the maximum value.");
    }

    public void test_maxId() {
        try {
            MyInlineLocalNameIntegerURIHandler h = new MyInlineLocalNameIntegerURIHandler("www.blazegraph.com", 33);
        }
        catch (RuntimeException e) {
            TestInlineLocalNameIntegerURIHandler.assertTrue((boolean)true);
            return;
        }
        TestInlineLocalNameIntegerURIHandler.fail((String)"32 exceeds the maximum id value.");
    }

    public void test_edgeCase1() {
        long edge = 144115188075855999L;
        int id = 16;
        MyInlineLocalNameIntegerURIHandler h = new MyInlineLocalNameIntegerURIHandler("www.blazegraph.com", 16);
        this.check(h, 144115188075855999L, 16);
    }

    public void test_edgeCase2() {
        long edge = 0x200000000000080L;
        int id = 16;
        MyInlineLocalNameIntegerURIHandler h = new MyInlineLocalNameIntegerURIHandler("www.blazegraph.com", 16);
        try {
            long packedVal = h.packValue(0x200000000000080L);
        }
        catch (RuntimeException e) {
            TestInlineLocalNameIntegerURIHandler.assertTrue((boolean)true);
            return;
        }
        TestInlineLocalNameIntegerURIHandler.fail();
    }

    public void test_edgeCase3() {
        long edge = 0L;
        int id = 16;
        MyInlineLocalNameIntegerURIHandler h = new MyInlineLocalNameIntegerURIHandler("www.blazegraph.com", 16);
        try {
            long packedVal = h.packValue(0L);
        }
        catch (RuntimeException e) {
            TestInlineLocalNameIntegerURIHandler.fail();
        }
        this.check(h, 0L, 16);
    }

    public void test_edgeCase4() {
        long edge = -1L;
        int id = 16;
        MyInlineLocalNameIntegerURIHandler h = new MyInlineLocalNameIntegerURIHandler("www.blazegraph.com", 16);
        try {
            long packedVal = h.packValue(-1L);
        }
        catch (RuntimeException e) {
            TestInlineLocalNameIntegerURIHandler.assertTrue((boolean)true);
            return;
        }
        TestInlineLocalNameIntegerURIHandler.fail();
    }

    public void test_differentIds() {
        long packed2;
        long value = 123456789L;
        int id1 = 4;
        int id2 = 31;
        MyInlineLocalNameIntegerURIHandler h1 = new MyInlineLocalNameIntegerURIHandler("www.blazegraph.com", 4);
        MyInlineLocalNameIntegerURIHandler h2 = new MyInlineLocalNameIntegerURIHandler("www.blazegraph.com", 31);
        long packed1 = h1.packValue(123456789L);
        TestInlineLocalNameIntegerURIHandler.assertTrue((packed1 != (packed2 = h2.packValue(123456789L)) ? 1 : 0) != 0);
        long unpacked1 = h1.unpackValue(packed1);
        long unpacked2 = h2.unpackValue(packed2);
        TestInlineLocalNameIntegerURIHandler.assertTrue((unpacked1 == unpacked2 ? 1 : 0) != 0);
    }

    private void check(MyInlineLocalNameIntegerURIHandler h, long value, int id) {
        long packedVal = h.packValue(value);
        if (log.isDebugEnabled()) {
            log.debug((Object)("packedVal: " + packedVal));
            log.debug((Object)("test:  " + value + " : " + h.unpackValue(packedVal)));
            log.debug((Object)("packedId:  " + id + " : " + h.unpackId(packedVal)));
        }
        TestInlineLocalNameIntegerURIHandler.assertTrue((value == h.unpackValue(packedVal) ? 1 : 0) != 0);
        TestInlineLocalNameIntegerURIHandler.assertTrue((id == h.unpackId(packedVal) ? 1 : 0) != 0);
    }

    private class MyInlineLocalNameIntegerURIHandler
    extends InlineLocalNameIntegerURIHandler {
        public MyInlineLocalNameIntegerURIHandler(String namespace, int packedId) {
            super(namespace, packedId);
        }
    }
}

