/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal;

import com.bigdata.rdf.internal.InlineFixedWidthIntegerURIHandler;
import com.bigdata.rdf.internal.InlineHexUUIDURIHandler;
import com.bigdata.rdf.internal.InlinePrefixedFixedWidthIntegerURIHandler;
import com.bigdata.rdf.internal.InlinePrefixedIntegerURIHandler;
import com.bigdata.rdf.internal.InlinePrefixedSuffixedFixedWidthIntegerURIHandler;
import com.bigdata.rdf.internal.InlinePrefixedSuffixedHexUUIDURIHandler;
import com.bigdata.rdf.internal.InlinePrefixedSuffixedIntegerURIHandler;
import com.bigdata.rdf.internal.InlinePrefixedSuffixedUUIDURIHandler;
import com.bigdata.rdf.internal.InlineSuffixedFixedWidthIntegerURIHandler;
import com.bigdata.rdf.internal.InlineSuffixedHexUUIDURIHandler;
import com.bigdata.rdf.internal.InlineSuffixedIntegerURIHandler;
import com.bigdata.rdf.internal.InlineSuffixedUUIDURIHandler;
import com.bigdata.rdf.internal.impl.literal.AbstractLiteralIV;
import com.bigdata.rdf.internal.impl.literal.UUIDLiteralIV;
import com.bigdata.rdf.internal.impl.literal.XSDNumericIV;
import java.util.UUID;
import junit.framework.TestCase2;
import org.junit.Test;

public class TestInlineURIHandlers
extends TestCase2 {
    public TestInlineURIHandlers() {
    }

    public TestInlineURIHandlers(String name) {
        super(name);
    }

    @Test
    public void testPrefixedIntegerURIHandler() {
        String nameSpace = "http://blazegraph.com/";
        String localName = "DB1234";
        String fixture = "DB";
        int intValue = 1234;
        InlinePrefixedIntegerURIHandler handler = new InlinePrefixedIntegerURIHandler("http://blazegraph.com/", "DB");
        XSDNumericIV iv = (XSDNumericIV)handler.createInlineIV("DB1234");
        if (log.isDebugEnabled()) {
            log.debug((Object)iv.getDTE().name());
        }
        TestInlineURIHandlers.assertTrue((1234 == iv.getInlineValue().intValue() ? 1 : 0) != 0);
        TestInlineURIHandlers.assertTrue((boolean)"DB1234".equals(handler.getLocalNameFromDelegate((AbstractLiteralIV)iv)));
    }

    @Test
    public void testSuffixedIntegerURIHandler() {
        String nameSpace = "http://blazegraph.com/";
        String localName = "1234DB";
        String fixture = "DB";
        int intValue = 1234;
        InlineSuffixedIntegerURIHandler handler = new InlineSuffixedIntegerURIHandler("http://blazegraph.com/", "DB");
        XSDNumericIV iv = (XSDNumericIV)handler.createInlineIV("1234DB");
        if (log.isDebugEnabled()) {
            log.debug((Object)iv.getDTE().name());
        }
        TestInlineURIHandlers.assertTrue((1234 == iv.getInlineValue().intValue() ? 1 : 0) != 0);
        TestInlineURIHandlers.assertTrue((boolean)"1234DB".equals(handler.getLocalNameFromDelegate((AbstractLiteralIV)iv)));
    }

    @Test
    public void testFixedWidthIntegerURIHandler() {
        String nameSpace = "http://blazegraph.com/";
        String localName = "001234";
        int intValue = 1234;
        int width = 6;
        InlineFixedWidthIntegerURIHandler handler = new InlineFixedWidthIntegerURIHandler("http://blazegraph.com/", 6);
        XSDNumericIV iv = (XSDNumericIV)handler.createInlineIV("001234");
        if (log.isDebugEnabled()) {
            log.debug((Object)iv.getDTE().name());
        }
        TestInlineURIHandlers.assertTrue((1234 == iv.getInlineValue().intValue() ? 1 : 0) != 0);
        TestInlineURIHandlers.assertTrue((boolean)"001234".equals(handler.getLocalNameFromDelegate((AbstractLiteralIV)iv)));
    }

    @Test
    public void testFixedWidthIntegerURIHandlerFail() {
        String nameSpace = "http://blazegraph.com/";
        String localName = "001234";
        int intValue = 1234;
        int width = 7;
        InlineFixedWidthIntegerURIHandler handler = new InlineFixedWidthIntegerURIHandler("http://blazegraph.com/", 7);
        XSDNumericIV iv = (XSDNumericIV)handler.createInlineIV("001234");
        if (log.isDebugEnabled()) {
            log.debug((Object)iv.getDTE().name());
        }
        TestInlineURIHandlers.assertTrue((1234 == iv.getInlineValue().intValue() ? 1 : 0) != 0);
        TestInlineURIHandlers.assertTrue((!"001234".equals(handler.getLocalNameFromDelegate((AbstractLiteralIV)iv)) ? 1 : 0) != 0);
        TestInlineURIHandlers.assertTrue((boolean)String.format("%07d", 1234).equals(handler.getLocalNameFromDelegate((AbstractLiteralIV)iv)));
    }

    @Test
    public void testPrefixFixedWidthIntegerURIHandler() {
        String nameSpace = "http://blazegraph.com/";
        String localName = "PREFIX_001234";
        String fixture = "PREFIX_";
        int intValue = 1234;
        int width = 6;
        InlinePrefixedFixedWidthIntegerURIHandler handler = new InlinePrefixedFixedWidthIntegerURIHandler("http://blazegraph.com/", "PREFIX_", 6);
        XSDNumericIV iv = (XSDNumericIV)handler.createInlineIV("PREFIX_001234");
        if (log.isDebugEnabled()) {
            log.debug((Object)iv.getDTE().name());
        }
        TestInlineURIHandlers.assertTrue((1234 == iv.getInlineValue().intValue() ? 1 : 0) != 0);
        TestInlineURIHandlers.assertTrue((boolean)"PREFIX_001234".equals(handler.getLocalNameFromDelegate((AbstractLiteralIV)iv)));
    }

    @Test
    public void testSuffixFixedWidthIntegerURIHandler() {
        String nameSpace = "http://blazegraph.com/";
        String localName = "001234_SUFFIX";
        String fixture = "_SUFFIX";
        int intValue = 1234;
        int width = 6;
        InlineSuffixedFixedWidthIntegerURIHandler handler = new InlineSuffixedFixedWidthIntegerURIHandler("http://blazegraph.com/", "_SUFFIX", 6);
        XSDNumericIV iv = (XSDNumericIV)handler.createInlineIV("001234_SUFFIX");
        if (log.isDebugEnabled()) {
            log.debug((Object)iv.getDTE().name());
        }
        TestInlineURIHandlers.assertTrue((iv != null ? 1 : 0) != 0);
        TestInlineURIHandlers.assertTrue((1234 == iv.getInlineValue().intValue() ? 1 : 0) != 0);
        TestInlineURIHandlers.assertTrue((boolean)"001234_SUFFIX".equals(handler.getLocalNameFromDelegate((AbstractLiteralIV)iv)));
    }

    @Test
    public void testPrefixedSuffixFixedWidthIntegerURIHandler() {
        String nameSpace = "http://blazegraph.com/";
        String localName = "PRE_001234_SUFFIX";
        String pre = "PRE_";
        String fixture = "_SUFFIX";
        int intValue = 1234;
        int width = 6;
        InlinePrefixedSuffixedFixedWidthIntegerURIHandler handler = new InlinePrefixedSuffixedFixedWidthIntegerURIHandler("http://blazegraph.com/", "PRE_", "_SUFFIX", 6);
        XSDNumericIV iv = (XSDNumericIV)handler.createInlineIV("PRE_001234_SUFFIX");
        if (log.isDebugEnabled()) {
            log.debug((Object)iv.getDTE().name());
        }
        TestInlineURIHandlers.assertTrue((iv != null ? 1 : 0) != 0);
        TestInlineURIHandlers.assertTrue((1234 == iv.getInlineValue().intValue() ? 1 : 0) != 0);
        TestInlineURIHandlers.assertTrue((boolean)"PRE_001234_SUFFIX".equals(handler.getLocalNameFromDelegate((AbstractLiteralIV)iv)));
    }

    @Test
    public void testPrefixedSuffixIntegerURIHandler() {
        String nameSpace = "http://blazegraph.com/";
        String localName = "PRE_1234_SUFFIX";
        String pre = "PRE_";
        String fixture = "_SUFFIX";
        int intValue = 1234;
        InlinePrefixedSuffixedIntegerURIHandler handler = new InlinePrefixedSuffixedIntegerURIHandler("http://blazegraph.com/", "PRE_", "_SUFFIX");
        XSDNumericIV iv = (XSDNumericIV)handler.createInlineIV("PRE_1234_SUFFIX");
        if (log.isDebugEnabled()) {
            log.debug((Object)iv.getDTE().name());
        }
        TestInlineURIHandlers.assertTrue((iv != null ? 1 : 0) != 0);
        TestInlineURIHandlers.assertTrue((1234 == iv.getInlineValue().intValue() ? 1 : 0) != 0);
        TestInlineURIHandlers.assertTrue((boolean)"PRE_1234_SUFFIX".equals(handler.getLocalNameFromDelegate((AbstractLiteralIV)iv)));
    }

    @Test
    public void testHexUUIDURIHandler() {
        String nameSpace = "http://blazegraph.com/hex_uuid/";
        String localName = "010072F0000038090100000000D56C9E";
        InlineHexUUIDURIHandler handler = new InlineHexUUIDURIHandler("http://blazegraph.com/hex_uuid/");
        UUIDLiteralIV iv = (UUIDLiteralIV)handler.createInlineIV("010072F0000038090100000000D56C9E");
        if (log.isDebugEnabled()) {
            log.debug((Object)iv.getDTE().name());
        }
        TestInlineURIHandlers.assertTrue((iv != null ? 1 : 0) != 0);
        TestInlineURIHandlers.assertTrue((boolean)"010072F0000038090100000000D56C9E".equals(handler.getLocalNameFromDelegate((AbstractLiteralIV)iv)));
    }

    @Test
    public void testSuffixedHexUUIDURIHandler() {
        String nameSpace = "http://blazegraph.com/hex_uuid/";
        String suffix = "suffix";
        String localName = "010072F0000038090100000000D56C9Esuffix";
        InlineSuffixedHexUUIDURIHandler handler = new InlineSuffixedHexUUIDURIHandler("http://blazegraph.com/hex_uuid/", "suffix");
        UUIDLiteralIV iv = (UUIDLiteralIV)handler.createInlineIV("010072F0000038090100000000D56C9Esuffix");
        if (log.isDebugEnabled()) {
            log.debug((Object)iv.getDTE().name());
        }
        TestInlineURIHandlers.assertTrue((iv != null ? 1 : 0) != 0);
        TestInlineURIHandlers.assertTrue((boolean)"010072F0000038090100000000D56C9Esuffix".equals(handler.getLocalNameFromDelegate((AbstractLiteralIV)iv)));
    }

    @Test
    public void testSuffixedUUIDURIHandler() {
        String nameSpace = "http://blazegraph.com/uuid/";
        UUID uuid = UUID.randomUUID();
        String suffix = "suffix";
        String localName = uuid.toString() + "suffix";
        InlineSuffixedUUIDURIHandler handler = new InlineSuffixedUUIDURIHandler("http://blazegraph.com/uuid/", "suffix");
        UUIDLiteralIV iv = (UUIDLiteralIV)handler.createInlineIV(localName);
        if (log.isDebugEnabled()) {
            log.debug((Object)iv.getDTE().name());
        }
        TestInlineURIHandlers.assertTrue((iv != null ? 1 : 0) != 0);
        TestInlineURIHandlers.assertTrue((boolean)localName.equals(handler.getLocalNameFromDelegate((AbstractLiteralIV)iv)));
    }

    @Test
    public void testPrefixedSuffixedHexUUIDURIHandler() {
        String nameSpace = "http://blazegraph.com/hex_uuid/";
        String prefix = "prefix";
        String suffix = "suffix";
        String localName = "prefix010072F0000038090100000000D56C9Esuffix";
        InlinePrefixedSuffixedHexUUIDURIHandler handler = new InlinePrefixedSuffixedHexUUIDURIHandler("http://blazegraph.com/hex_uuid/", "prefix", "suffix");
        UUIDLiteralIV iv = (UUIDLiteralIV)handler.createInlineIV("prefix010072F0000038090100000000D56C9Esuffix");
        if (log.isDebugEnabled()) {
            log.debug((Object)iv.getDTE().name());
        }
        TestInlineURIHandlers.assertTrue((iv != null ? 1 : 0) != 0);
        TestInlineURIHandlers.assertTrue((boolean)"prefix010072F0000038090100000000D56C9Esuffix".equals(handler.getLocalNameFromDelegate((AbstractLiteralIV)iv)));
    }

    @Test
    public void testPrefixedSuffixedUUIDURIHandler() {
        String nameSpace = "http://blazegraph.com/uuid/";
        UUID uuid = UUID.randomUUID();
        String prefix = "prefix";
        String suffix = "suffix";
        String localName = "prefix" + uuid.toString() + "suffix";
        InlinePrefixedSuffixedUUIDURIHandler handler = new InlinePrefixedSuffixedUUIDURIHandler("http://blazegraph.com/uuid/", "prefix", "suffix");
        UUIDLiteralIV iv = (UUIDLiteralIV)handler.createInlineIV(localName);
        if (log.isDebugEnabled()) {
            log.debug((Object)iv.getDTE().name());
        }
        TestInlineURIHandlers.assertTrue((iv != null ? 1 : 0) != 0);
        TestInlineURIHandlers.assertTrue((boolean)localName.equals(handler.getLocalNameFromDelegate((AbstractLiteralIV)iv)));
    }
}

