/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal;

import com.bigdata.btree.keys.IKeyBuilder;
import com.bigdata.rdf.internal.DTE;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.IVUtility;
import com.bigdata.rdf.internal.TestEncodeDecodeKeys;
import com.bigdata.rdf.internal.VTE;
import com.bigdata.rdf.internal.impl.AbstractIV;
import com.bigdata.rdf.internal.impl.literal.AbstractLiteralIV;
import com.bigdata.rdf.internal.impl.literal.FullyInlineTypedLiteralIV;
import com.bigdata.rdf.internal.impl.literal.PartlyInlineTypedLiteralIV;
import com.bigdata.rdf.lexicon.BlobsIndexHelper;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.test.MockTermIdFactory;
import java.util.LinkedList;
import junit.framework.TestCase2;

public class TestLiteralDatatypeIV
extends TestCase2 {
    private MockTermIdFactory termIdFactory;

    public TestLiteralDatatypeIV() {
    }

    public TestLiteralDatatypeIV(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.termIdFactory = new MockTermIdFactory();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.termIdFactory = null;
    }

    private IV<?, ?> newTermId(VTE vte) {
        return this.termIdFactory.newTermId(vte);
    }

    public void test_LiteralDatatypeIV() {
        IV<?, ?> datatypeIV = this.newTermId(VTE.URI);
        this.doTest((PartlyInlineTypedLiteralIV<BigdataLiteral>)new PartlyInlineTypedLiteralIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV(""), datatypeIV));
        this.doTest((PartlyInlineTypedLiteralIV<BigdataLiteral>)new PartlyInlineTypedLiteralIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV("abc"), datatypeIV));
        this.doTest((PartlyInlineTypedLiteralIV<BigdataLiteral>)new PartlyInlineTypedLiteralIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV(" "), datatypeIV));
        this.doTest((PartlyInlineTypedLiteralIV<BigdataLiteral>)new PartlyInlineTypedLiteralIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV("1"), datatypeIV));
        this.doTest((PartlyInlineTypedLiteralIV<BigdataLiteral>)new PartlyInlineTypedLiteralIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV("12"), datatypeIV));
        LinkedList<PartlyInlineTypedLiteralIV> ivs = new LinkedList<PartlyInlineTypedLiteralIV>();
        ivs.add(new PartlyInlineTypedLiteralIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV(""), datatypeIV));
        ivs.add(new PartlyInlineTypedLiteralIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV("abc"), datatypeIV));
        ivs.add(new PartlyInlineTypedLiteralIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV(" "), datatypeIV));
        ivs.add(new PartlyInlineTypedLiteralIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV("1"), datatypeIV));
        ivs.add(new PartlyInlineTypedLiteralIV((AbstractLiteralIV)new FullyInlineTypedLiteralIV("12"), datatypeIV));
        IV[] e = ivs.toArray(new IV[0]);
        TestEncodeDecodeKeys.doEncodeDecodeTest(e);
        TestEncodeDecodeKeys.doComparatorTest(e);
    }

    private void doTest(PartlyInlineTypedLiteralIV<BigdataLiteral> iv) {
        TestLiteralDatatypeIV.assertEquals((Object)VTE.LITERAL, (Object)iv.getVTE());
        TestLiteralDatatypeIV.assertFalse((boolean)iv.isInline());
        TestLiteralDatatypeIV.assertTrue((boolean)iv.isExtension());
        TestLiteralDatatypeIV.assertEquals((Object)DTE.XSDString, (Object)iv.getDTE());
        BlobsIndexHelper h = new BlobsIndexHelper();
        IKeyBuilder keyBuilder = h.newKeyBuilder();
        byte[] key = IVUtility.encode((IKeyBuilder)keyBuilder, iv).getKey();
        PartlyInlineTypedLiteralIV actual = (PartlyInlineTypedLiteralIV)IVUtility.decode((byte[])key);
        AbstractIV expectedExtensionIV = (AbstractIV)iv.getExtensionIV();
        AbstractIV actualExtensionIV = (AbstractIV)actual.getExtensionIV();
        TestLiteralDatatypeIV.assertEquals((Object)expectedExtensionIV, (Object)actualExtensionIV);
        TestLiteralDatatypeIV.assertEquals((int)expectedExtensionIV.byteLength(), (int)actualExtensionIV.byteLength());
        AbstractLiteralIV expectedDelegateIV = iv.getDelegate();
        AbstractLiteralIV actualDelegateIV = actual.getDelegate();
        TestLiteralDatatypeIV.assertEquals((Object)expectedDelegateIV, (Object)actualDelegateIV);
        TestLiteralDatatypeIV.assertEquals((int)expectedDelegateIV.byteLength(), (int)actualDelegateIV.byteLength());
        TestLiteralDatatypeIV.assertEquals(iv, (Object)actual);
        TestLiteralDatatypeIV.assertEquals((int)key.length, (int)iv.byteLength());
        TestLiteralDatatypeIV.assertEquals((int)key.length, (int)actual.byteLength());
    }
}

