/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal;

import com.bigdata.rdf.axioms.NoAxioms;
import com.bigdata.rdf.internal.InlineNamespaceMultiURIHandler;
import com.bigdata.rdf.internal.InlineSignedIntegerURIHandler;
import com.bigdata.rdf.internal.InlineURIHandler;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.rio.StatementBuffer;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.store.AbstractTripleStoreTestCase;
import com.bigdata.rdf.vocab.TestMultiVocabulary;
import com.bigdata.rdf.vocab.TestNamespaceMultiURIHandler;
import java.util.Properties;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;

public class TestMultiInlineURIHandlersSingleNamespace
extends AbstractTripleStoreTestCase {
    @Override
    public Properties getProperties() {
        Properties props = new Properties(super.getProperties());
        props.setProperty(BigdataSail.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        props.setProperty(BigdataSail.Options.TRUTH_MAINTENANCE, "false");
        props.setProperty(BigdataSail.Options.JUSTIFY, "false");
        props.setProperty(AbstractTripleStore.Options.VOCABULARY_CLASS, TestMultiVocabulary.class.getName());
        props.setProperty(AbstractTripleStore.Options.INLINE_URI_FACTORY_CLASS, TestNamespaceMultiURIHandler.class.getName());
        props.setProperty(AbstractTripleStore.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        props.setProperty(AbstractTripleStore.Options.TEXT_INDEX, "false");
        return props;
    }

    public void test_TwoNamespaceCreation() {
        InlineNamespaceMultiURIHandler mHandler = new InlineNamespaceMultiURIHandler("http://blazegraph.com/data/");
        boolean noException = true;
        try {
            InlineSignedIntegerURIHandler i = new InlineSignedIntegerURIHandler("http://www.bigdata.com/");
            mHandler.addHandler((InlineURIHandler)i);
        }
        catch (RuntimeException e) {
            noException = false;
        }
        if (noException) {
            TestMultiInlineURIHandlersSingleNamespace.fail();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_TestVocabularyInlineValues() {
        Properties properties = this.getProperties();
        AbstractTripleStore store = this.getStore(properties);
        try {
            int i;
            BigdataValueFactory vf = store.getValueFactory();
            StatementBuffer sb = new StatementBuffer(store, 4);
            BigdataURI pred = vf.createURI("http://blazegraph.com/Position#hasMarketValue");
            BigdataLiteral obj = vf.createLiteral("100.00");
            BigdataURI[] uris = new BigdataURI[]{vf.createURI("http://blazegraph.com/Data#Position_010072F0000038090100000000D56C9E_TaxCost"), vf.createURI("http://blazegraph.com/Data#Position_010072F0000038090100000000D56C9E_UnrealizedGain"), vf.createURI("http://blazegraph.com/Data#Position_010072F0000038090100000000D56C9E"), vf.createURI("http://blazegraph.com/Data#Position_010072F0000038090100000000D56C9E_WashSale")};
            String[] localNames = new String[]{"Position_010072F0000038090100000000D56C9E_TaxCost", "Position_010072F0000038090100000000D56C9E_UnrealizedGain", "Position_010072F0000038090100000000D56C9E", "Position_010072F0000038090100000000D56C9E_WashSale"};
            for (i = 0; i < uris.length; ++i) {
                sb.add((Resource)uris[i], (URI)pred, (Value)obj);
            }
            sb.flush();
            store.commit();
            if (log.isDebugEnabled()) {
                log.debug((Object)store.dumpStore());
            }
            for (i = 0; i < uris.length; ++i) {
                BigdataURI uri = uris[i];
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Checking " + uri.getNamespace() + " " + uri.getLocalName() + " inline: " + uri.getIV().isInline()));
                    log.debug((Object)(localNames[i] + " : " + uri.getLocalName()));
                }
                TestMultiInlineURIHandlersSingleNamespace.assertTrue((boolean)uri.getIV().isInline());
                TestMultiInlineURIHandlersSingleNamespace.assertTrue((boolean)localNames[i].equals(uri.getLocalName()));
            }
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("BLZG-1938:  Single Namespace Multiple InlineURIHandlers Testing");
        suite.addTestSuite(TestMultiInlineURIHandlersSingleNamespace.class);
        return suite;
    }
}

