/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal;

import com.bigdata.rdf.internal.IDatatypeURIResolver;
import com.bigdata.rdf.internal.VTE;
import com.bigdata.rdf.internal.constraints.MathBOp;
import com.bigdata.rdf.internal.constraints.MathUtility;
import com.bigdata.rdf.internal.impl.extensions.CompressedTimestampExtension;
import com.bigdata.rdf.internal.impl.literal.LiteralExtensionIV;
import com.bigdata.rdf.internal.impl.literal.NumericIV;
import com.bigdata.rdf.internal.impl.literal.XSDDecimalIV;
import com.bigdata.rdf.internal.impl.literal.XSDIntegerIV;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.model.BigdataValueFactoryImpl;
import com.bigdata.test.MockTermIdFactory;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.UUID;
import junit.framework.TestCase2;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.Value;

public class TestPackedLongIVs
extends TestCase2 {
    public TestPackedLongIVs() {
    }

    public TestPackedLongIVs(String name) {
        super(name);
    }

    public void testMath() {
        final BigdataValueFactory vf = BigdataValueFactoryImpl.getInstance((String)(this.getName() + UUID.randomUUID()));
        final MockTermIdFactory termIdFactory = new MockTermIdFactory();
        CompressedTimestampExtension ext = new CompressedTimestampExtension(new IDatatypeURIResolver(){

            public BigdataURI resolve(URI uri) {
                BigdataURI buri = vf.createURI(uri.stringValue());
                buri.setIV(termIdFactory.newTermId(VTE.URI));
                return buri;
            }
        });
        BigdataLiteral bvZero = vf.createLiteral("0", CompressedTimestampExtension.COMPRESSED_TIMESTAMP);
        LiteralExtensionIV zero = ext.createIV((Value)bvZero);
        zero.setValue((BigdataValue)bvZero);
        BigdataLiteral bfOne = vf.createLiteral("1", CompressedTimestampExtension.COMPRESSED_TIMESTAMP);
        LiteralExtensionIV one = ext.createIV((Value)bfOne);
        one.setValue((BigdataValue)bfOne);
        BigdataLiteral bfTen = vf.createLiteral("10", CompressedTimestampExtension.COMPRESSED_TIMESTAMP);
        LiteralExtensionIV ten = ext.createIV((Value)bfTen);
        ten.setValue((BigdataValue)bfTen);
        BigdataLiteral bfTwenty = vf.createLiteral("20", CompressedTimestampExtension.COMPRESSED_TIMESTAMP);
        LiteralExtensionIV twenty = ext.createIV((Value)bfTwenty);
        twenty.setValue((BigdataValue)bfTwenty);
        NumericIV result10a_int_act = MathUtility.literalMath((Literal)zero, (Literal)ten, (MathBOp.MathOp)MathBOp.MathOp.PLUS);
        NumericIV result10b_int_act = MathUtility.literalMath((Literal)twenty, (Literal)ten, (MathBOp.MathOp)MathBOp.MathOp.MINUS);
        NumericIV result10c_int_act = MathUtility.literalMath((Literal)ten, (Literal)one, (MathBOp.MathOp)MathBOp.MathOp.MULTIPLY);
        NumericIV result10d_dec_act = MathUtility.literalMath((Literal)ten, (Literal)one, (MathBOp.MathOp)MathBOp.MathOp.DIVIDE);
        NumericIV result10e_int_act = MathUtility.literalMath((Literal)ten, (Literal)twenty, (MathBOp.MathOp)MathBOp.MathOp.MIN);
        NumericIV result10f_int_act = MathUtility.literalMath((Literal)twenty, (Literal)ten, (MathBOp.MathOp)MathBOp.MathOp.MIN);
        NumericIV result20a_int_act = MathUtility.literalMath((Literal)ten, (Literal)ten, (MathBOp.MathOp)MathBOp.MathOp.PLUS);
        NumericIV result20b_int_act = MathUtility.literalMath((Literal)ten, (Literal)twenty, (MathBOp.MathOp)MathBOp.MathOp.MAX);
        NumericIV result20c_int_act = MathUtility.literalMath((Literal)twenty, (Literal)ten, (MathBOp.MathOp)MathBOp.MathOp.MAX);
        XSDIntegerIV result10_int = new XSDIntegerIV(new BigInteger("10"));
        XSDDecimalIV result10_dec = new XSDDecimalIV(new BigDecimal(new BigInteger("10")));
        XSDIntegerIV result20_int = new XSDIntegerIV(new BigInteger("20"));
        TestPackedLongIVs.assertEquals((Object)result10_int, (Object)result10a_int_act);
        TestPackedLongIVs.assertEquals((Object)result10_int, (Object)result10b_int_act);
        TestPackedLongIVs.assertEquals((Object)result10_int, (Object)result10c_int_act);
        TestPackedLongIVs.assertEquals((Object)result10_dec, (Object)result10d_dec_act);
        TestPackedLongIVs.assertEquals((Object)result10_int, (Object)result10e_int_act);
        TestPackedLongIVs.assertEquals((Object)result10_int, (Object)result10f_int_act);
        TestPackedLongIVs.assertEquals((Object)result20_int, (Object)result20a_int_act);
        TestPackedLongIVs.assertEquals((Object)result20_int, (Object)result20b_int_act);
        TestPackedLongIVs.assertEquals((Object)result20_int, (Object)result20c_int_act);
    }
}

