/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal;

import com.bigdata.btree.keys.IKeyBuilder;
import com.bigdata.btree.keys.KeyBuilder;
import com.bigdata.rdf.internal.DTE;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.IVUtility;
import com.bigdata.rdf.internal.VTE;
import com.bigdata.rdf.internal.impl.AbstractIV;
import com.bigdata.rdf.internal.impl.TermId;
import com.bigdata.rdf.lexicon.BlobsIndexHelper;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactoryImpl;
import java.util.Random;
import junit.framework.TestCase2;

public class TestTermIV
extends TestCase2 {
    public TestTermIV() {
    }

    public TestTermIV(String name) {
        super(name);
    }

    public void test_TermIV_isNullIV() {
        TermId iv = TermId.NullIV;
        TestTermIV.assertTrue((boolean)iv.isNullIV());
        TestTermIV.assertEquals((Object)VTE.URI, (Object)iv.getVTE());
        TestTermIV.assertEquals((long)0L, (long)iv.getTermId());
        TermId fromStringIV = TermId.fromString((String)iv.toString());
        TestTermIV.assertNotSame((Object)iv, (Object)fromStringIV);
        TestTermIV.assertEquals((byte)iv.flags(), (byte)fromStringIV.flags());
        TestTermIV.assertEquals((long)iv.getTermId(), (long)fromStringIV.getTermId());
        TestTermIV.assertNull((Object)IVUtility.decode((byte[])TermId.NullIV.encode((IKeyBuilder)new KeyBuilder()).getKey()));
    }

    public void test_TermIV_isExtensionIV() {
        TermId iv = new TermId(VTE.URI, 12L);
        TestTermIV.assertEquals((Object)VTE.URI, (Object)iv.getVTE());
        TestTermIV.assertFalse((boolean)iv.isInline());
        TestTermIV.assertFalse((boolean)iv.isExtension());
        TestTermIV.assertEquals((Object)DTE.XSDBoolean, (Object)iv.getDTE());
        TestTermIV.assertEquals((long)12L, (long)iv.getTermId());
    }

    private void doTermIVTest(VTE vte, long termId) {
        KeyBuilder keyBuilder = new KeyBuilder(9);
        TermId iv = new TermId(vte, termId);
        TestTermIV.assertEquals((byte)AbstractIV.toFlags((VTE)vte, (boolean)false, (boolean)false, (DTE)DTE.XSDBoolean), (byte)iv.flags());
        TestTermIV.assertEquals((Object)vte, (Object)iv.getVTE());
        TestTermIV.assertEquals((long)termId, (long)iv.getTermId());
        TestTermIV.assertEquals((Object)iv, (Object)TermId.fromString((String)iv.toString()));
        byte[] key = iv.encode(keyBuilder.reset()).getKey();
        TermId iv2 = (TermId)IVUtility.decode((byte[])key);
        TestTermIV.assertEquals((Object)vte, (Object)iv2.getVTE());
        TestTermIV.assertEquals((long)termId, (long)iv2.getTermId());
        TestTermIV.assertEquals((Object)iv, (Object)TermId.fromString((String)iv2.toString()));
        TestTermIV.assertEquals((Object)iv, (Object)iv2);
        BigdataLiteral value = BigdataValueFactoryImpl.getInstance((String)this.getName()).createLiteral("foo");
        iv2.setValue((BigdataValue)value);
        TestTermIV.assertEquals((Object)iv, (Object)TermId.fromString((String)iv2.toString()));
    }

    public void test_TermId_URI() {
        this.doTermIVTest(VTE.URI, 12L);
    }

    public void test_TermId_Literal() {
        this.doTermIVTest(VTE.LITERAL, 12L);
    }

    public void test_TermId_BNode() {
        this.doTermIVTest(VTE.BNODE, 12L);
    }

    public void test_TermId_URI_Counter_ONE() {
        this.doTermIVTest(VTE.URI, 1L);
    }

    public void test_TermId_URI_Counter_MINUS_ONE() {
        this.doTermIVTest(VTE.URI, -1L);
    }

    public void test_TermId_URI_Counter_MIN_VALUE() {
        this.doTermIVTest(VTE.URI, Long.MIN_VALUE);
    }

    public void test_TermId_URI_Counter_MAX_VALUE() {
        this.doTermIVTest(VTE.URI, Long.MAX_VALUE);
    }

    public void test_TermId() {
        Random r = new Random();
        block8: for (VTE vte : VTE.values()) {
            long termId = r.nextLong();
            TermId v = new TermId(vte, termId);
            TestTermIV.assertFalse((boolean)v.isInline());
            TestTermIV.assertEquals((long)termId, (long)v.getTermId());
            try {
                v.getInlineValue();
                TestTermIV.fail((String)("Expecting " + UnsupportedOperationException.class));
            }
            catch (UnsupportedOperationException ex) {
                // empty catch block
            }
            byte[] key = v.encode((IKeyBuilder)new KeyBuilder()).getKey();
            IV iv2 = IVUtility.decode((byte[])key);
            TestTermIV.assertEquals((Object)v, (Object)iv2);
            TestTermIV.assertEquals((int)0, (int)v.compareTo(iv2));
            TestTermIV.assertEquals((int)0, (int)iv2.compareTo((Object)v));
            TestTermIV.assertEquals((boolean)v.isURI(), (boolean)iv2.isURI());
            TestTermIV.assertEquals((boolean)v.isLiteral(), (boolean)iv2.isLiteral());
            TestTermIV.assertEquals((boolean)v.isBNode(), (boolean)iv2.isBNode());
            TestTermIV.assertEquals((boolean)v.isStatement(), (boolean)iv2.isStatement());
            TestTermIV.assertEquals((String)("flags=" + v.flags()), (Object)vte, (Object)v.getVTE());
            switch (vte) {
                case URI: {
                    TestTermIV.assertTrue((boolean)v.isURI());
                    TestTermIV.assertFalse((boolean)v.isBNode());
                    TestTermIV.assertFalse((boolean)v.isLiteral());
                    TestTermIV.assertFalse((boolean)v.isStatement());
                    continue block8;
                }
                case BNODE: {
                    TestTermIV.assertFalse((boolean)v.isURI());
                    TestTermIV.assertTrue((boolean)v.isBNode());
                    TestTermIV.assertFalse((boolean)v.isLiteral());
                    TestTermIV.assertFalse((boolean)v.isStatement());
                    continue block8;
                }
                case LITERAL: {
                    TestTermIV.assertFalse((boolean)v.isURI());
                    TestTermIV.assertFalse((boolean)v.isBNode());
                    TestTermIV.assertTrue((boolean)v.isLiteral());
                    TestTermIV.assertFalse((boolean)v.isStatement());
                    continue block8;
                }
                case STATEMENT: {
                    TestTermIV.assertFalse((boolean)v.isURI());
                    TestTermIV.assertFalse((boolean)v.isBNode());
                    TestTermIV.assertFalse((boolean)v.isLiteral());
                    TestTermIV.assertTrue((boolean)v.isStatement());
                    continue block8;
                }
                default: {
                    TestTermIV.fail((String)("vte=" + vte));
                }
            }
        }
    }

    public void test_TermId_mockIV() {
        for (VTE vte : VTE.values()) {
            TermId v = TermId.mockIV((VTE)vte);
            TestTermIV.assertFalse((boolean)v.isInline());
            TestTermIV.assertTrue((boolean)v.isNullIV());
            TestTermIV.assertEquals((Object)vte, (Object)v.getVTE());
            TestTermIV.assertEquals((long)0L, (long)v.getTermId());
            try {
                v.getInlineValue();
                TestTermIV.fail((String)("Expecting " + UnsupportedOperationException.class));
            }
            catch (UnsupportedOperationException ex) {
                // empty catch block
            }
            byte[] key = v.encode((IKeyBuilder)new KeyBuilder()).getKey();
            IV iv2 = IVUtility.decode((byte[])key);
            TestTermIV.assertNull((Object)iv2);
            switch (vte) {
                case URI: {
                    TestTermIV.assertTrue((boolean)v.isURI());
                    TestTermIV.assertFalse((boolean)v.isBNode());
                    TestTermIV.assertFalse((boolean)v.isLiteral());
                    TestTermIV.assertFalse((boolean)v.isStatement());
                    break;
                }
                case BNODE: {
                    TestTermIV.assertFalse((boolean)v.isURI());
                    TestTermIV.assertTrue((boolean)v.isBNode());
                    TestTermIV.assertFalse((boolean)v.isLiteral());
                    TestTermIV.assertFalse((boolean)v.isStatement());
                    break;
                }
                case LITERAL: {
                    TestTermIV.assertFalse((boolean)v.isURI());
                    TestTermIV.assertFalse((boolean)v.isBNode());
                    TestTermIV.assertTrue((boolean)v.isLiteral());
                    TestTermIV.assertFalse((boolean)v.isStatement());
                    break;
                }
                case STATEMENT: {
                    TestTermIV.assertFalse((boolean)v.isURI());
                    TestTermIV.assertFalse((boolean)v.isBNode());
                    TestTermIV.assertFalse((boolean)v.isLiteral());
                    TestTermIV.assertTrue((boolean)v.isStatement());
                    break;
                }
                default: {
                    TestTermIV.fail((String)("vte=" + vte));
                }
            }
            String s = v.toString();
            TermId tmp = TermId.fromString((String)s);
            TestTermIV.assertEquals((String)s, (String)tmp.toString());
            TestTermIV.assertNotSame((Object)v, (Object)tmp);
            TestTermIV.assertEquals((byte)v.flags(), (byte)tmp.flags());
            TestTermIV.assertEquals((long)v.getTermId(), (long)tmp.getTermId());
        }
    }

    public void test_NullIV_decode_as_null_reference() {
        BlobsIndexHelper h = new BlobsIndexHelper();
        TermId iv = TermId.NullIV;
        IKeyBuilder keyBuilder = h.newKeyBuilder();
        byte[] key = IVUtility.encode((IKeyBuilder)keyBuilder, (IV)iv).getKey();
        TestTermIV.assertNull((Object)IVUtility.decode((byte[])key));
    }
}

