/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal;

import com.bigdata.btree.keys.IKeyBuilder;
import com.bigdata.rdf.internal.AbstractEncodeDecodeKeysTestCase;
import com.bigdata.rdf.internal.DTE;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.IVUtility;
import com.bigdata.rdf.internal.VTE;
import com.bigdata.rdf.internal.impl.literal.AbstractLiteralIV;
import com.bigdata.rdf.internal.impl.literal.FullyInlineTypedLiteralIV;
import com.bigdata.rdf.internal.impl.uri.URIExtensionIV;
import com.bigdata.rdf.lexicon.BlobsIndexHelper;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.vocab.BaseVocabulary;
import com.bigdata.rdf.vocab.VocabularyDecl;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import junit.framework.TestCase2;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.RDFS;

public class TestURIExtensionIV
extends TestCase2 {
    private String namespace;
    private BaseVocabulary vocab;

    public TestURIExtensionIV() {
    }

    public TestURIExtensionIV(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.namespace = this.getName();
        this.vocab = new MockVocabulary(this.namespace);
        this.vocab.init();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.vocab = null;
        this.namespace = null;
    }

    private URIExtensionIV<BigdataURI> newFixture(URI uri) {
        String namespace = uri.getNamespace();
        URIImpl namespaceURI = new URIImpl(namespace);
        IV namespaceIV = this.vocab.get((Value)namespaceURI);
        if (namespaceIV == null) {
            TestURIExtensionIV.fail((String)("Not declared by vocabulary: namespace: " + namespace));
        }
        FullyInlineTypedLiteralIV localNameIV = new FullyInlineTypedLiteralIV(uri.getLocalName());
        URIExtensionIV iv = new URIExtensionIV((AbstractLiteralIV)localNameIV, namespaceIV);
        return iv;
    }

    public void test_InlineURIIV() {
        this.doTest((URI)new URIImpl("http://www.bigdata.com/"));
        this.doTest((URI)new URIImpl("http://www.bigdata.com/foo"));
        this.doTest(RDFS.CLASS);
        this.doTest(RDFS.SUBPROPERTYOF);
        this.doTest((URI)new URIImpl("http://www.Department0.University0.edu/UndergraduateStudent488"));
        this.doTest((URI)new URIImpl("http://www.Department0.University0.edu/GraduateStudent15"));
    }

    private void doTest(URI uri) {
        URIExtensionIV<BigdataURI> iv = this.newFixture(uri);
        TestURIExtensionIV.assertEquals((Object)VTE.URI, (Object)iv.getVTE());
        TestURIExtensionIV.assertTrue((boolean)iv.isInline());
        TestURIExtensionIV.assertTrue((boolean)iv.isExtension());
        TestURIExtensionIV.assertEquals((Object)DTE.XSDString, (Object)iv.getDTE());
        BlobsIndexHelper h = new BlobsIndexHelper();
        IKeyBuilder keyBuilder = h.newKeyBuilder();
        byte[] key = IVUtility.encode((IKeyBuilder)keyBuilder, iv).getKey();
        IV actual = IVUtility.decode((byte[])key);
        TestURIExtensionIV.assertEquals(iv, (Object)actual);
        TestURIExtensionIV.assertEquals((int)key.length, (int)iv.byteLength());
        TestURIExtensionIV.assertEquals((int)key.length, (int)actual.byteLength());
    }

    public void test_encodeDecode_comparator() {
        LinkedList<URIExtensionIV<BigdataURI>> ivs = new LinkedList<URIExtensionIV<BigdataURI>>();
        ivs.add(this.newFixture((URI)new URIImpl("http://www.bigdata.com/")));
        ivs.add(this.newFixture((URI)new URIImpl("http://www.bigdata.com/foo")));
        ivs.add(this.newFixture(RDFS.CLASS));
        ivs.add(this.newFixture(RDFS.SUBPROPERTYOF));
        ivs.add(this.newFixture((URI)new URIImpl("http://www.Department0.University0.edu/UndergraduateStudent488")));
        ivs.add(this.newFixture((URI)new URIImpl("http://www.Department0.University0.edu/GraduateStudent15")));
        IV[] e = ivs.toArray(new IV[0]);
        AbstractEncodeDecodeKeysTestCase.doEncodeDecodeTest(e);
        AbstractEncodeDecodeKeysTestCase.doComparatorTest(e);
    }

    public static class MockVocabulary
    extends BaseVocabulary {
        public MockVocabulary() {
        }

        public MockVocabulary(String namespace) {
            super(namespace);
        }

        protected void addValues() {
            this.addDecl(new MockVocabularyDecl());
        }
    }

    private static class MockVocabularyDecl
    implements VocabularyDecl {
        private static final URI[] uris = new URI[]{new URIImpl("http://www.bigdata.com/"), new URIImpl("http://www.w3.org/2000/01/rdf-schema#"), new URIImpl("http://www.Department0.University0.edu/")};

        private MockVocabularyDecl() {
        }

        public Iterator<URI> values() {
            return Collections.unmodifiableList(Arrays.asList(uris)).iterator();
        }
    }
}

