/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal;

import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.TestEncodeDecodeKeys;
import com.bigdata.rdf.internal.impl.literal.XSDUnsignedByteIV;
import com.bigdata.rdf.internal.impl.literal.XSDUnsignedIntIV;
import com.bigdata.rdf.internal.impl.literal.XSDUnsignedLongIV;
import com.bigdata.rdf.internal.impl.literal.XSDUnsignedShortIV;
import java.math.BigInteger;
import junit.framework.TestCase2;

public class TestUnsignedIVs
extends TestCase2 {
    public TestUnsignedIVs() {
    }

    public TestUnsignedIVs(String name) {
        super(name);
    }

    public void test_xsd_unsignedByte() {
        XSDUnsignedByteIV MIN_VALUE = new XSDUnsignedByteIV(-128);
        XSDUnsignedByteIV MINUS_ONE = new XSDUnsignedByteIV(-1);
        XSDUnsignedByteIV ZERO = new XSDUnsignedByteIV(0);
        XSDUnsignedByteIV ONE = new XSDUnsignedByteIV(1);
        XSDUnsignedByteIV MAX_VALUE = new XSDUnsignedByteIV(127);
        TestUnsignedIVs.assertTrue((boolean)MIN_VALUE.isUnsignedNumeric());
        TestUnsignedIVs.assertEquals((short)0, (short)MIN_VALUE.promote());
        TestUnsignedIVs.assertEquals((short)127, (short)MINUS_ONE.promote());
        TestUnsignedIVs.assertEquals((short)128, (short)ZERO.promote());
        TestUnsignedIVs.assertEquals((short)129, (short)ONE.promote());
        TestUnsignedIVs.assertEquals((short)255, (short)MAX_VALUE.promote());
        TestUnsignedIVs.assertFalse((boolean)MIN_VALUE.booleanValue());
        TestUnsignedIVs.assertTrue((boolean)MINUS_ONE.booleanValue());
        TestUnsignedIVs.assertTrue((boolean)ZERO.booleanValue());
        TestUnsignedIVs.assertTrue((boolean)ONE.booleanValue());
        TestUnsignedIVs.assertTrue((boolean)MAX_VALUE.booleanValue());
        IV[] e = new IV[]{MIN_VALUE, MINUS_ONE, ZERO, ONE, MAX_VALUE};
        TestEncodeDecodeKeys.doEncodeDecodeTest(e);
        TestEncodeDecodeKeys.doComparatorTest(e);
    }

    public void test_xsd_unsignedShort() {
        XSDUnsignedShortIV MIN_VALUE = new XSDUnsignedShortIV(Short.MIN_VALUE);
        XSDUnsignedShortIV MINUS_ONE = new XSDUnsignedShortIV(-1);
        XSDUnsignedShortIV ZERO = new XSDUnsignedShortIV(0);
        XSDUnsignedShortIV ONE = new XSDUnsignedShortIV(1);
        XSDUnsignedShortIV MAX_VALUE = new XSDUnsignedShortIV(Short.MAX_VALUE);
        TestUnsignedIVs.assertTrue((boolean)MIN_VALUE.isUnsignedNumeric());
        TestUnsignedIVs.assertEquals((int)0, (int)MIN_VALUE.promote());
        TestUnsignedIVs.assertEquals((int)Short.MAX_VALUE, (int)MINUS_ONE.promote());
        TestUnsignedIVs.assertEquals((int)32768, (int)ZERO.promote());
        TestUnsignedIVs.assertEquals((int)32769, (int)ONE.promote());
        TestUnsignedIVs.assertEquals((int)65535, (int)MAX_VALUE.promote());
        TestUnsignedIVs.assertEquals((int)0, (int)MIN_VALUE.promote());
        TestUnsignedIVs.assertEquals((int)Short.MAX_VALUE, (int)MINUS_ONE.promote());
        TestUnsignedIVs.assertEquals((int)32768, (int)ZERO.promote());
        TestUnsignedIVs.assertEquals((int)32769, (int)ONE.promote());
        TestUnsignedIVs.assertEquals((int)65535, (int)MAX_VALUE.promote());
        TestUnsignedIVs.assertFalse((boolean)MIN_VALUE.booleanValue());
        TestUnsignedIVs.assertTrue((boolean)MINUS_ONE.booleanValue());
        TestUnsignedIVs.assertTrue((boolean)ZERO.booleanValue());
        TestUnsignedIVs.assertTrue((boolean)ONE.booleanValue());
        TestUnsignedIVs.assertTrue((boolean)MAX_VALUE.booleanValue());
        IV[] e = new IV[]{MIN_VALUE, MINUS_ONE, ZERO, ONE, MAX_VALUE};
        TestEncodeDecodeKeys.doEncodeDecodeTest(e);
        TestEncodeDecodeKeys.doComparatorTest(e);
    }

    public void test_xsd_unsignedInt() {
        XSDUnsignedIntIV MIN_VALUE = new XSDUnsignedIntIV(Integer.MIN_VALUE);
        XSDUnsignedIntIV MINUS_ONE = new XSDUnsignedIntIV(-1);
        XSDUnsignedIntIV ZERO = new XSDUnsignedIntIV(0);
        XSDUnsignedIntIV ONE = new XSDUnsignedIntIV(1);
        XSDUnsignedIntIV MAX_VALUE = new XSDUnsignedIntIV(Integer.MAX_VALUE);
        TestUnsignedIVs.assertTrue((boolean)MIN_VALUE.isUnsignedNumeric());
        TestUnsignedIVs.assertEquals((long)0L, (long)MIN_VALUE.promote());
        TestUnsignedIVs.assertEquals((long)Integer.MAX_VALUE, (long)MINUS_ONE.promote());
        TestUnsignedIVs.assertEquals((long)0x80000000L, (long)ZERO.promote());
        TestUnsignedIVs.assertEquals((long)0x80000001L, (long)ONE.promote());
        TestUnsignedIVs.assertEquals((long)0xFFFFFFFFL, (long)MAX_VALUE.promote());
        TestUnsignedIVs.assertEquals((long)0L, (long)MIN_VALUE.promote());
        TestUnsignedIVs.assertEquals((long)Integer.MAX_VALUE, (long)MINUS_ONE.promote());
        TestUnsignedIVs.assertEquals((long)0x80000000L, (long)ZERO.promote());
        TestUnsignedIVs.assertEquals((long)0x80000001L, (long)ONE.promote());
        TestUnsignedIVs.assertEquals((long)0xFFFFFFFFL, (long)MAX_VALUE.promote());
        TestUnsignedIVs.assertFalse((boolean)MIN_VALUE.booleanValue());
        TestUnsignedIVs.assertTrue((boolean)MINUS_ONE.booleanValue());
        TestUnsignedIVs.assertTrue((boolean)ZERO.booleanValue());
        TestUnsignedIVs.assertTrue((boolean)ONE.booleanValue());
        TestUnsignedIVs.assertTrue((boolean)MAX_VALUE.booleanValue());
        IV[] e = new IV[]{MIN_VALUE, MINUS_ONE, ZERO, ONE, MAX_VALUE};
        TestEncodeDecodeKeys.doEncodeDecodeTest(e);
        TestEncodeDecodeKeys.doComparatorTest(e);
    }

    public void test_xsd_unsignedLong() {
        XSDUnsignedLongIV MIN_VALUE = new XSDUnsignedLongIV(Long.MIN_VALUE);
        XSDUnsignedLongIV MINUS_ONE = new XSDUnsignedLongIV(-1L);
        XSDUnsignedLongIV ZERO = new XSDUnsignedLongIV(0L);
        XSDUnsignedLongIV ONE = new XSDUnsignedLongIV(1L);
        XSDUnsignedLongIV MAX_VALUE = new XSDUnsignedLongIV(Long.MAX_VALUE);
        TestUnsignedIVs.assertTrue((boolean)MIN_VALUE.isUnsignedNumeric());
        BigInteger adjust = BigInteger.valueOf(Long.MIN_VALUE).negate();
        TestUnsignedIVs.assertEquals((Object)BigInteger.valueOf(0L), (Object)MIN_VALUE.promote());
        TestUnsignedIVs.assertEquals((Object)BigInteger.valueOf(-1L).add(adjust), (Object)MINUS_ONE.promote());
        TestUnsignedIVs.assertEquals((Object)adjust, (Object)ZERO.promote());
        TestUnsignedIVs.assertEquals((Object)BigInteger.valueOf(1L).add(adjust), (Object)ONE.promote());
        TestUnsignedIVs.assertEquals((Object)BigInteger.valueOf(Long.MAX_VALUE).add(adjust), (Object)MAX_VALUE.promote());
        TestUnsignedIVs.assertFalse((boolean)MIN_VALUE.booleanValue());
        TestUnsignedIVs.assertTrue((boolean)MINUS_ONE.booleanValue());
        TestUnsignedIVs.assertTrue((boolean)ZERO.booleanValue());
        TestUnsignedIVs.assertTrue((boolean)ONE.booleanValue());
        TestUnsignedIVs.assertTrue((boolean)MAX_VALUE.booleanValue());
        IV[] e = new IV[]{MIN_VALUE, MINUS_ONE, ZERO, ONE, MAX_VALUE};
        TestEncodeDecodeKeys.doEncodeDecodeTest(e);
        TestEncodeDecodeKeys.doComparatorTest(e);
    }
}

