/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal;

import com.bigdata.service.geospatial.ZOrderRangeScanUtil;
import junit.framework.TestCase2;

public class TestZOrderRangeScanUtility
extends TestCase2 {
    public void testBigMinCalculation2Dim() {
        byte[] searchMinZOrder = new byte[]{Byte.valueOf("00001100", 2)};
        byte[] searchMaxZOrder = new byte[]{Byte.valueOf("00101101", 2)};
        ZOrderRangeScanUtil rangeScanUtil = new ZOrderRangeScanUtil(searchMinZOrder, searchMaxZOrder, 2);
        byte[] divRecord1 = new byte[]{Byte.valueOf("00010011", 2)};
        byte[] bigMinExp1 = new byte[]{Byte.valueOf("00100100", 2)};
        byte[] bigMinAct1 = rangeScanUtil.calculateBigMin(divRecord1);
        TestZOrderRangeScanUtility.assertEquals((byte[])bigMinExp1, (byte[])bigMinAct1);
        TestZOrderRangeScanUtility.assertFalse((boolean)rangeScanUtil.isInSearchRange(divRecord1));
        TestZOrderRangeScanUtility.assertTrue((boolean)rangeScanUtil.isInSearchRange(bigMinAct1));
        byte[] divRecord2 = new byte[]{Byte.valueOf("00100000", 2)};
        byte[] bigMinExp2 = new byte[]{Byte.valueOf("00100100", 2)};
        byte[] bigMinAct2 = rangeScanUtil.calculateBigMin(divRecord2);
        TestZOrderRangeScanUtility.assertEquals((byte[])bigMinExp2, (byte[])bigMinAct2);
        TestZOrderRangeScanUtility.assertFalse((boolean)rangeScanUtil.isInSearchRange(divRecord2));
        TestZOrderRangeScanUtility.assertTrue((boolean)rangeScanUtil.isInSearchRange(bigMinAct2));
        byte[] divRecord3 = new byte[]{Byte.valueOf("00011111", 2)};
        byte[] bigMinExp3 = new byte[]{Byte.valueOf("00100100", 2)};
        byte[] bigMinAct3 = rangeScanUtil.calculateBigMin(divRecord3);
        TestZOrderRangeScanUtility.assertEquals((byte[])bigMinExp3, (byte[])bigMinAct3);
        TestZOrderRangeScanUtility.assertFalse((boolean)rangeScanUtil.isInSearchRange(divRecord3));
        TestZOrderRangeScanUtility.assertTrue((boolean)rangeScanUtil.isInSearchRange(bigMinAct3));
        byte[] divRecord4 = new byte[]{Byte.valueOf("00100011", 2)};
        byte[] bigMinExp4 = new byte[]{Byte.valueOf("00100100", 2)};
        byte[] bigMinAct4 = rangeScanUtil.calculateBigMin(divRecord4);
        TestZOrderRangeScanUtility.assertEquals((byte[])bigMinExp4, (byte[])bigMinAct4);
        TestZOrderRangeScanUtility.assertFalse((boolean)rangeScanUtil.isInSearchRange(divRecord4));
        TestZOrderRangeScanUtility.assertTrue((boolean)rangeScanUtil.isInSearchRange(bigMinAct4));
        byte[] divRecord5 = new byte[]{Byte.valueOf("00101000", 2)};
        byte[] bigMinExp5 = new byte[]{Byte.valueOf("00101100", 2)};
        byte[] bigMinAct5 = rangeScanUtil.calculateBigMin(divRecord5);
        TestZOrderRangeScanUtility.assertEquals((byte[])bigMinExp5, (byte[])bigMinAct5);
        TestZOrderRangeScanUtility.assertFalse((boolean)rangeScanUtil.isInSearchRange(divRecord5));
        TestZOrderRangeScanUtility.assertTrue((boolean)rangeScanUtil.isInSearchRange(bigMinAct5));
        byte[] divRecord6 = new byte[]{Byte.valueOf("00101001", 2)};
        byte[] bigMinExp6 = new byte[]{Byte.valueOf("00101100", 2)};
        byte[] bigMinAct6 = rangeScanUtil.calculateBigMin(divRecord6);
        TestZOrderRangeScanUtility.assertEquals((byte[])bigMinExp6, (byte[])bigMinAct6);
        TestZOrderRangeScanUtility.assertFalse((boolean)rangeScanUtil.isInSearchRange(divRecord6));
        TestZOrderRangeScanUtility.assertTrue((boolean)rangeScanUtil.isInSearchRange(bigMinAct6));
        byte[] divRecord7 = new byte[]{Byte.valueOf("00101010", 2)};
        byte[] bigMinExp7 = new byte[]{Byte.valueOf("00101100", 2)};
        byte[] bigMinAct7 = rangeScanUtil.calculateBigMin(divRecord7);
        TestZOrderRangeScanUtility.assertEquals((byte[])bigMinExp7, (byte[])bigMinAct7);
        TestZOrderRangeScanUtility.assertFalse((boolean)rangeScanUtil.isInSearchRange(divRecord7));
        TestZOrderRangeScanUtility.assertTrue((boolean)rangeScanUtil.isInSearchRange(bigMinAct7));
        byte[] divRecord8 = new byte[]{Byte.valueOf("00101011", 2)};
        byte[] bigMinExp8 = new byte[]{Byte.valueOf("00101100", 2)};
        byte[] bigMinAct8 = rangeScanUtil.calculateBigMin(divRecord8);
        TestZOrderRangeScanUtility.assertEquals((byte[])bigMinExp8, (byte[])bigMinAct8);
        TestZOrderRangeScanUtility.assertFalse((boolean)rangeScanUtil.isInSearchRange(divRecord8));
        TestZOrderRangeScanUtility.assertTrue((boolean)rangeScanUtil.isInSearchRange(bigMinAct8));
    }

    public void testBigMinCalculation3Dim() {
        byte[] searchMinZOrder = new byte[]{Byte.valueOf("00000000", 2), Byte.valueOf("00000000", 2), Byte.valueOf("00010011", 2)};
        byte[] searchMaxZOrder = new byte[]{Byte.valueOf("00000000", 2), Byte.valueOf("00000000", 2), Byte.valueOf("00010111", 2)};
        ZOrderRangeScanUtil rangeScanUtil = new ZOrderRangeScanUtil(searchMinZOrder, searchMaxZOrder, 3);
        byte[] dividingRecord = new byte[]{Byte.valueOf("00000000", 2), Byte.valueOf("00000000", 2), Byte.valueOf("00010101", 2)};
        TestZOrderRangeScanUtility.assertFalse((boolean)rangeScanUtil.isInSearchRange(dividingRecord));
        byte[] bigMinAct = rangeScanUtil.calculateBigMin(dividingRecord);
        TestZOrderRangeScanUtility.assertTrue((boolean)rangeScanUtil.isInSearchRange(bigMinAct));
        TestZOrderRangeScanUtility.assertEquals((byte[])searchMaxZOrder, (byte[])bigMinAct);
    }

    public void testLoadFunction() {
        byte[] testByteArray1 = new byte[]{Byte.valueOf("00000000", 2), Byte.valueOf("01111111", 2), Byte.valueOf("01111111", 2)};
        ZOrderRangeScanUtil.load((boolean)true, (int)2, (byte[])testByteArray1, (int)2);
        byte[] exp1 = new byte[]{Byte.valueOf("00100000", 2), Byte.valueOf("01010101", 2), Byte.valueOf("01010101", 2)};
        TestZOrderRangeScanUtility.assertEquals((byte[])testByteArray1, (byte[])exp1);
        byte[] testByteArray2 = new byte[]{Byte.valueOf("00100000", 2), Byte.valueOf("01111111", 2), Byte.valueOf("00000000", 2)};
        ZOrderRangeScanUtil.load((boolean)false, (int)11, (byte[])testByteArray2, (int)2);
        byte[] exp2 = new byte[]{Byte.valueOf("00100000", 2), Byte.valueOf("01101111", 2), Byte.valueOf("01010101", 2)};
        TestZOrderRangeScanUtility.assertEquals((byte[])testByteArray2, (byte[])exp2);
        byte[] testByteArray3 = new byte[]{Byte.valueOf("00000000", 2), Byte.valueOf("01111111", 2), Byte.valueOf("01111111", 2)};
        ZOrderRangeScanUtil.load((boolean)true, (int)5, (byte[])testByteArray3, (int)3);
        byte[] exp3 = new byte[]{Byte.valueOf("00000100", 2), Byte.valueOf("01101101", 2), Byte.valueOf("00110110", 2)};
        TestZOrderRangeScanUtility.assertEquals((byte[])testByteArray3, (byte[])exp3);
    }
}

