/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal.encoder;

import com.bigdata.bop.Constant;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.Var;
import com.bigdata.bop.bindingSet.ListBindingSet;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.InlineLiteralIV;
import com.bigdata.rdf.internal.VTE;
import com.bigdata.rdf.internal.XSD;
import com.bigdata.rdf.internal.encoder.IBindingSetDecoder;
import com.bigdata.rdf.internal.encoder.IBindingSetEncoder;
import com.bigdata.rdf.internal.impl.BlobIV;
import com.bigdata.rdf.internal.impl.TermId;
import com.bigdata.rdf.internal.impl.literal.FullyInlineTypedLiteralIV;
import com.bigdata.rdf.internal.impl.literal.IPv4AddrIV;
import com.bigdata.rdf.internal.impl.literal.LiteralArrayIV;
import com.bigdata.rdf.internal.impl.literal.LiteralExtensionIV;
import com.bigdata.rdf.internal.impl.literal.PackedLongIV;
import com.bigdata.rdf.internal.impl.literal.UUIDLiteralIV;
import com.bigdata.rdf.internal.impl.literal.XSDBooleanIV;
import com.bigdata.rdf.internal.impl.literal.XSDDecimalIV;
import com.bigdata.rdf.internal.impl.literal.XSDIntegerIV;
import com.bigdata.rdf.internal.impl.literal.XSDNumericIV;
import com.bigdata.rdf.internal.impl.literal.XSDUnsignedByteIV;
import com.bigdata.rdf.internal.impl.literal.XSDUnsignedIntIV;
import com.bigdata.rdf.internal.impl.literal.XSDUnsignedLongIV;
import com.bigdata.rdf.internal.impl.literal.XSDUnsignedShortIV;
import com.bigdata.rdf.internal.impl.uri.FullyInlineURIIV;
import com.bigdata.rdf.internal.impl.uri.URIExtensionIV;
import com.bigdata.rdf.internal.impl.uri.VocabURIByteIV;
import com.bigdata.rdf.internal.impl.uri.VocabURIShortIV;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.model.BigdataValueFactoryImpl;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import junit.framework.TestCase2;
import org.openrdf.model.URI;
import org.openrdf.model.impl.URIImpl;

public abstract class AbstractBindingSetEncoderTestCase
extends TestCase2 {
    protected boolean testCache = true;
    protected String namespace = this.getName();
    protected BigdataValueFactory valueFactory = BigdataValueFactoryImpl.getInstance((String)this.namespace);
    protected TermId<BigdataLiteral> termId;
    protected TermId<BigdataLiteral> termId2;
    protected BlobIV<BigdataLiteral> blobIV;
    protected TermId<BigdataValue> mockIV1;
    protected TermId<BigdataValue> mockIV2;
    protected TermId<BigdataValue> mockIV3;
    protected TermId<BigdataValue> mockIVCarryingUri;
    protected TermId<BigdataValue> mockIVCarryingBNode;
    protected XSDIntegerIV<BigdataLiteral> inlineIV1;
    protected XSDDecimalIV<BigdataLiteral> inlineIV2;
    protected XSDNumericIV<BigdataLiteral> inlineIV3;
    protected XSDBooleanIV<?> inlineIV4;
    protected FullyInlineTypedLiteralIV<BigdataLiteral> fullyInlinedTypedLiteralIV;
    protected IPv4AddrIV<BigdataLiteral> ipV4AddrIv;
    protected LiteralArrayIV literalArrayIV;
    protected PackedLongIV<BigdataLiteral> packedLongIV;
    protected UUIDLiteralIV<BigdataLiteral> uuidLiteralIV;
    protected XSDUnsignedByteIV<BigdataLiteral> unsignedByteIV;
    protected XSDUnsignedIntIV<BigdataLiteral> unsignedIntIV;
    protected XSDUnsignedLongIV<BigdataLiteral> unsignedLongIV;
    protected XSDUnsignedShortIV<BigdataLiteral> unsignedShortIV;
    protected FullyInlineURIIV<BigdataURI> fullyInlineUriIV;
    protected LiteralExtensionIV<BigdataLiteral> literalExtensionIV;
    protected URIExtensionIV<?> uriExtensionIV;
    protected VocabURIByteIV<BigdataURI> vocabUriByteIV;
    protected VocabURIShortIV<BigdataURI> vocabUriShortIV;
    protected IBindingSetEncoder encoder;
    protected IBindingSetDecoder decoder;

    public AbstractBindingSetEncoderTestCase() {
    }

    public AbstractBindingSetEncoderTestCase(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.termId = new TermId(VTE.LITERAL, 12L);
        this.termId.setValue((BigdataValue)this.valueFactory.createLiteral("abc"));
        this.termId2 = new TermId(VTE.LITERAL, 36L);
        this.termId2.setValue((BigdataValue)this.valueFactory.createLiteral("xyz"));
        this.blobIV = new BlobIV(VTE.LITERAL, 912, 0);
        this.blobIV.setValue((BigdataValue)this.valueFactory.createLiteral("bigfoo"));
        this.mockIV1 = TermId.mockIV((VTE)VTE.LITERAL);
        this.mockIV1.setValue((BigdataValue)this.valueFactory.createLiteral("red"));
        this.mockIV2 = TermId.mockIV((VTE)VTE.LITERAL);
        this.mockIV2.setValue((BigdataValue)this.valueFactory.createLiteral("blue"));
        this.mockIV3 = TermId.mockIV((VTE)VTE.LITERAL);
        this.mockIV3.setValue((BigdataValue)this.valueFactory.createLiteral("green"));
        this.mockIVCarryingUri = TermId.mockIV((VTE)VTE.URI);
        this.mockIVCarryingUri.setValue((BigdataValue)this.valueFactory.createURI("http://green.as.uri"));
        this.mockIVCarryingBNode = TermId.mockIV((VTE)VTE.BNODE);
        this.mockIVCarryingBNode.setValue((BigdataValue)this.valueFactory.createBNode("_:green_as_bnode"));
        this.inlineIV1 = new XSDIntegerIV(BigInteger.valueOf(100L));
        this.inlineIV1.setValue((BigdataValue)this.valueFactory.createLiteral("100", XSD.INTEGER));
        this.inlineIV2 = new XSDDecimalIV(BigDecimal.valueOf(100L));
        this.inlineIV2.setValue((BigdataValue)this.valueFactory.createLiteral("100.0", XSD.DOUBLE));
        this.inlineIV3 = new XSDNumericIV(2);
        this.inlineIV3.setValue((BigdataValue)this.valueFactory.createLiteral("2", XSD.SHORT));
        this.inlineIV4 = XSDBooleanIV.valueOf((boolean)true);
        this.fullyInlinedTypedLiteralIV = new FullyInlineTypedLiteralIV("Test 123", null, null);
        this.ipV4AddrIv = new IPv4AddrIV("127.0.0.1");
        this.literalArrayIV = new LiteralArrayIV(new InlineLiteralIV[]{this.inlineIV1, this.inlineIV2, this.inlineIV3});
        this.packedLongIV = new PackedLongIV(7736464L);
        this.uuidLiteralIV = new UUIDLiteralIV(UUID.randomUUID());
        this.unsignedByteIV = new XSDUnsignedByteIV(3);
        this.unsignedIntIV = new XSDUnsignedIntIV(23);
        this.unsignedLongIV = new XSDUnsignedLongIV(37747583929L);
        this.unsignedShortIV = new XSDUnsignedShortIV(5);
        this.fullyInlineUriIV = new FullyInlineURIIV((URI)new URIImpl("http://my.random.datatype"));
        this.literalExtensionIV = new LiteralExtensionIV(this.inlineIV1, this.fullyInlineUriIV);
        this.literalExtensionIV.setValue((BigdataValue)this.valueFactory.createLiteral("some dummy value"));
        this.uriExtensionIV = new URIExtensionIV(this.fullyInlinedTypedLiteralIV, this.fullyInlineUriIV);
        this.vocabUriByteIV = new VocabURIByteIV(3);
        this.vocabUriByteIV.setValue((BigdataValue)this.valueFactory.createURI("http://some.vocab.item1"));
        this.vocabUriShortIV = new VocabURIShortIV(4);
        this.vocabUriShortIV.setValue((BigdataValue)this.valueFactory.createURI("http://some.vocab.item2"));
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.encoder.release();
        this.encoder = null;
        this.decoder.release();
        this.decoder = null;
        this.valueFactory.remove();
        this.valueFactory = null;
        this.namespace = null;
        this.termId2 = null;
        this.termId = null;
        this.blobIV = null;
        this.mockIV3 = null;
        this.mockIV2 = null;
        this.mockIV1 = null;
        this.inlineIV1 = null;
        this.inlineIV2 = null;
        this.inlineIV3 = null;
        this.inlineIV4 = null;
        this.fullyInlinedTypedLiteralIV = null;
        this.ipV4AddrIv = null;
        this.literalArrayIV = null;
        this.packedLongIV = null;
        this.uuidLiteralIV = null;
        this.unsignedByteIV = null;
        this.unsignedIntIV = null;
        this.unsignedLongIV = null;
        this.unsignedShortIV = null;
        this.fullyInlineUriIV = null;
        this.literalExtensionIV = null;
        this.uriExtensionIV = null;
        this.vocabUriByteIV = null;
        this.vocabUriShortIV = null;
    }

    protected IBindingSet doEncodeDecodeTest(IBindingSet expected) {
        return this.doEncodeDecodeTest(expected, this.testCache);
    }

    protected IBindingSet doEncodeDecodeTest(IBindingSet expected, boolean testCache) {
        byte[] data = this.encoder.encodeSolution(expected);
        this.encoder.flush();
        Random r = new Random();
        if (r.nextBoolean()) {
            IBindingSet actual = this.decoder.decodeSolution(data, 0, data.length, true);
            this.assertEquals(expected, actual, testCache);
            return actual;
        }
        int off2 = r.nextInt(20) + 1;
        byte[] data2 = new byte[data.length + off2];
        System.arraycopy(data, 0, data2, off2, data.length);
        IBindingSet actual2 = this.decoder.decodeSolution(data2, off2, data.length, true);
        this.assertEquals(expected, actual2, testCache);
        return actual2;
    }

    protected void assertEquals(IBindingSet expected, IBindingSet actual, boolean testCache) {
        TestCase2.assertEquals((Object)expected, (Object)actual);
        if (!testCache) {
            return;
        }
        for (Map.Entry e : expected) {
            IConstant c = (IConstant)e.getValue();
            IV iv = (IV)c.get();
            if (!iv.hasValue() || !iv.needsMaterialization()) continue;
            IVariable var = (IVariable)e.getKey();
            IConstant c2 = actual.get(var);
            AbstractBindingSetEncoderTestCase.assertNotNull((Object)c2);
            IV iv2 = (IV)c2.get();
            AbstractBindingSetEncoderTestCase.assertEquals((Object)iv, (Object)iv2);
            if (!iv2.hasValue()) {
                AbstractBindingSetEncoderTestCase.fail((String)("IVCache not set on decode: " + iv));
            }
            AbstractBindingSetEncoderTestCase.assertEquals((Object)iv.getValue(), (Object)iv2.getValue());
        }
    }

    public void test_encodeEmpty() {
        ListBindingSet expected = new ListBindingSet();
        this.doEncodeDecodeTest((IBindingSet)expected);
    }

    public void test_encodeNonEmpty() {
        ListBindingSet expected = new ListBindingSet();
        expected.set((IVariable)Var.var((String)"x"), (IConstant)new Constant((Object)new XSDNumericIV(12)));
        this.doEncodeDecodeTest((IBindingSet)expected);
    }

    public void test_encodeNonEmpty2() {
        ListBindingSet expected = new ListBindingSet();
        expected.set((IVariable)Var.var((String)"x"), (IConstant)new Constant((Object)new XSDNumericIV(12)));
        expected.set((IVariable)Var.var((String)"y"), (IConstant)new Constant((Object)new FullyInlineURIIV((URI)new URIImpl("http://www.bigdata.com"))));
        this.doEncodeDecodeTest((IBindingSet)expected);
    }

    public void test_multipleSolutions() {
        ListBindingSet expected = new ListBindingSet();
        expected.set((IVariable)Var.var((String)"x"), (IConstant)new Constant((Object)new XSDNumericIV(12)));
        expected.set((IVariable)Var.var((String)"y"), (IConstant)new Constant((Object)new FullyInlineURIIV((URI)new URIImpl("http://www.bigdata.com"))));
        this.doEncodeDecodeTest((IBindingSet)expected);
        expected = new ListBindingSet();
        expected.set((IVariable)Var.var((String)"x"), (IConstant)new Constant((Object)new XSDNumericIV(99)));
        this.doEncodeDecodeTest((IBindingSet)expected);
    }

    public void test_multipleSolutions2() {
        ListBindingSet expected = new ListBindingSet();
        expected.set((IVariable)Var.var((String)"x"), (IConstant)new Constant((Object)new XSDNumericIV(12)));
        this.doEncodeDecodeTest((IBindingSet)expected);
        expected = new ListBindingSet();
        expected.set((IVariable)Var.var((String)"x"), (IConstant)new Constant((Object)new XSDNumericIV(99)));
        expected.set((IVariable)Var.var((String)"y"), (IConstant)new Constant((Object)new FullyInlineURIIV((URI)new URIImpl("http://www.bigdata.com"))));
        this.doEncodeDecodeTest((IBindingSet)expected);
    }

    public void test_multipleSolutions3() {
        ListBindingSet expected = new ListBindingSet();
        expected.set((IVariable)Var.var((String)"x"), (IConstant)new Constant((Object)new XSDNumericIV(12)));
        this.doEncodeDecodeTest((IBindingSet)expected);
        expected = new ListBindingSet();
        this.doEncodeDecodeTest((IBindingSet)expected);
        expected = new ListBindingSet();
        expected.set((IVariable)Var.var((String)"x"), (IConstant)new Constant((Object)new XSDNumericIV(99)));
        expected.set((IVariable)Var.var((String)"y"), (IConstant)new Constant((Object)new FullyInlineURIIV((URI)new URIImpl("http://www.bigdata.com"))));
        this.doEncodeDecodeTest((IBindingSet)expected);
    }

    public void test_multipleSolutions4() {
        ListBindingSet expected = new ListBindingSet();
        this.doEncodeDecodeTest((IBindingSet)expected);
        expected = new ListBindingSet();
        expected.set((IVariable)Var.var((String)"x"), (IConstant)new Constant((Object)new XSDNumericIV(12)));
        this.doEncodeDecodeTest((IBindingSet)expected);
        expected = new ListBindingSet();
        expected.set((IVariable)Var.var((String)"x"), (IConstant)new Constant((Object)new XSDNumericIV(99)));
        expected.set((IVariable)Var.var((String)"y"), (IConstant)new Constant((Object)new FullyInlineURIIV((URI)new URIImpl("http://www.bigdata.com"))));
        this.doEncodeDecodeTest((IBindingSet)expected);
    }

    public void test_multipleSolutions5() {
        ListBindingSet expected = new ListBindingSet();
        expected.set((IVariable)Var.var((String)"x"), (IConstant)new Constant((Object)new XSDNumericIV(12)));
        this.doEncodeDecodeTest((IBindingSet)expected);
        expected = new ListBindingSet();
        expected.set((IVariable)Var.var((String)"x"), (IConstant)new Constant((Object)new XSDNumericIV(99)));
        expected.set((IVariable)Var.var((String)"y"), (IConstant)new Constant((Object)new FullyInlineURIIV((URI)new URIImpl("http://www.bigdata.com"))));
        this.doEncodeDecodeTest((IBindingSet)expected);
        expected = new ListBindingSet();
        this.doEncodeDecodeTest((IBindingSet)expected);
    }

    public void test_encodeNonEmptyWithCachedValue() {
        ListBindingSet expected = new ListBindingSet();
        expected.set((IVariable)Var.var((String)"x"), (IConstant)new Constant(this.termId));
        this.doEncodeDecodeTest((IBindingSet)expected);
    }

    public void test_encodeNonEmptyWithCachedValues() {
        ListBindingSet expected = new ListBindingSet();
        expected.set((IVariable)Var.var((String)"x"), (IConstant)new Constant(this.termId));
        expected.set((IVariable)Var.var((String)"y"), (IConstant)new Constant(this.blobIV));
        this.doEncodeDecodeTest((IBindingSet)expected);
    }

    public void test_encodeNonEmptyWithCachedValuesAndInlineValues() {
        ListBindingSet expected = new ListBindingSet();
        expected.set((IVariable)Var.var((String)"x"), (IConstant)new Constant(this.termId));
        expected.set((IVariable)Var.var((String)"y"), (IConstant)new Constant(this.inlineIV1));
        expected.set((IVariable)Var.var((String)"z"), (IConstant)new Constant(this.inlineIV2));
        this.doEncodeDecodeTest((IBindingSet)expected);
    }

    public void test_encodeNonEmptyWithCachedValuesAndInlineValues2() {
        ListBindingSet expected = new ListBindingSet();
        expected.set((IVariable)Var.var((String)"x"), (IConstant)new Constant(this.termId));
        expected.set((IVariable)Var.var((String)"y"), (IConstant)new Constant(this.inlineIV2));
        this.doEncodeDecodeTest((IBindingSet)expected);
    }

    public void test_multipleSolutionsWithCachedValues() {
        ListBindingSet expected = new ListBindingSet();
        expected.set((IVariable)Var.var((String)"x"), (IConstant)new Constant(this.termId));
        expected.set((IVariable)Var.var((String)"y"), (IConstant)new Constant(this.blobIV));
        this.doEncodeDecodeTest((IBindingSet)expected);
        expected = new ListBindingSet();
        expected.set((IVariable)Var.var((String)"x"), (IConstant)new Constant(this.termId));
        this.doEncodeDecodeTest((IBindingSet)expected);
    }

    public void test_multipleSolutionsWithCachedValues2() {
        ListBindingSet expected = new ListBindingSet();
        expected.set((IVariable)Var.var((String)"x"), (IConstant)new Constant(this.termId));
        this.doEncodeDecodeTest((IBindingSet)expected);
        expected = new ListBindingSet();
        expected.set((IVariable)Var.var((String)"x"), (IConstant)new Constant(this.termId));
        expected.set((IVariable)Var.var((String)"y"), (IConstant)new Constant(this.blobIV));
        this.doEncodeDecodeTest((IBindingSet)expected);
    }

    public void test_multipleSolutionsWithCachedValues3() {
        ListBindingSet expected = new ListBindingSet();
        expected.set((IVariable)Var.var((String)"x"), (IConstant)new Constant(this.termId));
        this.doEncodeDecodeTest((IBindingSet)expected);
        expected = new ListBindingSet();
        this.doEncodeDecodeTest((IBindingSet)expected);
        expected = new ListBindingSet();
        expected.set((IVariable)Var.var((String)"x"), (IConstant)new Constant(this.termId));
        expected.set((IVariable)Var.var((String)"y"), (IConstant)new Constant(this.blobIV));
        this.doEncodeDecodeTest((IBindingSet)expected);
    }

    public void test_multipleSolutionsWithCachedValue4() {
        ListBindingSet expected = new ListBindingSet();
        this.doEncodeDecodeTest((IBindingSet)expected);
        expected = new ListBindingSet();
        expected.set((IVariable)Var.var((String)"x"), (IConstant)new Constant(this.termId));
        this.doEncodeDecodeTest((IBindingSet)expected);
        expected = new ListBindingSet();
        expected.set((IVariable)Var.var((String)"x"), (IConstant)new Constant(this.termId));
        expected.set((IVariable)Var.var((String)"y"), (IConstant)new Constant(this.blobIV));
        this.doEncodeDecodeTest((IBindingSet)expected);
    }

    public void test_multipleSolutionsWithCachedValue5() {
        ListBindingSet expected = new ListBindingSet();
        expected.set((IVariable)Var.var((String)"x"), (IConstant)new Constant(this.termId));
        this.doEncodeDecodeTest((IBindingSet)expected);
        expected = new ListBindingSet();
        expected.set((IVariable)Var.var((String)"x"), (IConstant)new Constant(this.termId));
        expected.set((IVariable)Var.var((String)"y"), (IConstant)new Constant(this.blobIV));
        this.doEncodeDecodeTest((IBindingSet)expected);
        expected = new ListBindingSet();
        this.doEncodeDecodeTest((IBindingSet)expected);
    }

    public void test_solutionWithThreeBindings1() {
        ListBindingSet expected = new ListBindingSet();
        expected.set((IVariable)Var.var((String)"x"), (IConstant)new Constant(this.termId2));
        expected.set((IVariable)Var.var((String)"y"), (IConstant)new Constant(this.blobIV));
        expected.set((IVariable)Var.var((String)"z"), (IConstant)new Constant(this.termId));
        this.doEncodeDecodeTest((IBindingSet)expected);
    }

    public void test_solutionWithThreeBindingsSomeNotCached1() {
        TermId termIdNoCache = new TermId(VTE.LITERAL, 912L);
        ListBindingSet expected = new ListBindingSet();
        expected.set((IVariable)Var.var((String)"y"), (IConstant)new Constant((Object)termIdNoCache));
        expected.set((IVariable)Var.var((String)"x"), (IConstant)new Constant(this.termId2));
        expected.set((IVariable)Var.var((String)"z"), (IConstant)new Constant(this.termId));
        this.doEncodeDecodeTest((IBindingSet)expected);
        expected = new ListBindingSet();
        expected.set((IVariable)Var.var((String)"x"), (IConstant)new Constant(this.termId2));
        expected.set((IVariable)Var.var((String)"y"), (IConstant)new Constant((Object)termIdNoCache));
        expected.set((IVariable)Var.var((String)"z"), (IConstant)new Constant(this.termId));
        this.doEncodeDecodeTest((IBindingSet)expected);
        expected = new ListBindingSet();
        expected.set((IVariable)Var.var((String)"z"), (IConstant)new Constant(this.termId));
        expected.set((IVariable)Var.var((String)"x"), (IConstant)new Constant(this.termId2));
        expected.set((IVariable)Var.var((String)"y"), (IConstant)new Constant((Object)termIdNoCache));
        this.doEncodeDecodeTest((IBindingSet)expected);
    }

    public void test_solutionWithThreeBindingsSomeNotCachedSomeInline() {
        TermId termIdNoCache = new TermId(VTE.LITERAL, 912L);
        ListBindingSet expected = new ListBindingSet();
        expected.set((IVariable)Var.var((String)"y"), (IConstant)new Constant((Object)termIdNoCache));
        expected.set((IVariable)Var.var((String)"x"), (IConstant)new Constant(this.inlineIV1));
        expected.set((IVariable)Var.var((String)"z"), (IConstant)new Constant(this.termId));
        this.doEncodeDecodeTest((IBindingSet)expected);
        expected = new ListBindingSet();
        expected.set((IVariable)Var.var((String)"x"), (IConstant)new Constant(this.termId2));
        expected.set((IVariable)Var.var((String)"y"), (IConstant)new Constant((Object)termIdNoCache));
        expected.set((IVariable)Var.var((String)"z"), (IConstant)new Constant(this.inlineIV2));
        this.doEncodeDecodeTest((IBindingSet)expected);
        expected = new ListBindingSet();
        expected.set((IVariable)Var.var((String)"z"), (IConstant)new Constant(this.termId));
        expected.set((IVariable)Var.var((String)"x"), (IConstant)new Constant(this.inlineIV2));
        expected.set((IVariable)Var.var((String)"y"), (IConstant)new Constant((Object)termIdNoCache));
        this.doEncodeDecodeTest((IBindingSet)expected);
        expected = new ListBindingSet();
        expected.set((IVariable)Var.var((String)"z2"), (IConstant)new Constant(this.inlineIV2));
        expected.set((IVariable)Var.var((String)"z3"), (IConstant)new Constant(this.inlineIV3));
        expected.set((IVariable)Var.var((String)"z4"), (IConstant)new Constant(this.inlineIV4));
        this.doEncodeDecodeTest((IBindingSet)expected);
    }

    public void test_solutionWithThreeBindings2() {
        ListBindingSet expected = new ListBindingSet();
        expected.set((IVariable)Var.var((String)"z"), (IConstant)new Constant(this.termId));
        expected.set((IVariable)Var.var((String)"x"), (IConstant)new Constant(this.termId2));
        expected.set((IVariable)Var.var((String)"y"), (IConstant)new Constant(this.blobIV));
        this.doEncodeDecodeTest((IBindingSet)expected);
    }

    public void testAbstractLiteralIVs() {
        ListBindingSet expected = new ListBindingSet();
        expected.set((IVariable)Var.var((String)"x1"), (IConstant)new Constant(this.ipV4AddrIv));
        expected.set((IVariable)Var.var((String)"x2"), (IConstant)new Constant((Object)this.literalArrayIV));
        expected.set((IVariable)Var.var((String)"x4"), (IConstant)new Constant(this.packedLongIV));
        expected.set((IVariable)Var.var((String)"x5"), (IConstant)new Constant(this.uuidLiteralIV));
        expected.set((IVariable)Var.var((String)"x6"), (IConstant)new Constant(this.unsignedByteIV));
        expected.set((IVariable)Var.var((String)"x7"), (IConstant)new Constant(this.unsignedIntIV));
        expected.set((IVariable)Var.var((String)"x8"), (IConstant)new Constant(this.unsignedLongIV));
        expected.set((IVariable)Var.var((String)"x9"), (IConstant)new Constant(this.unsignedShortIV));
        this.doEncodeDecodeTest((IBindingSet)expected);
    }

    public void testFullyInlineUriIV() {
        ListBindingSet expected = new ListBindingSet();
        expected.set((IVariable)Var.var((String)"x"), (IConstant)new Constant(this.fullyInlineUriIV));
        this.doEncodeDecodeTest((IBindingSet)expected);
    }

    public void testLiteralExtensionIV() {
        ListBindingSet expected = new ListBindingSet();
        expected.set((IVariable)Var.var((String)"x"), (IConstant)new Constant(this.literalExtensionIV));
        this.doEncodeDecodeTest((IBindingSet)expected);
    }

    public void testUriExtensionIV() {
        ListBindingSet expected = new ListBindingSet();
        expected.set((IVariable)Var.var((String)"x"), (IConstant)new Constant(this.uriExtensionIV));
        this.doEncodeDecodeTest((IBindingSet)expected);
    }

    public void testVocabUriByteIV() {
        ListBindingSet expected = new ListBindingSet();
        expected.set((IVariable)Var.var((String)"x"), (IConstant)new Constant(this.vocabUriByteIV));
        this.doEncodeDecodeTest((IBindingSet)expected);
    }

    public void testVocabUriShortIV() {
        ListBindingSet expected = new ListBindingSet();
        expected.set((IVariable)Var.var((String)"x"), (IConstant)new Constant(this.vocabUriShortIV));
        this.doEncodeDecodeTest((IBindingSet)expected);
    }

    protected BlobIV<BigdataLiteral> getVeryLargeLiteral() {
        int len = 1024000;
        StringBuilder sb = new StringBuilder(1024000);
        for (int i = 0; i < 1024000; ++i) {
            sb.append(Character.toChars(65 + i % 26));
        }
        String s = sb.toString();
        Random r = new Random();
        int hash = r.nextInt();
        short collisionCounter = (short)r.nextInt(12);
        BlobIV blobIV2 = new BlobIV(VTE.LITERAL, hash, collisionCounter);
        blobIV2.setValue((BigdataValue)this.valueFactory.createLiteral(s));
        return blobIV2;
    }

    public void test_solutionWithVeryLargeObject() {
        BlobIV<BigdataLiteral> blobIV2 = this.getVeryLargeLiteral();
        ListBindingSet expected = new ListBindingSet();
        expected.set((IVariable)Var.var((String)"x"), (IConstant)new Constant(blobIV2));
        this.doEncodeDecodeTest((IBindingSet)expected);
    }

    public void test_solutionWithVeryLargeObject2() {
        BlobIV<BigdataLiteral> blobIV2 = this.getVeryLargeLiteral();
        ListBindingSet expected = new ListBindingSet();
        expected.set((IVariable)Var.var((String)"x"), (IConstant)new Constant(blobIV2));
        expected.set((IVariable)Var.var((String)"y"), (IConstant)new Constant(this.blobIV));
        expected.set((IVariable)Var.var((String)"z"), (IConstant)new Constant(this.termId));
        this.doEncodeDecodeTest((IBindingSet)expected);
    }

    public void test_solutionWithVeryLargeObject3() {
        BlobIV<BigdataLiteral> blobIV2 = this.getVeryLargeLiteral();
        ListBindingSet expected = new ListBindingSet();
        expected.set((IVariable)Var.var((String)"z"), (IConstant)new Constant(this.termId));
        expected.set((IVariable)Var.var((String)"x"), (IConstant)new Constant(blobIV2));
        expected.set((IVariable)Var.var((String)"y"), (IConstant)new Constant(this.blobIV));
        this.doEncodeDecodeTest((IBindingSet)expected);
    }

    public void test_solutionWithSameValueBoundTwice() {
        ListBindingSet expected = new ListBindingSet();
        expected.set((IVariable)Var.var((String)"y"), (IConstant)new Constant(this.termId));
        expected.set((IVariable)Var.var((String)"z"), (IConstant)new Constant(this.termId));
        this.doEncodeDecodeTest((IBindingSet)expected);
    }

    public void test_solutionWithOneMockIV() {
        ListBindingSet expected = new ListBindingSet();
        expected.set((IVariable)Var.var((String)"y"), (IConstant)new Constant(this.termId));
        expected.set((IVariable)Var.var((String)"x"), (IConstant)new Constant(this.termId2));
        expected.set((IVariable)Var.var((String)"z"), (IConstant)new Constant(this.mockIV1));
        this.doEncodeDecodeTest((IBindingSet)expected);
    }

    public void test_solutionWithAllMockIVs() {
        ListBindingSet expected = new ListBindingSet();
        expected.set((IVariable)Var.var((String)"y"), (IConstant)new Constant(this.mockIV1));
        expected.set((IVariable)Var.var((String)"x"), (IConstant)new Constant(this.mockIV2));
        expected.set((IVariable)Var.var((String)"z"), (IConstant)new Constant(this.mockIV3));
        this.doEncodeDecodeTest((IBindingSet)expected);
    }

    public void test_solutionWithMockIVAndOthersToo() {
        ListBindingSet expected = new ListBindingSet();
        expected.set((IVariable)Var.var((String)"a"), (IConstant)new Constant(this.termId));
        expected.set((IVariable)Var.var((String)"y"), (IConstant)new Constant(this.mockIV1));
        expected.set((IVariable)Var.var((String)"c"), (IConstant)new Constant(this.blobIV));
        expected.set((IVariable)Var.var((String)"x"), (IConstant)new Constant(this.mockIV2));
        expected.set((IVariable)Var.var((String)"b"), (IConstant)new Constant(this.termId2));
        expected.set((IVariable)Var.var((String)"z"), (IConstant)new Constant(this.mockIV3));
        expected.set((IVariable)Var.var((String)"d"), (IConstant)new Constant(this.mockIVCarryingUri));
        expected.set((IVariable)Var.var((String)"e"), (IConstant)new Constant(this.mockIVCarryingBNode));
        this.doEncodeDecodeTest((IBindingSet)expected);
    }

    public void test_solutionWithMockIVsPreservesFlagsBits() {
        ListBindingSet expected = new ListBindingSet();
        expected.set((IVariable)Var.var((String)"z"), (IConstant)new Constant(this.mockIV3));
        expected.set((IVariable)Var.var((String)"d"), (IConstant)new Constant(this.mockIVCarryingUri));
        expected.set((IVariable)Var.var((String)"e"), (IConstant)new Constant(this.mockIVCarryingBNode));
        IBindingSet decoded = this.doEncodeDecodeTest((IBindingSet)expected);
        Constant zval = (Constant)decoded.get((IVariable)Var.var((String)"z"));
        Constant dval = (Constant)decoded.get((IVariable)Var.var((String)"d"));
        Constant eval = (Constant)decoded.get((IVariable)Var.var((String)"e"));
        AbstractBindingSetEncoderTestCase.assertEquals((byte)this.mockIV3.flags(), (byte)((IV)zval.get()).flags());
        AbstractBindingSetEncoderTestCase.assertEquals((byte)this.mockIVCarryingUri.flags(), (byte)((IV)dval.get()).flags());
        AbstractBindingSetEncoderTestCase.assertEquals((byte)this.mockIVCarryingBNode.flags(), (byte)((IV)eval.get()).flags());
    }
}

