/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal.encoder;

import com.bigdata.bop.Constant;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.Var;
import com.bigdata.bop.bindingSet.ListBindingSet;
import com.bigdata.io.DataInputBuffer;
import com.bigdata.io.DataOutputBuffer;
import com.bigdata.rdf.internal.encoder.AbstractBindingSetEncoderTestCase;
import com.bigdata.rdf.internal.encoder.IVSolutionSetDecoder;
import com.bigdata.rdf.internal.encoder.IVSolutionSetEncoder;
import java.util.ArrayList;
import java.util.List;

public class TestIVSolutionSetEncoder
extends AbstractBindingSetEncoderTestCase {
    public TestIVSolutionSetEncoder() {
    }

    public TestIVSolutionSetEncoder(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.encoder = new IVSolutionSetEncoder();
        this.decoder = new IVSolutionSetDecoder();
    }

    public void test_streamAPI() {
        ArrayList<IBindingSet> expectedSolutions = new ArrayList<IBindingSet>();
        ListBindingSet expected = new ListBindingSet();
        expected.set((IVariable)Var.var((String)"x"), (IConstant)new Constant((Object)this.termId));
        expectedSolutions.add((IBindingSet)expected);
        expected = new ListBindingSet();
        expected.set((IVariable)Var.var((String)"x"), (IConstant)new Constant((Object)this.termId));
        expected.set((IVariable)Var.var((String)"y"), (IConstant)new Constant((Object)this.blobIV));
        expectedSolutions.add((IBindingSet)expected);
        this.doEncodeDecodeTest(expectedSolutions);
    }

    public void test_streamAPI2() {
        ArrayList<IBindingSet> expectedSolutions = new ArrayList<IBindingSet>();
        ListBindingSet expected = new ListBindingSet();
        expected.set((IVariable)Var.var((String)"x"), (IConstant)new Constant((Object)this.termId));
        expectedSolutions.add((IBindingSet)expected);
        expected = new ListBindingSet();
        expectedSolutions.add((IBindingSet)expected);
        expected = new ListBindingSet();
        expected.set((IVariable)Var.var((String)"x"), (IConstant)new Constant((Object)this.termId));
        expected.set((IVariable)Var.var((String)"y"), (IConstant)new Constant((Object)this.blobIV));
        expectedSolutions.add((IBindingSet)expected);
        this.doEncodeDecodeTest(expectedSolutions);
    }

    protected void doEncodeDecodeTest(List<IBindingSet> expectedSolutions) {
        int nsolutions = expectedSolutions.size();
        DataOutputBuffer out = new DataOutputBuffer();
        for (IBindingSet bset : expectedSolutions) {
            ((IVSolutionSetEncoder)this.encoder).encodeSolution(out, bset);
        }
        DataInputBuffer in = new DataInputBuffer(out.array());
        for (int i = 0; i < nsolutions; ++i) {
            IBindingSet expected = expectedSolutions.get(i);
            IBindingSet actual = ((IVSolutionSetDecoder)this.decoder).decodeSolution(in, true);
            this.assertEquals(expected, actual, true);
        }
    }
}

